/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public final class VC {
    public static final Rectangle DEFAULT_RECTANGLE = new Rectangle(-16000, -16000, 32000, 32000);
    public static final int DEFAULT_VX = 16000;
    public static final int DEFAULT_VY = 16000;
    private double m_dvWidth;
    private double m_dvHeight;
    private double m_vdWidth;
    private double m_vdHeight;
    private int m_dvOffX;
    private int m_dvOffY;
    private int m_vdOffX;
    private int m_vdOffY;
    private double m_vdOffX_PlusHalf;
    private double m_vdOffY_PlusHalf;
    private int m_destWidth;
    private int m_destHeight;
    private int m_virtWidth;
    private int m_virtHeight;

    public VC(double destWidth, double destHeight) {
        this(destWidth, destHeight, 32000.0, 32000.0);
    }

    public VC(double destWidth, double destHeight, double virtWidth, double virtHeight) {
        this.m_dvWidth = virtWidth / destWidth;
        this.m_dvHeight = virtHeight / destHeight;
        this.m_vdWidth = destWidth / virtWidth;
        this.m_vdHeight = destHeight / virtHeight;
        this.m_dvOffX = (int)(-virtWidth) / 2;
        this.m_dvOffY = (int)virtHeight / 2;
        this.m_vdOffX = (int)destWidth / 2;
        this.m_vdOffY = (int)destHeight / 2;
        this.m_virtWidth = (int)virtWidth;
        this.m_virtHeight = (int)virtHeight;
        this.m_destWidth = (int)destWidth;
        this.m_destHeight = (int)destHeight;
        this.m_vdOffX_PlusHalf = (double)this.m_vdOffX + 0.5;
        this.m_vdOffY_PlusHalf = (double)this.m_vdOffY + 0.5;
    }

    public VC(VC source) {
        this(source.m_destWidth, source.m_destHeight, source.m_virtWidth, source.m_virtHeight);
    }

    public Point destToVirt(int dx, int dy) {
        return this.destToVirt(new Point(dx, dy));
    }

    public Dimension destToVirt(Dimension d) {
        return new Dimension((int)((double)d.width * this.m_dvWidth), (int)((double)d.height * this.m_dvHeight));
    }

    public Point destToVirt(Point dest) {
        double x = this.dvX(dest.x);
        double y = this.dvY(dest.y);
        Point virt = new Point((int)x, (int)y);
        return virt;
    }

    public Polygon destToVirt(Polygon dest) {
        Polygon virt = new Polygon();
        for (int i = 0; i < dest.npoints; ++i) {
            double x = this.dvX(dest.xpoints[i]);
            double y = this.dvY(dest.ypoints[i]);
            virt.addPoint((int)x, (int)y);
        }
        return virt;
    }

    public Rectangle destToVirt(Rectangle dest) {
        double x = this.dvX(dest.x);
        double y = this.dvY(dest.y + dest.height);
        double width = (double)dest.width * this.m_dvWidth;
        double height = (double)dest.height * this.m_dvHeight;
        Rectangle virt = new Rectangle((int)x, (int)y, (int)width, (int)height);
        return virt;
    }

    public Shape destToVirtShape(Shape shapeDC) {
        AffineTransform at = AffineTransform.getScaleInstance(this.m_dvWidth, -this.m_dvHeight);
        Shape shapeVC = at.createTransformedShape(shapeDC);
        at = AffineTransform.getTranslateInstance(this.m_dvOffX, this.m_dvOffY);
        shapeVC = at.createTransformedShape(shapeVC);
        return shapeVC;
    }

    public int destToVirtHeight(int nHeight) {
        return (int)((double)nHeight * this.m_dvHeight);
    }

    public int destToVirtHeight(double nHeight) {
        return (int)(nHeight * this.m_dvHeight);
    }

    public int destToVirtWidth(int nWidth) {
        return (int)((double)nWidth * this.m_dvWidth);
    }

    public int destToVirtWidth(double fWidth) {
        return (int)(fWidth * this.m_dvWidth);
    }

    public int destToVirtX(int x) {
        return (int)this.dvX(x);
    }

    public int destToVirtY(int y) {
        return (int)this.dvY(y);
    }

    private double dvX(double dx) {
        double vx = dx * this.m_dvWidth + (double)this.m_dvOffX;
        return vx;
    }

    private double dvY(double dy) {
        double vy = dy * -this.m_dvHeight + (double)this.m_dvOffY;
        return vy;
    }

    public Rectangle getDestCoords() {
        return new Rectangle(0, 0, this.m_destWidth, this.m_destHeight);
    }

    public Rectangle getVirtCoords() {
        return new Rectangle(-this.m_virtWidth / 2, -this.m_virtHeight / 2, this.m_virtWidth, this.m_virtHeight);
    }

    public Dimension getVirtDimension() {
        return new Dimension(this.m_virtWidth, this.m_virtHeight);
    }

    private double vdX(double vx) {
        double dx = vx * this.m_vdWidth + (double)this.m_vdOffX;
        return dx;
    }

    private double vdY(double vy) {
        double dy = vy * -this.m_vdHeight + (double)this.m_vdOffY;
        return dy;
    }

    public Point virtToDest(int vx, int vy) {
        return this.virtToDest(new Point(vx, vy));
    }

    public Dimension virtToDest(Dimension d) {
        return new Dimension((int)Math.round((double)d.width * this.m_vdWidth), (int)Math.round((double)d.height * this.m_vdHeight));
    }

    public Point virtToDest(Point virt) {
        double x = this.vdX(virt.x);
        double y = this.vdY(virt.y);
        Point dest = new Point((int)Math.round(x), (int)Math.round(y));
        return dest;
    }

    public AffineTransform getAffineTransform() {
        return new AffineTransform(this.m_vdWidth, 0.0, 0.0, -this.m_vdHeight, this.m_vdOffX_PlusHalf, this.m_vdOffY_PlusHalf);
    }

    public Polygon virtToDest(Polygon virt) {
        Polygon dest = new Polygon();
        for (int i = 0; i < virt.npoints; ++i) {
            double x = (double)virt.xpoints[i] * this.m_vdWidth + this.m_vdOffX_PlusHalf;
            double y = (double)virt.ypoints[i] * -this.m_vdHeight + this.m_vdOffY_PlusHalf;
            dest.addPoint((int)Math.floor(x), (int)Math.floor(y));
        }
        return dest;
    }

    public Rectangle virtToDest(Rectangle virt) {
        double dTop = this.vdY(virt.y + virt.height);
        double dBot = this.vdY(virt.y);
        int top = (int)Math.round(dTop);
        int bottom = (int)Math.round(dBot);
        int height = bottom - top;
        double dLeft = this.vdX(virt.x);
        double dRight = this.vdX(virt.x + virt.width);
        int left = (int)Math.round(dLeft);
        int right = (int)Math.round(dRight);
        int width = right - left;
        Rectangle dest = new Rectangle(left, top, width, height);
        return dest;
    }

    public double virtToDestHeight(double fVHeight) {
        return fVHeight * this.m_vdHeight;
    }

    public int virtToDestHeight(int nVHeight) {
        return (int)Math.round((double)nVHeight * this.m_vdHeight);
    }

    public double virtToDestWidth(double fVWidth) {
        return fVWidth * this.m_vdWidth;
    }

    public int virtToDestWidth(int nVWidth) {
        return (int)((double)nVWidth * this.m_vdWidth + 0.5);
    }

    public int virtToDestX(int x) {
        return (int)(this.vdX(x) + 0.5);
    }

    public int virtToDestY(int y) {
        return (int)(this.vdY(y) + 0.5);
    }

    public double virtToDestX(double x) {
        return this.vdX(x) + 0.5;
    }

    public double virtToDestY(double y) {
        return this.vdY(y) + 0.5;
    }

    public double destToVirtX(double x) {
        return this.dvX(x);
    }

    public double destToVirtY(double y) {
        return this.dvY(y);
    }

    public int getAspectAdjustedX(int distX) {
        double aspect = this.getSquareAspectRatioX() / this.getSquareAspectRatioY();
        return aspect > 1.0 ? (int)((double)distX * aspect) : distX;
    }

    public int getAspectAdjustedY(int distY) {
        double aspect = this.getSquareAspectRatioY() / this.getSquareAspectRatioX();
        return aspect > 1.0 ? (int)((double)distY * aspect) : distY;
    }

    public double getSquareAspectRatioX() {
        if (this.m_destWidth > this.m_destHeight) {
            return (double)this.m_destHeight / (double)this.m_destWidth;
        }
        return 1.0;
    }

    public double getSquareAspectRatioY() {
        if (this.m_destWidth < this.m_destHeight) {
            return (double)this.m_destWidth / (double)this.m_destHeight;
        }
        return 1.0;
    }

    public int getMinY() {
        return -this.m_virtWidth / 2;
    }

    public int getMaxY() {
        return this.m_virtWidth / 2;
    }

    public int getMinX() {
        return -this.m_virtWidth / 2;
    }

    public int getMaxX() {
        return this.m_virtWidth / 2;
    }

    public Rectangle vcCombineKeepDCDimension(Point pt, Dimension dim) {
        Dimension dcDim = this.virtToDest(dim);
        Rectangle vcRect = new Rectangle(pt, dim);
        Rectangle dcRect = this.virtToDest(vcRect);
        if (dcRect.width == dcDim.width && dcRect.height == dcDim.height) {
            return vcRect;
        }
        vcRect = new Rectangle(pt, this.destToVirt(dcDim));
        dcRect = this.virtToDest(vcRect);
        if (dcRect.width == dcDim.width && dcRect.height == dcDim.height) {
            return vcRect;
        }
        Point dcPt = this.virtToDest(pt);
        return this.destToVirt(new Rectangle(dcPt.x, dcPt.y - dcDim.height, dcDim.width, dcDim.height));
    }
}

