/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.common.gauges;

import com.businessobjects.visualization.pfjgraphics.rendering.common.gauges.GaugeBase;
import com.businessobjects.visualization.pfjgraphics.rendering.common.gauges.TrendPointInfo;
import com.businessobjects.visualization.pfjgraphics.rendering.common.math.BadNumber;
import com.businessobjects.visualization.pfjgraphics.rendering.common.math.FloatingPoint;
import com.businessobjects.visualization.pfjgraphics.rendering.common.math.MathExt;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine.IScale;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine.ScaleLinear;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.AnnotationBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.IStandardDraw;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.IStandardLook;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.StandardDrawPFJ;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.ObjectID;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GaugeCircularBase
extends GaugeBase {
    public static final int kPOINTY_NEEDLE_STYLE = 1;
    private static final double kLABEL_FUDGE = 0.02;
    private static final int OUTER_MARGIN = 2;
    protected Point m_ptCenter;
    protected double m_dArcRadius;
    protected IScale m_AngleScaleInv = null;
    protected double m_dCenterRadius = 1.0;
    protected double m_dArcRelThickness;
    protected double m_dArcRelInnerRadius;
    protected Rectangle m_FittedGaugeBox;

    public GaugeCircularBase(IStandardDraw stdDraw, IStandardLook stdLook, Object logger) {
        super(stdDraw, stdLook, logger);
    }

    @Override
    public void drawInOffscreen() {
        if (this.getAttrBoolean("GaugeArea", "Visible")) {
            super.drawInOffscreen();
            this.initCalc();
            this.drawStyledBackground();
        }
    }

    @Override
    protected void drawAfterOffscreen() {
        if (this.getAttrBoolean("GaugeArea", "Visible")) {
            if (this.isNeedleVisible()) {
                this.initScales();
                this.drawBackgroundBand(this.m_StdLook.getObjectID("GaugeBackground"));
                this.drawQualityBands();
                this.drawGrids();
                this.drawLabels();
            }
            this.drawTitle();
            if (this.isNeedleVisible()) {
                this.drawTrendPoints();
                this.drawScaleMultipleLabel();
            }
            if (this.isNeedleVisible()) {
                this.drawMarks();
                for (int i = 0; i < this.m_ValueList.length; ++i) {
                    this.drawNeedle(i);
                }
            }
        }
    }

    protected double getArcIncrement() {
        return Math.asin(1.0 / this.m_dArcRadius) * 57.29577951308232;
    }

    protected Polygon getArcPolygon(double dMin, double dMax) {
        Point pt = new Point();
        Polygon polygon = new Polygon();
        double dIncrement = this.getArcIncrement();
        assert (dMin <= dMax);
        double dRelMin = this.m_Scale.valueToUnit(dMin);
        double dRelMax = this.m_Scale.valueToUnit(dMax);
        if (this.getAttrBoolean("GaugeArea", "Gauge.Descending")) {
            double dSwap = dRelMax;
            dRelMax = 1.0 - dRelMin;
            dRelMin = 1.0 - dSwap;
        }
        double dStartAngle = this.m_AngleScaleInv.unitToValue(1.0 - dRelMin);
        double dStopAngle = this.m_AngleScaleInv.unitToValue(1.0 - dRelMax);
        double dAngleInDeg = dStartAngle;
        while (!FloatingPoint.greaterThan(dStopAngle, dAngleInDeg)) {
            GaugeCircularBase.polarToCartesian(pt, dAngleInDeg, this.m_dArcRelInnerRadius + this.m_dArcRelThickness, this.m_dArcRadius, this.m_ptCenter);
            polygon.addPoint(pt.x, pt.y);
            dAngleInDeg -= dIncrement;
        }
        GaugeCircularBase.polarToCartesian(pt, dStopAngle, this.m_dArcRelInnerRadius + this.m_dArcRelThickness, this.m_dArcRadius, this.m_ptCenter);
        polygon.addPoint(pt.x, pt.y);
        if (this.m_dArcRelThickness > 0.0) {
            dAngleInDeg = dStopAngle;
            while (!FloatingPoint.greaterThan(dAngleInDeg, dStartAngle)) {
                GaugeCircularBase.polarToCartesian(pt, dAngleInDeg, this.m_dArcRelInnerRadius, this.m_dArcRadius, this.m_ptCenter);
                polygon.addPoint(pt.x, pt.y);
                dAngleInDeg += dIncrement;
            }
            GaugeCircularBase.polarToCartesian(pt, dStartAngle, this.m_dArcRelInnerRadius, this.m_dArcRadius, this.m_ptCenter);
            polygon.addPoint(pt.x, pt.y);
        } else {
            polygon.addPoint(this.m_ptCenter.x, this.m_ptCenter.y);
        }
        return polygon;
    }

    private Shape getArcShape(double dMin, double dMax, double dArcRelThickness) {
        assert (dMin <= dMax);
        double dRelMin = this.m_Scale.valueToUnit(dMin);
        double dRelMax = this.m_Scale.valueToUnit(dMax);
        if (this.getAttrBoolean("GaugeArea", "Gauge.Descending")) {
            double dSwap = dRelMax;
            dRelMax = 1.0 - dRelMin;
            dRelMin = 1.0 - dSwap;
        }
        double dStartAngle = this.m_AngleScaleInv.unitToValue(1.0 - dRelMin);
        double dStopAngle = this.m_AngleScaleInv.unitToValue(1.0 - dRelMax);
        GeneralPath shape = new GeneralPath();
        double rOuter = (this.m_dArcRelInnerRadius + dArcRelThickness) * this.m_dArcRadius;
        double extent = dStopAngle - dStartAngle;
        Arc2D.Double outerArc = new Arc2D.Double((double)this.m_ptCenter.x - rOuter, (double)this.m_ptCenter.y - rOuter, 2.0 * rOuter, 2.0 * rOuter, dStartAngle, extent, 0);
        Point2D startPoint = outerArc.getStartPoint();
        shape.moveTo((float)startPoint.getX(), (float)startPoint.getY());
        shape.append(outerArc, false);
        double rInner = this.m_dArcRelInnerRadius * this.m_dArcRadius;
        Arc2D.Double innerArc = new Arc2D.Double((double)this.m_ptCenter.x - rInner, (double)this.m_ptCenter.y - rInner, 2.0 * rInner, 2.0 * rInner, dStopAngle, -extent, 0);
        shape.append(innerArc, true);
        shape.closePath();
        return shape;
    }

    protected void drawGrids() {
        this.drawGrid("GaugeMinorGrid", this.m_ScaleMinorTicksList);
        this.drawGrid("GaugeMajorGrid", this.m_ScaleMajorTicksList);
    }

    private void drawGrid(String tickID, List<Double> gridList) {
        if (this.getAttrBoolean(tickID, "Visible")) {
            Point ptIn = new Point();
            Point ptOut = new Point();
            double dRelTickLen = this.getAttrDouble(tickID, "Gauge.RelTickLen") * this.m_dArcRelThickness;
            if (FloatingPoint.approxEqual(dRelTickLen, 0.0)) {
                dRelTickLen = this.m_dArcRelThickness;
            }
            for (Double dTick : gridList) {
                double dAngle = this.m_AngleScaleInv.unitToValue(1.0 - this.m_Scale.valueToUnit(dTick));
                GaugeCircularBase.polarToCartesian(ptOut, dAngle, this.m_dArcRelInnerRadius + dRelTickLen, this.m_dArcRadius, this.m_ptCenter);
                GaugeCircularBase.polarToCartesian(ptIn, dAngle, this.m_dArcRelInnerRadius, this.m_dArcRadius, this.m_ptCenter);
                this.m_StdDraw.drawLine(this.m_StdLook.getObjectID(tickID), ptIn.x, ptIn.y, ptOut.x, ptOut.y, this.m_StdLook);
            }
        }
    }

    protected void drawLabels() {
        if (this.getAttrBoolean("GaugeLabel", "Visible")) {
            ArrayList<Rectangle> labelRectangles = new ArrayList<Rectangle>();
            ObjectID idLabel = this.m_StdLook.getObjectID("GaugeLabel");
            double dRelLabelPos = this.getRelLabelPos();
            boolean bShowZero = this.m_p.getDisplay(Identity.Y1ZeroLine);
            for (Double dLabelValue : this.m_ScaleMajorTicksList) {
                this.drawOneLabel(idLabel, dLabelValue, dRelLabelPos, bShowZero, labelRectangles);
            }
        }
    }

    protected double getRelLabelPos() {
        return this.m_dArcRelInnerRadius - 0.02;
    }

    protected void drawOneLabel(Object idLabel, Double dLabelValue, double dRelLabelPos, boolean bShowZero, List<Rectangle> labelRectangles) {
        Point ptLabel = new Point();
        if (dLabelValue == 0.0 && !bShowZero) {
            return;
        }
        double dAngle = this.m_AngleScaleInv.unitToValue(1.0 - this.m_Scale.valueToUnit(dLabelValue));
        GaugeCircularBase.polarToCartesian(ptLabel, dAngle, dRelLabelPos, this.m_dArcRadius, this.m_ptCenter);
        double dLabel = dLabelValue / this.m_dScaleMultiple;
        String szLabel = this.m_StdDraw.formatValue(idLabel, dLabel, this.m_StdLook);
        Dimension textDim = this.m_StdDraw.getTextSize(idLabel, szLabel, this.m_StdLook);
        ptLabel = this.calcLabelPos(ptLabel, dAngle, textDim, true);
        Rectangle rLabel = new Rectangle(ptLabel.x, ptLabel.y, textDim.width, textDim.height);
        if (labelRectangles != null) {
            boolean bIntersect = false;
            for (int i = 0; i < labelRectangles.size(); ++i) {
                Rectangle r = labelRectangles.get(i);
                if (!rLabel.intersects(r)) continue;
                labelRectangles = null;
                bIntersect = true;
                break;
            }
            if (dLabelValue == 0.0 && bIntersect) {
                return;
            }
            if (labelRectangles != null) {
                labelRectangles.add(rLabel);
            }
        }
        this.m_StdDraw.drawText(idLabel, szLabel, rLabel, this.m_StdLook);
    }

    protected void drawTitle() {
        if (this.getAttrBoolean("GaugeTitle", "Visible") && this.m_szTitle != null) {
            Point ptLabel;
            ObjectID objID = this.m_StdLook.getObjectID("GaugeTitle");
            Dimension textDim = ((StandardDrawPFJ)this.m_StdDraw).getTextSize((Object)objID, this.m_szTitle, this.m_StdDraw.getRectangle().getSize());
            switch (this.getTitlePosition()) {
                case 1: {
                    ptLabel = new Point(this.m_FittedGaugeBox.x + this.m_FittedGaugeBox.width / 2, this.m_FittedGaugeBox.y + this.m_FittedGaugeBox.height);
                    ptLabel.x -= textDim.width / 2;
                    ptLabel.y += 5;
                    break;
                }
                default: {
                    ptLabel = new Point(this.m_ptCenter.x, this.m_ptCenter.y + (int)Math.round(this.m_dArcRadius) / 4);
                    ptLabel.x -= textDim.width / 2;
                    ptLabel.y -= textDim.height;
                    break;
                }
                case 2: {
                    ptLabel = new Point(this.m_ptCenter.x, this.m_ptCenter.y - (int)this.m_dArcRadius);
                    ptLabel.x -= textDim.width / 2;
                    ptLabel.y -= textDim.height * 2 - textDim.height / 3;
                }
            }
            this.m_StdDraw.drawText(objID, this.m_szTitle, new Rectangle(ptLabel.x, ptLabel.y, textDim.width, textDim.height), this.m_StdLook);
        }
    }

    protected void drawValue() {
        if (this.getAttrBoolean("GaugeValue", "Visible")) {
            ObjectID objID = this.m_StdLook.getObjectID("GaugeValue");
            Point ptLabel = new Point(this.m_ptCenter.x, this.m_ptCenter.y + (int)Math.round(this.m_dArcRadius) * 3 / 5);
            ObjectID idLabel = this.m_StdLook.getObjectID("GaugeLabel");
            Number value = this.getValue(false);
            String strValue = value instanceof Double ? (((Double)value).isNaN() ? "Not a Number" : this.m_StdDraw.formatValue(idLabel, value.doubleValue(), this.m_StdLook)) : (value instanceof BadNumber ? ((BadNumber)value).toString() : "");
            Dimension textDim = this.m_StdDraw.getTextSize(objID, strValue, this.m_StdLook);
            ptLabel.x -= textDim.width / 2;
            ptLabel.y -= textDim.height;
            this.m_StdDraw.drawText(objID, strValue, new Rectangle(ptLabel.x, ptLabel.y, textDim.width, textDim.height), this.m_StdLook);
        }
    }

    protected void drawNeedle(int series) {
        boolean bDropShadow = this.getDropShadowSetting();
        if (bDropShadow) {
            int nPolygon = 0;
            ColorPolygon colorPolygon = this.getNeedleColorPolygon(nPolygon++);
            Rectangle rBounds = new Rectangle();
            while (colorPolygon != null) {
                rBounds = rBounds.intersection(colorPolygon.m_Polygon.getBounds());
                colorPolygon = this.getNeedleColorPolygon(nPolygon++);
            }
            this.m_StdDraw.beginDropShadow(rBounds);
            this.drawSingleNeedle(series);
            this.drawNeedleCenter();
            this.m_StdDraw.endDropShadow();
        }
        this.drawSingleNeedle(series);
        this.drawNeedleCenter();
    }

    protected boolean getDropShadowSetting() {
        Integer needleStyleObj = (Integer)this.m_StdLook.getAttrValue(this.m_StdLook.getObjectID("GaugeNeedle"), this.m_StdLook.getAttr("Gauge.NeedleStyle"));
        int nNeedleStyle = needleStyleObj;
        Boolean dropShadowObj = this.getDropShadowObj(nNeedleStyle);
        if (dropShadowObj == null) {
            dropShadowObj = (Boolean)this.m_StdLook.getAttrValue(this.m_StdLook.getObjectID("GaugeNeedle"), this.m_StdLook.getAttr("Shadow"));
        }
        return dropShadowObj;
    }

    private void drawSingleNeedle(int series) {
        int nPolygon = 0;
        if (Double.isNaN(this.m_ValueList[series])) {
            return;
        }
        if (this.getAttrBoolean("GaugeNeedle", "Visible")) {
            ObjectID objectID = this.m_StdLook.getObjectID("GaugeNeedle");
            ColorPolygon colorPolygon = this.getNeedleColorPolygon(nPolygon++);
            while (colorPolygon != null) {
                double dAngle = 180.0 - this.m_AngleScaleInv.unitToValue(1.0 - this.m_Scale.valueToUnit(this.m_ValueList[series]));
                double needleLengthFactor = this.m_dArcRadius / ((double)this.m_rGauge.width / 2.0);
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(this.m_ptCenter.x, this.m_ptCenter.y);
                affineTransform.rotate(dAngle * (Math.PI / 180));
                affineTransform.scale(this.m_dRatioX * needleLengthFactor, this.m_dRatioY * needleLengthFactor);
                affineTransform.translate(-8000.0, -8000.0);
                colorPolygon.m_Polygon = this.transformPolygon(affineTransform, colorPolygon.m_Polygon);
                this.m_StdLook.setAttrValue(objectID, this.m_StdLook.getAttr("FillColor"), colorPolygon.m_FillColor);
                this.m_StdLook.setAttrValue(objectID, this.m_StdLook.getAttr("BorderColor"), colorPolygon.m_BorderColor);
                int group = ((StandardDrawPFJ)this.m_StdDraw).getGroupID();
                IdentObj id = new IdentObj(objectID.getObjectID(), series, group);
                IBlackBox bb = this.m_p.getGraphObject().assignSeriesColor(series, group);
                Polygon polygonVC = this.m_p.getVC().destToVirt(colorPolygon.m_Polygon);
                DrawFactory.createPolygon(this.m_p.getDetectiv(), id, polygonVC, bb, null, 1.0);
                colorPolygon = this.getNeedleColorPolygon(nPolygon++);
            }
        }
    }

    protected void drawNeedleCenter() {
        Color centerCircleColor;
        Integer needleStyleObj = (Integer)this.m_StdLook.getAttrValue(this.m_StdLook.getObjectID("GaugeNeedle"), this.m_StdLook.getAttr("Gauge.NeedleStyle"));
        int nNeedleStyle = needleStyleObj;
        double dRatio = this.getCenterCircleThickness(nNeedleStyle);
        Color centerCircleBorderColor = centerCircleColor = this.getCenterCircleColor(nNeedleStyle);
        ObjectID objCircle = this.m_StdLook.getObjectID("GaugeCenterCircle");
        this.m_StdLook.setAttrValue(objCircle, this.m_StdLook.getAttr("FillColor"), centerCircleColor);
        this.m_StdLook.setAttrValue(objCircle, this.m_StdLook.getAttr("BorderColor"), centerCircleBorderColor);
        int dRadius = (int)Math.round(this.m_dArcRadius * dRatio);
        Rectangle rCircle = new Rectangle(this.m_ptCenter.x - dRadius, this.m_ptCenter.y - dRadius, 2 * dRadius, 2 * dRadius);
        this.m_StdDraw.drawOval(objCircle, rCircle, this.m_StdLook);
    }

    protected Color getCenterCircleColor(int nNeedleStyle) {
        return Color.black;
    }

    protected double getCenterCircleThickness(int nNeedleStyle) {
        return 0.02;
    }

    @Override
    protected Polygon getMarkPolygon(GaugeBase.Mark mark) {
        double dInnerDiameter = this.getAttrDouble("GaugeMarker", "Gauge.RelInnerRadius");
        if (mark.bSmall) {
            this.m_dArcRelThickness /= 2.0;
        }
        double dOuterDiameter = dInnerDiameter + this.m_dArcRelThickness;
        double dMarkCenter = this.m_AngleScaleInv.unitToValue(1.0 - this.m_Scale.valueToUnit(mark.value.doubleValue(), true), true);
        Polygon poly = new Polygon();
        Point pt = new Point();
        GaugeCircularBase.polarToCartesian(pt, dMarkCenter, dInnerDiameter, this.m_dArcRadius, this.m_ptCenter);
        poly.addPoint(pt.x, pt.y);
        GaugeCircularBase.polarToCartesian(pt, dMarkCenter - 1.5, dOuterDiameter, this.m_dArcRadius, this.m_ptCenter);
        poly.addPoint(pt.x, pt.y);
        GaugeCircularBase.polarToCartesian(pt, dMarkCenter + 1.5, dOuterDiameter, this.m_dArcRadius, this.m_ptCenter);
        poly.addPoint(pt.x, pt.y);
        return poly;
    }

    protected void initCalc() {
        this.m_dArcRelThickness = this.getRelThickness();
        this.m_ptCenter = this.getCenter();
        this.m_dArcRadius = this.getRadius() - 2.0;
    }

    static void polarToCartesian(Point pt, double fAngleInDeg, double relRadius, double dRadius, Point origin) {
        while (fAngleInDeg >= 360.0) {
            fAngleInDeg -= 360.0;
        }
        while (fAngleInDeg < 0.0) {
            fAngleInDeg += 360.0;
        }
        double radius = dRadius * relRadius;
        double fX = radius * Math.cos(fAngleInDeg * (Math.PI / 180));
        double fY = -(radius * Math.sin(fAngleInDeg * (Math.PI / 180)));
        pt.x = origin.x + (int)Math.round(fX);
        pt.y = origin.y + (int)Math.round(fY);
    }

    @Override
    protected void drawBackgroundBand(Object objectID) {
        this.m_StdDraw.drawShape(objectID, this.getArcShape(this.m_Scale.getMinValue(), this.m_Scale.getMaxValue(), this.m_dArcRelThickness), this.m_StdLook);
    }

    @Override
    protected void drawQualityBand(Object objectID, double dMin, double dMax) {
        this.m_StdDraw.drawShape(objectID, this.getArcShape(dMin, dMax, this.m_dArcRelThickness), this.m_StdLook);
    }

    protected void initScales() {
        double dStopAngle;
        double dStartAngle = this.getAttrDouble("GaugeScaleArea", "Gauge.StartAngle");
        if (dStartAngle <= (dStopAngle = this.getAttrDouble("GaugeScaleArea", "Gauge.StopAngle"))) {
            dStartAngle += 360.0;
        }
        this.m_AngleScaleInv = new ScaleLinear(dStopAngle, dStartAngle);
    }

    protected Point calcLabelPos(Point ptLabel, double dAngle, Dimension textDim, boolean bLabelIn) {
        Point ptText = new Point();
        double dAlignLimit = 20.0;
        if (dAngle < 0.0) {
            dAngle += 360.0;
        }
        if (dAngle > 360.0) {
            dAngle -= 360.0;
        }
        if (bLabelIn) {
            ptText.x = dAngle > 270.0 + dAlignLimit || dAngle < 90.0 - dAlignLimit ? ptLabel.x - textDim.width : (dAngle > 90.0 + dAlignLimit && dAngle < 270.0 - dAlignLimit ? ptLabel.x : ptLabel.x - textDim.width / 2);
            ptText.y = dAngle > dAlignLimit && dAngle < 180.0 - dAlignLimit ? ptLabel.y : (dAngle > 180.0 + dAlignLimit && dAngle < -dAlignLimit ? ptLabel.y - textDim.height : ptLabel.y - textDim.height / 2);
        } else {
            ptText.x = dAngle > 270.0 + dAlignLimit || dAngle < 90.0 - dAlignLimit ? ptLabel.x : (dAngle > 90.0 + dAlignLimit && dAngle < 270.0 - dAlignLimit ? ptLabel.x - textDim.width : ptLabel.x - textDim.width / 2);
            ptText.y = dAngle > dAlignLimit && dAngle < 180.0 - dAlignLimit ? ptLabel.y - textDim.height : (dAngle > 180.0 + dAlignLimit && dAngle < 360.0 - dAlignLimit ? ptLabel.y : ptLabel.y - textDim.height / 2);
        }
        return ptText;
    }

    @Override
    protected Point getTrendPointLocation(int nIndex, TrendPointInfo tpi) {
        double dAngle = this.m_AngleScaleInv.unitToValue(1.0 - this.m_Scale.valueToUnit(tpi.getValue()));
        if ((dAngle -= 180.0) < 360.0) {
            dAngle += 360.0;
        }
        return MathExt.rotatePoint(new Point(this.m_ptCenter.x - (int)(this.m_dArcRadius * 0.82), this.m_ptCenter.y), this.m_ptCenter, dAngle);
    }

    protected void drawScaleMultipleLabel() {
        if (this.getAttrBoolean("GaugeScaleFactorLbl", "Visible")) {
            String szScaleScaleLabel = this.calcScaleFactorLabel();
            ObjectID objID = this.m_StdLook.getObjectID("GaugeScaleFactorLbl");
            Point ptLabel = new Point(this.m_ptCenter.x, this.m_ptCenter.y + (int)Math.round(this.m_dArcRadius) / 4 * 3);
            Dimension textDim = this.m_StdDraw.getTextSize(objID, szScaleScaleLabel, this.m_StdLook);
            ptLabel.x -= textDim.width / 2;
            ptLabel.y -= textDim.height;
            this.m_StdDraw.drawText(objID, szScaleScaleLabel, new Rectangle(ptLabel.x, ptLabel.y, textDim.width, textDim.height), this.m_StdLook);
        }
    }

    @Override
    protected void calcRatios() {
        Dimension dGauge = new Dimension();
        Rectangle rBounds = this.calcGaugeBounds();
        Dimension size = rBounds.getSize();
        Dimension dMeta = this.getMetaSize();
        double dRatio = (double)dMeta.width / (double)dMeta.height;
        dGauge.width = Math.min(size.width, (int)((double)size.height * dRatio));
        dGauge.height = Math.min(size.height, (int)((double)size.width / dRatio));
        this.m_rGauge = new Rectangle(rBounds.x + (size.width - dGauge.width) / 2, rBounds.y + (size.height - dGauge.height) / 2, dGauge.width, dGauge.height);
        this.m_dRatioX = (double)this.m_rGauge.width / (double)dMeta.width;
        this.m_dRatioY = (double)this.m_rGauge.height / (double)dMeta.height;
    }

    protected Rectangle calcGaugeBounds() {
        Rectangle rBoundsDC = this.m_StdDraw.getRectangle();
        Dimension dimTitleDC = this.m_titleBoundingBoxDC;
        int nPositioningFactorVC = dimTitleDC.height;
        switch (this.getTitlePosition()) {
            case 2: {
                rBoundsDC.height -= nPositioningFactorVC;
                rBoundsDC.y += nPositioningFactorVC;
                break;
            }
            case 1: {
                rBoundsDC.height -= nPositioningFactorVC;
                break;
            }
        }
        return rBoundsDC;
    }

    protected void drawStyledBackground() {
        if (this.m_p.getBorderType(Identity.SubFrame) != 0) {
            AnnotationBox.calcBorderedBox(this.m_p, Identity.SubFrame, ((StandardDrawPFJ)this.m_StdDraw).getRectangleVC(), false);
        }
    }

    protected abstract Point getCenter();

    protected abstract double getRadius();

    protected double getRelThickness() {
        return this.getAttrDouble("GaugeMarker", "Gauge.RelThickness");
    }

    protected abstract ColorPolygon getNeedleColorPolygon(int var1);

    protected abstract Boolean getDropShadowObj(int var1);

    @Override
    protected boolean getStepDensity() {
        return true;
    }

    protected static class ColorPolygon {
        public Polygon m_Polygon;
        public Color m_BorderColor;
        public Color m_FillColor;

        protected ColorPolygon() {
        }
    }
}

