/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.logging.log4j;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.LogLog;

public class RollingTimeStampedFileAppender
extends RollingFileAppender {
    private String m_datePattern;
    private DateFormat m_sdf;
    private String m_pureName;
    private String m_suffix;
    private Date m_now;
    private static final TimeZone s_timeZone = TimeZone.getTimeZone("GMT");

    public RollingTimeStampedFileAppender() {
    }

    public RollingTimeStampedFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    public RollingTimeStampedFileAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
    }

    public String getDatePattern() {
        return this.m_datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.m_datePattern = datePattern;
    }

    public void activateOptions() {
        if (this.fileName != null) {
            int delim;
            boolean succ;
            File file = new File(this.fileName);
            File folder = file.getParentFile();
            if (folder != null && !folder.exists() && !(succ = folder.mkdirs())) {
                LogLog.warn((String)("Failed to create logs folder:" + folder.getPath()));
            }
            if (this.m_datePattern != null) {
                this.m_now = new Date(System.currentTimeMillis());
                this.m_sdf = new SimpleDateFormat(this.m_datePattern, Locale.ENGLISH);
                this.m_sdf.setTimeZone(s_timeZone);
            }
            if ((delim = this.fileName.lastIndexOf(46)) != -1) {
                this.m_pureName = this.fileName.substring(0, delim);
                this.m_suffix = this.fileName.substring(delim);
            } else {
                this.m_pureName = this.fileName;
                this.m_suffix = "";
            }
        } else {
            LogLog.error((String)("Filename option is not set for [" + this.name + "]"));
        }
        super.activateOptions();
    }

    public void rollOver() {
        LogLog.debug((String)("maxBackupIndex=" + this.maxBackupIndex));
        int maximumBackupIndex = this.maxBackupIndex;
        if (maximumBackupIndex > 0) {
            File target;
            File file;
            String timeStamp = "";
            if (this.m_datePattern != null) {
                this.m_now.setTime(System.currentTimeMillis());
                timeStamp = this.m_sdf.format(this.m_now);
            }
            if ((file = new File(this.getIndexedFileName(maximumBackupIndex, timeStamp))).exists()) {
                file.delete();
            }
            for (int i = maximumBackupIndex - 1; i >= 1; --i) {
                file = new File(this.getIndexedFileName(i, timeStamp));
                if (!file.exists()) continue;
                target = new File(this.getIndexedFileName(i + 1, timeStamp));
                LogLog.debug((String)("Renaming file " + file + " to " + target));
                file.renameTo(target);
            }
            target = new File(this.getIndexedFileName(1, timeStamp));
            this.closeFile();
            file = new File(this.fileName);
            LogLog.debug((String)("Renaming file " + file + " to " + target));
            file.renameTo(target);
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
    }

    private String getIndexedFileName(int index, String timeStamp) {
        return this.m_pureName + timeStamp + '.' + index + this.m_suffix;
    }
}

