/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.model3d;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawObject;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DMesh;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DSurface;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.TriangleRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Polygon;
import java.awt.Shape;

public final class Model3DSurfaceTopo
extends Model3DSurface {
    public Model3DSurfaceTopo(JChart_3D chart, IdentObj id, IBlackBox bb, Point3d[] vertices, boolean[][] bGridStatus, boolean bFrontTriangle, boolean bAutoshading) {
        super(chart, id, bb, vertices, bGridStatus, bFrontTriangle, true);
    }

    public void displayFace(int f, IBlackBox bb, double fIntensity) {
        IDrawObject detObj = null;
        Polygon poly = this.projectVertices(f);
        boolean bUpperSideVisible = !Model3DMesh.isNegative(poly);
        IdentObj newId = this.m_id.incrementMisc(f);
        int[] TopFaceIndex = this.m_faces[f];
        int nLen = TopFaceIndex.length;
        if (nLen == 3) {
            double[] dd = new double[3];
            for (int i = 0; i < nLen; ++i) {
                int index = TopFaceIndex[i];
                Point3d vertex = this.m_vertices[index];
                dd[i] = this.m_chart.getHeightRatio(vertex.y);
            }
            TriangleRenderer renderer = new TriangleRenderer(poly, dd, fIntensity, this.m_chart.getPerspective(), bUpperSideVisible);
            detObj = DrawFactory.createShape(this.drawContainer, newId, (Shape)poly, bb, null, renderer);
        }
        if (detObj == null) {
            detObj = DrawFactory.createPolygon(this.drawContainer, newId, poly, bb, null, fIntensity);
        }
        if (this.m_bWantGrids) {
            this.displayGridFace(true, 0, f);
            this.displayGridFace(true, 1, f);
            this.displayGridFace(true, 2, f);
            this.displayGridFace(false, 0, f);
            this.displayGridFace(false, 1, f);
            this.displayGridFace(false, 2, f);
        }
    }
}

