/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Dimension2D;

public class TriangleRenderer
implements BlackBoxRenderer {
    private static final Paint BACKSIDE_PAINT = Color.black;
    private Perspective m_Perspective = null;
    private boolean m_bUpperSide = true;
    private Paint m_filling;
    private Paint m_SVGFillPaint;
    private double m_fIntensity = 1.0;
    private final float[] m_heightRatio = new float[3];
    private final Polygon m_triangle;
    private final int[] index = new int[3];
    private final Dimension margins = new Dimension(0, 0);
    private final float[] tempArray = new float[3];

    public TriangleRenderer(Polygon triangle, double[] ratio, double fIntensity, Perspective persp, boolean bUpperSide) {
        if (ratio == null || ratio.length < 3 || triangle == null || triangle.npoints < 3) {
            throw new IllegalArgumentException();
        }
        this.m_Perspective = persp;
        this.doIndex(ratio);
        for (int i = 0; i < 3; ++i) {
            this.m_heightRatio[i] = (float)ratio[i];
        }
        this.m_triangle = triangle;
        this.m_fIntensity = fIntensity;
        this.m_bUpperSide = bUpperSide;
        this.m_SVGFillPaint = this.createPaint(this.createTricolor());
        this.m_filling = this.m_bUpperSide ? this.m_SVGFillPaint : BACKSIDE_PAINT;
    }

    public Dimension2D getMargins() {
        return (Dimension)this.margins.clone();
    }

    public void render(Graphics2D g, Shape shape) {
        g.setPaint(this.m_filling);
        g.fill(shape);
    }

    public void updateFrom(IBlackBox bb) {
        Color[] colors = this.createTricolor();
        this.m_filling = this.createPaint(colors);
    }

    protected Color[] createTricolor() {
        Color[] colors = new Color[3];
        BlackBoxObj bbGradient = new BlackBoxObj(this.m_Perspective, Identity.ColorByHeight);
        for (int i = 0; i < 3; ++i) {
            colors[i] = bbGradient.getGradientColorAt(this.m_heightRatio[i]);
        }
        return colors;
    }

    public Color multiplyByIntensity(Color color) {
        if (this.m_fIntensity == 1.0) {
            return color;
        }
        color.getRGBColorComponents(this.tempArray);
        int i = 0;
        while (i < 3) {
            int n = i++;
            this.tempArray[n] = (float)((double)this.tempArray[n] * this.m_fIntensity);
        }
        return new Color(this.tempArray[0], this.tempArray[1], this.tempArray[2]);
    }

    protected Paint createPaint(Color[] colors) {
        float[] zz = this.m_heightRatio;
        float Z1 = zz[this.index[1]] - zz[this.index[0]];
        int[] yy = this.m_triangle.ypoints;
        float Y2 = yy[this.index[2]] - yy[this.index[0]];
        float Z2 = zz[this.index[2]] - zz[this.index[0]];
        float Y1 = yy[this.index[1]] - yy[this.index[0]];
        float nX = Z1 * Y2 - Z2 * Y1;
        int[] xx = this.m_triangle.xpoints;
        float X1 = xx[this.index[1]] - xx[this.index[0]];
        float X2 = xx[this.index[2]] - xx[this.index[0]];
        float nY = Z2 * X1 - Z1 * X2;
        float norm = nX * nX + nY * nY;
        if (!FP.nonzero(norm)) {
            return null;
        }
        norm = (float)Math.sqrt(norm);
        float fX0 = xx[this.index[0]];
        float fY0 = yy[this.index[0]];
        float ss = (nX /= norm) * X2 + (nY /= norm) * Y2;
        float fX2 = fX0 + ss * nX;
        float fY2 = fY0 + ss * nY;
        Color firstColor = this.multiplyByIntensity(colors[this.index[0]]);
        Color secondColor = this.multiplyByIntensity(colors[this.index[2]]);
        GradientPaint gradient = new GradientPaint(fX0, fY0, firstColor, fX2, fY2, secondColor, true);
        return gradient;
    }

    public final void doIndex(double[] d) {
        if (d[0] <= d[1]) {
            if (d[1] <= d[2]) {
                this.index[0] = 0;
                this.index[1] = 1;
                this.index[2] = 2;
            } else if (d[0] <= d[2]) {
                this.index[0] = 0;
                this.index[1] = 2;
                this.index[2] = 1;
            } else {
                this.index[0] = 2;
                this.index[1] = 0;
                this.index[2] = 1;
            }
        } else if (d[2] <= d[1]) {
            this.index[0] = 2;
            this.index[1] = 1;
            this.index[2] = 0;
        } else if (d[0] <= d[2]) {
            this.index[0] = 1;
            this.index[1] = 0;
            this.index[2] = 2;
        } else {
            this.index[0] = 1;
            this.index[1] = 2;
            this.index[2] = 0;
        }
    }

    public static boolean doIndex(int[] index, double[] d) {
        if (d[0] <= d[1]) {
            if (d[1] <= d[2]) {
                index[0] = 0;
                index[1] = 1;
                index[2] = 2;
                return true;
            }
            if (d[0] <= d[2]) {
                index[0] = 0;
                index[1] = 2;
                index[2] = 1;
                return false;
            }
            index[0] = 2;
            index[1] = 0;
            index[2] = 1;
            return true;
        }
        if (d[2] <= d[1]) {
            index[0] = 2;
            index[1] = 1;
            index[2] = 0;
            return false;
        }
        if (d[0] <= d[2]) {
            index[0] = 1;
            index[1] = 0;
            index[2] = 2;
            return false;
        }
        index[0] = 1;
        index[1] = 2;
        index[2] = 0;
        return true;
    }
}

