/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IDataProcessor;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.ITrendlineEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.NatCubic;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SmoothEngine
implements ITrendlineEngine {
    private boolean isValid = false;
    private List<Point2D> dataSet = new ArrayList<Point2D>();

    SmoothEngine() {
    }

    @Override
    public void processDataValues(List<Point2D> data) {
        assert (this.dataSet.isEmpty());
        for (Point2D pt : data) {
            if (pt == null) continue;
            this.dataSet.add(pt);
        }
        if (this.dataSet.size() > 1) {
            this.isValid = true;
        }
    }

    @Override
    public List<Point> generateCurve(int seriesId, IDataProcessor dataProcessor) {
        if (!this.isValid) {
            return Collections.EMPTY_LIST;
        }
        Polygon poly = new Polygon();
        for (Point2D pt : this.dataSet) {
            if (pt == null) continue;
            int x = dataProcessor.getXAxisCoord(seriesId, pt.getX());
            int y = dataProcessor.getYAxisCoord(seriesId, pt.getY());
            poly.addPoint(x, y);
        }
        Polygon polyInter = NatCubic.interpolate(poly);
        if (polyInter.npoints == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Point> vcPts = new ArrayList<Point>();
        for (int i = 0; i < polyInter.npoints; ++i) {
            vcPts.add(new Point(polyInter.xpoints[i], polyInter.ypoints[i]));
        }
        return vcPts;
    }

    @Override
    public void setSmoothingFactor(int smoothFactor) {
    }

    @Override
    public String getCorrelationText(Format format) {
        return "";
    }

    @Override
    public String getEquationText(Format format) {
        return "";
    }
}

