/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.ICurveFit;

class FitExponential
implements ICurveFit {
    private static final int NUM_COEFFS = 2;

    FitExponential() {
    }

    public double compute(double x, double[] a) {
        assert (a.length >= 3);
        double y = a[1] * Math.pow(a[2], x);
        return y;
    }

    public void eval(double x, double[] a) {
        assert (a.length >= 3);
        a[1] = 1.0;
        a[2] = x;
    }

    public int numCoeffs() {
        return 2;
    }

    public double transformY(double y) {
        assert (y > 0.0);
        return Math.log(y);
    }

    public double invTransformCoeff(int ia, double a) {
        return Math.exp(a);
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) {
        assert (strCoeffs.length >= 3);
        String strTerm1 = strCoeffs[1];
        String strTerm2 = strCoeffs[2] + "^x";
        return "y = " + strTerm1 + " * " + strTerm2;
    }
}

