/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AutoNumberFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.Access;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IAxisScale;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.NumericScale;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.OrdinalScale;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.Axis2DObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import java.awt.Rectangle;
import java.text.Format;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RelativeAxisObj
extends AxisObj
implements INumericAxis {
    final NumericScale m_numericScale;
    private final OrdinalScale m_ordinalScale;
    private final IAxisScale axisScale;

    RelativeAxisObj(Perspective perspective, Access access, AxisTemplate id, int nOrdinalAxisType, boolean bAscending) {
        this(perspective, access, id, nOrdinalAxisType, bAscending, 0, 100);
    }

    RelativeAxisObj(Perspective perspective, Access access, AxisTemplate id, int nOrdinalAxisType, boolean bAscending, int nAxisOffset, int nAxisSize) {
        super(perspective, access, id, bAscending, nAxisOffset, nAxisSize);
        double fAxisLengthRel = (double)nAxisSize / 100.0;
        double fAxisPositionRel = (double)nAxisOffset / 100.0;
        int nNumSeries = access.getNumNonIgnoredSeries();
        int nNumGroups = access.getNumGroups();
        int nNumTotalGroups = access.getNumTotalGroups();
        this.m_numericScale = null;
        this.m_ordinalScale = new OrdinalScale(perspective, nOrdinalAxisType, nNumSeries, nNumGroups, fAxisLengthRel, fAxisPositionRel, bAscending, nNumTotalGroups, this.m_template);
        this.axisScale = this.m_ordinalScale;
        this.calc(false);
    }

    protected RelativeAxisObj(Perspective perspective, Access access, AxisTemplate template, MinMaxObj minMaxObj, boolean bAscending, int nAxisOffset, int nAxisSize) {
        super(perspective, access, template, bAscending, nAxisOffset, nAxisSize);
        this.m_ordinalScale = null;
        this.m_numericScale = new NumericScale(perspective, template, minMaxObj, bAscending, nAxisOffset, nAxisSize, this.m_fAxisLengthRel, this.m_fAxisPositionRel);
        this.axisScale = this.m_numericScale;
        this.calc(false);
    }

    public void calc(boolean bDraw) {
        boolean bDataOK = true;
        if (this.isNumericAxis()) {
            bDataOK = this.m_numericScale.calcNumericScaleInternal();
        } else {
            this.calcOrdinalScale();
        }
        if (bDataOK) {
            this.updateNumberFormat(this.m_LabelFormat, true);
            this.updateNumberFormat(this.m_DataTextFormat, false);
            this.calcNumLabels();
            if (bDraw) {
                super.calc();
            }
        }
    }

    @Override
    public void pdeCalc(Rectangle frameRect) {
        if (this instanceof Axis2DObj && frameRect != null) {
            Axis2DObj axis2DObj = (Axis2DObj)this;
            Rectangle oldFrame = axis2DObj.m_rFrame;
            axis2DObj.resetFrame(frameRect);
            this.calc(true);
            axis2DObj.resetFrame(oldFrame);
        } else {
            this.calc(true);
        }
    }

    @Override
    public void calc() {
        this.calc(true);
    }

    @Override
    public boolean isNumericAxis() {
        return this.m_ordinalScale == null;
    }

    protected void updateNumberFormat(Format format, boolean useSpan) {
        if (this.isNumericAxis() && format instanceof AutoNumberFormat) {
            AutoNumberFormat autoFormat = (AutoNumberFormat)format;
            if (this.m_gt.isPercent()) {
                autoFormat.setPercent();
            } else if (useSpan) {
                autoFormat.setSpan(this.m_numericScale.getMaxValue() - this.m_numericScale.getMinValue());
            } else {
                autoFormat.setSpan(1.0);
            }
        }
    }

    @Override
    public double getMajorGridPos(int nIndex) {
        return this.axisScale.getMajorGridPos(nIndex);
    }

    @Override
    protected double getMinorGridPos(int nMajorIndex, int nMinorIndex) {
        return this.axisScale.getMinorGridPos(nMajorIndex, nMinorIndex);
    }

    @Override
    protected double getLabelRelPos(int nIndex) {
        if (this.isNumericAxis()) {
            return this.getMajorGridPos(nIndex);
        }
        return this.m_ordinalScale.getCenterRelCoord(nIndex);
    }

    private void calcNumLabels() {
        this.axisScale.calcNumLabels();
    }

    @Override
    protected int getNumLabels() {
        return this.axisScale.getNumLabels();
    }

    @Override
    public int getNumMajorGrids() {
        int nNumMajorGrids = this.isNumericAxis() ? this.getNumLabels() : this.m_ordinalScale.getNumMajorGrids();
        return nNumMajorGrids;
    }

    @Override
    protected int getNumMinorGrids() {
        return this.axisScale.getNumMinorGrids();
    }

    @Override
    protected void calcOrdinalScale() {
        this.m_ordinalScale.calcOrdinalScale();
    }

    public void setMultiBarAlignMaxSeriesCount(int nSeriesCount) {
        this.m_ordinalScale.setMultiBarAlignOverrideSeriesCount(nSeriesCount);
    }

    protected double getLowRelCoord(int seriesId, int groupId) {
        return this.m_ordinalScale.getLowRelCoord(seriesId, groupId);
    }

    public double getCenterRelCoord(double g) {
        double fCoord = this.m_ordinalScale.getCenterRelCoord(g);
        return fCoord;
    }

    protected boolean useSeriesLabels() {
        boolean bUseSeriesLabels = this.m_ordinalScale.useSeriesLabels();
        return bUseSeriesLabels;
    }

    protected int getGroupAboveRelCoord(double fCoord) {
        int nGroupAbove = this.m_ordinalScale.getGroupAboveRelCoord(fCoord);
        return nGroupAbove;
    }

    protected int getGroupBelowRelCoord(double fCoord) {
        int nGroupBelow = this.m_ordinalScale.getGroupBelowRelCoord(fCoord);
        return nGroupBelow;
    }

    protected double getHighRelCoord(int s, int g) {
        double fHighRelCoord = this.m_ordinalScale.getHighRelCoord(s, g);
        return fHighRelCoord;
    }

    @Override
    public double getBaseRelCoord() {
        double fBaseRel = this.m_numericScale.getBaseRelCoord();
        return fBaseRel;
    }

    @Override
    public List<String> getNumericLabels() {
        assert (this.isNumericAxis());
        if (this.isNumericAxis()) {
            return this.m_numericScale.getNumericLabels();
        }
        return null;
    }

    @Override
    public List<Double> getNumericLabelsAsDouble() {
        assert (this.isNumericAxis());
        if (this.isNumericAxis()) {
            return this.m_numericScale.getNumericLabelsAsDouble();
        }
        return null;
    }

    @Override
    public double getValueFromRelCoord(double fCoord) {
        assert (this.isNumericAxis());
        return this.m_numericScale.getValueFromRelCoord(fCoord);
    }

    @Override
    public double getValueRelCoord(double fValue) {
        return this.m_numericScale.getValueRelCoord(fValue);
    }

    @Override
    public boolean hasNegData() {
        assert (this.isNumericAxis());
        return this.m_numericScale.hasNegData();
    }

    @Override
    public boolean isZeroInRange() {
        assert (this.isNumericAxis());
        return this.m_numericScale.isZeroInRange();
    }

    @Override
    public boolean isLogScale() {
        return this.m_numericScale.isLogScale();
    }

    @Override
    public boolean isDateScale() {
        return this.m_numericScale.isDateScale();
    }

    @Override
    public final double getMinCoord() {
        assert (this.isNumericAxis());
        double fDoubleForMinCoord = this.m_numericScale.getDoubleForMinCoord();
        return this.getValueCoord(fDoubleForMinCoord);
    }

    @Override
    public final double getMaxCoord() {
        assert (this.isNumericAxis());
        double fDoubleForMaxCoord = this.m_numericScale.getDoubleForMaxCoord();
        return this.getValueCoord(fDoubleForMaxCoord);
    }

    @Override
    public final double getMinValue() {
        assert (this.isNumericAxis());
        return this.m_numericScale.getMinValue();
    }

    @Override
    public final double getBaseMax() {
        assert (this.isNumericAxis());
        return this.m_numericScale.getBaseMax();
    }

    @Override
    public final double getBaseMin() {
        assert (this.isNumericAxis());
        return this.m_numericScale.getBaseMin();
    }

    @Override
    public final double getMaxValue() {
        assert (this.isNumericAxis());
        return this.m_numericScale.getMaxValue();
    }

    @Override
    public final double getStepValue() {
        assert (this.isNumericAxis());
        return this.m_numericScale.getStepValue();
    }

    @Override
    public boolean isValueOffscale(double fValue) {
        assert (this.isNumericAxis());
        return this.m_numericScale.isValueOffscale(fValue);
    }
}

