/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.IDateScale;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.Access;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Bar2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Depth2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IGanttAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IOrdinalAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.TaskSpacing;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Polygon;
import java.awt.Rectangle;

class AxisTaskObj
implements IGanttAxis {
    public static final int X_RIGHTCLIP_PASTFRAME = 300;
    public static final int X_PERCENT_COMPLETE_TOP_LABEL_MARGIN = 1000;
    public static final int X_PERCENT_COMPLETE_MARGIN = 2000;
    public static final int X_PERCENT_COMPLETE_WIDTH = 1000;
    public static final int X_PERCENT_COMPLETE_HEIGHT = 1000;
    public static final int Y_EXTRATASKS_YSPACE_BELOWFRAME = 500;
    public static final int Y_EXTRATASKS_BETTER_VISIBILITY = 3;
    public static final int MAX_TASKSIZE_WIDTHVC = 16000;
    private Access m_Access;
    private TaskSpacing m_taskSpacing;
    private Perspective m_Perspective;
    private IDateScale m_dateScale;
    private Rectangle m_rFrame;
    private int m_nXRightFrameClip;
    private INumericAxis m_timeAxisStandard;
    private IOrdinalAxis m_taskAxisStandard;
    private boolean m_useStandardDraw;
    private int m_taskHeight;
    private boolean m_showLinks;
    private Bar2D m_bar2D;

    AxisTaskObj(Perspective perspective, INumericAxis timeAxis, IOrdinalAxis taskAxis, Access access, Depth2D depth2D) {
        this.m_Perspective = perspective;
        this.m_dateScale = null;
        this.m_useStandardDraw = true;
        this.m_timeAxisStandard = timeAxis;
        this.m_taskAxisStandard = taskAxis;
        this.m_Access = access;
        this.m_bar2D = new Bar2D(perspective, perspective.getDetectiv(), depth2D);
    }

    public void calc(double fStartDate, double fEndDate, double fCurrDate) {
        this.m_rFrame = this.m_Perspective.getFrameRect(false);
        this.m_taskSpacing = new TaskSpacing(this.m_Perspective, this.m_Access);
        this.m_taskHeight = this.m_useStandardDraw ? (int)(this.m_taskAxisStandard.getHighCoord(0, 0) - this.m_taskAxisStandard.getLowCoord(0, 0)) : this.m_taskSpacing.calcTaskHeight();
        this.m_showLinks = this.m_Perspective.getDisplay(Identity.ChildLinkLine);
        this.m_nXRightFrameClip = this.m_rFrame.x + this.m_rFrame.width + 300;
    }

    boolean dateRangeCheckX(int value) {
        if (this.m_timeAxisStandard != null) {
            return true;
        }
        throw new RuntimeException("Not Implemented");
    }

    public int clipXToRightFrame(int nX) {
        if (!this.dateRangeCheckX(nX) || nX > this.m_nXRightFrameClip) {
            nX = this.m_nXRightFrameClip;
        }
        return nX;
    }

    public void drawAllTasks() {
        int nTotalGroups = this.m_Perspective.getNumTotalGroups();
        int nMaxNumTasks = this.m_taskSpacing.calcMaxNumTasks(this.m_taskHeight);
        int nNumTasks = 0;
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.m_Access);
        while (gEnum.hasNext() && nNumTasks < nMaxNumTasks) {
            int g = gEnum.next();
            int nY = this.calcTaskYCoord(g);
            assert (g >= 0 && g < nTotalGroups);
            boolean bRolledUpTask = this.m_taskSpacing.isTaskRolledUp(g);
            if (bRolledUpTask) continue;
            DataItem dataItem = DataItem.DI_GANTT_STARTDATE;
            double fStartDate = this.m_Access.getDataAsDouble(0, g, dataItem, true);
            dataItem = DataItem.DI_GANTT_STOPDATE;
            double fStopDate = this.m_Access.getDataAsDouble(0, g, dataItem, true);
            this.drawTask(fStartDate, fStopDate, nY, this.m_taskHeight, 0, g);
        }
    }

    private int calcTaskYCoord(int taskIndex) {
        int yCoord;
        if (this.m_useStandardDraw) {
            yCoord = (int)this.m_taskAxisStandard.getLowCoord(0, taskIndex);
        } else {
            int nSpaceBetTasksVC = this.m_taskSpacing.getSpaceBetTasks();
            yCoord = this.m_rFrame.y + this.m_rFrame.height;
            yCoord -= (nSpaceBetTasksVC + this.m_taskHeight) * (taskIndex + 1);
        }
        return yCoord;
    }

    private void drawTask(double fStartDate, double fStopDate, int nY, int nHeight, int series, int group) {
        int nStartX = this.dateToXVC(fStartDate);
        int nStopX = this.dateToXVC(fStopDate);
        if (fStartDate < fStopDate && this.dateRangeCheckX(nStartX)) {
            nStopX = this.clipXToRightFrame(nStopX);
            int nWidth = nStopX - nStartX;
            IBlackBox bbTask = this.m_Perspective.getGraphObject().assignSeriesColor(series, group);
            this.m_bar2D.draw(series, group, new Rectangle(nStartX, nY, nWidth, nHeight), bbTask, null);
        }
    }

    public void drawAllLinks() {
        if (!this.m_showLinks) {
            return;
        }
        int nTotalGroups = this.m_Perspective.getNumTotalGroups();
        int nMaxNumTasks = this.m_taskSpacing.calcMaxNumTasks(this.m_taskHeight);
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.m_Access);
        for (int nNumTasks = 0; gEnum.hasNext() && nNumTasks < nMaxNumTasks; ++nNumTasks) {
            boolean bDatesEqual;
            int nParentTask = gEnum.next();
            assert (nParentTask >= 0 && nParentTask < nTotalGroups);
            DataItem dataItem = DataItem.DI_GANTT_CHILDLINKLINE;
            double fChildLink = nParentTask;
            int nChildTask = (int)fChildLink;
            boolean bChildLinkValid = fChildLink > 0.0 && nChildTask >= 0 && nChildTask < nTotalGroups;
            dataItem = DataItem.DI_GANTT_STOPDATE;
            double fStopDateParent = this.m_Access.getDataAsDouble(0, nParentTask, dataItem, true);
            double fStartDateChild = 0.0;
            boolean bTaskRolledUp = false;
            if (bChildLinkValid) {
                dataItem = DataItem.DI_GANTT_STARTDATE;
                fStartDateChild = this.m_Access.getDataAsDouble(0, nChildTask, dataItem, true);
                bTaskRolledUp = this.m_taskSpacing.isTaskRolledUp(nChildTask);
            }
            bChildLinkValid = bChildLinkValid && nChildTask < nMaxNumTasks && !bTaskRolledUp;
            boolean bl = bDatesEqual = fStopDateParent == fStartDateChild;
            if (!bChildLinkValid) continue;
            this.drawLink(nParentTask, nChildTask, fStopDateParent, fStartDateChild, bDatesEqual);
        }
    }

    private void drawLink(int nParentTask, int nChildTask, double fStopDateParent, double fStartDateChild, boolean bJustVerticalLine) {
        int nXParent = this.dateToXVC(fStopDateParent);
        int nYParent = this.taskToYVC(nParentTask);
        int nXChild = this.dateToXVC(fStartDateChild);
        int nYChild = this.calcTaskYCoord(nChildTask);
        IdentObj idChildLinkLine = Identity.ChildLinkLine;
        IdentObj idNew = idChildLinkLine.changeSeries(nParentTask).changeMisc(1);
        IdentObj perspID = Identity.ChildLinkLine;
        Color color = this.m_Perspective.getBorderColor(perspID);
        double fLineWidth = this.m_Perspective.getLineWidth(perspID);
        BlackBoxObj bbLink = new BlackBoxObj(this.m_Perspective, idNew);
        bbLink.setBorderColor(color);
        int nVirtLineWidth = this.m_Perspective.getVC().destToVirtWidth(fLineWidth);
        int nYMiddleOfChild = nYChild + this.m_taskHeight / 2;
        if (nXParent > this.m_nXRightFrameClip) {
            nXParent = this.m_nXRightFrameClip;
        }
        if (nXChild > this.m_nXRightFrameClip) {
            nXChild = this.m_nXRightFrameClip;
        }
        Java2DLine line2D = new Java2DLine(this.m_Perspective);
        if (bJustVerticalLine) {
            int nArrowSize = nVirtLineWidth * 2;
            int nYTopOfChild = nYChild + this.m_taskHeight;
            line2D.createLine(idChildLinkLine, idNew, nXParent, nYParent, nXParent, nYTopOfChild + nArrowSize, bbLink, null, fLineWidth);
            idNew = idNew.changeMisc(3);
            bbLink.setFillColor(color);
            Polygon polyArrow = new Polygon();
            polyArrow.addPoint(nXChild - nArrowSize, nYTopOfChild + nArrowSize * 2);
            polyArrow.addPoint(nXChild + nArrowSize, nYTopOfChild + nArrowSize * 2);
            polyArrow.addPoint(nXChild, nYTopOfChild);
            polyArrow.addPoint(nXChild - nArrowSize, nYTopOfChild + nArrowSize * 2);
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), idNew, polyArrow, (IBlackBox)bbLink, null);
        } else {
            line2D.createLine(idChildLinkLine, idNew, nXParent, nYParent, nXParent, nYMiddleOfChild - nVirtLineWidth, bbLink, null, fLineWidth);
            idNew = idNew.changeMisc(2);
            line2D.createLine(idChildLinkLine, idNew, nXParent - nVirtLineWidth / 2, nYMiddleOfChild, nXChild - nVirtLineWidth * 2, nYMiddleOfChild, bbLink, null, fLineWidth);
            idNew = idNew.changeMisc(3);
            bbLink.setFillColor(color);
            Polygon polyArrow = new Polygon();
            int nArrowSize = nVirtLineWidth * 3;
            polyArrow.addPoint(nXChild - nArrowSize, nYMiddleOfChild - nArrowSize);
            polyArrow.addPoint(nXChild, nYMiddleOfChild);
            polyArrow.addPoint(nXChild - nArrowSize, nYMiddleOfChild + nArrowSize);
            polyArrow.addPoint(nXChild - nArrowSize, nYMiddleOfChild - nArrowSize);
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), idNew, polyArrow, (IBlackBox)bbLink, null);
        }
    }

    private int taskToYVC(int parentTask) {
        if (this.m_taskAxisStandard == null) {
            throw new RuntimeException("Not Implemented");
        }
        return (int)this.m_taskAxisStandard.getCenterCoord(parentTask);
    }

    private int dateToXVC(double value) {
        if (this.m_dateScale != null) {
            return this.m_dateScale.dateToXVC(value);
        }
        if (this.m_timeAxisStandard != null) {
            return (int)this.m_timeAxisStandard.getValueCoord(value);
        }
        throw new RuntimeException("Not Implemented");
    }

    public void drawAllRollups() {
        int nTotalSeries = this.m_Perspective.getNumTotalSeries();
        int nMaxNumTasks = this.m_taskSpacing.calcMaxNumTasks(this.m_taskHeight);
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.m_Access);
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < nTotalSeries);
            DataItem dataItem = DataItem.DI_GANTT_PARENT_IF_ROLLEDUP;
            double fParent = -1.0;
            int nParent = (int)fParent;
            boolean bTaskRolledUp = this.m_taskSpacing.isTaskRolledUp(s);
            if (!bTaskRolledUp || nParent >= nMaxNumTasks) continue;
            Color color = this.m_Perspective.getFillColor(this.m_Perspective.getSeries(s));
            dataItem = DataItem.DI_GANTT_STARTDATE;
            double fStartDate = this.m_Access.getDataAsDouble(s, 0, dataItem, true);
            dataItem = DataItem.DI_GANTT_STOPDATE;
            double fStopDate = this.m_Access.getDataAsDouble(s, 0, dataItem, true);
            int nStartX = this.dateToXVC(fStartDate);
            int nStopX = this.dateToXVC(fStopDate);
            int nTextWidth = nStopX - nStartX;
            String sTaskText = this.m_Perspective.getSeriesLabel(s);
            int nYParent = this.m_taskSpacing.getTaskY(nParent);
            int nSpacing = this.m_taskSpacing.getSpaceBetTasks();
            int nHeight = nSpacing / 2;
            int nStartY = nYParent - nSpacing + nSpacing / 3;
            Rectangle rTask = new Rectangle(nStartX, nStartY, nTextWidth, nHeight);
            if (nStartX < this.m_nXRightFrameClip && nStopX != 50000) {
                IdentObj idRollup = Identity.RollupLabel;
                IdentObj idNew = idRollup.changeSeries(s);
                sTaskText = this.truncLabel(sTaskText, idNew, rTask);
                this.drawLabel(idNew, color, rTask, sTaskText);
            }
            IdentObj idRollupDot = Identity.RollupDot;
            IdentObj idNewDot = idRollupDot.changeSeries(s);
            int nDotWidth = this.m_taskHeight / 3 + this.m_taskHeight / 3;
            int nXDot = nStartX + nTextWidth / 2 - nDotWidth / 2;
            int nYDot = nYParent + this.m_taskHeight / 5;
            Rectangle rDot = new Rectangle(nXDot, nYDot, nDotWidth, nDotWidth);
            this.drawRollupDot(idNewDot, color, rDot);
        }
    }

    private String truncLabel(String strTaskText, IdentObj idLabel, Rectangle rTask) {
        String strNew = strTaskText;
        int nTextBoxRight = rTask.x + rTask.width;
        if (nTextBoxRight > this.m_nXRightFrameClip) {
            double fNumCharsToTrunc;
            int nRightClip = this.clipXToRightFrame(rTask.x + rTask.width);
            double fTruncRatio = Math.abs(((double)nTextBoxRight - (double)nRightClip) / (double)rTask.width);
            int nLength = strTaskText.length();
            double fTruncLength = (double)nLength - (fNumCharsToTrunc = fTruncRatio * (double)nLength);
            if (fTruncLength > 0.0) {
                strNew = strTaskText.substring(0, (int)(fTruncLength -= 3.0));
                strNew = strNew.concat("...");
            }
        }
        return strNew;
    }

    private void drawLabel(IdentObj idLabel, Color color, Rectangle rLabelVC, String strText) {
        ITextStyle textStyle = this.m_taskSpacing.getTaskTextStyle(idLabel);
        VC theVC = this.m_Perspective.getVC();
        double nFontSizeDC = textStyle.getFontSizeDC(theVC);
        Dimension dimMaxVC = new Dimension(rLabelVC.width, rLabelVC.height);
        Dimension dimMaxDC = theVC.virtToDest(dimMaxVC);
        boolean bTextWrap = textStyle.getWordWrap();
        Dimension dimTextBoxDC = textStyle.getTextSizeDC(strText, nFontSizeDC, dimMaxDC, null, bTextWrap);
        Dimension dimTextBoxVC = theVC.destToVirt(dimTextBoxDC);
        rLabelVC.width = dimTextBoxVC.width;
        rLabelVC.height = dimTextBoxVC.height;
        BlackBoxObj bbLabel = new BlackBoxObj(this.m_Perspective, idLabel);
        bbLabel.setFillColor(color);
        DrawFactory.createLabel(this.m_Perspective.getDetectiv(), idLabel, strText, rLabelVC, textStyle, bbLabel, null);
    }

    private void drawRollupDot(IdentObj idRollupDot, Color color, Rectangle rRollupDot) {
        BlackBoxObj bbRollupDot = new BlackBoxObj(this.m_Perspective, idRollupDot);
        bbRollupDot.setFillColor(color);
        DrawFactory.createOval(this.m_Perspective.getDetectiv(), idRollupDot, rRollupDot.x, rRollupDot.y, rRollupDot.width, rRollupDot.height, bbRollupDot, null, false);
    }
}

