/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataLabels;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.Access;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DatumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.IDataStorage;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.AnnotationBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.SimpleBlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.LegendObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MissingData;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import org.apache.log4j.Logger;

public abstract class JChart_Base
implements IChartEngine {
    private static final Logger logger = Logger.getLogger((String)"com.businessobjects.visualization.pfjgraphics.rendering.pfj.JChart_Base");
    public static final int CM_AUTOMATIC = 0;
    public static final int CM_SERIES = 1;
    public static final int CM_GROUP = 2;
    public static final int CM_HEIGHT = 3;
    public static final int LARGE_DATASET = 899;
    final Perspective m_Perspective;
    private Access m_Access;
    final JGraphType m_gt;
    private IDrawContainer drawContainer;
    int m_nTotalSeries;
    int m_nTotalGroups;
    int m_nSeries;
    int m_nGroups;
    boolean m_bAbsolute;
    boolean m_bStacked;
    boolean m_bWantRiserBorder;
    boolean m_bSmallDataSet;
    boolean m_bColorAutoshadeRisers;
    int m_nEffColorMode;
    int m_nSeriesLooping;
    boolean[] m_bSeriesHasSFX;
    int m_nFillMissingData;
    boolean m_bForceAbsoluteDrawNonStackedInProgress = false;
    DataLabels m_DataLabels;
    SeriesEnumerator m_sEnumForward;
    SeriesEnumerator m_sEnumReverse;
    GroupsEnumerator m_gEnumForward;
    GroupsEnumerator m_gEnumReverse;
    private MissingData m_missData = null;
    Rectangle m_rAvailableSpace;

    protected JChart_Base(Perspective perspective) {
        this.m_Perspective = perspective;
        this.m_gt = this.m_Perspective.getJGraphType();
    }

    public void init() {
        assert (this.m_Access != null);
        this.copyParams();
    }

    public final void setDataView(Access dataView) {
        this.m_Access = dataView;
        this.m_nSeries = this.m_Access.getNumNonIgnoredSeries();
        this.m_nGroups = this.m_Access.getNumGroups();
    }

    public final Access getDataView() {
        return this.m_Access;
    }

    public IBlackBox assignSeriesColor(int s, int g) {
        IBlackBox retVal = null;
        if (this.m_Perspective.isColorByGroup()) {
            retVal = this.assignSeriesColor(g);
            retVal.setBorderProperties(this.assignSeriesIdent(s));
        } else {
            retVal = this.assignSeriesColor(s);
        }
        Color highlight = this.m_Perspective.getColorHighlight(s, g);
        if (highlight != null) {
            retVal.setHighlightColor(highlight);
        }
        return retVal;
    }

    public IBlackBox assignSeriesColor(int series) {
        IBlackBox retVal = this.assignSeriesColor(this.assignSeriesIdent(series));
        Color highlight = this.m_Perspective.getColorHighlight(series);
        if (highlight != null) {
            retVal.setHighlightColor(highlight);
        }
        return retVal;
    }

    private IBlackBox assignSeriesColor(IdentObj idSeries) {
        return new BlackBoxObj(this.m_Perspective, idSeries);
    }

    private IdentObj assignSeriesIdent(int s) {
        return new IdentObj(-3, s % this.m_nSeriesLooping);
    }

    public void calculate(IDrawContainer renderModel) {
        this.drawContainer = renderModel;
        this.calc();
        this.calcLegend();
    }

    public void calc() {
        this.copyParams();
        this.calcLast();
    }

    private void calcLast() {
        this.calcAllMissingData();
    }

    public void calcForceAbsolute() {
        this.copyParams();
        this.m_bAbsolute = true;
        this.m_bStacked = false;
        this.m_bForceAbsoluteDrawNonStackedInProgress = true;
        this.calcLast();
    }

    private void calcAllMissingData() {
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (this.m_nFillMissingData != 0 && gt.isBLAType()) {
            boolean bFirstTime = false;
            if (this.m_missData == null) {
                bFirstTime = true;
            }
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
            this.m_missData = new MissingData(this, this.m_Perspective, this.m_Access, this.m_Perspective.getDataStorage());
            this.m_missData.calcMissingData(sEnum, bFirstTime);
        }
    }

    public final void calcLegend() {
        if (this.m_Perspective.getLegendDisplay() && this.wantLegend() && this.m_Perspective.getJGraphType().hasLegend()) {
            LegendObj.calc(this.m_Perspective);
        }
    }

    protected void copyParams() {
        this.drawContainer = this.m_Perspective.getDetectiv();
        this.m_nSeries = this.m_Access.getNumNonIgnoredSeries();
        this.m_nGroups = this.m_Access.getNumGroups();
        this.m_bSmallDataSet = this.m_nSeries * this.m_nGroups < 899;
        this.m_nTotalSeries = this.m_Access.getNumTotalSeries();
        this.m_nTotalGroups = this.m_Access.getNumTotalGroups();
        this.m_bForceAbsoluteDrawNonStackedInProgress = false;
        this.m_bAbsolute = this.m_gt.isScalingAbs();
        this.m_bStacked = this.m_gt.isScalingStacked();
        this.m_nEffColorMode = this.m_Perspective.getEffectiveColorMode();
        this.m_bColorAutoshadeRisers = this.m_Perspective.getAutoshading() && this.m_bSmallDataSet;
        this.m_nFillMissingData = this.m_Perspective.getFillMissingData();
        switch (this.m_Perspective.getRiserBorderMode()) {
            case 0: {
                this.m_bWantRiserBorder = this.m_bSmallDataSet;
                break;
            }
            case 1: {
                this.m_bWantRiserBorder = false;
                break;
            }
            case 2: {
                this.m_bWantRiserBorder = true;
                break;
            }
            default: {
                throw new RuntimeException("RiserBorderMode problem: " + this.m_Perspective.getRiserBorderMode());
            }
        }
        this.m_Perspective.setFillType(Identity.ColorByHeight, 2);
        this.m_bSeriesHasSFX = new boolean[this.m_nTotalSeries];
        for (int s = 0; s < this.m_nTotalSeries; ++s) {
            IdentObj idSeries = this.m_Perspective.getSeries(s);
            this.m_bSeriesHasSFX[s] = this.m_Perspective.getFillType(idSeries) != 1 || this.m_Perspective.getShadowDisplay(idSeries);
        }
        this.m_sEnumForward = SeriesEnumerator.getIterator(this.m_Perspective, this.m_Access);
        this.m_sEnumReverse = SeriesEnumerator.getReverseIterator(this.m_Perspective, this.m_Access);
        this.m_gEnumForward = GroupsEnumerator.getIterator(this.m_Perspective, this.m_Access);
        this.m_gEnumReverse = GroupsEnumerator.getReverseIterator(this.m_Perspective, this.m_Access);
        this.m_nSeriesLooping = this.m_Perspective.getSeriesLooping();
    }

    public Point dataToVirtualCoords(IdentObj id, double x, double y) {
        throw new UnsupportedOperationException("dataToVirtualCoords not supported by chart type " + this.m_gt);
    }

    public MinMaxObj findPreScaledLimits(int nAxis, int nScaling, boolean bMustIncludeZero) {
        return null;
    }

    protected IBlackBox getBlackBox(IdentObj id) {
        int s = id.getSeriesID();
        int g = id.getGroupID();
        IBlackBox bb = s != -3 ? this.assignSeriesColor(s, g) : new BlackBoxObj(this.m_Perspective, id);
        return bb;
    }

    public IBlackBox getBlackBox(IdentObj id, double fRatio) {
        assert (fRatio >= 0.0 && fRatio <= 1.0);
        if (fRatio < 0.0) {
            fRatio = 0.0;
        } else if (fRatio > 1.0) {
            fRatio = 1.0;
        }
        BlackBoxObj bbGradient = new BlackBoxObj(this.m_Perspective, Identity.ColorByHeight);
        IBlackBox bb = this.getBlackBox(id);
        bb.setFillColor(bbGradient.getGradientColorAt(fRatio));
        return bb;
    }

    DatumObj getDataValue(int s, int g) {
        return this.getDataValue(s, g, DataItem.DI_GENERAL, false);
    }

    DatumObj getDataValue(int s, int g, DataItem item) {
        return this.getDataValue(s, g, item, false);
    }

    DatumObj getDataValue(int s, int g, DataItem item, boolean ignoreDataRange) {
        boolean bStatus = true;
        double fValue = this.m_Access.getDataAsDouble(s, g, item, ignoreDataRange);
        if (!Double.isNaN(fValue)) {
            if (this.m_nFillMissingData != 0 && this.m_Access.getDataStorage().isMissingDataFilledIn(s, g)) {
                bStatus = true;
            }
        } else {
            fValue = 0.0;
            bStatus = false;
        }
        DatumObj dObj = new DatumObj(fValue, bStatus);
        return dObj;
    }

    public String getStringDataValue(int series, int group, DataItem item, boolean ignoreDataRange) {
        String str = this.m_Access.getDataAsString(series, group, item);
        if (str == null) {
            str = "";
        }
        return str;
    }

    public String getStringDataValue(int series, int group, DataItem item) {
        return this.getStringDataValue(series, group, item, false);
    }

    public void setDataAsDouble(int series, int group, DataItem item, double d, boolean ignoreDataRange) {
        this.m_Access.setDataAsDouble(series, group, item, d, ignoreDataRange);
    }

    public void setDataAsDouble(int series, int group, DataItem item, double d) {
        this.setDataAsDouble(series, group, item, d, false);
    }

    public void setDataAsString(int series, int group, DataItem item, String str, boolean ignoreDataRange) {
        this.m_Access.setDataAsString(series, group, item, str, ignoreDataRange);
    }

    public void setDataAsString(int series, int group, DataItem item, String str) {
        this.setDataAsString(series, group, item, str, false);
    }

    public final IDrawContainer getDrawContainer() {
        return this.drawContainer;
    }

    public double getQuantizedDataValue(int nSeries, int nGroup) {
        return this.getQuantizedDataValue(nSeries, nGroup, DataItem.DI_GENERAL);
    }

    public double getQuantizedDataValue(int nSeries, int nGroup, DataItem item) {
        throw new RuntimeException("Data quantization by the spectral legend not supported by chart type " + this.m_gt.getChartName());
    }

    public GroupsEnumerator getResetGroupsEnumerator() {
        GroupsEnumerator enumerator = this.m_gEnumForward.shallowCopy();
        enumerator.reset();
        return enumerator;
    }

    public GroupsEnumerator getResetGroupsEnumerator(boolean bForward) {
        GroupsEnumerator gEnum = (bForward ? this.m_gEnumForward : this.m_gEnumReverse).shallowCopy();
        gEnum.reset();
        return gEnum;
    }

    public SeriesEnumerator getResetSeriesEnumerator() {
        SeriesEnumerator enumerator = this.m_sEnumForward.shallowCopy();
        enumerator.reset();
        return enumerator;
    }

    public SeriesEnumerator getResetSeriesEnumerator(boolean bForward) {
        SeriesEnumerator sEnum = (bForward ? this.m_sEnumForward : this.m_sEnumReverse).shallowCopy();
        sEnum.reset();
        return sEnum;
    }

    public boolean isIgnoredOffScale(INumericAxis axisObj, double fValue) {
        boolean bIsOffScale = axisObj.isValueOffscale(fValue);
        return bIsOffScale && !this.allowDisplayOffScale(axisObj);
    }

    public boolean allowDisplayOffScale(INumericAxis axisObj) {
        boolean bDisplayOffScale;
        if (this.m_gt.isScatter() || this.m_gt.isBubble()) {
            bDisplayOffScale = false;
        } else {
            int nID = axisObj.getAxisObjID();
            switch (nID) {
                case 0: {
                    bDisplayOffScale = this.m_Perspective.getDisplayOffScale(2004);
                    break;
                }
                case 1: {
                    bDisplayOffScale = this.m_Perspective.getDisplayOffScale(2005);
                    break;
                }
                case 2: {
                    bDisplayOffScale = this.m_Perspective.getDisplayOffScale(2012);
                    break;
                }
                case 3: {
                    bDisplayOffScale = this.m_Perspective.getDisplayOffScale(2013);
                    break;
                }
                case 4: {
                    bDisplayOffScale = this.m_Perspective.getDisplayOffScale(2014);
                    break;
                }
                default: {
                    bDisplayOffScale = false;
                }
            }
        }
        return bDisplayOffScale;
    }

    public boolean isBadValueInLogscale(INumericAxis axisObj, double fValue) {
        boolean bIsBad = fValue <= 0.0;
        boolean bIsLog = axisObj.isLogScale();
        return bIsBad && bIsLog;
    }

    public boolean isBadValueInLogscale(int axis, double fValue) {
        boolean bIsLog;
        boolean bIsBad = fValue <= 0.0;
        switch (axis) {
            case 7: {
                bIsLog = this.m_Perspective.getX1LogScale();
                break;
            }
            case 0: {
                bIsLog = this.m_Perspective.getY1LogScale();
                break;
            }
            case 1: {
                bIsLog = this.m_Perspective.getY2LogScale();
                break;
            }
            case 2: {
                bIsLog = this.m_Perspective.getY3LogScale();
                break;
            }
            case 3: {
                bIsLog = this.m_Perspective.getY4LogScale();
                break;
            }
            case 4: {
                bIsLog = this.m_Perspective.getY5LogScale();
                break;
            }
            case 8: {
                bIsLog = false;
                break;
            }
            default: {
                bIsLog = true;
            }
        }
        return bIsBad && bIsLog;
    }

    public boolean optimizeData() {
        return false;
    }

    public void reloadOriginalData() {
    }

    public void updateDataSet(IDataStorage ds) {
    }

    public boolean wantLegend() {
        boolean isTimeScaleAxis = this.m_Perspective.getUseTimeScaleAxis();
        boolean gtWantsLegend = this.m_Perspective.getJGraphType().hasLegend();
        return gtWantsLegend && !isTimeScaleAxis;
    }

    protected IBlackBox getMissingDataBlackBox(int s, int g, int gNext) {
        SimpleBlackBoxObj bbTransp = null;
        if (this.m_nFillMissingData != 0) {
            boolean bFilledMissingData;
            boolean bl = bFilledMissingData = this.m_Access.getDataStorage().isMissingDataFilledIn(s, g) || this.m_Access.getDataStorage().isMissingDataFilledIn(s, gNext);
            if (bFilledMissingData) {
                IdentObj idSeries = this.m_Perspective.getSeries(s);
                bbTransp = new SimpleBlackBoxObj(this.m_Perspective, idSeries, this.m_bWantRiserBorder);
                bbTransp.setTransparentFillColor(true);
            }
        }
        return bbTransp;
    }

    protected IBlackBox getMissingDataBlackBox(int s, int g) {
        boolean bFilledMissingData;
        SimpleBlackBoxObj bbTransp = null;
        int nFillMissData = this.m_Perspective.getFillMissingData();
        if (nFillMissData != 0 && (bFilledMissingData = this.m_Access.getDataStorage().isMissingDataFilledIn(s, g))) {
            IdentObj idSeries = this.m_Perspective.getSeries(s);
            bbTransp = new SimpleBlackBoxObj(this.m_Perspective, idSeries, this.m_bWantRiserBorder);
            bbTransp.setTransparentFillColor(true);
        }
        return bbTransp;
    }

    protected void calcDataValueLabelPositions() {
        ITextStyle textStyle = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, Identity.DataText);
        Iterator<DataLabels.DataLabelInfo> i = this.m_DataLabels.iterator();
        while (i.hasNext()) {
            DataLabels.DataLabelInfo dataLabelInfo = i.next();
            int nDataTextPosition = this.m_Perspective.getDataTextPosition(dataLabelInfo.m_Series, dataLabelInfo.m_Group);
            int nDataTextPositionSecondary = this.m_Perspective.getDataTextPositionSecondary();
            Dimension textDC = textStyle.getTextSizeDC(dataLabelInfo.m_Text);
            Dimension dimLabelVC = this.m_Perspective.getTextRotation(Identity.DataText) == 1 || this.m_Perspective.getTextRotation(Identity.DataText) == 2 ? this.m_Perspective.getVC().destToVirt(new Dimension(textDC.height, textDC.width)) : this.m_Perspective.getVC().destToVirt(textDC);
            dataLabelInfo.m_Rectangle = this.calcDataValuePosition(dataLabelInfo.m_Series, dataLabelInfo.m_Group, nDataTextPosition, nDataTextPositionSecondary, dimLabelVC);
        }
    }

    protected void drawDataLabels() {
        this.calcDataValueLabelPositions();
        this.drawAllDataValues();
    }

    protected void drawAllDataValues() {
        IdentObj id = Identity.DataText;
        ITextStyle textStyle = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, id);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        Iterator<DataLabels.DataLabelInfo> i = this.m_DataLabels.iterator();
        while (i.hasNext()) {
            DataLabels.DataLabelInfo dataLabelInfo = i.next();
            int s = dataLabelInfo.m_Series;
            int g = dataLabelInfo.m_Group;
            Rectangle rect = dataLabelInfo.m_Rectangle;
            String text = dataLabelInfo.m_Text;
            IdentObj fullID = this.m_Perspective.getDataText(s, g);
            if (rect == null || text == null) continue;
            AnnotationBox.calcBorderedBox(this.m_Perspective, this.m_Perspective.getDataTextBox(s, g), rect, true);
            DrawFactory.createLabel(this.m_Perspective.getDetectiv(), fullID, text, rect, textStyle, blackBox, null);
        }
    }

    protected Rectangle calcDataValuePosition(int s, int g, int nDataTextPosition, int dataTextPositionSecondary, Dimension dimLabel) {
        logger.warn((Object)"You must implement this abstract function in a derived class.");
        return null;
    }

    public Rectangle getAvailableSpace() {
        return this.m_rAvailableSpace;
    }

    public void setAvailableSpace(Rectangle availableSpace) {
        this.m_rAvailableSpace = availableSpace;
    }

    public abstract IAxis getAxis(int var1);
}

