/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisDescriptor;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataLabels;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DatumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Bar2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Standard;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.NonZeroBaseLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IOrdinalAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JChart_2D_BLA
extends JChart_2D_Standard {
    public static final double DEPTH_FACTOR = 12.0;
    public static final boolean DRAW_NEG_SERIES = true;
    public static final boolean DRAW_POS_SERIES = false;
    private boolean m_bFromZero;
    private boolean m_bBipolar;
    private boolean m_bDualY;
    private boolean m_bBarAsPictograph;
    private int m_nLineThick;
    private boolean m_wantStackedConnectorLines;
    private BlackBoxObj m_stackedConnectorLinesBB;
    private boolean m_bTransparentMarkers = false;
    public static final IChartEngineFactory engineFactory = new IChartEngineFactory(){

        public IChartEngine createChartEngine(Perspective perspective) {
            return new JChart_2D_BLA(perspective);
        }
    };

    private JChart_2D_BLA(Perspective perspective) {
        super(perspective);
    }

    @Override
    public void calc() {
        if (this.anySeriesIsForcedToAbsolute() && this.m_gt.isStacked()) {
            super.calc();
            this.calcBarLineArea();
            super.calcForceAbsolute();
            this.calcBarLineArea();
        } else {
            super.calc();
            this.calcBarLineArea();
        }
    }

    private void calcBarLineArea() {
        this.m_bTransparentMarkers = this.m_Perspective.getTransparentMarkers();
        boolean isNumericAxis = this.m_Perspective.getUseNumericScaleAxis() || this.m_Perspective.getUsePGSDKTimeScaleAxis();
        boolean bIsTimeScaleAxis = this.m_Perspective.getUseTimeScaleAxis();
        if (bIsTimeScaleAxis) {
            this.calcTimeAxisOrdinalCoords();
        } else if (isNumericAxis) {
            this.calcNumericAxisOrdinalCoords();
        } else if (this.m_gt.isRiserBar() && this.isComboWithBar()) {
            this.calcBarOrdinalCoords();
        } else {
            this.calcOrdinalCoords();
        }
        if (!this.m_Perspective.getPDECalc()) {
            if (this.m_bBipolar && this.wantDepthEffect()) {
                this.calcBiPolarTwoHalfD();
            } else {
                this.drawAreaRisers();
                this.drawBarRisers();
                this.drawLineRisers();
                if (this.m_bBipolar) {
                    this.drawDualAxisLine();
                }
            }
            this.drawTrendlines();
            this.drawUserLines();
            this.drawDataLabels();
            this.drawBLAStackedValuesOnTop();
        }
    }

    private void drawBLAStackedValuesOnTop() {
        boolean bDisplayStackedValueOnTop = this.m_Perspective.getDisplay(Identity.DataTextStackedTotalOnTop);
        if (bDisplayStackedValueOnTop && this.m_bStacked) {
            this.drawStackedDataValueTotalOnTop();
        }
    }

    private void calcBiPolarTwoHalfD() {
        boolean bY1first = this.m_bHorz && this.m_nDepthAngle > 90;
        this.drawAxisAreaRisersDepth(bY1first, !bY1first);
        this.drawAxisBarRisers(bY1first, !bY1first);
        if (bY1first) {
            this.drawAxisLineRisers(0);
        } else {
            this.drawAxisLineRisers(1);
        }
        this.drawDualAxisLine();
        this.drawAxisAreaRisersDepth(!bY1first, bY1first);
        this.drawAxisBarRisers(!bY1first, bY1first);
        if (!bY1first) {
            this.drawAxisLineRisers(0);
        } else {
            this.drawAxisLineRisers(1);
        }
    }

    private void drawDualAxisLine() {
        if (this.m_Perspective.getFrameDisplay() && this.m_Perspective.getDualAxisLineDisplay()) {
            double fSplit = (double)this.m_Perspective.getDualAxisSplitPosition() / 100.0;
            this.getFrame().drawSeparator(this.m_bHorz, fSplit);
        }
    }

    @Override
    protected void calcDataAbsolute() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        double fValue = 0.0;
        int nSeriesPerPixel = this.calcRisersPerPixel();
        boolean bIsTimeScaleAxis = this.m_Perspective.getUseTimeScaleAxis();
        this.numericYCoord = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        sEnum.reset();
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            gEnum.reset();
            while (gEnum.hasNext()) {
                int g = gEnum.next();
                this.m_dataOK[s][g] = true;
                INumericAxis axisObj = this.whichAxisForSeries(s, null);
                if (axisObj == null) continue;
                DatumObj dObj = this.getDataValue(s, g, this.getDataItem());
                fValue = dObj.value;
                if (!dObj.m_bOK) {
                    this.m_dataOK[s][g] = false;
                }
                if (fValue <= 0.0 && axisObj.isLogScale()) {
                    this.m_dataOK[s][g] = false;
                    fValue = 0.0;
                }
                if (!this.m_Perspective.getForceSeriesAbsolute(s) && this.m_bForceAbsoluteDrawNonStackedInProgress) {
                    this.m_dataOK[s][g] = false;
                }
                if (this.isIgnoredOffScale(axisObj, fValue)) {
                    this.m_dataOK[s][g] = false;
                    fValue = 0.0;
                }
                if (bIsTimeScaleAxis) {
                    double value = this.getDataView().getDataAsDouble(s, g, DataItem.DI_XY_Y);
                    this.numericYCoord[s][g] = (int)axisObj.getValueCoord(value);
                } else {
                    this.numericYCoord[s][g] = (int)axisObj.getValueCoord(fValue);
                }
                if (!this.m_DataLabels.wantDataLabel(s, g) || !this.m_dataOK[s][g]) continue;
                this.m_DataLabels.setDataValue(fValue, s, g);
                this.m_DataLabels.setDataText(this.getDataString(fValue, s, g, axisObj), s, g);
            }
        }
        this.calcOverdrawEliminate(nSeriesPerPixel);
    }

    private void calcOverdrawEliminate(int nSeriesPerPixel) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        if (this.m_Perspective.getOverdrawSkip() && nSeriesPerPixel > 4) {
            gEnum.reset();
            while (gEnum.hasNext()) {
                int g = gEnum.next();
                int nBunchEnd = this.m_nSeries / nSeriesPerPixel - 1;
                for (int iBunch = 1; iBunch < nBunchEnd; ++iBunch) {
                    int s;
                    int sRel;
                    int sRelStart = iBunch * nSeriesPerPixel;
                    int sRelBound = sRelStart + nSeriesPerPixel;
                    assert (sRelBound <= this.m_nSeries);
                    int sForMin = -1;
                    int sForMax = -1;
                    int nMinCoord = Integer.MAX_VALUE;
                    int nMaxCoord = -2147483647;
                    for (sRel = sRelStart; sRel < sRelBound; ++sRel) {
                        s = sEnum.get(sRel);
                        assert (s >= 0 && s < this.m_nTotalSeries);
                        if (!this.m_dataOK[s][g]) continue;
                        int nCoord = this.numericYCoord[s][g];
                        if (nCoord < nMinCoord) {
                            nMinCoord = nCoord;
                            sForMin = s;
                        }
                        if (nCoord <= nMaxCoord) continue;
                        nMaxCoord = nCoord;
                        sForMax = s;
                    }
                    if (sForMin == -1) continue;
                    for (sRel = sRelStart; sRel < sRelBound; ++sRel) {
                        s = sEnum.get(sRel);
                        assert (s >= 0 && s < this.m_nTotalSeries);
                        if (s == sForMin || s == sForMax) continue;
                        this.m_dataOK[s][g] = false;
                    }
                }
            }
        }
    }

    @Override
    protected void copyParams() {
        super.copyParams();
        this.m_bFromZero = this.m_Perspective.getScaleFromZero();
        this.m_bBipolar = this.m_gt.isBipolar();
        this.m_bDualY = this.m_gt.isDualY();
        this.m_bBarAsPictograph = this.m_nDepthRadius > 0 ? false : this.m_Perspective.getDisplayBarAsPictograph();
        this.m_nLineThick = this.m_Perspective.getDataLineThickness();
        this.m_bar2D = new Bar2D(this.m_Perspective, this.getDrawContainer());
        this.m_DataLabels = new DataLabels(this.m_Perspective);
        this.m_wantStackedConnectorLines = this.m_Perspective.getDisplay(Identity.StackedConnectorLines);
        this.m_stackedConnectorLinesBB = this.m_wantStackedConnectorLines ? new BlackBoxObj(this.m_Perspective, Identity.StackedConnectorLines) : null;
    }

    private void drawAreaRisers() {
        if (this.m_nGroups >= 2) {
            if (this.wantDepthEffect()) {
                if (this.m_bBipolar) {
                    this.drawAxisAreaRisersDepth(false, true);
                }
                this.drawAxisAreaRisersDepth(true, false);
            } else {
                this.drawAreaRisersFlat();
                if (!this.m_bMarkerDisplay && this.m_bTransparentMarkers) {
                    this.drawTransparentMarkers(3);
                }
                if (this.m_Perspective.getDrawAreaMarkers()) {
                    this.drawMarkers();
                }
            }
        }
    }

    private void drawAreaRisersFlat() {
        boolean bForwardSeries = this.m_bAbsolute;
        boolean isStacked = this.m_Perspective.getJGraphType().isStacked();
        SeriesEnumerator seriesIter = this.getResetSeriesEnumerator(bForwardSeries);
        while (seriesIter.hasNext()) {
            INumericAxis yAxisObj;
            int s = seriesIter.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            if (this.m_depth2D.getSeriesType(s) != 3 || (yAxisObj = this.whichAxisForSeries(s, null)) == null) continue;
            NonZeroBaseLine nonZeroBase = new NonZeroBaseLine(this.m_Perspective, yAxisObj, this.m_bAbsolute, this.m_bFromZero);
            int nYBase = nonZeroBase.getYBaseLine();
            Point baseStart = null;
            Point baseEnd = null;
            Polygon poly = new Polygon();
            GroupsEnumerator groupIter = this.getResetGroupsEnumerator();
            while (groupIter.hasNext()) {
                int g = groupIter.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                Point p = this.getCoords(s, g);
                if (!this.m_dataOK[s][g] && !isStacked) continue;
                poly.addPoint(p.x, p.y);
                if (null == baseStart) {
                    baseStart = this.overrideY(nYBase, p);
                }
                baseEnd = this.overrideY(nYBase, p);
            }
            if (poly.npoints <= 1) continue;
            poly.addPoint(baseEnd.x, baseEnd.y);
            if (!baseEnd.equals(baseStart)) {
                poly.addPoint(baseStart.x, baseStart.y);
            }
            IdentObj id = new IdentObj(500, s);
            IBlackBox blackBox = this.assignSeriesColor(s);
            DrawFactory.createPolygon(this.getDrawContainer(), id, poly, blackBox, this.m_rClip);
        }
    }

    private Point overrideY(int nYBase, Point p) {
        if (this.m_bHorz) {
            return new Point(nYBase, p.y);
        }
        return new Point(p.x, nYBase);
    }

    private void drawAxisAreaRisersDepth(boolean bDrawY1, boolean bDrawY2) {
        boolean bForwardGroups;
        boolean bRightToLeft;
        if (bDrawY1 && bDrawY2) {
            throw new RuntimeException("bDrawY1 and bDrawY2 cannot both be true for Area charts.");
        }
        boolean bDescending = bDrawY1 ? this.getY1Axis().isDescending() : this.getY2Axis().isDescending();
        boolean bl = bRightToLeft = this.m_nDepthAngle > 90;
        boolean bReverseSeries = !this.m_bAbsolute && (this.m_bHorz ? bDescending != bRightToLeft : bDescending);
        boolean bForwardSeries = !bReverseSeries;
        boolean bReverseGroups = this.m_bHorz || bRightToLeft;
        boolean bl2 = bForwardGroups = !bReverseGroups;
        if (this.m_bAbsolute) {
            this.drawAxisAreaRisersDepthAbsolute(bForwardSeries, bForwardGroups, bDrawY1, bDrawY2);
        } else {
            this.drawAxisAreaRisersDepthStackedOrPercent(bForwardSeries, bForwardGroups, bDrawY1, bDrawY2);
        }
    }

    private void drawAxisAreaRisersDepthAbsolute(boolean bForwardSeries, boolean bForwardGroups, boolean bDrawY1, boolean bDrawY2) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator(bForwardGroups);
        while (sEnum.hasNext()) {
            INumericAxis yAxisObj;
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            if (this.m_depth2D.getSeriesType(s) != 3 || (yAxisObj = this.whichAxisForSeries(s, null)) == null) continue;
            int nAxisID = yAxisObj.getAxisObjID();
            if (bDrawY1 ? nAxisID != 0 && this.m_bBipolar : bDrawY2 && nAxisID != 1 && this.m_bBipolar) continue;
            Polygon front = new Polygon();
            Stack<Point> bottom = new Stack<Point>();
            gEnum.reset();
            while (gEnum.hasNext()) {
                int g = gEnum.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                if (!bForwardGroups && g == gEnum.get(0)) continue;
                this.drawOneAreaRiserDepth(s, g, gEnum, front, bottom);
                if (this.m_Perspective.getDrawAreaMarkers()) {
                    this.drawMarkersWithDepth(s);
                }
                if (this.m_bMarkerDisplay || !this.m_bTransparentMarkers) continue;
                this.drawTransparentMarkersWithDepth(s, 3);
            }
            int size = bottom.size();
            for (int i = 0; i < size; ++i) {
                Point pt = (Point)bottom.pop();
                front.addPoint(pt.x, pt.y);
            }
            DrawFactory.createPolygon(this.getDrawContainer(), new IdentObj(500, s), front, this.assignSeriesColor(s), this.m_bColorAutoshadeRisers ? 1.0 : 1.0);
        }
    }

    private void drawAxisAreaRisersDepthStackedOrPercent(boolean bForwardSeries, boolean bForwardGroups, boolean bDrawY1, boolean bDrawY2) {
        int s;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator(bForwardGroups);
        Vector<Polygon> frontPolys = new Vector<Polygon>(this.m_nTotalSeries);
        Vector bottoms = new Vector(this.m_nTotalSeries);
        for (s = 0; s < this.m_nTotalSeries; ++s) {
            frontPolys.add(new Polygon());
            bottoms.add(new Stack());
        }
        while (gEnum.hasNext()) {
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            if (!bForwardGroups && g == gEnum.get(0)) continue;
            SeriesEnumerator sEnumStacked = this.getResetSeriesEnumerator(bForwardSeries);
            while (sEnumStacked.hasNext()) {
                INumericAxis yAxisObj;
                int s2 = sEnumStacked.next();
                assert (s2 >= 0 && s2 < this.m_nTotalSeries);
                if (this.m_depth2D.getSeriesType(s2) != 3 || (yAxisObj = this.whichAxisForSeries(s2, null)) == null) continue;
                int nAxisID = yAxisObj.getAxisObjID();
                boolean bDrawRiser = true;
                if (bDrawY1) {
                    if (nAxisID != 0) {
                        bDrawRiser = false;
                    }
                } else if (bDrawY2 && nAxisID != 1) {
                    bDrawRiser = false;
                }
                if (!bDrawRiser) continue;
                this.drawOneAreaRiserDepth(s2, g, gEnum, (Polygon)frontPolys.get(s2), (Stack)bottoms.get(s2));
                if (this.m_bMarkerDisplay || !this.m_bTransparentMarkers) continue;
                this.drawTransparentMarkersWithDepth(s2, 3);
            }
        }
        for (s = 0; s < frontPolys.size(); ++s) {
            Polygon front = (Polygon)frontPolys.get(s);
            if (null == front || front.npoints <= 1) continue;
            Stack bottom = (Stack)bottoms.get(s);
            int size = bottom.size();
            for (int i = 0; i < size; ++i) {
                Point pt = (Point)bottom.pop();
                front.addPoint(pt.x, pt.y);
            }
            DrawFactory.createPolygon(this.getDrawContainer(), new IdentObj(500, s), front, this.assignSeriesColor(s), this.m_bColorAutoshadeRisers ? 1.0 : 1.0);
        }
    }

    private void drawOneAreaRiserDepth(int s, int g, GroupsEnumerator gEnum, Polygon polyFront, Stack<Point> bottom) {
        double fIntensityTop = 1.0;
        double fIntensitySide = 1.0;
        double fIntensityBottom = 1.0;
        boolean bDrawSidePolygon = false;
        int nValueCoord = this.numericYCoord[s][g];
        int gFirst = gEnum.get(0);
        int gLast = gEnum.getLast();
        int gPrev = gEnum.peekBefore(g);
        int gNext = gEnum.peekAfter(g);
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bForwardGroups = gFirst <= gLast;
        INumericAxis yAxisObj = this.whichAxisForSeries(s, null);
        if (yAxisObj != null) {
            boolean bPointsUpwards;
            int x3;
            int x2;
            int y3;
            int y2;
            int g2;
            int dy;
            int dx;
            Point ptFrontOffset;
            NonZeroBaseLine nonZeroBase = new NonZeroBaseLine(this.m_Perspective, yAxisObj, this.m_bAbsolute, this.m_bFromZero);
            int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
            boolean bDescending = yAxisObj.isDescending();
            IBlackBox blackBox = this.assignSeriesColor(s, g);
            IBlackBox blackBoxNew = bForwardGroups ? this.getMissingDataBlackBox(s, g, gNext) : this.getMissingDataBlackBox(s, g, gPrev);
            if (blackBoxNew == null) {
                blackBoxNew = blackBox;
            }
            boolean bNegValue = bDescending ? nValueCoord > nZeroCoord : nValueCoord < nZeroCoord;
            int sPrev = this.prevSeriesForAxis(s, g, yAxisObj, bNegValue);
            boolean bFromZero = this.wantRisersFromZero(yAxisObj);
            int nBaseCoord = this.m_bAbsolute || sPrev == -2 ? nonZeroBase.getYBaseLine() : this.numericYCoord[sPrev][g];
            if (this.wantDepthEffect()) {
                Point ptBackOffset = this.m_depth2D.getSeriesBackOffset(s);
                ptFrontOffset = this.m_depth2D.getSeriesFrontOffset(s);
                dx = ptFrontOffset.x - ptBackOffset.x;
                dy = ptFrontOffset.y - ptBackOffset.y;
            } else {
                ptFrontOffset = new Point();
                dx = 0;
                dy = 0;
            }
            Point p0 = this.getCoords(s, g);
            int x0 = p0.x - ptFrontOffset.x;
            int y0 = p0.y - ptFrontOffset.y;
            int n = g2 = bForwardGroups ? gNext : gPrev;
            if (g2 == -1) {
                return;
            }
            int nValueCoord2 = this.numericYCoord[s][g2];
            boolean bNegValue2 = bDescending ? nValueCoord2 > nZeroCoord : nValueCoord2 < nZeroCoord;
            int sPrev2 = this.prevSeriesForAxis(s, g2, yAxisObj, bNegValue2);
            int nBaseCoord2 = 0;
            nBaseCoord2 = this.m_bAbsolute || sPrev2 == -2 ? nonZeroBase.getYBaseLine() : this.numericYCoord[sPrev2][g2];
            Point p1 = this.getCoords(s, g2);
            int x1 = p1.x - ptFrontOffset.x;
            int y1 = p1.y - ptFrontOffset.y;
            if (this.m_bHorz) {
                y2 = y1;
                y3 = y0;
                x2 = this.m_bAbsolute || sPrev2 == -2 ? nBaseCoord2 - ptFrontOffset.x : this.numericYCoord[sPrev2][g2] - ptFrontOffset.x;
                x3 = this.m_bAbsolute || sPrev == -2 ? nBaseCoord - ptFrontOffset.x : this.numericYCoord[sPrev][g] - ptFrontOffset.x;
                if (bNegValue2 != bNegValue) {
                    int t = x1;
                    x1 = x2;
                    x2 = t;
                }
            } else {
                x2 = x1;
                x3 = x0;
                y2 = this.m_bAbsolute || sPrev2 == -2 ? nBaseCoord2 - ptFrontOffset.y : this.numericYCoord[sPrev2][g2] - ptFrontOffset.y;
                y3 = this.m_bAbsolute || sPrev == -2 ? nBaseCoord - ptFrontOffset.y : this.numericYCoord[sPrev][g] - ptFrontOffset.y;
                if (bNegValue2 != bNegValue) {
                    int t = y1;
                    y1 = y2;
                    y2 = t;
                }
            }
            if (g == gFirst && bForwardGroups) {
                polyFront.addPoint(x0, y0);
                bottom.push(new Point(x3, y3));
            }
            polyFront.addPoint(x1, y1);
            bottom.push(new Point(x2, y2));
            if (g == gLast && !bForwardGroups) {
                polyFront.addPoint(x0, y0);
                bottom.push(new Point(x3, y3));
            }
            double fAngle = Math.atan2(y1 - y0, x1 - x0) * 57.29577951308232;
            if (this.m_bHorz) {
                bPointsUpwards = bFromZero ? (bRightToLeft ? bDescending != bNegValue : bDescending == bNegValue) : (bRightToLeft ? bDescending : !bDescending);
            } else {
                boolean bl = bFromZero ? bDescending == bNegValue : (bPointsUpwards = !bDescending);
            }
            if (bPointsUpwards) {
                boolean bShowLeftSide;
                Polygon polyTop;
                boolean bDrawUnderside = false;
                boolean bDrawTopside = true;
                if (this.m_bHorz) {
                    if (bRightToLeft) {
                        if (fAngle + 180.0 > (double)this.m_nDepthAngle) {
                            bDrawTopside = false;
                        }
                    } else if (fAngle < (double)(this.m_nDepthAngle - 180)) {
                        bDrawTopside = false;
                    }
                } else if (bRightToLeft) {
                    if (fAngle + 180.0 < (double)this.m_nDepthAngle) {
                        bDrawTopside = false;
                    }
                } else if (fAngle > (double)this.m_nDepthAngle) {
                    bDrawTopside = false;
                }
                if ((this.m_bAbsolute || this.isTopStackedArea(s)) && bDrawTopside) {
                    polyTop = new Polygon();
                    polyTop.addPoint(x0, y0);
                    polyTop.addPoint(x1, y1);
                    polyTop.addPoint(x1 + dx, y1 + dy);
                    polyTop.addPoint(x0 + dx, y0 + dy);
                    polyTop.addPoint(x0, y0);
                    if (this.m_bColorAutoshadeRisers) {
                        fIntensityTop = this.m_bHorz ? 0.8 : 0.8;
                    }
                    DrawFactory.createPolygon(this.getDrawContainer(), new IdentObj(558, s, g), polyTop, blackBoxNew, fIntensityTop);
                }
                if (nonZeroBase.wantNonZeroBaseLine() && this.m_bAbsolute) {
                    polyTop = new Polygon();
                    polyTop.addPoint(x0, y0);
                    polyTop.addPoint(x1, y1);
                    polyTop.addPoint(x1 + dx, y1 + dy);
                    polyTop.addPoint(x0 + dx, y0 + dy);
                    polyTop.addPoint(x0, y0);
                    DrawFactory.createPolygon(this.getDrawContainer(), new IdentObj(558, s, g), polyTop, blackBoxNew, fIntensityTop);
                }
                boolean bl = bShowLeftSide = bRightToLeft || this.m_bHorz;
                if (bForwardGroups) {
                    bDrawSidePolygon = bShowLeftSide ? g == gFirst : gNext == gLast;
                } else if (bShowLeftSide) {
                    bDrawSidePolygon = g == gLast;
                } else {
                    boolean bl2 = bDrawSidePolygon = gPrev == gFirst;
                }
                if (bDrawSidePolygon) {
                    Polygon polySide = new Polygon();
                    if (bShowLeftSide) {
                        polySide.addPoint(x0, y0);
                        polySide.addPoint(x3, y3);
                        polySide.addPoint(x3 + dx, y3 + dy);
                        polySide.addPoint(x0 + dx, y0 + dy);
                        polySide.addPoint(x0, y0);
                    } else {
                        polySide.addPoint(x1, y1);
                        polySide.addPoint(x2, y2);
                        polySide.addPoint(x2 + dx, y2 + dy);
                        polySide.addPoint(x1 + dx, y1 + dy);
                        polySide.addPoint(x1, y1);
                    }
                    if (this.m_bColorAutoshadeRisers) {
                        fIntensitySide = this.m_bHorz ? 0.8 : 0.8;
                    }
                    DrawFactory.createPolygon(this.getDrawContainer(), new IdentObj(559, s, g), polySide, blackBoxNew, fIntensitySide);
                }
            } else {
                boolean bShowLeftSide;
                boolean bDrawUnderside = true;
                boolean bDrawTopside = false;
                if (this.m_bHorz) {
                    if (bRightToLeft) {
                        if (fAngle > (double)(this.m_nDepthAngle - 180)) {
                            bDrawTopside = true;
                        }
                    } else if (fAngle < (double)(this.m_nDepthAngle - 180)) {
                        bDrawTopside = true;
                    }
                } else if (bRightToLeft) {
                    if (fAngle + 180.0 < (double)this.m_nDepthAngle) {
                        bDrawTopside = true;
                    }
                } else if (fAngle > (double)this.m_nDepthAngle) {
                    bDrawTopside = true;
                }
                if (bDrawTopside && (this.m_bAbsolute || this.isTopStackedArea(s))) {
                    Polygon polyTop = new Polygon();
                    polyTop.addPoint(x0, y0);
                    polyTop.addPoint(x1, y1);
                    polyTop.addPoint(x1 + dx, y1 + dy);
                    polyTop.addPoint(x0 + dx, y0 + dy);
                    polyTop.addPoint(x0, y0);
                    if (this.m_bColorAutoshadeRisers) {
                        fIntensityTop = 0.4;
                    }
                    DrawFactory.createPolygon(this.getDrawContainer(), new IdentObj(558, s, g), polyTop, blackBoxNew, fIntensityTop);
                }
                if (bDrawUnderside && (this.m_bAbsolute || this.isBottomStackedArea(s))) {
                    Polygon polyBottom = new Polygon();
                    polyBottom.addPoint(x2, y2);
                    polyBottom.addPoint(x3, y3);
                    polyBottom.addPoint(x3 + dx, y3 + dy);
                    polyBottom.addPoint(x2 + dx, y2 + dy);
                    polyBottom.addPoint(x2, y2);
                    if (this.m_bColorAutoshadeRisers) {
                        fIntensityBottom = this.m_bHorz ? 0.8 : 0.8;
                    }
                    DrawFactory.createPolygon(this.getDrawContainer(), new IdentObj(560, s, g), polyBottom, blackBoxNew, fIntensityBottom);
                }
                boolean bl = bShowLeftSide = bRightToLeft || this.m_bHorz;
                if (bForwardGroups) {
                    bDrawSidePolygon = bShowLeftSide ? g == gFirst : gNext == gLast;
                } else if (bShowLeftSide) {
                    bDrawSidePolygon = g == gLast;
                } else {
                    boolean bl3 = bDrawSidePolygon = gPrev == gFirst;
                }
                if (bDrawSidePolygon) {
                    Polygon polySide = new Polygon();
                    if (bShowLeftSide) {
                        polySide.addPoint(x0, y0);
                        polySide.addPoint(x3, y3);
                        polySide.addPoint(x3 + dx, y3 + dy);
                        polySide.addPoint(x0 + dx, y0 + dy);
                        polySide.addPoint(x0, y0);
                    } else {
                        polySide.addPoint(x1, y1);
                        polySide.addPoint(x2, y2);
                        polySide.addPoint(x2 + dx, y2 + dy);
                        polySide.addPoint(x1 + dx, y1 + dy);
                        polySide.addPoint(x1, y1);
                    }
                    if (this.m_bColorAutoshadeRisers) {
                        fIntensitySide = this.m_bHorz ? 0.8 : 0.8;
                    }
                    DrawFactory.createPolygon(this.getDrawContainer(), new IdentObj(559, s, g), polySide, blackBoxNew, fIntensitySide);
                }
            }
        }
    }

    private void drawAxisBarRisers(boolean bDrawY1, boolean bDrawY2) {
        if (this.m_bAbsolute) {
            this.drawAxisBarRisersAbsolute(bDrawY1, bDrawY2);
        } else if (this.m_bDualY && !this.m_bBipolar) {
            this.drawAxisBarRisersStackedDualY(bDrawY1, bDrawY2);
        } else {
            this.drawAxisBarRisersStacked(bDrawY1, bDrawY2);
        }
    }

    private void drawAxisBarRisersAbsolute(boolean bDrawY1, boolean bDrawY2) {
        boolean bReverseSeries;
        boolean bReverseGroups;
        boolean bRightToLeft;
        boolean bl = bRightToLeft = this.m_nDepthAngle > 90;
        if (this.m_bHorz) {
            bReverseGroups = true;
            bReverseSeries = true;
        } else {
            bReverseGroups = bRightToLeft;
            bReverseSeries = bRightToLeft;
        }
        boolean bForwardSeries = !bReverseSeries;
        boolean bForwardGroups = !bReverseGroups;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator(bForwardGroups);
        while (gEnum.hasNext()) {
            int axisID;
            INumericAxis yAxisObj;
            int s;
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            if (bDrawY1) {
                sEnum.reset();
                while (sEnum.hasNext()) {
                    s = sEnum.next();
                    assert (s >= 0 && s < this.m_nTotalSeries);
                    if (this.m_depth2D.getSeriesType(s) != 1 || (yAxisObj = this.whichAxisForSeries(s, null)) == null || (axisID = yAxisObj.getAxisObjID()) != 0 && this.m_bBipolar) continue;
                    this.drawOneBarRiser(s, g, null);
                }
            }
            if (!bDrawY2 || !this.m_bBipolar) continue;
            sEnum.reset();
            while (sEnum.hasNext()) {
                s = sEnum.next();
                assert (s >= 0 && s < this.m_nTotalSeries);
                yAxisObj = this.whichAxisForSeries(s, null);
                if (yAxisObj == null || (axisID = yAxisObj.getAxisObjID()) != 1 && this.m_bBipolar) continue;
                this.drawOneBarRiser(s, g, null);
            }
        }
    }

    private void drawAxisBarRisersStacked(boolean bDrawY1, boolean bDrawY2) {
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bReverseGroups = this.m_bHorz || bRightToLeft;
        boolean bForwardGroups = !bReverseGroups;
        Point[] previousStackedConnectorPoints = new Point[this.m_nTotalSeries];
        boolean bDescending = bDrawY1 ? this.getY1Axis().isDescending() : this.getY2Axis().isDescending();
        boolean bReverseSeries = this.m_bHorz ? bDescending != bRightToLeft : bDescending;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator(bForwardGroups);
        while (gEnum.hasNext()) {
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            if (bReverseSeries) {
                this.drawBarGroup(g, bDrawY1, bDrawY2, true, false, previousStackedConnectorPoints);
                this.drawBarGroup(g, bDrawY1, bDrawY2, false, true, previousStackedConnectorPoints);
                continue;
            }
            this.drawBarGroup(g, bDrawY1, bDrawY2, true, true, previousStackedConnectorPoints);
            this.drawBarGroup(g, bDrawY1, bDrawY2, false, false, previousStackedConnectorPoints);
        }
    }

    private void drawAxisBarRisersStackedDualY(boolean bDrawY1, boolean bDrawY2) {
        boolean bY1ReverseSeries;
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bReverseGroups = this.m_bHorz || bRightToLeft;
        boolean bForwardGroups = !bReverseGroups;
        boolean bReverseSeries = false;
        boolean bY2first = this.m_bHorz || bRightToLeft;
        boolean bY1Descending = this.getY1Axis().isDescending();
        boolean bY2Descending = this.getY2Axis().isDescending();
        boolean bl = this.m_bHorz ? bY1Descending != bRightToLeft : (bY1ReverseSeries = bY1Descending);
        boolean bY2ReverseSeries = this.m_bHorz ? bY2Descending != bRightToLeft : bY2Descending;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator(bForwardGroups);
        while (gEnum.hasNext()) {
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            if (bY2first) {
                if (bY2ReverseSeries) {
                    this.drawBarGroup(g, false, bDrawY2, !bReverseSeries, false, null);
                    this.drawBarGroup(g, false, bDrawY2, bReverseSeries, true, null);
                } else {
                    this.drawBarGroup(g, false, bDrawY2, !bReverseSeries, true, null);
                    this.drawBarGroup(g, false, bDrawY2, bReverseSeries, false, null);
                }
                if (bY1ReverseSeries) {
                    this.drawBarGroup(g, bDrawY1, false, !bReverseSeries, false, null);
                    this.drawBarGroup(g, bDrawY1, false, bReverseSeries, true, null);
                    continue;
                }
                this.drawBarGroup(g, bDrawY1, false, !bReverseSeries, true, null);
                this.drawBarGroup(g, bDrawY1, false, bReverseSeries, false, null);
                continue;
            }
            if (bY1ReverseSeries) {
                this.drawBarGroup(g, bDrawY1, false, !bReverseSeries, false, null);
                this.drawBarGroup(g, bDrawY1, false, bReverseSeries, true, null);
            } else {
                this.drawBarGroup(g, bDrawY1, false, !bReverseSeries, true, null);
                this.drawBarGroup(g, bDrawY1, false, bReverseSeries, false, null);
            }
            if (bY2ReverseSeries) {
                this.drawBarGroup(g, false, bDrawY2, !bReverseSeries, false, null);
                this.drawBarGroup(g, false, bDrawY2, bReverseSeries, true, null);
                continue;
            }
            this.drawBarGroup(g, false, bDrawY2, !bReverseSeries, true, null);
            this.drawBarGroup(g, false, bDrawY2, bReverseSeries, false, null);
        }
    }

    private void drawBarGroup(int g, boolean bDrawY1, boolean bDrawY2, boolean bReverseSeries, boolean bNegative, Point[] previousStackedConnectorPoints) {
        boolean bForwardSeries = !bReverseSeries;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        while (sEnum.hasNext()) {
            boolean bNegValue;
            INumericAxis yAxisObj;
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            if (this.m_depth2D.getSeriesType(s) != 1 || (yAxisObj = this.whichAxisForSeries(s, null)) == null) continue;
            int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
            boolean bDescending = yAxisObj.isDescending();
            boolean bl = bDescending ? this.numericYCoord[s][g] > nZeroCoord : (bNegValue = this.numericYCoord[s][g] < nZeroCoord);
            if (bNegValue != bNegative) continue;
            int axisID = yAxisObj.getAxisObjID();
            if (!bDrawY1 && axisID == 0 || !bDrawY2 && axisID == 1) continue;
            this.drawOneBarRiser(s, g, previousStackedConnectorPoints);
        }
    }

    private void drawBarRisers() {
        if (this.m_bBipolar) {
            this.drawAxisBarRisers(false, true);
            this.drawAxisBarRisers(true, false);
        } else if (this.m_bDualY) {
            this.drawAxisBarRisers(true, true);
        } else {
            this.drawAxisBarRisers(true, false);
        }
    }

    private void drawOneBarRiser(int s, int g, Point[] previousStackedConnectorPoints) {
        Rectangle rVirt;
        int top;
        int bottom;
        int right;
        int nHigh;
        int nLow;
        int nValueCoord = this.numericYCoord[s][g];
        if (!this.m_dataOK[s][g] || this.m_depth2D.getSeriesType(s) != 1) {
            return;
        }
        INumericAxis yAxisObj = this.whichAxisForSeries(s, null);
        if (yAxisObj == null) {
            return;
        }
        int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
        boolean bDescending = yAxisObj.isDescending();
        IBlackBox blackBox = this.assignSeriesColor(s, g);
        IBlackBox blackBoxNew = this.getMissingDataBlackBox(s, g);
        if (blackBoxNew == null) {
            blackBoxNew = blackBox;
        }
        boolean bNegValue = bDescending ? nValueCoord > nZeroCoord : nValueCoord < nZeroCoord;
        int sPrev = this.prevSeriesForAxis(s, g, yAxisObj, bNegValue);
        boolean bFromZero = this.wantRisersFromZero(yAxisObj);
        int nBaseCoord = this.m_bAbsolute || sPrev == -2 ? (bFromZero ? nZeroCoord : (int)yAxisObj.getBaseCoord()) : this.numericYCoord[sPrev][g];
        if (bFromZero) {
            nLow = bDescending != bNegValue ? nValueCoord : nBaseCoord;
            nHigh = bDescending != bNegValue ? nBaseCoord : nValueCoord;
        } else {
            nLow = bDescending ? nValueCoord : nBaseCoord;
            nHigh = bDescending ? nBaseCoord : nValueCoord;
        }
        int left = 0;
        if (this.m_bHorz) {
            left = nLow;
            right = nHigh;
            bottom = !this.m_gt.isRiserBar() ? this.ordinalCoord[s][g] - this.m_barThickCoord / 2 : this.ordinalCoord[s][g];
            top = bottom + this.m_barThickCoord;
        } else {
            int nXOrdinalCoord = this.m_bAlignMultiYBars ? this.getMultiYCoordX(s, g) : this.ordinalCoord[s][g];
            bottom = nLow;
            top = nHigh;
            left = !this.m_gt.isRiserBar() ? nXOrdinalCoord - this.m_barThickCoord / 2 : nXOrdinalCoord;
            right = left + this.m_barThickCoord;
        }
        if (this.m_wantStackedConnectorLines && previousStackedConnectorPoints != null) {
            int connectorX2;
            int connectorY1 = this.m_bHorz ? bottom : nValueCoord;
            int connectorY2 = this.m_bHorz ? top : nValueCoord;
            int connectorX1 = this.m_bHorz ? nValueCoord : left;
            int n = connectorX2 = this.m_bHorz ? nValueCoord : right;
            if (this.m_nDepthRadius > 0) {
                Point offset = this.m_depth2D.getSeriesFrontOffset(s);
                connectorY1 -= offset.y;
                connectorY2 -= offset.y;
                connectorX1 -= offset.x;
                connectorX2 -= offset.x;
            }
            if (previousStackedConnectorPoints[s] != null) {
                Point previousConnectPoint = previousStackedConnectorPoints[s];
                Java2DLine.createLine(this.m_Perspective, Identity.StackedConnectorLines, previousConnectPoint.x, previousConnectPoint.y, connectorX1, connectorY1, this.m_stackedConnectorLinesBB);
            }
            previousStackedConnectorPoints[s] = new Point(connectorX2, connectorY2);
        }
        if ((rVirt = this.nonZeroBarRiser(s, g, yAxisObj.isLogScale() || yAxisObj.isDateScale(), nLow, nHigh, top, bottom, left, right)) == null) {
            rVirt = new Rectangle(left, bottom, right - left, top - bottom);
        }
        if (this.wantDepthEffect() && this.getFrame() != null) {
            this.m_bar2D.drawTwoHalfDBarRiser(s, g, rVirt, blackBoxNew, this.m_depth2D.getSeriesFrontOffset(s), this.m_depth2D.getSeriesBackOffset(s), this.m_nDepthAngle, this.m_bColorAutoshadeRisers);
        } else {
            IdentObj idFront = new IdentObj(521, s, g);
            boolean bDrawPictograph = false;
            if (this.m_bBarAsPictograph) {
                bDrawPictograph = this.m_bar2D.isSeriesBarPictoGraph(s, yAxisObj);
            }
            if (bDrawPictograph) {
                this.m_bar2D.drawBarAsPictograph(yAxisObj, this.m_bHorz, rVirt, idFront, blackBoxNew, this.m_rClip);
            } else {
                this.m_bar2D.drawBarBasic(idFront, rVirt, blackBoxNew, this.m_rClip);
            }
        }
    }

    private void drawLineRisers() {
        if (this.m_Perspective.getConnectLineMarkers()) {
            this.drawLines(false);
        }
        this.drawMarkers();
        if (!this.m_bMarkerDisplay && this.m_bTransparentMarkers) {
            this.drawTransparentMarkers(2);
        }
    }

    protected void drawLinesWithDepth() {
        if (this.m_bBipolar) {
            this.drawAxisLineRisers(1);
            this.drawAxisLineRisers(0);
        } else if (this.m_bDualY) {
            this.drawAxisLineRisers(0);
            this.drawAxisLineRisers(1);
        } else {
            this.drawAxisLineRisers(0);
        }
    }

    private void drawAxisLineRisers(int nAxis) {
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bReverseGroups = this.m_bHorz || bRightToLeft;
        boolean bForwardGroups = !bReverseGroups;
        boolean bForwardSeries = true;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator(bForwardGroups);
        while (sEnum.hasNext()) {
            int axisID;
            INumericAxis yAxisObj;
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            if (this.m_depth2D.getSeriesType(s) != 2 || (yAxisObj = this.whichAxisForSeries(s, null)) == null || (axisID = yAxisObj.getAxisObjID()) != nAxis && (!this.m_bAbsolute || this.m_bBipolar)) continue;
            if (this.m_Perspective.getConnectLineMarkers(s)) {
                gEnum.reset();
                while (gEnum.hasNext()) {
                    int g = gEnum.next();
                    assert (g >= 0 && g < this.m_nTotalGroups);
                    if (!bForwardGroups && g == gEnum.get(0)) continue;
                    this.drawOneLineRiser(s, g, gEnum);
                }
            }
            if (this.m_nDepthRadius <= 0 || !this.m_Perspective.getMarkerDisplay(s)) continue;
            this.drawMarkersWithDepth(s);
            if (this.m_bMarkerDisplay || !this.m_bTransparentMarkers) continue;
            this.drawTransparentMarkersWithDepth(s, 2);
        }
    }

    private int getMultiYCoordX(int s, int g) {
        int nXCoord = this.ordinalCoord[s][g];
        if (this.m_gt.isMultiY()) {
            int nAxis = this.getAxisAssignment(s);
            int nTransformedSeries = this.m_ordCoordsAlignedIdx[nAxis][s];
            nXCoord = this.ordinalCoord[nTransformedSeries][g];
        }
        return nXCoord;
    }

    private Rectangle nonZeroBarRiser(int s, int g, boolean bLogScale, int nLow, int nHigh, int top, int bottom, int left, int right) {
        Rectangle rVirt = null;
        boolean bNegNZValue = false;
        boolean bNegData = false;
        double fBaseline = 0.0;
        int nBaseLineYCoord = 0;
        INumericAxis axisObj = this.whichAxisForSeries(s, null);
        IdentObj id = axisObj.getAxisIdentObj();
        boolean bNonZeroBaseline = this.m_Perspective.getNonZeroBaseline(id);
        if (this.m_bAbsolute) {
            if (bNonZeroBaseline) {
                fBaseline = this.m_Perspective.getNonZeroBaselineValue(id);
                if (bLogScale && fBaseline <= 0.0) {
                    bNonZeroBaseline = false;
                }
            }
            if (bNonZeroBaseline) {
                boolean bl = bNegNZValue = fBaseline < 0.0;
                nBaseLineYCoord = bNegNZValue ? (fBaseline >= axisObj.getMinValue() ? (int)axisObj.getValueCoord(fBaseline) : (int)axisObj.getValueCoord(axisObj.getBaseMin())) : (fBaseline <= axisObj.getMaxValue() ? (int)axisObj.getValueCoord(fBaseline) : (int)axisObj.getValueCoord(axisObj.getBaseMax()));
                DatumObj dObj = this.getDataValue(s, g, this.getDataItem());
                boolean bl2 = bNegData = dObj.value < 0.0;
                if (this.m_bHorz) {
                    if (!bNegNZValue) {
                        if (bNegData) {
                            if (nHigh <= nBaseLineYCoord) {
                                right = nBaseLineYCoord;
                            } else if (nHigh > nBaseLineYCoord) {
                                left = nBaseLineYCoord;
                            }
                        } else if (nHigh >= nBaseLineYCoord) {
                            left = nBaseLineYCoord;
                        } else if (nHigh < nBaseLineYCoord) {
                            left = right;
                            right = nBaseLineYCoord;
                        }
                    } else if (bNegData) {
                        if (nHigh <= nBaseLineYCoord) {
                            right = nBaseLineYCoord;
                        } else if (nHigh > nBaseLineYCoord) {
                            right = nBaseLineYCoord;
                        }
                    } else if (nHigh >= nBaseLineYCoord) {
                        left = nBaseLineYCoord;
                    } else if (nHigh < nBaseLineYCoord) {
                        left = right;
                        right = nBaseLineYCoord;
                    }
                } else if (!bNegNZValue) {
                    if (bNegData) {
                        if (nHigh <= nBaseLineYCoord) {
                            top = nBaseLineYCoord;
                        } else if (nHigh > nBaseLineYCoord) {
                            bottom = nBaseLineYCoord;
                        }
                    } else if (nHigh >= nBaseLineYCoord) {
                        bottom = nBaseLineYCoord;
                    } else if (nHigh < nBaseLineYCoord) {
                        bottom = top;
                        top = nBaseLineYCoord;
                    }
                } else if (bNegData) {
                    if (nLow >= nBaseLineYCoord) {
                        top = bottom;
                        bottom = nBaseLineYCoord;
                    } else if (nLow < nBaseLineYCoord) {
                        top = nBaseLineYCoord;
                    }
                } else if (nHigh >= nBaseLineYCoord) {
                    bottom = nBaseLineYCoord;
                } else if (nHigh < nBaseLineYCoord) {
                    bottom = top;
                    top = nBaseLineYCoord;
                }
                rVirt = new Rectangle(left, bottom, right - left, top - bottom);
            }
        }
        return rVirt;
    }

    private boolean checkData(int s, int g, GroupsEnumerator gEnum) {
        boolean bForwardGroups;
        boolean bOK = true;
        int gFirst = gEnum.get(0);
        int gLast = gEnum.getLast();
        int gPrev = gEnum.peekBefore(g);
        int gNext = gEnum.peekAfter(g);
        assert (gFirst >= 0 && gLast >= 0 && g >= 0 && g < this.m_nTotalGroups);
        boolean bl = bForwardGroups = gFirst <= gLast;
        if (bForwardGroups) {
            if (gNext == -1) {
                return false;
            }
            if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext]) {
                return false;
            }
        } else {
            if (gPrev == -1) {
                return false;
            }
            if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gPrev]) {
                return false;
            }
        }
        if (this.m_nDepthRadius <= 0) {
            throw new RuntimeException("Can't draw 2.5D lines without positive DepthRadius");
        }
        if (this.getFrame() == null) {
            throw new RuntimeException("Can't draw 2.5D lines without m_Frame");
        }
        Rectangle rFrame = this.getFrame().getBackWallBounds();
        if (rFrame == null) {
            throw new RuntimeException("Can't draw 2.5D lines when m_Frame has no bounding rect");
        }
        return bOK;
    }

    private void drawOneLineRiser(int s, int g, GroupsEnumerator groupIter) {
        boolean bForwardGroups;
        int gFirst = groupIter.get(0);
        int gLast = groupIter.getLast();
        int gPrev = groupIter.peekBefore(g);
        int gNext = groupIter.peekAfter(g);
        boolean bl = bForwardGroups = gFirst <= gLast;
        if (this.checkData(s, g, groupIter)) {
            int dy;
            int dx;
            Point ptFrontOffset;
            if (this.wantDepthEffect()) {
                Point ptBackOffset = this.m_depth2D.getSeriesBackOffset(s);
                ptFrontOffset = this.m_depth2D.getSeriesFrontOffset(s);
                dx = ptFrontOffset.x - ptBackOffset.x;
                dy = ptFrontOffset.y - ptBackOffset.y;
            } else {
                ptFrontOffset = new Point();
                dx = 0;
                dy = 0;
            }
            Point p0 = this.getCoords(s, g);
            int x0 = p0.x - ptFrontOffset.x;
            int y0 = p0.y - ptFrontOffset.y;
            Point p1 = bForwardGroups ? this.getCoords(s, gNext) : this.getCoords(s, gPrev);
            int x1 = p1.x - ptFrontOffset.x;
            int y1 = p1.y - ptFrontOffset.y;
            this.drawOneLineRiserDepth(s, g, groupIter, x0, y0, x1, y1, dx, dy);
        }
    }

    private void drawOneLineRiserDepth(int s, int g, GroupsEnumerator groupIter, int x0, int y0, int x1, int y1, int dx, int dy) {
        boolean bDrawSidePolygon;
        boolean bShowLeftSide;
        Polygon polyTop;
        int y3;
        int x3;
        int y2;
        int x2;
        boolean bDrawUnderside;
        int gFirst = groupIter.get(0);
        int gLast = groupIter.getLast();
        int gPrev = groupIter.peekBefore(g);
        int gNext = groupIter.peekAfter(g);
        int gAfterNext = groupIter.peekAfter(gNext);
        int gBeforePrev = groupIter.peekBefore(gPrev);
        double fIntensity = 1.0;
        boolean bForwardGroups = gFirst <= gLast;
        IBlackBox blackBox = this.assignSeriesColor(s, g);
        IBlackBox blackBoxNew = bForwardGroups ? this.getMissingDataBlackBox(s, g, gNext) : this.getMissingDataBlackBox(s, g, gPrev);
        if (blackBoxNew == null) {
            blackBoxNew = blackBox;
        }
        Rectangle rFrame = this.getFrame().getBackWallBounds();
        double fThickMax = this.m_bHorz ? (double)rFrame.width / 12.0 : (double)rFrame.height / 12.0;
        int nOffset = (int)(fThickMax * (double)this.m_nLineThick / 100.0);
        double fAngleRad = Math.atan2(y1 - y0, x1 - x0);
        double fAngleDeg = fAngleRad * 57.29577951308232;
        if (this.m_nDepthAngle <= 90) {
            bDrawUnderside = this.m_bHorz ? fAngleDeg < (double)(this.m_nDepthAngle - 180) : fAngleDeg > (double)this.m_nDepthAngle;
        } else {
            boolean bl = bDrawUnderside = fAngleDeg + 180.0 < (double)this.m_nDepthAngle;
        }
        if (this.m_bHorz) {
            x2 = x1 - nOffset;
            y2 = y1;
            x3 = x0 - nOffset;
            y3 = y0;
        } else {
            x2 = x1;
            y2 = y1 - nOffset;
            x3 = x0;
            y3 = y0 - nOffset;
        }
        Polygon polyFront = new Polygon();
        polyFront.addPoint(x0, y0);
        polyFront.addPoint(x1, y1);
        polyFront.addPoint(x2, y2);
        polyFront.addPoint(x3, y3);
        polyFront.addPoint(x0, y0);
        if (bDrawUnderside) {
            polyTop = new Polygon();
            polyTop.addPoint(x2, y2);
            polyTop.addPoint(x3, y3);
            polyTop.addPoint(x3 + dx, y3 + dy);
            polyTop.addPoint(x2 + dx, y2 + dy);
            polyTop.addPoint(x2, y2);
        } else {
            polyTop = new Polygon();
            polyTop.addPoint(x0, y0);
            polyTop.addPoint(x1, y1);
            polyTop.addPoint(x1 + dx, y1 + dy);
            polyTop.addPoint(x0 + dx, y0 + dy);
            polyTop.addPoint(x0, y0);
        }
        if (this.m_bColorAutoshadeRisers) {
            fIntensity = this.m_bHorz ? 0.8 : (bDrawUnderside ? 0.4 : 0.8);
        }
        DrawFactory.createPolygon(this.getDrawContainer(), new IdentObj(562, s, g), polyTop, blackBoxNew, fIntensity);
        if (this.m_bColorAutoshadeRisers) {
            fIntensity = 1.0;
        }
        DrawFactory.createPolygon(this.getDrawContainer(), new IdentObj(502, s, g), polyFront, blackBoxNew, fIntensity);
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bl = bShowLeftSide = bRightToLeft || this.m_bHorz;
        if (bForwardGroups) {
            bDrawSidePolygon = bShowLeftSide ? g == gFirst || gPrev != -1 && !this.m_dataOK[s][gPrev] : gNext == gLast || gAfterNext != -1 && !this.m_dataOK[s][gAfterNext];
        } else if (bShowLeftSide) {
            bDrawSidePolygon = g == gLast || gNext != -1 && !this.m_dataOK[s][gNext];
        } else {
            boolean bl2 = bDrawSidePolygon = gPrev == gFirst || gBeforePrev != -1 && !this.m_dataOK[s][gBeforePrev];
        }
        if (bDrawSidePolygon) {
            Polygon polySide = new Polygon();
            if (bShowLeftSide) {
                polySide.addPoint(x0, y0);
                polySide.addPoint(x3, y3);
                polySide.addPoint(x3 + dx, y3 + dy);
                polySide.addPoint(x0 + dx, y0 + dy);
                polySide.addPoint(x0, y0);
            } else {
                polySide.addPoint(x1, y1);
                polySide.addPoint(x2, y2);
                polySide.addPoint(x2 + dx, y2 + dy);
                polySide.addPoint(x1 + dx, y1 + dy);
                polySide.addPoint(x1, y1);
            }
            if (this.m_bColorAutoshadeRisers) {
                fIntensity = this.m_bHorz ? 0.8 : 0.8;
            }
            DrawFactory.createPolygon(this.getDrawContainer(), new IdentObj(561, s, g), polySide, blackBoxNew, fIntensity);
        }
    }

    @Override
    protected Point getCoords(int s, int g) {
        int yValue = this.numericYCoord[s][g];
        int seriesType = this.m_depth2D.getSeriesType(s);
        int nCenterOrd = !this.m_bIsThisAComboWithBar && this.m_bExtendToFrameEdge ? this.ordinalCoord[s][g] : (seriesType == 1 || this.m_gt.isRiserBar() && (seriesType == 2 || seriesType == 3) ? this.ordinalCoord[s][g] + this.m_barThickCoord / 2 : this.ordinalCoord[s][g]);
        Point ptCenter = this.m_bHorz ? new Point(yValue, nCenterOrd) : new Point(nCenterOrd, yValue);
        return ptCenter;
    }

    private IAxis2D getXAxis() {
        AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
        if (axisDescriptor.hasO1()) {
            return (IAxis2D)((Object)this.getO1Axis());
        }
        return (IAxis2D)((Object)this.getX1Axis());
    }

    @Override
    public int getXAxisMaxCoord() {
        IAxis2D xAxis = this.getXAxis();
        return xAxis.getMaxVC();
    }

    @Override
    public int getXAxisMinCoord() {
        IAxis2D xAxis = this.getXAxis();
        return xAxis.getMinVC();
    }

    @Override
    public int getXAxisCoord(int seriesId, double value) {
        value -= 1.0;
        IAxis2D xAxis = this.getXAxis();
        if (this.m_gt.getAxisDescriptor().hasO1()) {
            IOrdinalAxis ordAxis = (IOrdinalAxis)((Object)xAxis);
            int xCoordLow = (int)ordAxis.getLowCoord(seriesId, (int)value);
            int seriesType = this.m_depth2D.getSeriesType(seriesId);
            int xCoord = seriesType == 1 || this.m_gt.isRiserBar() && (seriesType == 2 || seriesType == 3) ? xCoordLow + this.m_barThickCoord / 2 : this.ordinalCoord[seriesId][(int)value];
            return xCoord;
        }
        INumericAxis numAxis = (INumericAxis)((Object)xAxis);
        return (int)numAxis.getValueCoord(value);
    }

    @Override
    public double getXAxisValue(int coord) {
        if (this.m_gt.getAxisDescriptor().hasO1()) {
            int minCoord = this.getXAxisMinCoord();
            if (this.m_nTotalGroups == 1) {
                return Double.NaN;
            }
            int x1 = this.getXAxisCoord(0, 1.0);
            int x2 = this.getXAxisCoord(0, 2.0);
            return (double)(coord - x1) / (double)(x2 - x1);
        }
        INumericAxis numAxis = this.getX1Axis();
        return numAxis.getValueFromCoord(coord);
    }

    public boolean isBottomStackedArea(int s) {
        return this.isVisibleStackedArea(s, false);
    }

    public boolean isTopStackedArea(int s) {
        return this.isVisibleStackedArea(s, true);
    }

    public boolean isVisibleStackedArea(int sCurrent, boolean bTopFace) {
        int axisCurrent = this.getAxisAssignment(sCurrent);
        boolean bForward = !bTopFace;
        boolean bIsTop = true;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForward);
        while (bIsTop && sEnum.hasNext()) {
            boolean bDone;
            int s = sEnum.next();
            boolean bl = bForward ? s >= sCurrent : (bDone = s <= sCurrent);
            if (bDone) break;
            if (this.m_depth2D.getSeriesType(s) != 3 || this.getAxisAssignment(s) != axisCurrent) continue;
            bIsTop = false;
        }
        return bIsTop;
    }

    protected boolean wantRisersFromZero(INumericAxis yAxisObj) {
        boolean bFromZero = this.m_bFromZero;
        if (!bFromZero) {
            boolean bl = bFromZero = yAxisObj.hasNegData() && !this.m_bAbsolute && !yAxisObj.isLogScale();
        }
        if (yAxisObj.isDateScale()) {
            bFromZero = false;
        }
        return bFromZero;
    }
}

