/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.MarkerTemplate;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DepthMarker {
    private DepthMarker() {
    }

    static List<Polygon> createDepthMarker(MarkerTemplate markerTemplate, int nXDepth, int nYDepth, final int nDepthAngle) {
        ArrayList<Polygon> vectorPolyMarker = null;
        Polygon polyMarkerFace = DepthMarker.getDepthMarkerFace(markerTemplate);
        if (polyMarkerFace != null) {
            vectorPolyMarker = new ArrayList<Polygon>();
            for (int nFace = 0; nFace < polyMarkerFace.npoints; ++nFace) {
                int nSide = (nFace + 1) % polyMarkerFace.npoints;
                Polygon polyMarkerSide = new Polygon();
                polyMarkerSide.addPoint(polyMarkerFace.xpoints[nFace], polyMarkerFace.ypoints[nFace]);
                polyMarkerSide.addPoint(polyMarkerFace.xpoints[nSide], polyMarkerFace.ypoints[nSide]);
                polyMarkerSide.addPoint(polyMarkerFace.xpoints[nSide] + nXDepth, polyMarkerFace.ypoints[nSide] + nYDepth);
                polyMarkerSide.addPoint(polyMarkerFace.xpoints[nFace] + nXDepth, polyMarkerFace.ypoints[nFace] + nYDepth);
                vectorPolyMarker.add(polyMarkerSide);
            }
            Comparator<Polygon> comp = new Comparator<Polygon>(){

                @Override
                public int compare(Polygon o1, Polygon o2) {
                    Rectangle rect1 = o1.getBounds();
                    Rectangle rect2 = o2.getBounds();
                    int x1 = rect1.x + rect1.width;
                    int x2 = rect2.x + rect2.width;
                    if (nDepthAngle > 90) {
                        return x2 - x1;
                    }
                    return x1 - x2;
                }
            };
            Collections.sort(vectorPolyMarker, comp);
            vectorPolyMarker.add(polyMarkerFace);
        }
        return vectorPolyMarker;
    }

    protected static Polygon getDepthMarkerFace(MarkerTemplate markerTemplate) {
        Polygon polyMarkerFace = null;
        if (markerTemplate.getMarkerType() != 0) {
            if (markerTemplate.getPolygon() == null) {
                Rectangle rectTemplate = markerTemplate.getRect();
                polyMarkerFace = new Polygon();
                polyMarkerFace.addPoint(rectTemplate.x, rectTemplate.y);
                polyMarkerFace.addPoint(rectTemplate.x + rectTemplate.width, rectTemplate.y);
                polyMarkerFace.addPoint(rectTemplate.x + rectTemplate.width, rectTemplate.y + rectTemplate.height);
                polyMarkerFace.addPoint(rectTemplate.x, rectTemplate.y + rectTemplate.height);
            } else {
                polyMarkerFace = new Polygon(markerTemplate.getPolygon().xpoints, markerTemplate.getPolygon().ypoints, markerTemplate.getPolygon().npoints);
            }
        }
        return polyMarkerFace;
    }
}

