/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DetObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Detectiv;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyle2DObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;

class DetLabel
extends DetObj {
    private final Rectangle m_rBoundsVC;
    private TextStyle2DObj m_TextStyle2D;
    private String m_szText;
    private List<String> m_textList;
    private boolean m_transparentText;

    public DetLabel(IDrawContainer container, IdentObj id, String szText, Rectangle rBounds, ITextStyle textStyle, IBlackBox blackBox, Rectangle rClip) {
        super(container, id, blackBox, rClip);
        this.m_textList = TextUtil.getWrappedTextList(((Detectiv)container).getPerspective(), textStyle, szText, rBounds.getSize());
        this.m_rBoundsVC = new Rectangle(rBounds.x, rBounds.y, rBounds.width, rBounds.height);
        this.m_TextStyle2D = (TextStyle2DObj)textStyle;
        this.m_szText = szText;
        this.m_transparentText = blackBox.getTransparentFillColor();
    }

    public String getLabelString() {
        return this.m_szText;
    }

    public void hilite(Graphics2D g, VC vc) {
        Rectangle dest = vc.virtToDest(this.m_rBoundsVC);
        g.setXORMode(Color.yellow);
        g.drawRect(dest.x, dest.y, dest.width, dest.height);
        g.setPaintMode();
    }

    public void paintIt(Graphics2D g, VC vc) {
        if (this.m_szText.length() > 0 && !this.m_transparentText) {
            Rectangle rDest = vc.virtToDest(this.m_rBoundsVC);
            this.m_TextStyle2D.setRectDC(rDest);
            this.m_TextStyle2D.setText(this.m_szText);
            this.m_TextStyle2D.drawText(g, vc, this.blackBox, rDest, this.m_textList);
        }
    }

    public static Dimension calcRotatedLabelBounds(double angle, int width, int height) {
        double sinAngle = Math.abs(Math.sin(angle));
        double cosAngle = Math.abs(Math.cos(angle));
        int boxwidth = (int)(cosAngle * (double)width + sinAngle * (double)height);
        int boxheight = (int)(sinAngle * (double)width + cosAngle * (double)height);
        return new Dimension(boxwidth, boxheight);
    }

    public Shape getShape() {
        return this.m_rBoundsVC;
    }
}

