/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine.IScale;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utilities.OutOfRangeException;

public class ScaleLinear
implements IScale {
    public static final boolean DEBUG = true;
    private double m_dMinValue;
    private double m_dMaxValue;
    private double m_dScaleRange;

    public ScaleLinear(double dMinValue, double dMaxValue) throws IllegalArgumentException {
        assert (!Double.isNaN(dMinValue) && !Double.isNaN(dMaxValue));
        assert (dMinValue != 7.7777777E307 && dMaxValue != 7.7777777E307);
        this.m_dMinValue = dMinValue;
        this.m_dMaxValue = dMaxValue;
        this.m_dScaleRange = this.m_dMaxValue - this.m_dMinValue;
        if (this.m_dScaleRange <= 0.0) {
            throw new IllegalArgumentException("new ScaleLinear: dMinValue must be less than dMaxValue.");
        }
    }

    public double getMinValue() {
        return this.m_dMinValue;
    }

    public double getMaxValue() {
        return this.m_dMaxValue;
    }

    public boolean containsValue(double dValue) {
        return dValue >= this.m_dMinValue && dValue <= this.m_dMaxValue;
    }

    public double unitToValue(double dUnit) throws OutOfRangeException {
        return this.unitToValue(dUnit, false);
    }

    public double unitToValue(double dUnit, boolean bAllowExtrapolation) throws OutOfRangeException {
        if (!bAllowExtrapolation) {
            if (dUnit > 1.0) {
                dUnit = 1.0;
            } else if (dUnit < 0.0) {
                dUnit = 0.0;
            }
        }
        return this.m_dMinValue + dUnit * this.m_dScaleRange;
    }

    public double valueToUnit(double dValue) throws OutOfRangeException {
        return this.valueToUnit(dValue, false);
    }

    public double valueToUnit(double dValue, boolean bAllowExtrapolation) throws OutOfRangeException {
        if (!bAllowExtrapolation) {
            if (dValue < this.m_dMinValue) {
                dValue = this.m_dMinValue;
            } else if (dValue > this.m_dMaxValue) {
                dValue = this.m_dMaxValue;
            }
        }
        return (dValue - this.m_dMinValue) / this.m_dScaleRange;
    }
}

