/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataRange;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.Access;

public class SeriesEnumerator
extends DataEnumerator {
    private SeriesEnumerator(int[] array) {
        super(array);
    }

    private SeriesEnumerator(SeriesEnumerator other) {
        super(other);
    }

    public SeriesEnumerator shallowCopy() {
        return new SeriesEnumerator(this);
    }

    public static SeriesEnumerator getIterator(Perspective perspective, Access access) {
        return SeriesEnumerator.getIterator(perspective, access, true);
    }

    public static SeriesEnumerator getReverseIterator(Perspective perspective, Access access) {
        return SeriesEnumerator.getIterator(perspective, access, false);
    }

    private static SeriesEnumerator getIterator(Perspective perspective, Access access, boolean bForward) {
        DataRange drViewable = access.getViewableDataRangeSG(perspective);
        int nViewSeriesStart = drViewable.getRowStart();
        int nViewSeriesStop = drViewable.getRowStop();
        int numSeries = nViewSeriesStop - nViewSeriesStart + 1;
        int numActualSeries = 0;
        if (numSeries < 0) {
            int[] indexArray = new int[]{};
            return new SeriesEnumerator(indexArray);
        }
        int[] indexArray = new int[numSeries];
        if (bForward) {
            int index = 0;
            for (int s = nViewSeriesStart; s <= nViewSeriesStop; ++s) {
                if (perspective.getIgnoreSeries(s)) continue;
                indexArray[index++] = s;
                ++numActualSeries;
            }
            if (numActualSeries < numSeries) {
                int[] smallerArray = new int[numActualSeries];
                System.arraycopy(indexArray, 0, smallerArray, 0, numActualSeries);
                indexArray = smallerArray;
            }
        } else {
            int index = numSeries - 1;
            for (int s = nViewSeriesStart; s <= nViewSeriesStop; ++s) {
                if (perspective.getIgnoreSeries(s)) continue;
                indexArray[index--] = s;
                ++numActualSeries;
            }
            if (numActualSeries < numSeries) {
                int delta = numSeries - numActualSeries;
                int[] smallerArray = new int[numActualSeries];
                System.arraycopy(indexArray, delta, smallerArray, 0, numActualSeries);
                indexArray = smallerArray;
            }
        }
        return new SeriesEnumerator(indexArray);
    }
}

