/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import com.businessobjects.visualization.pfjgraphics.rendering.converter.AdvFormatStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.NumberFormatOptions;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.PFJDecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;

public class ScaledNumberFormat
extends PFJDecimalFormat {
    private static final long serialVersionUID = -8066603673160839737L;
    protected double scaleFactor = 1.0;

    public ScaledNumberFormat(String pattern, DecimalFormatSymbols symbols, double scaleFactor) {
        super(pattern, symbols);
        this.scaleFactor = scaleFactor;
    }

    public ScaledNumberFormat() {
    }

    public StringBuffer format(long val, StringBuffer toAppendTo, FieldPosition pos) {
        return super.format((double)val / this.scaleFactor, toAppendTo, pos);
    }

    public StringBuffer format(double val, StringBuffer toAppendTo, FieldPosition pos) {
        return super.format(val / this.scaleFactor, toAppendTo, pos);
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public AdvFormatStruct toAdvFormatStruct() {
        AdvFormatStruct fmt = super.toAdvFormatStruct();
        if (fmt.formatType != NumberFormatOptions.PercentFormat.ordinal()) {
            fmt.szPostfixText[1] = '\u0000';
            fmt.szPostfixText[0] = '\u0000';
            if (this.scaleFactor == 1000.0) {
                fmt.szPostfixText[0] = 75;
            } else if (this.scaleFactor == 1000000.0) {
                fmt.szPostfixText[0] = 77;
            } else if (this.scaleFactor == 1.0E9) {
                fmt.szPostfixText[0] = 66;
            }
        }
        fmt.dScaleFactor = this.scaleFactor;
        return fmt;
    }
}

