/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import com.businessobjects.visualization.pfjgraphics.rendering.converter.AdvFormatStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.NumberFormatOptions;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.ScaledNumberFormat;
import java.text.DecimalFormatSymbols;

public class AutoNumberFormat
extends ScaledNumberFormat {
    public AutoNumberFormat(DecimalFormatSymbols symbols) {
        super("#.#", symbols, 1.0);
    }

    public AutoNumberFormat() {
    }

    public void setPercent() {
        this.applyPattern("#.#%");
    }

    public void setSpan(double span) {
        if ((span = Math.abs(span)) >= 1.0E9) {
            this.applyPattern("0.#E0");
            this.scaleFactor = 1.0;
        } else if (span >= 1.0E7) {
            this.applyPattern("0.#M");
            this.scaleFactor = 1000000.0;
        } else if (span > 10000.0) {
            this.applyPattern("0.#K");
            this.scaleFactor = 1000.0;
        } else {
            this.applyPattern("#.#");
            this.scaleFactor = 1.0;
        }
    }

    public AdvFormatStruct toAdvFormatStruct() {
        AdvFormatStruct fmt = super.toAdvFormatStruct();
        fmt.formatType = NumberFormatOptions.NoFormat.ordinal();
        fmt.stdFormat = 1;
        return fmt;
    }
}

