/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.internal.util;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.internal.util.ResourceFormat;
import com.businessobjects.visualization.internal.util.ResourceManager;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;

public abstract class Resources {
    private static final String DEFAULT_ERROR_CODE = "";
    private static final ILogger LOGGER = LoggerManager.getLogger((String)(class$com$businessobjects$visualization$internal$util$Resources == null ? (class$com$businessobjects$visualization$internal$util$Resources = Resources.class$("com.businessobjects.visualization.internal.util.Resources")) : class$com$businessobjects$visualization$internal$util$Resources).getName());
    public static final String UNKNOWN = "???";
    private final String baseName_;
    private final Locale locale_;
    static /* synthetic */ Class class$com$businessobjects$visualization$internal$util$Resources;

    protected Resources(String baseName, Locale locale) {
        if (baseName == null) {
            throw new VisualizationRuntimeException("VIZ_00006_ERR_BASENAME____NULL");
        }
        if (locale == null) {
            throw new VisualizationRuntimeException("VIZ_00007_ERR_LOCALE____NULL");
        }
        this.baseName_ = baseName;
        this.locale_ = locale;
    }

    private String error(String key, Throwable t) {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error((Object)("Could not get message for key \"" + key + '\"'), t);
        }
        return UNKNOWN;
    }

    public String getBaseName() {
        return this.baseName_;
    }

    public Locale getLocale() {
        return this.locale_;
    }

    public String getMessage(String key) {
        try {
            return this.getMessageImpl(key);
        }
        catch (Throwable t) {
            return this.error(key, t);
        }
    }

    public String getMessage(String key, Object[] params) {
        try {
            String msg = this.getMessage(key);
            MessageFormat mf = new MessageFormat(msg, this.locale_);
            StringBuffer buffer = new StringBuffer();
            mf.format(params, buffer, (FieldPosition)null);
            return buffer.toString();
        }
        catch (IllegalArgumentException e) {
            return this.error(key, e);
        }
    }

    protected abstract String getMessageImpl(String var1);

    public Enumeration getKeys() {
        try {
            return this.getKeysImpl();
        }
        catch (Throwable t) {
            LOGGER.error((Object)"Could not get keys ", t);
            return null;
        }
    }

    protected abstract Enumeration getKeysImpl();

    public static String getErrorCode(String id) {
        if (id == null) {
            return DEFAULT_ERROR_CODE;
        }
        int iIndex = id.lastIndexOf("_ERR_");
        if (iIndex == -1) {
            return DEFAULT_ERROR_CODE;
        }
        return id.substring(0, iIndex);
    }

    public static Resources getResources(String[] baseNames) {
        return Resources.getResources(baseNames, Locale.getDefault(), ResourceFormat.BOLOC);
    }

    public static Resources getResources(String[] baseNames, Locale locale) {
        return Resources.getResources(baseNames, locale, ResourceFormat.BOLOC);
    }

    public static Resources getResources(String[] baseNames, ResourceFormat format) {
        return Resources.getResources(baseNames, Locale.getDefault(), format);
    }

    public static Resources getResources(String[] baseNames, Locale locale, ResourceFormat format) {
        if (baseNames == null) {
            throw new VisualizationRuntimeException("VIZ_00006_ERR_BASENAME____NULL");
        }
        if (locale == null) {
            throw new VisualizationRuntimeException("VIZ_00007_ERR_LOCALE____NULL");
        }
        try {
            return ResourceManager.getInstance().getBundle(baseNames, locale, format);
        }
        catch (Throwable t) {
            if (baseNames != null && baseNames.length != 0) {
                LOGGER.error((Object)("Could not get resources for baseNames \"" + baseNames[0] + "\" and locale \"" + (locale != null ? locale.toString() : DEFAULT_ERROR_CODE) + "\" and format \"" + format.toString() + "\""), t);
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DefaultResources
    extends Resources {
        private ResourceBundle bundle_;

        protected DefaultResources(String baseName, Locale locale, ResourceBundle bundle) {
            super(baseName, locale);
            this.bundle_ = bundle;
        }

        public String getMessageImpl(String key) {
            return this.bundle_.getString(key);
        }

        public Enumeration getKeysImpl() {
            return this.bundle_.getKeys();
        }
    }

    public static class BolocResources
    extends Resources {
        private Map map_;

        protected BolocResources(String baseName, Locale locale, Map map) {
            super(baseName, locale);
            this.map_ = map;
        }

        public String getMessageImpl(String key) {
            return (String)this.map_.get(key);
        }

        public Enumeration getKeysImpl() {
            return new Enumeration(this){
                private Iterator iterator_;
                private Object next_;
                private final /* synthetic */ BolocResources this$0;
                {
                    this.this$0 = this$0;
                    this.iterator_ = BolocResources.access$000(this.this$0);
                }

                public boolean hasMoreElements() {
                    if (this.next_ == null && this.iterator_.hasNext()) {
                        this.next_ = this.iterator_.next();
                    }
                    return this.next_ != null;
                }

                public Object nextElement() {
                    if (this.hasMoreElements()) {
                        Object result = this.next_;
                        this.next_ = null;
                        return result;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        private Iterator getKeyIterator() {
            return this.map_.keySet().iterator();
        }

        static /* synthetic */ Iterator access$000(BolocResources x0) {
            return x0.getKeyIterator();
        }
    }
}

