/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic.xml.settings.generated;

import com.businessobjects.visualization.common.internal.XmlReaderVersion;
import com.businessobjects.visualization.graphic.xml.settings.MigrationSettings;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLGraphic;
import com.businessobjects.visualization.util.xml.Helper;
import com.businessobjects.visualization.util.xml.XmlEventType;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlWriter;

public class XMLSettings {
    public String m_a_schemaLocation;
    public String m_a_version;
    public String m_a_Name;
    public XMLGraphic m_Graphic = null;

    public void unmarshall(XmlReaderVersion readerVersion) throws XmlException {
        this.processAttribute(readerVersion);
        while (!(readerVersion.getXmlReader().next() == XmlEventType.END_DOCUMENT || readerVersion.getXmlReader().getEventType() == XmlEventType.END_ELEMENT && readerVersion.getXmlReader().getName() != null && readerVersion.getXmlReader().getName().equals("Settings"))) {
            String sNode = readerVersion.getXmlReader().getName();
            MigrationSettings.instance().manageNode(this, readerVersion, sNode);
            if (sNode == null || !sNode.equals("Graphic")) continue;
            this.m_Graphic = new XMLGraphic();
            this.m_Graphic.unmarshall(readerVersion);
        }
    }

    public void processAttribute(XmlReaderVersion readerVersion) throws XmlException {
        for (int i = 0; i < readerVersion.getXmlReader().getAttributeCount(); ++i) {
            String prefixName = readerVersion.getXmlReader().getAttributePrefix(i);
            String attName = readerVersion.getXmlReader().getAttributeName(i);
            String finalName = (prefixName != null ? prefixName : "") + (prefixName != null && attName != null ? ":" : "") + (attName != null ? attName : "");
            MigrationSettings.instance().manageAttribute(this, readerVersion, finalName, readerVersion.getXmlReader().getAttributeValue(i));
            if (finalName.equals("xsi:schemaLocation")) {
                this.m_a_schemaLocation = readerVersion.getXmlReader().getAttributeValue(i);
                continue;
            }
            if (finalName.equals("version")) {
                this.m_a_version = readerVersion.getXmlReader().getAttributeValue(i);
                continue;
            }
            if (!finalName.equals("Name")) continue;
            this.m_a_Name = readerVersion.getXmlReader().getAttributeValue(i);
        }
    }

    public void dump() {
        ++Helper.indent;
        Helper.print("XMLSettings");
        Helper.print("schemaLocation", this.m_a_schemaLocation);
        Helper.print("version", this.m_a_version);
        Helper.print("Name", this.m_a_Name);
        if (this.m_Graphic != null) {
            this.m_Graphic.dump();
        }
        Helper.println("XMLSettings ");
        --Helper.indent;
    }

    public void marshall2(XmlWriter xw) throws XmlException {
        if (this.m_a_schemaLocation != null) {
            xw.attribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", this.m_a_schemaLocation);
        }
        if (this.m_a_version != null) {
            xw.attribute(null, "version", this.m_a_version);
        }
        if (this.m_a_Name != null) {
            xw.attribute(null, "Name", this.m_a_Name);
        }
        if (this.m_Graphic != null) {
            xw.startElement("Graphic");
            this.m_Graphic.marshall2(xw);
            xw.endElement("Graphic");
        }
    }

    public boolean equals(Object o) {
        XMLSettings obj = (XMLSettings)o;
        if (this.m_a_schemaLocation == obj.m_a_schemaLocation || this.m_a_schemaLocation != null && !this.m_a_schemaLocation.equals(obj.m_a_schemaLocation)) {
            return false;
        }
        if (this.m_a_version == obj.m_a_version || this.m_a_version != null && !this.m_a_version.equals(obj.m_a_version)) {
            return false;
        }
        if (this.m_a_Name == obj.m_a_Name || this.m_a_Name != null && !this.m_a_Name.equals(obj.m_a_Name)) {
            return false;
        }
        return this.m_Graphic.equals(obj.m_Graphic);
    }
}

