/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.transform;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.dataexchange.DataHolder;
import com.businessobjects.visualization.dataexchange.callbacks.IDimensionLabelsIterator;
import com.businessobjects.visualization.dataexchange.callbacks.IMember;
import com.businessobjects.visualization.dataexchange.callbacks.IValuesGrid;
import com.businessobjects.visualization.dataexchange.common.DataType;
import com.businessobjects.visualization.dataexchange.data.DataAdapter;
import com.businessobjects.visualization.dataexchange.data.DatasetAdapter;
import com.businessobjects.visualization.dataexchange.data.DimensionLabelsAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesGroupAdapter;
import com.businessobjects.visualization.dataexchange.data.impl.DoubleValueData;
import com.businessobjects.visualization.dataexchange.data.impl.StringLabelData;
import com.businessobjects.visualization.dataexchange.data.impl.TreeNode;
import com.businessobjects.visualization.dataexchange.data.impl.TreeNodeArray;
import com.businessobjects.visualization.dataexchange.definition.AnalysisAxis;
import com.businessobjects.visualization.dataexchange.definition.DataDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DatasetDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import com.businessobjects.visualization.dataexchange.transform.ITransform;
import com.businessobjects.visualization.dataexchange.transform.MembersNUplet;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.TreeSet;

public class ProjectDimensionsTransform
implements ITransform {
    public static final int MAX_AXES_LIMIT = 2;
    private final int axisIndex_;
    private final DimensionLabels pivotDimension_;
    private final boolean sortAxis_;
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$dataexchange$transform$ProjectDimensionsTransform == null ? (class$com$businessobjects$visualization$dataexchange$transform$ProjectDimensionsTransform = ProjectDimensionsTransform.class$("com.businessobjects.visualization.dataexchange.transform.ProjectDimensionsTransform")) : class$com$businessobjects$visualization$dataexchange$transform$ProjectDimensionsTransform));
    static /* synthetic */ Class class$com$businessobjects$visualization$dataexchange$transform$ProjectDimensionsTransform;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$businessobjects$visualization$dataexchange$data$impl$TreeNode;

    public ProjectDimensionsTransform(int axisIndex, DimensionLabels dl, boolean sortAxis) {
        this.axisIndex_ = axisIndex;
        this.pivotDimension_ = dl;
        this.sortAxis_ = sortAxis;
    }

    public DimensionLabels getPivotDimension() {
        return this.pivotDimension_;
    }

    public int getAxisIndex() {
        return this.axisIndex_;
    }

    public int getTransformType() {
        return 1;
    }

    public int getTransformMode() {
        return 129;
    }

    public DataHolder transform(DataHolder aDataHolder) {
        int i;
        int i2;
        DatasetDescriptor origDataset;
        boolean bOrigIsTable;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Project axisIndex:" + this.axisIndex_ + " dimensionLabels:" + this.pivotDimension_));
        }
        boolean bl = bOrigIsTable = (origDataset = aDataHolder.getDataDescriptor().getDatasetDescriptor()).getCardinality() == 1;
        if (origDataset.getCardinality() == 0) {
            throw new IllegalArgumentException("Need at least an axis to pivot !");
        }
        int pivotAxisIndex = origDataset.getAxisIndex(this.pivotDimension_);
        int otherAxisIndex = pivotAxisIndex == 0 ? 1 : 0;
        AnalysisAxis pivotAxis = origDataset.getAxisList()[pivotAxisIndex];
        boolean bResultIsTable = pivotAxis.getDimensionLabelsList().length < 2;
        DatasetDescriptor resultDataset = DatasetDescriptor.newInstance(origDataset);
        resultDataset.getAxisList()[pivotAxisIndex].removeDimensionLabels(this.pivotDimension_);
        AnalysisAxis otherAxis = null;
        if (bOrigIsTable) {
            otherAxis = new AnalysisAxis();
            resultDataset.addAxis(otherAxis);
        } else {
            otherAxis = resultDataset.getAxisList()[otherAxisIndex];
        }
        if (bResultIsTable) {
            resultDataset.removeAxis(resultDataset.getAxisList()[pivotAxisIndex]);
        }
        otherAxis.addDimensionLabels(this.pivotDimension_);
        int iPivotIndex = origDataset.getAxisList()[pivotAxisIndex].getDimensionLabelsIndex(this.pivotDimension_);
        AbstractSet pivotSet = this.sortAxis_ ? new TreeSet() : new LinkedHashSet();
        IDimensionLabelsIterator pivotIter = aDataHolder.getDataAdapter().getDataset().getLabelsIterator(pivotAxisIndex, iPivotIndex);
        while (pivotIter.hasNext()) {
            pivotSet.add(pivotIter.next().getValue());
        }
        Object[] pivotList = pivotSet.toArray(new Object[0]);
        ArrayList<IValuesGrid> valueGrids = new ArrayList<IValuesGrid>();
        MeasureValuesGroupAdapter[] mvgaList = aDataHolder.getDataAdapter().getDataset().getValueGroupList();
        for (int i3 = 0; i3 < mvgaList.length; ++i3) {
            MeasureValuesAdapter[] mvaList = mvgaList[i3].getMeasureValuesList();
            for (int j = 0; j < mvaList.length; ++j) {
                valueGrids.add(mvaList[j].getGridCallback());
            }
        }
        HashMap[] measureValues = new HashMap[valueGrids.size()];
        LinkedHashSet<MembersNUplet> pivotAxisUpletsList = new LinkedHashSet<MembersNUplet>();
        LinkedHashSet<MembersNUplet> otherAxisUpletsList = new LinkedHashSet<MembersNUplet>();
        if (!bOrigIsTable) {
            IDimensionLabelsIterator rootOtherAxisIter = aDataHolder.getDataAdapter().getDataset().getLabelsIterator(otherAxisIndex, 0);
            while (rootOtherAxisIter.hasLeaves()) {
                IMember[] aMember = rootOtherAxisIter.nextLeaf();
                for (int i4 = 0; i4 < pivotList.length; ++i4) {
                    MembersNUplet nuplet = new MembersNUplet(aMember, pivotList[i4], this.pivotDimension_, origDataset.getAxisList()[otherAxisIndex]);
                    otherAxisUpletsList.add(nuplet);
                }
            }
        } else {
            for (int i5 = 0; i5 < pivotList.length; ++i5) {
                MembersNUplet nuplet = new MembersNUplet(pivotList[i5], this.pivotDimension_);
                otherAxisUpletsList.add(nuplet);
            }
        }
        int otherAxisLength = otherAxisUpletsList.size();
        IDimensionLabelsIterator pivotAxisRootIter = aDataHolder.getDataAdapter().getDataset().getLabelsIterator(pivotAxisIndex, 0);
        int j = 0;
        while (pivotAxisRootIter.hasLeaves()) {
            int index;
            IMember[] aMember = pivotAxisRootIter.nextLeaf();
            int pivotMemberIndex = -1;
            for (int i6 = 0; i6 < aMember.length; ++i6) {
                if (aMember[i6].getDimensionIndex() != iPivotIndex) continue;
                pivotMemberIndex = i6;
                break;
            }
            if ((index = this.getIndex(aMember[pivotMemberIndex].getValue(), pivotList)) == -1) {
                throw new VisualizationInternalException("Pivot value not found in PivotSet!");
            }
            MembersNUplet nuplet = new MembersNUplet(aMember, pivotMemberIndex, origDataset.getAxisList()[pivotAxisIndex]);
            pivotAxisUpletsList.add(nuplet);
            for (int i7 = 0; i7 < valueGrids.size(); ++i7) {
                double[] doubleValues;
                if (measureValues[i7] == null) {
                    measureValues[i7] = new HashMap();
                }
                if ((doubleValues = (double[])measureValues[i7].get(nuplet)) == null) {
                    doubleValues = new double[otherAxisLength];
                    this.initWithNoValues(doubleValues);
                    measureValues[i7].put(nuplet, doubleValues);
                }
                if (!bOrigIsTable) {
                    IDimensionLabelsIterator rootOtherAxisIterInternal = aDataHolder.getDataAdapter().getDataset().getLabelsIterator(otherAxisIndex, 0);
                    int nColumn = 0;
                    while (rootOtherAxisIterInternal.hasLeaves()) {
                        rootOtherAxisIterInternal.nextLeaf();
                        doubleValues[index + nColumn * pivotList.length] = ((IValuesGrid)valueGrids.get(i7)).valueAt(pivotAxisIndex == 0 ? nColumn : j, pivotAxisIndex == 0 ? j : nColumn, 0);
                        ++nColumn;
                    }
                    continue;
                }
                doubleValues[index] = ((IValuesGrid)valueGrids.get(i7)).valueAt(j, 0, 0);
            }
            ++j;
        }
        DataDescriptor resultDescriptor = new DataDescriptor();
        resultDescriptor.setDatasetDescriptor(resultDataset);
        DataAdapter resultAdapter = resultDescriptor.getDataAdapter();
        DatasetAdapter resultDatasetAdapter = resultAdapter.getDataset();
        DimensionLabelsAdapter[] resultPivotAxisDimensionAdapters = new DimensionLabelsAdapter[]{};
        DimensionLabels[] resultPivotAxisDimensionDescriptors = new DimensionLabels[]{};
        if (!bResultIsTable) {
            resultPivotAxisDimensionAdapters = resultDatasetAdapter.getAxisList()[pivotAxisIndex].getDimensionLabelsList();
            resultPivotAxisDimensionDescriptors = resultDataset.getAxisList()[pivotAxisIndex].getDimensionLabelsList();
        }
        DimensionLabelsAdapter[] resultOtherAxisDimensionAdapters = resultDatasetAdapter.getAxisList()[otherAxisIndex].getDimensionLabelsList();
        DimensionLabels[] resultOtherAxisDimensionDescriptors = resultDataset.getAxisList()[otherAxisIndex].getDimensionLabelsList();
        Object[][] pivotDimension_LabelsData = new Object[resultPivotAxisDimensionDescriptors.length][pivotAxisUpletsList.size()];
        Object[][] otherDimensionLabelsData = new Object[resultOtherAxisDimensionDescriptors.length][otherAxisLength];
        double[][][] valuesData = new double[valueGrids.size()][pivotAxisIndex == 0 ? otherAxisLength : pivotAxisUpletsList.size()][pivotAxisIndex == 0 ? pivotAxisUpletsList.size() : otherAxisLength];
        Iterator iter = pivotAxisUpletsList.iterator();
        int nLine = 0;
        while (iter.hasNext()) {
            int i8;
            MembersNUplet uplet = (MembersNUplet)iter.next();
            for (i8 = 0; i8 < resultPivotAxisDimensionDescriptors.length; ++i8) {
                pivotDimension_LabelsData[i8][nLine] = uplet.getValue(resultPivotAxisDimensionDescriptors[i8]);
            }
            for (i8 = 0; i8 < valueGrids.size(); ++i8) {
                for (int k = 0; k < otherAxisLength; ++k) {
                    valuesData[i8][pivotAxisIndex == 0 ? k : nLine][pivotAxisIndex == 0 ? nLine : k] = ((double[])measureValues[i8].get(uplet))[k];
                }
            }
            ++nLine;
        }
        Iterator iter2 = otherAxisUpletsList.iterator();
        int nCol = 0;
        while (iter2.hasNext()) {
            MembersNUplet uplet = (MembersNUplet)iter2.next();
            for (i2 = 0; i2 < resultOtherAxisDimensionDescriptors.length; ++i2) {
                otherDimensionLabelsData[i2][nCol] = uplet.getValue(resultOtherAxisDimensionDescriptors[i2]);
            }
            ++nCol;
        }
        for (i = 0; i < resultOtherAxisDimensionAdapters.length; ++i) {
            this.fillAdapter(resultOtherAxisDimensionAdapters[i], otherDimensionLabelsData[i], otherDimensionLabelsData[i][0].getClass());
        }
        for (i = 0; i < resultPivotAxisDimensionAdapters.length; ++i) {
            this.fillAdapter(resultPivotAxisDimensionAdapters[i], pivotDimension_LabelsData[i], pivotDimension_LabelsData[i][0].getClass());
        }
        mvgaList = resultDatasetAdapter.getValueGroupList();
        int nMeasure = 0;
        for (i2 = 0; i2 < mvgaList.length; ++i2) {
            MeasureValuesAdapter[] mvaList = mvgaList[i2].getMeasureValuesList();
            for (int k = 0; k < mvaList.length; ++k) {
                if (bResultIsTable) {
                    mvaList[k].setData(new DoubleValueData(valuesData[nMeasure++][0]));
                    continue;
                }
                mvaList[k].setData(new DoubleValueData(valuesData[nMeasure++]));
            }
        }
        return new DataHolder(resultDescriptor, resultAdapter);
    }

    private void initWithNoValues(double[] doubleValues) {
        for (int i = 0; i < doubleValues.length; ++i) {
            doubleValues[i] = 1.7E308;
        }
    }

    private int getIndex(Object value, Object[] valueList) {
        for (int i = 0; i < valueList.length; ++i) {
            if (!value.equals(valueList[i])) continue;
            return i;
        }
        return -1;
    }

    private void fillAdapter(DimensionLabelsAdapter dla, Object[] srcArray, Class ctype) {
        Object[] a = (Object[])Array.newInstance(ctype, srcArray.length);
        System.arraycopy(srcArray, 0, a, 0, a.length);
        if (ctype.equals(class$java$lang$String == null ? (class$java$lang$String = ProjectDimensionsTransform.class$("java.lang.String")) : class$java$lang$String)) {
            dla.setData(new StringLabelData((String[])a));
        } else if (ctype.equals(class$com$businessobjects$visualization$dataexchange$data$impl$TreeNode == null ? (class$com$businessobjects$visualization$dataexchange$data$impl$TreeNode = ProjectDimensionsTransform.class$("com.businessobjects.visualization.dataexchange.data.impl.TreeNode")) : class$com$businessobjects$visualization$dataexchange$data$impl$TreeNode)) {
            dla.setData(new TreeNodeArray(DataType.STRING, (TreeNode[])a));
        } else {
            throw new VisualizationInternalException("type not supported for pivoting:" + ctype.getName());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

