/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.data.AnalysisAxisAdapter;
import com.businessobjects.visualization.dataexchange.data.DatasetAdapter;
import com.businessobjects.visualization.dataexchange.data.DictionaryAdapter;
import com.businessobjects.visualization.dataexchange.data.DimensionLabelsAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesGroupAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDatasetAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDictionaryAdapter;
import com.businessobjects.visualization.dataexchange.data.impl.DoubleValueData;
import com.businessobjects.visualization.dataexchange.data.impl.StringLabelData;
import java.util.Iterator;

public class DataAdapter
implements IXMLDelegator {
    private static final ILogger LOGGER = LoggerManager.getLogger((String)(class$com$businessobjects$visualization$dataexchange$data$DataAdapter == null ? (class$com$businessobjects$visualization$dataexchange$data$DataAdapter = DataAdapter.class$("com.businessobjects.visualization.dataexchange.data.DataAdapter")) : class$com$businessobjects$visualization$dataexchange$data$DataAdapter).getName());
    private DictionaryAdapter[] dictionaries_ = new DictionaryAdapter[0];
    private DatasetAdapter dataset_;
    static /* synthetic */ Class class$com$businessobjects$visualization$dataexchange$data$DataAdapter;

    public DataAdapter() {
    }

    public DataAdapter(XMLDataAdapter xmlData, SerializationHelper sh) {
        this();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Deserializing DataAdapter (current version:" + sh.getCurrentVersion() + ") from stream (serialized version:" + sh.getSerializedVersion() + ")"));
        }
        Iterator iter = null;
        iter = xmlData.m_list_dictionaryAdapter.iterator();
        this.dictionaries_ = new DictionaryAdapter[xmlData.m_list_dictionaryAdapter.size()];
        int i = 0;
        while (iter.hasNext()) {
            this.dictionaries_[i++] = new DictionaryAdapter((XMLDictionaryAdapter)iter.next(), sh);
        }
        this.dataset_ = new DatasetAdapter(xmlData.m_datasetAdapter, sh);
    }

    public Object getXMLDelegate() {
        XMLDataAdapter xda = new XMLDataAdapter();
        for (int i = 0; i < this.dictionaries_.length; ++i) {
            xda.m_list_dictionaryAdapter.add(this.dictionaries_[i].getXMLDelegate());
        }
        xda.m_datasetAdapter = (XMLDatasetAdapter)this.dataset_.getXMLDelegate();
        return xda;
    }

    public DatasetAdapter[] getDatasets() {
        if (this.dataset_ == null) {
            return new DatasetAdapter[0];
        }
        DatasetAdapter[] daList = new DatasetAdapter[]{this.getDataset()};
        return daList;
    }

    public DatasetAdapter getDataset() {
        return this.dataset_;
    }

    public DictionaryAdapter[] getDictionaries() {
        return this.dictionaries_;
    }

    public void setDatasets(DatasetAdapter[] datasets) {
        if (datasets != null && datasets.length > 0) {
            this.setDataset(datasets[0]);
        }
    }

    public void setDataset(DatasetAdapter datasetAdapter) {
        this.dataset_ = datasetAdapter;
    }

    public void setDictionaries(DictionaryAdapter[] dictionaries) {
        this.dictionaries_ = dictionaries;
    }

    public boolean isFilled() {
        int j;
        for (j = 0; j < this.dataset_.getAxisList().length; ++j) {
            if (this.dataset_.getAxisList()[j].isFilled() == -1) continue;
            return false;
        }
        for (j = 0; j < this.dataset_.getValueGroupList().length; ++j) {
            if (this.dataset_.getValueGroupList()[j].isFilled() == -1) continue;
            return false;
        }
        return true;
    }

    public void checkDataConsistency() {
        int j;
        int j2;
        for (j2 = 0; j2 < this.dataset_.getAxisList().length; ++j2) {
            if (this.dataset_.getAxisList()[j2].isFilled() == -1) continue;
            throw new VisualizationRuntimeException("VIZ_00076_ERR_DATASET___0___MISSIN", new Object[]{new Integer(0), new Integer(j2), new Integer(this.dataset_.getAxisList()[j2].isFilled())});
        }
        for (j2 = 0; j2 < this.dataset_.getValueGroupList().length; ++j2) {
            if (this.dataset_.getValueGroupList()[j2].isFilled() == -1) continue;
            throw new VisualizationRuntimeException("VIZ_00077_ERR_DATASET___0___MISSIN", new Object[]{new Integer(0), new Integer(j2), new Integer(this.dataset_.getValueGroupList()[j2].isFilled())});
        }
        int[] dimLimits = new int[3];
        int axisLimits = this.dataset_.getAxisList().length;
        for (j = 0; j < this.dataset_.getAxisList().length; ++j) {
            AnalysisAxisAdapter aa = this.dataset_.getAxisList()[j];
            if (aa.isCustomIteratorImpl()) {
                dimLimits[j] = -1;
                continue;
            }
            DimensionLabelsAdapter[] dlList = aa.getDimensionLabelsList();
            int previousCount = -1;
            for (int k = 0; k < dlList.length; ++k) {
                int count = dlList[k].getData().getValuesCount(1);
                if (previousCount != -1 && count != previousCount) {
                    throw new VisualizationRuntimeException("VIZ_00078_ERR_STACKED_DIMENSIONS_F", new Object[]{new Integer(0), new Integer(j), new Integer(k), new Integer(count), new Integer(k - 1), new Integer(previousCount)});
                }
                previousCount = count;
            }
            dimLimits[j] = previousCount;
        }
        for (j = 0; j < this.dataset_.getValueGroupList().length; ++j) {
            MeasureValuesGroupAdapter mvga = this.dataset_.getValueGroupList()[j];
            MeasureValuesAdapter[] mvList = mvga.getMeasureValuesList();
            for (int k = 0; k < mvList.length; ++k) {
                if (mvList[k].isCustomGridImpl()) continue;
                int cardinality = mvList[k].getData().getCardinality();
                if (axisLimits > 0 && cardinality != axisLimits) {
                    throw new VisualizationRuntimeException("VIZ_00010_ERR_IMPROPER_CARDINALITY", new Object[]{new Integer(cardinality), new Integer(axisLimits), new Integer(0), new Integer(j), new Integer(k)});
                }
                int cardIndex = 1;
                int axisIndex = axisLimits - 1;
                while (axisIndex >= 0) {
                    if (mvList[k].getData().getValuesCount(cardIndex) != dimLimits[axisIndex]) {
                        String expected = "";
                        String found = "";
                        int cardIndex2 = 1;
                        int axisIndex2 = axisLimits - 1;
                        while (axisIndex2 >= 0) {
                            expected = expected + "[" + dimLimits[axisIndex2] + "]";
                            found = found + "[" + mvList[k].getData().getValuesCount(cardIndex2) + "]";
                            --axisIndex2;
                            ++cardIndex2;
                        }
                        throw new VisualizationRuntimeException("VIZ_00011_ERR_WRONG_NUMBER_OF_VALU", new Object[]{new Integer(0), new Integer(j), new Integer(k), found, expected});
                    }
                    --axisIndex;
                    ++cardIndex;
                }
            }
        }
    }

    public static void padMeasureValues(DatasetAdapter dataset, double paddingValue) {
        int j;
        int[] dimLimits = new int[]{1, 1, 1};
        int axisLimits = dataset.getAxisList().length;
        if (axisLimits == 0) {
            throw new VisualizationRuntimeException("VIZ_00012_ERR_CANNOT_PAD_DATASET__");
        }
        for (j = 0; j < dataset.getAxisList().length; ++j) {
            AnalysisAxisAdapter aa = dataset.getAxisList()[j];
            if (aa.isCustomIteratorImpl()) {
                throw new VisualizationRuntimeException("VIZ_00013_ERR_CANNOT_PAD_DATASET__");
            }
            DimensionLabelsAdapter[] dlList = aa.getDimensionLabelsList();
            if (dlList.length == 0) {
                throw new VisualizationRuntimeException("VIZ_00079_ERR_CANNOT_PAD_DATASET__", new Object[]{new Integer(j)});
            }
            if (dlList[0].getData() == null) {
                throw new VisualizationRuntimeException("VIZ_00080_ERR_CANNOT_PAD_DATASET__", new Object[]{new Integer(j)});
            }
            if (dlList[0].getData().getValuesCount(1) == 0) {
                throw new VisualizationRuntimeException("VIZ_00014_ERR_CANNOT_PAD_DATASET__", new Object[]{new Integer(j)});
            }
            dimLimits[j] = dlList[0].getData().getValuesCount(1);
        }
        for (j = 0; j < dataset.getValueGroupList().length; ++j) {
            MeasureValuesGroupAdapter mvga = dataset.getValueGroupList()[j];
            MeasureValuesAdapter[] mvList = mvga.getMeasureValuesList();
            block7: for (int k = 0; k < mvList.length; ++k) {
                if (mvList[k].isCustomGridImpl()) {
                    throw new VisualizationRuntimeException("VIZ_00081_ERR_CANNOT_PAD_DATASET__", new Object[]{new Integer(k)});
                }
                double[][][] paddedArray = new double[dimLimits[2]][dimLimits[1]][dimLimits[0]];
                if (paddingValue != 0.0) {
                    for (int i2 = 0; i2 < paddedArray.length; ++i2) {
                        for (int i1 = 0; i1 < paddedArray[i2].length; ++i1) {
                            for (int i0 = 0; i0 < paddedArray[i2][i1].length; ++i0) {
                                paddedArray[i2][i1][i0] = paddingValue;
                            }
                        }
                    }
                }
                switch (axisLimits) {
                    case 1: {
                        mvList[k].setData(new DoubleValueData(paddedArray[0][0]));
                        continue block7;
                    }
                    case 2: {
                        mvList[k].setData(new DoubleValueData(paddedArray[0]));
                        continue block7;
                    }
                    case 3: {
                        mvList[k].setData(new DoubleValueData(paddedArray));
                        continue block7;
                    }
                }
            }
        }
    }

    public static void padDimensionLabels(DatasetAdapter dataset, String paddingValue) {
        int axisLimits = dataset.getAxisList().length;
        if (axisLimits == 0) {
            throw new VisualizationRuntimeException("VIZ_00012_ERR_CANNOT_PAD_DATASET__");
        }
        MeasureValuesGroupAdapter mvga = dataset.getValueGroupList()[0];
        DoubleValueData data = (DoubleValueData)mvga.getMeasureValuesList()[0].getData();
        if (data == null) {
            throw new VisualizationRuntimeException("VIZ_00015_ERR_CANNOT_PAD_DATASET__");
        }
        String paddedValue = "";
        if (paddingValue != null) {
            paddedValue = paddingValue;
        }
        int cardinality = data.getCardinality();
        int j = 0;
        while (j < dataset.getAxisList().length) {
            AnalysisAxisAdapter aa = dataset.getAxisList()[j];
            if (aa.isCustomIteratorImpl()) {
                throw new VisualizationRuntimeException("VIZ_00013_ERR_CANNOT_PAD_DATASET__");
            }
            int axisSize = data.getValuesCount(cardinality);
            String[] paddedArray = new String[axisSize];
            for (int i = 0; i < paddedArray.length; ++i) {
                paddedArray[i] = paddedValue;
            }
            DimensionLabelsAdapter[] dlList = aa.getDimensionLabelsList();
            for (int i = 0; i < dlList.length; ++i) {
                dlList[i].setData(new StringLabelData(paddedArray));
            }
            ++j;
            --cardinality;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

