/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.GraphicDescription;
import com.businessobjects.visualization.GraphicInstance;
import com.businessobjects.visualization.LocalizedEngine;
import com.businessobjects.visualization.ProviderDescription;
import com.businessobjects.visualization.Score;
import com.businessobjects.visualization.common.exceptions.NotImplementedException;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.dataexchange.definition.DataDescriptor;
import com.businessobjects.visualization.feed.Feed;
import com.businessobjects.visualization.feed.IFeedMediator;
import com.businessobjects.visualization.feed.definition.FeedDef;
import com.businessobjects.visualization.graphic.IGraphicMediator;
import com.businessobjects.visualization.graphic.IGraphicNode;
import com.businessobjects.visualization.graphic.PropertyDef;
import com.businessobjects.visualization.graphic.VisuObject;
import java.util.Iterator;
import java.util.TreeSet;

public class GraphicInstanceMediator
implements IGraphicMediator,
IFeedMediator {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$GraphicInstanceMediator == null ? (class$com$businessobjects$visualization$GraphicInstanceMediator = GraphicInstanceMediator.class$("com.businessobjects.visualization.GraphicInstanceMediator")) : class$com$businessobjects$visualization$GraphicInstanceMediator));
    private GraphicInstance graphicInstance_;
    static /* synthetic */ Class class$com$businessobjects$visualization$GraphicInstanceMediator;

    public GraphicInstanceMediator(GraphicInstance gi) {
        this.graphicInstance_ = gi;
    }

    public void notifyPropertyUpdated(IGraphicNode parent, PropertyDef propDef, VisuObject value) {
    }

    public void notifyFeedAdded(Feed feed) {
        if (this.graphicInstance_.getGraphic() == null) {
            throw new VisualizationInternalException("Cannot add Feeds when no graphic is determined yet!");
        }
    }

    public int getMinOccurence(FeedDef feed) {
        int iMinRestriction = this.graphicInstance_.getMinRestrictionCount(feed.getId());
        return Math.max(feed.getMin(), iMinRestriction);
    }

    public int getMaxOccurence(FeedDef feed) {
        int iMaxRestriction = this.graphicInstance_.getMaxRestrictionCount(feed.getId());
        return Math.min(iMaxRestriction, feed.getMax());
    }

    public boolean checkRestrictions(int nFeedCount, String feedDefId) {
        int iMinRestriction = this.graphicInstance_.getMinRestrictionCount(feedDefId);
        int iMaxRestriction = this.graphicInstance_.getMaxRestrictionCount(feedDefId);
        return this.checkRestrictions(nFeedCount, iMinRestriction, iMaxRestriction);
    }

    boolean checkRestrictions(int nFeedCount, int iMinRestriction, int iMaxRestriction) {
        return nFeedCount <= iMaxRestriction && nFeedCount >= iMinRestriction;
    }

    public void notifyFeedRemoved(Feed feed) {
    }

    public void notifyFeedUpdated(Feed feed) {
        throw new NotImplementedException();
    }

    public void notifyDataDescriptorUpdated() {
        this.graphicInstance_.updateDataDescriptorFromFeeder();
        this.graphicInstance_.fireDataDescriptorChanged();
    }

    public GraphicDescription[] getBestGraphics(int iCount, String businessDomainId, String analysisTypeId) {
        LOGGER.info((Object)"Entering getBestGraphics");
        TreeSet<Score> rankingSet = new TreeSet<Score>();
        LocalizedEngine locEngine = this.graphicInstance_.getLocalizedEngine();
        DataDescriptor dd = DataDescriptor.newInstance(this.graphicInstance_.getDataDescriptor());
        ProviderDescription[] providers = locEngine.getProviders();
        GraphicInstance testGi = new GraphicInstance(locEngine);
        testGi.setDataDescriptor(dd);
        for (int i = 0; i < providers.length; ++i) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Provider:" + providers[i].getName()));
            }
            GraphicDescription[] gInfo = providers[i].getGraphics();
            for (int j = 0; j < gInfo.length; ++j) {
                Score aScore;
                if (gInfo[j].getAvailableOutputTypes() == 32) continue;
                if (LOGGER.isInfoEnabled()) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("...Trying Graphic: ").append("(id:" + gInfo[j].getId()).append(") (name:" + gInfo[j].getName()).append(") (desc:" + gInfo[j].getDescription() + ")").append(") (categ:" + gInfo[j].getCategory() + ")");
                    LOGGER.info((Object)buf.toString());
                }
                boolean bIsValid = true;
                try {
                    testGi.turnTo(gInfo[j].getId());
                    if (!testGi.getFeeder().hasMinimumFeeds()) {
                        bIsValid = false;
                    }
                }
                catch (Exception e) {
                    bIsValid = false;
                    LOGGER.info((Object)("Exception: " + e.toString() + " will trying turnTo in bestChart..."));
                }
                if (!bIsValid || !((aScore = Score.computeScore(testGi, gInfo[j], businessDomainId, analysisTypeId)).getScore() > 0.0)) continue;
                rankingSet.add(aScore);
            }
        }
        GraphicDescription[] gdList = new GraphicDescription[rankingSet.size() > iCount ? iCount : rankingSet.size()];
        Iterator iter = rankingSet.iterator();
        for (int i = rankingSet.size() - 1; i >= 0 && iter.hasNext(); --i) {
            if (i < gdList.length) {
                gdList[i] = ((Score)iter.next()).getGraphicDescription();
                continue;
            }
            iter.next();
        }
        rankingSet.clear();
        return gdList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

