/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleSerialBlob;
import oracle.jdbc.rowset.OracleSerialClob;
import oracle.jdbc.rowset.OracleWebRowSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class OracleWebRowSetXmlReaderContHandler
extends DefaultHandler {
    private OracleWebRowSet wrset;
    private RowSetMetaData rsetMetaData;
    private Vector updatesToRowSet;
    private Vector keyCols;
    private String columnValue;
    private String propertyValue;
    private String metadataValue;
    private boolean isNullValue;
    private int columnIndex;
    private Hashtable propertyNameTagMap;
    private Hashtable metadataNameTagMap;
    private Hashtable dataNameTagMap;
    protected static final String WEBROWSET_ELEMENT_NAME = "webRowSet";
    protected static final String PROPERTIES_ELEMENT_NAME = "properties";
    protected static final String METADATA_ELEMENT_NAME = "metadata";
    protected static final String DATA_ELEMENT_NAME = "data";
    private int state;
    private static final int INITIAL_STATE = 0;
    private static final int PROPERTIES_STATE = 1;
    private static final int METADATA_STATE = 2;
    private static final int DATA_STATE = 3;
    private int tag;
    private static final int NO_TAG = -1;
    private String[] propertyNames = new String[]{"command", "concurrency", "datasource", "escape-processing", "fetch-direction", "fetch-size", "isolation-level", "key-columns", "map", "max-field-size", "max-rows", "query-timeout", "read-only", "rowset-type", "show-deleted", "table-name", "url", "sync-provider", "null", "column", "type", "class", "sync-provider-name", "sync-provider-vendor", "sync-provider-version", "sync-provider-grade", "data-source-lock"};
    private boolean readReadOnlyValue;
    private static final int PROPERTY_COMMAND_TAG = 0;
    private static final int PROPERTY_CONCURRENCY_TAG = 1;
    private static final int PROPERTY_DATASOURCETAG = 2;
    private static final int PROPERTY_ESCAPEPROCESSING_TAG = 3;
    private static final int PROPERTY_FETCHDIRECTION_TAG = 4;
    private static final int PROPERTY_FETCHSIZE_TAG = 5;
    private static final int PROPERTY_ISOLATIONLEVEL_TAG = 6;
    private static final int PROPERTY_KEYCOLUMNS_TAG = 7;
    private static final int PROPERTY_MAP_TAG = 8;
    private static final int PROPERTY_MAXFIELDSIZE_TAG = 9;
    private static final int PROPERTY_MAXROWS_TAG = 10;
    private static final int PROPERTY_QUERYTIMEOUT_TAG = 11;
    private static final int PROPERTY_READONLY_TAG = 12;
    private static final int PROPERTY_ROWSETTYPE_TAG = 13;
    private static final int PROPERTY_SHOWDELETED_TAG = 14;
    private static final int PROPERTY_TABLENAME_TAG = 15;
    private static final int PROPERTY_URL_TAG = 16;
    private static final int PROPERTY_SYNCPROVIDER_TAG = 17;
    private static final int PROPERTY_NULL_TAG = 18;
    private static final int PROPERTY_COLUMN_TAG = 19;
    private static final int PROPERTY_TYPE_TAG = 20;
    private static final int PROPERTY_CLASS_TAG = 21;
    private static final int PROPERTY_SYNCPROVIDERNAME_TAG = 22;
    private static final int PROPERTY_SYNCPROVIDERVENDOR_TAG = 23;
    private static final int PROPERTY_SYNCPROVIDERVERSION_TAG = 24;
    private static final int PROPERTY_SYNCPROVIDERGRADE_TAG = 25;
    private static final int PROPERTY_DATASOURCELOCK_TAG = 26;
    private String[] metadataNames = new String[]{"column-count", "column-definition", "column-index", "auto-increment", "case-sensitive", "currency", "nullable", "signed", "searchable", "column-display-size", "column-label", "column-name", "schema-name", "column-precision", "column-scale", "table-name", "catalog-name", "column-type", "column-type-name", "null"};
    private static final int METADATA_COLUMNCOUNT_TAG = 0;
    private static final int METADATA_COLUMNDEFINITION_TAG = 1;
    private static final int METADATA_COLUMNINDEX_TAG = 2;
    private static final int METADATA_AUTOINCREMENT_TAG = 3;
    private static final int METADATA_CASESENSITIVE_TAG = 4;
    private static final int METADATA_CURRENCY_TAG = 5;
    private static final int METADATA_NULLABLE_TAG = 6;
    private static final int METADATA_SIGNED_TAG = 7;
    private static final int METADATA_SEARCHABLE_TAG = 8;
    private static final int METADATA_COLUMNDISPLAYSIZE_TAG = 9;
    private static final int METADATA_COLUMNLABEL_TAG = 10;
    private static final int METADATA_COLUMNNAME_TAG = 11;
    private static final int METADATA_SCHEMANAME_TAG = 12;
    private static final int METADATA_COLUMNPRECISION_TAG = 13;
    private static final int METADATA_COLUMNSCALE_TAG = 14;
    private static final int METADATA_TABLENAME_TAG = 15;
    private static final int METADATA_CATALOGNAME_TAG = 16;
    private static final int METADATA_COLUMNTYPE_TAG = 17;
    private static final int METADATA_COLUMNTYPENAME_TAG = 18;
    private static final int METADATA_NULL_TAG = 19;
    private String[] dataNames = new String[]{"currentRow", "insertRow", "deleteRow", "modifyRow", "columnValue", "updateValue", "null"};
    private static final int DATA_CURRENTROW_TAG = 0;
    private static final int DATA_INSERTROW_TAG = 1;
    private static final int DATA_DELETEROW_TAG = 2;
    private static final int DATA_MODIFYROW_TAG = 3;
    private static final int DATA_COLUMNVALUE_TAG = 4;
    private static final int DATA_UPDATEVALUE_TAG = 5;
    private static final int DATA_NULL_TAG = 6;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    OracleWebRowSetXmlReaderContHandler(RowSet rowset) {
        this.wrset = (OracleWebRowSet)rowset;
        this.initialize();
    }

    public void characters(char[] chrs, int start, int length) throws SAXException {
        String elementValue = new String(chrs, start, length);
        this.processElement(elementValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDocument() throws SAXException {
        try {
            if (this.readReadOnlyValue) {
                this.wrset.setReadOnly(this.readReadOnlyValue);
            }
        }
        catch (SQLException sqlexc) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SAXException: " + sqlexc.getMessage());
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw new SAXException(sqlexc.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String nsUri, String localName, String qualifiedName) throws SAXException {
        String elementName = localName == null || localName.equals("") ? qualifiedName : localName;
        block16 : switch (this.getState()) {
            case 1: {
                if (elementName.equals(PROPERTIES_ELEMENT_NAME)) {
                    this.state = 0;
                    break;
                }
                try {
                    int pTag = (Integer)this.propertyNameTagMap.get(elementName);
                    switch (pTag) {
                        case 7: {
                            if (this.keyCols == null) break;
                            int[] keyColumns = new int[this.keyCols.size()];
                            for (int i2 = 0; i2 < keyColumns.length; ++i2) {
                                keyColumns[i2] = Integer.parseInt((String)this.keyCols.elementAt(i2));
                            }
                            this.wrset.setKeyColumns(keyColumns);
                        }
                    }
                    this.setPropertyValue(this.propertyValue);
                }
                catch (SQLException sqlexc) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SAXException: " + sqlexc.getMessage());
                            Object var9_20 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_21 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    throw new SAXException(sqlexc.getMessage());
                }
                this.propertyValue = "";
                this.setNullValue(false);
                this.setTag(-1);
                break;
            }
            case 2: {
                if (elementName.equals(METADATA_ELEMENT_NAME)) {
                    try {
                        this.wrset.setMetaData(this.rsetMetaData);
                        this.state = 0;
                        break;
                    }
                    catch (SQLException sqlexc) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SAXException: " + "Error setting metadata in WebRowSet: " + sqlexc.getMessage());
                                Object var11_23 = null;
                            }
                            catch (Throwable throwable) {
                                Object var11_24 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        throw new SAXException("Error setting metadata in WebRowSet: " + sqlexc.getMessage());
                    }
                }
                try {
                    this.setMetaDataValue(this.metadataValue);
                }
                catch (SQLException sqlexc) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SAXException: " + "Error setting metadata value: " + sqlexc.getMessage());
                            Object var13_26 = null;
                        }
                        catch (Throwable throwable) {
                            Object var13_27 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    throw new SAXException("Error setting metadata value: " + sqlexc.getMessage());
                }
                this.metadataValue = "";
                this.setNullValue(false);
                this.setTag(-1);
                break;
            }
            case 3: {
                if (elementName.equals(DATA_ELEMENT_NAME)) {
                    this.state = 0;
                    return;
                }
                int dTag = (Integer)this.dataNameTagMap.get(elementName);
                switch (dTag) {
                    default: {
                        break block16;
                    }
                    case 4: {
                        try {
                            ++this.columnIndex;
                            this.insertValue(this.columnValue);
                            this.columnValue = "";
                            this.setNullValue(false);
                            this.setTag(-1);
                            break block16;
                        }
                        catch (SQLException sqlexc) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SAXException: " + "Error inserting column values: " + sqlexc.getMessage());
                                    Object var15_29 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var15_30 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            throw new SAXException("Error inserting column values: " + sqlexc.getMessage());
                        }
                    }
                    case 0: {
                        try {
                            this.wrset.insertRow();
                            this.wrset.moveToCurrentRow();
                            this.wrset.next();
                            OracleRow row = this.wrset.getCurrentRow();
                            row.setInsertedFlag(false);
                            this.applyUpdates();
                            break block16;
                        }
                        catch (SQLException sqlexc) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SAXException: " + "Error constructing current row: " + sqlexc.getMessage());
                                    Object var17_32 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var17_33 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            throw new SAXException("Error constructing current row: " + sqlexc.getMessage());
                        }
                    }
                    case 2: {
                        try {
                            this.wrset.insertRow();
                            this.wrset.moveToCurrentRow();
                            this.wrset.next();
                            OracleRow row = this.wrset.getCurrentRow();
                            row.setInsertedFlag(false);
                            row.setRowDeleted(true);
                            this.applyUpdates();
                            break block16;
                        }
                        catch (SQLException sqlexc) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SAXException: " + "Error constructing deleted row: " + sqlexc.getMessage());
                                    Object var19_35 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var19_36 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            throw new SAXException("Error constructing deleted row: " + sqlexc.getMessage());
                        }
                    }
                    case 1: {
                        try {
                            this.wrset.insertRow();
                            this.wrset.moveToCurrentRow();
                            this.wrset.next();
                            this.applyUpdates();
                            break block16;
                        }
                        catch (SQLException sqlexc) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SAXException: " + "Error constructing inserted row: " + sqlexc.getMessage());
                                    Object var21_38 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var21_39 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            throw new SAXException("Error constructing inserted row: " + sqlexc.getMessage());
                        }
                    }
                    case 3: 
                }
                try {
                    this.wrset.insertRow();
                    this.wrset.moveToCurrentRow();
                    this.wrset.next();
                    OracleRow row = this.wrset.getCurrentRow();
                    row.setRowDeleted(true);
                    this.applyUpdates();
                    break;
                }
                catch (SQLException sqlexc) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SAXException: " + "Error constructing modified row: " + sqlexc.getMessage());
                            Object var23_41 = null;
                        }
                        catch (Throwable throwable) {
                            Object var23_42 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    throw new SAXException("Error constructing modified row: " + sqlexc.getMessage());
                }
            }
        }
    }

    public void startElement(String nsUri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        String elementName = localName == null || localName.equals("") ? qualifiedName : localName;
        switch (this.getState()) {
            case 1: {
                int pTag = (Integer)this.propertyNameTagMap.get(elementName);
                if (pTag == 18) {
                    this.setNullValue(true);
                    this.propertyValue = null;
                    break;
                }
                this.setTag(pTag);
                break;
            }
            case 2: {
                int mTag = (Integer)this.metadataNameTagMap.get(elementName);
                if (mTag == 19) {
                    this.setNullValue(true);
                    this.metadataValue = null;
                    break;
                }
                this.setTag(mTag);
                break;
            }
            case 3: {
                int dTag = (Integer)this.dataNameTagMap.get(elementName);
                if (dTag == 6) {
                    this.setNullValue(true);
                    this.columnValue = null;
                    break;
                }
                this.setTag(dTag);
                if (dTag != 0 && dTag != 1 && dTag != 2 && dTag != 3) break;
                this.columnIndex = 0;
                try {
                    this.wrset.moveToInsertRow();
                }
                catch (SQLException ex) {}
                break;
            }
            default: {
                this.setState(elementName);
            }
        }
    }

    public void error(SAXParseException saxparseexception) throws SAXParseException {
        throw saxparseexception;
    }

    public void warning(SAXParseException saxparseexception) throws SAXParseException {
        System.out.println("** Warning, line " + saxparseexception.getLineNumber() + ", uri " + saxparseexception.getSystemId());
        System.out.println("   " + saxparseexception.getMessage());
    }

    private void initialize() {
        int j2;
        this.propertyNameTagMap = new Hashtable(30);
        int i2 = this.propertyNames.length;
        for (j2 = 0; j2 < i2; ++j2) {
            this.propertyNameTagMap.put(this.propertyNames[j2], j2);
        }
        this.metadataNameTagMap = new Hashtable(30);
        i2 = this.metadataNames.length;
        for (j2 = 0; j2 < i2; ++j2) {
            this.metadataNameTagMap.put(this.metadataNames[j2], j2);
        }
        this.dataNameTagMap = new Hashtable(10);
        i2 = this.dataNames.length;
        for (j2 = 0; j2 < i2; ++j2) {
            this.dataNameTagMap.put(this.dataNames[j2], j2);
        }
        this.updatesToRowSet = new Vector();
        this.columnValue = "";
        this.propertyValue = "";
        this.metadataValue = "";
        this.isNullValue = false;
        this.columnIndex = 0;
        this.readReadOnlyValue = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processElement(String elementValue) throws SAXException {
        try {
            switch (this.getState()) {
                case 1: {
                    this.propertyValue = elementValue;
                    break;
                }
                case 2: {
                    this.metadataValue = elementValue;
                    break;
                }
                case 3: {
                    this.setDataValue(elementValue);
                }
            }
        }
        catch (SQLException sqlexc) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SAXException: " + "processElement: " + sqlexc.getMessage());
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw new SAXException("processElement: " + sqlexc.getMessage());
        }
    }

    private BigDecimal getBigDecimalValue(String colValue) {
        return new BigDecimal(colValue);
    }

    private byte[] getBinaryValue(String colValue) {
        return colValue.getBytes();
    }

    private boolean getBooleanValue(String colValue) {
        return Boolean.valueOf(colValue);
    }

    private byte getByteValue(String colValue) {
        return Byte.parseByte(colValue);
    }

    private Date getDateValue(String colValue) {
        return new Date(this.getLongValue(colValue));
    }

    private double getDoubleValue(String colValue) {
        return Double.parseDouble(colValue);
    }

    private float getFloatValue(String colValue) {
        return Float.parseFloat(colValue);
    }

    private int getIntegerValue(String colValue) {
        return Integer.parseInt(colValue);
    }

    private long getLongValue(String colValue) {
        return Long.parseLong(colValue);
    }

    private boolean getNullValue() {
        return this.isNullValue;
    }

    private short getShortValue(String colValue) {
        return Short.parseShort(colValue);
    }

    private String getStringValue(String colValue) {
        return colValue;
    }

    private Time getTimeValue(String colValue) {
        return new Time(this.getLongValue(colValue));
    }

    private Timestamp getTimestampValue(String colValue) {
        return new Timestamp(this.getLongValue(colValue));
    }

    private Blob getBlobValue(String colValue) throws SQLException {
        return new OracleSerialBlob(colValue.getBytes());
    }

    private Clob getClobValue(String colValue) throws SQLException {
        return new OracleSerialClob(colValue.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyUpdates() throws SAXException {
        if (this.updatesToRowSet.size() > 0) {
            try {
                for (Object[] update : this.updatesToRowSet) {
                    this.columnIndex = (Integer)update[0];
                    this.insertValue((String)update[1]);
                }
                this.wrset.updateRow();
            }
            catch (SQLException sqlexc) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SAXException: " + "Error updating row: " + sqlexc.getMessage());
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new SAXException("Error updating row: " + sqlexc.getMessage());
            }
            this.updatesToRowSet.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertValue(String colValue) throws SQLException {
        if (this.getNullValue() || colValue == null) {
            this.wrset.updateNull(this.columnIndex);
            return;
        }
        int colType = this.wrset.getMetaData().getColumnType(this.columnIndex);
        switch (colType) {
            case -7: {
                this.wrset.updateByte(this.columnIndex, this.getByteValue(colValue));
                break;
            }
            case 5: {
                this.wrset.updateShort(this.columnIndex, this.getShortValue(colValue));
                break;
            }
            case 4: {
                this.wrset.updateInt(this.columnIndex, this.getIntegerValue(colValue));
                break;
            }
            case -5: {
                this.wrset.updateLong(this.columnIndex, this.getLongValue(colValue));
                break;
            }
            case 6: 
            case 7: {
                this.wrset.updateFloat(this.columnIndex, this.getFloatValue(colValue));
                break;
            }
            case 8: {
                this.wrset.updateDouble(this.columnIndex, this.getDoubleValue(colValue));
                break;
            }
            case 2: 
            case 3: {
                this.wrset.updateObject(this.columnIndex, (Object)this.getBigDecimalValue(colValue));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.wrset.updateBytes(this.columnIndex, this.getBinaryValue(colValue));
                break;
            }
            case 91: {
                this.wrset.updateDate(this.columnIndex, this.getDateValue(colValue));
                break;
            }
            case 92: {
                this.wrset.updateTime(this.columnIndex, this.getTimeValue(colValue));
                break;
            }
            case 93: {
                this.wrset.updateTimestamp(this.columnIndex, this.getTimestampValue(colValue));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.wrset.updateString(this.columnIndex, this.getStringValue(colValue));
                break;
            }
            case 2004: {
                this.wrset.updateBlob(this.columnIndex, this.getBlobValue(colValue));
                break;
            }
            case 2005: {
                this.wrset.updateClob(this.columnIndex, this.getClobValue(colValue));
                break;
            }
            default: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + "The type " + colType + " is not supported currently.");
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new SQLException("The type " + colType + " is not supported currently.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPropertyValue(String propValue) throws SQLException {
        boolean flag = this.getNullValue();
        switch (this.getTag()) {
            default: {
                break;
            }
            case 0: {
                if (flag) {
                    this.wrset.setCommand(null);
                    break;
                }
                this.wrset.setCommand(propValue);
                break;
            }
            case 1: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 357);
                            Object var4_3 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.wrset.setConcurrency(this.getIntegerValue(propValue));
                break;
            }
            case 2: {
                if (flag) {
                    this.wrset.setDataSourceName(null);
                    break;
                }
                this.wrset.setDataSourceName(propValue);
                break;
            }
            case 3: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 357);
                            Object var6_18 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_19 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.wrset.setEscapeProcessing(this.getBooleanValue(propValue));
                break;
            }
            case 4: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 357);
                            Object var8_21 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_22 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int _rsetType = this.wrset.getType();
                if (_rsetType == 1005) break;
                this.wrset.setFetchDirection(this.getIntegerValue(propValue));
                break;
            }
            case 5: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 357);
                            Object var10_24 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_25 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.wrset.setFetchSize(this.getIntegerValue(propValue));
                break;
            }
            case 6: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 357);
                            Object var12_27 = null;
                        }
                        catch (Throwable throwable) {
                            Object var12_28 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.wrset.setTransactionIsolation(this.getIntegerValue(propValue));
                break;
            }
            case 19: {
                if (this.keyCols == null) {
                    this.keyCols = new Vector();
                }
                this.keyCols.add(propValue);
                break;
            }
            case 9: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 357);
                            Object var14_30 = null;
                        }
                        catch (Throwable throwable) {
                            Object var14_31 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.wrset.setMaxFieldSize(this.getIntegerValue(propValue));
                break;
            }
            case 10: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 357);
                            Object var16_33 = null;
                        }
                        catch (Throwable throwable) {
                            Object var16_34 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.wrset.setMaxRows(this.getIntegerValue(propValue));
                break;
            }
            case 11: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 357);
                            Object var18_36 = null;
                        }
                        catch (Throwable throwable) {
                            Object var18_37 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.wrset.setQueryTimeout(this.getIntegerValue(propValue));
                break;
            }
            case 12: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 357);
                            Object var20_39 = null;
                        }
                        catch (Throwable throwable) {
                            Object var20_40 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.readReadOnlyValue = this.getBooleanValue(propValue);
                break;
            }
            case 13: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 357);
                            Object var22_42 = null;
                        }
                        catch (Throwable throwable) {
                            Object var22_43 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.wrset.setType(this.getIntegerValue(propValue));
                break;
            }
            case 14: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 357);
                            Object var24_45 = null;
                        }
                        catch (Throwable throwable) {
                            Object var24_46 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 357);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.wrset.setShowDeleted(this.getBooleanValue(propValue));
                break;
            }
            case 15: {
                if (flag) {
                    this.wrset.setTableName(null);
                    break;
                }
                this.wrset.setTableName(propValue);
                break;
            }
            case 16: {
                if (flag) {
                    this.wrset.setUrl(null);
                    break;
                }
                this.wrset.setUrl(propValue);
                break;
            }
            case 22: {
                if (flag) {
                    this.wrset.setSyncProvider(null);
                    break;
                }
                this.wrset.setSyncProvider(propValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMetaDataValue(String metaValue) throws SQLException {
        boolean flag = this.getNullValue();
        switch (this.getTag()) {
            default: {
                break;
            }
            case 0: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 358);
                            Object var4_3 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int _columnCount = this.getIntegerValue(metaValue);
                this.rsetMetaData = new OracleRowSetMetaData(_columnCount);
                this.columnIndex = 0;
                break;
            }
            case 2: {
                ++this.columnIndex;
                break;
            }
            case 3: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 358);
                            Object var6_18 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_19 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.rsetMetaData.setAutoIncrement(this.columnIndex, this.getBooleanValue(metaValue));
                break;
            }
            case 4: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 358);
                            Object var8_21 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_22 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.rsetMetaData.setCaseSensitive(this.columnIndex, this.getBooleanValue(metaValue));
                break;
            }
            case 5: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 358);
                            Object var10_24 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_25 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.rsetMetaData.setCurrency(this.columnIndex, this.getBooleanValue(metaValue));
                break;
            }
            case 6: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 358);
                            Object var12_27 = null;
                        }
                        catch (Throwable throwable) {
                            Object var12_28 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.rsetMetaData.setNullable(this.columnIndex, this.getIntegerValue(metaValue));
                break;
            }
            case 7: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 358);
                            Object var14_30 = null;
                        }
                        catch (Throwable throwable) {
                            Object var14_31 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.rsetMetaData.setSigned(this.columnIndex, this.getBooleanValue(metaValue));
                break;
            }
            case 8: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 358);
                            Object var16_33 = null;
                        }
                        catch (Throwable throwable) {
                            Object var16_34 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.rsetMetaData.setSearchable(this.columnIndex, this.getBooleanValue(metaValue));
                break;
            }
            case 9: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 358);
                            Object var18_36 = null;
                        }
                        catch (Throwable throwable) {
                            Object var18_37 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.rsetMetaData.setColumnDisplaySize(this.columnIndex, this.getIntegerValue(metaValue));
                break;
            }
            case 10: {
                if (flag) {
                    this.rsetMetaData.setColumnLabel(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setColumnLabel(this.columnIndex, metaValue);
                break;
            }
            case 11: {
                if (flag) {
                    this.rsetMetaData.setColumnName(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setColumnName(this.columnIndex, metaValue);
                break;
            }
            case 12: {
                if (flag) {
                    this.rsetMetaData.setSchemaName(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setSchemaName(this.columnIndex, metaValue);
                break;
            }
            case 13: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 358);
                            Object var20_39 = null;
                        }
                        catch (Throwable throwable) {
                            Object var20_40 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.rsetMetaData.setPrecision(this.columnIndex, this.getIntegerValue(metaValue));
                break;
            }
            case 14: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 358);
                            Object var22_42 = null;
                        }
                        catch (Throwable throwable) {
                            Object var22_43 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.rsetMetaData.setScale(this.columnIndex, this.getIntegerValue(metaValue));
                break;
            }
            case 15: {
                if (flag) {
                    this.rsetMetaData.setTableName(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setTableName(this.columnIndex, metaValue);
                break;
            }
            case 16: {
                if (flag) {
                    this.rsetMetaData.setCatalogName(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setCatalogName(this.columnIndex, metaValue);
                break;
            }
            case 17: {
                if (flag) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleWebRowSetXmlReaderContHandler.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 358);
                            Object var24_45 = null;
                        }
                        catch (Throwable throwable) {
                            Object var24_46 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 358);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.rsetMetaData.setColumnType(this.columnIndex, this.getIntegerValue(metaValue));
                break;
            }
            case 18: {
                if (flag) {
                    this.rsetMetaData.setColumnTypeName(this.columnIndex, null);
                    break;
                }
                this.rsetMetaData.setColumnTypeName(this.columnIndex, metaValue);
            }
        }
    }

    private void setDataValue(String elementValue) throws SQLException {
        switch (this.getTag()) {
            default: {
                break;
            }
            case 4: {
                this.columnValue = elementValue;
                break;
            }
            case 5: {
                Object[] update = new Object[2];
                update[1] = elementValue;
                update[0] = this.columnIndex;
                this.updatesToRowSet.add(update);
            }
        }
    }

    protected void setNullValue(boolean flag) {
        this.isNullValue = flag;
    }

    private int getState() {
        return this.state;
    }

    private int getTag() {
        return this.tag;
    }

    private void setState(String elementName) throws SAXException {
        if (elementName.equals(WEBROWSET_ELEMENT_NAME)) {
            this.state = 0;
        } else if (elementName.equals(PROPERTIES_ELEMENT_NAME)) {
            this.state = this.state != 1 ? 1 : 0;
        } else if (elementName.equals(METADATA_ELEMENT_NAME)) {
            this.state = this.state != 2 ? 2 : 0;
        } else if (elementName.equals(DATA_ELEMENT_NAME)) {
            this.state = this.state != 3 ? 3 : 0;
        }
    }

    private void setTag(int t) {
        this.tag = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSetXmlReaderContHandler.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSetXmlReaderContHandler.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConnection = null;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSetXmlReaderContHandler.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleWebRowSetXmlReaderContHandler.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleConnection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleWebRowSetXmlReaderContHandler"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

