/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.T2CConnection;

class T2CResultSetAccessor
extends ResultSetAccessor {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T2CResultSetAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(stmt, max_len * 2, form, external_type, forBind);
    }

    T2CResultSetAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        super(stmt, max_len * 2, nullable, flags, precision, scale, contflag, total_elems, form);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytes(int currentRow) throws SQLException {
        byte[] result = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CResultSetAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
            byte align = ((T2CConnection)this.statement.connection).byteAlign;
            int adjusted_columnIndex = this.columnIndex + (align - 1) & ~(align - 1);
            int off = adjusted_columnIndex + len * currentRow;
            result = new byte[len];
            System.arraycopy(this.rowSpaceByte, off, result, 0, len);
        }
        return result;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T2CResultSetAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

