/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.sql.Datum;

class PlsqlIbtBinder
extends Binder {
    Binder thePlsqlIbtCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtCopyingBinder;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PlsqlIbtBinder() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            PlsqlIbtBinder.init(this);
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void init(Binder x) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(x));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            x.type = (short)998;
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, "         Exit");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var16_15 = null;
                }
                catch (Throwable throwable) {
                    Object var16_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            PlsqlIbtBindInfo bindInfo = stmt.parameterPlsqlIbt[rank][bindPosition];
            if (clearPriorBindValues) {
                stmt.parameterPlsqlIbt[rank][bindPosition] = null;
            }
            int offset = bindInfo.ibtValueIndex;
            switch (bindInfo.element_internal_type) {
                case 9: {
                    for (int i2 = 0; i2 < bindInfo.curLen; ++i2) {
                        int len = 0;
                        String s2 = (String)bindInfo.arrayData[i2];
                        if (s2 != null) {
                            len = s2.length();
                            if (len > bindInfo.elemMaxLen - 1) {
                                len = bindInfo.elemMaxLen - 1;
                            }
                            s2.getChars(0, len, stmt.ibtBindChars, offset + 1);
                            stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i2] = 0;
                            stmt.ibtBindChars[offset] = (char)(len <<= 1);
                            stmt.ibtBindIndicators[bindInfo.ibtLengthIndex + i2] = (short)(len == 0 ? 3 : (short)(len + 2));
                        } else {
                            stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i2] = -1;
                        }
                        offset += bindInfo.elemMaxLen;
                    }
                    break;
                }
                case 6: {
                    for (int i3 = 0; i3 < bindInfo.curLen; ++i3) {
                        byte[] bytes = null;
                        if (bindInfo.arrayData[i3] != null) {
                            bytes = ((Datum)bindInfo.arrayData[i3]).getBytes();
                        }
                        if (bytes == null) {
                            stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i3] = -1;
                        } else {
                            stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i3] = 0;
                            stmt.ibtBindIndicators[bindInfo.ibtLengthIndex + i3] = (short)(bytes.length + 1);
                            stmt.ibtBindBytes[offset] = (byte)bytes.length;
                            System.arraycopy(bytes, 0, stmt.ibtBindBytes, offset + 1, bytes.length);
                        }
                        offset += bindInfo.elemMaxLen;
                    }
                    break;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            PlsqlIbtBinder.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 97);
                            Object var21_26 = null;
                        }
                        catch (Throwable throwable) {
                            Object var21_27 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            Object var23_29 = null;
        }
        catch (Throwable throwable) {
            Object var23_30 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var25_33 = null;
                }
                catch (Throwable throwable2) {
                    Object var25_34 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var25_31 = null;
            }
            catch (Throwable throwable) {
                Object var25_32 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Binder copyingBinder() {
        Binder binder;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.thePlsqlIbtCopyingBinder);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            binder = this.thePlsqlIbtCopyingBinder;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                PlsqlIbtBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return binder;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.PlsqlIbtBinder"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

