/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.value;

import com.crystaldecisions12.reports.common.value.DateTimeValue;
import com.crystaldecisions12.reports.common.value.DateValue;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.FormulaValueType;
import com.crystaldecisions12.reports.common.value.ValueType;
import java.util.Comparator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class RangeValue
extends FormulaValue {
    private final FormulaValue b;
    private final FormulaValue void;
    private final boolean c;
    private final boolean d;

    private RangeValue(FormulaValue formulaValue, FormulaValue formulaValue2, boolean bl2, boolean bl3) {
        FormulaValueType formulaValueType;
        if (formulaValue == null && formulaValue2 == null) {
            throw new NullPointerException("Both start and end values of a range cannot be null");
        }
        FormulaValueType formulaValueType2 = formulaValue == null ? FormulaValueType.unknown : formulaValue.getFormulaValueType();
        FormulaValueType formulaValueType3 = formulaValueType = formulaValue2 == null ? FormulaValueType.unknown : formulaValue2.getFormulaValueType();
        if (formulaValueType2.getBaseFormulaValueType() == FormulaValueType.bool || formulaValueType.getBaseFormulaValueType() == FormulaValueType.bool) {
            throw new IllegalArgumentException("Boolean range values are not allowed");
        }
        if (formulaValueType2.isRange() || formulaValueType.isRange()) {
            throw new IllegalArgumentException("A range cannot contain ranges as its start or end values");
        }
        if (formulaValueType2.isArray() || formulaValueType.isArray()) {
            throw new IllegalArgumentException("A range cannot contains arrays as its start or end values");
        }
        if (formulaValue != null && formulaValue2 != null && formulaValueType2 != formulaValueType) {
            throw new IllegalArgumentException("The start and end values cannot have different value types");
        }
        this.b = formulaValue;
        this.void = formulaValue2;
        this.c = bl2 && formulaValue != null;
        this.d = bl3 && formulaValue2 != null;
    }

    public static RangeValue fromStartAndEndValues(FormulaValue formulaValue, FormulaValue formulaValue2, boolean bl2, boolean bl3) {
        return new RangeValue(formulaValue, formulaValue2, bl2, bl3);
    }

    public static RangeValue fromSingleValue(FormulaValue formulaValue) {
        return new RangeValue(formulaValue, formulaValue, true, true);
    }

    public FormulaValue coerceToNumber() {
        return this.if(FormulaValueType.number);
    }

    public FormulaValue coerceToCurrency() {
        return this.if(FormulaValueType.currency);
    }

    public FormulaValue coerceToDate() {
        return this.if(FormulaValueType.date);
    }

    public FormulaValue coerceToTime() {
        return this.if(FormulaValueType.time);
    }

    public FormulaValue coerceToDateTime() {
        FormulaValueType formulaValueType = this.getFormulaValueType().getBaseFormulaValueType();
        if (formulaValueType == FormulaValueType.dateTime) {
            return this;
        }
        if (formulaValueType == FormulaValueType.date) {
            DateTimeValue dateTimeValue = null;
            if (this.b != null) {
                dateTimeValue = this.c ? ((DateValue)this.b).getStartOfDayDateTimeValue() : ((DateValue)this.b).getEndOfDayDateTimeValue();
            }
            DateTimeValue dateTimeValue2 = null;
            if (this.void != null) {
                dateTimeValue2 = this.d ? ((DateValue)this.void).getEndOfDayDateTimeValue() : ((DateValue)this.void).getStartOfDayDateTimeValue();
            }
            return RangeValue.fromStartAndEndValues(dateTimeValue, dateTimeValue2, this.c, this.d);
        }
        return this.if(FormulaValueType.dateTime);
    }

    public FormulaValue coerceToString() {
        return this.if(FormulaValueType.string);
    }

    private FormulaValue if(FormulaValueType formulaValueType) {
        FormulaValueType formulaValueType2 = this.getFormulaValueType().getBaseFormulaValueType();
        if (formulaValueType2 == formulaValueType) {
            return this;
        }
        FormulaValue formulaValue = RangeValue.coerce(this.b, formulaValueType);
        FormulaValue formulaValue2 = RangeValue.coerce(this.void, formulaValueType);
        if (formulaValue == null && this.b != null || formulaValue2 == null && this.void != null) {
            return null;
        }
        return RangeValue.fromStartAndEndValues(formulaValue, formulaValue2, this.c, this.d);
    }

    public FormulaValue coerceToRange() {
        return this;
    }

    public FormulaValue toSingleValue() {
        return this.b != null && this.b.equals(this.void) ? this.b : null;
    }

    public FormulaValue getStartValue() {
        return this.b;
    }

    public FormulaValue getEndValue() {
        return this.void;
    }

    public boolean getIncludeStart() {
        return this.c;
    }

    public boolean getIncludeEnd() {
        return this.d;
    }

    public ValueType getValueType() {
        ValueType valueType = this.b != null ? this.b.getValueType() : this.void.getValueType();
        return valueType.try();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        RangeValue rangeValue = (RangeValue)object;
        if (this.c != rangeValue.c || this.d != rangeValue.d) {
            return false;
        }
        if (this.b == null != (rangeValue.b == null)) {
            return false;
        }
        if (this.b != null && !this.b.equals(rangeValue.b)) {
            return false;
        }
        if (this.void == null != (rangeValue.void == null)) {
            return false;
        }
        return this.void == null || this.void.equals(rangeValue.void);
    }

    public int compareTo(Object object, Comparator comparator) {
        if (object == this) {
            return 0;
        }
        RangeValue rangeValue = (RangeValue)object;
        if (this.getValueType() != rangeValue.getValueType()) {
            throw new ClassCastException("Can't compare RangeValues with different valueTypes");
        }
        int n2 = RangeValue.a(this.b, rangeValue.b, comparator);
        if (n2 != 0) {
            return n2;
        }
        n2 = RangeValue.a(this.void, rangeValue.void, comparator);
        if (n2 != 0) {
            return n2;
        }
        n2 = RangeValue.a(this.c, rangeValue.c);
        if (n2 != 0) {
            return n2;
        }
        return RangeValue.a(this.d, rangeValue.d);
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + (this.b == null ? 0 : this.b.hashCode());
        n2 = 37 * n2 + (this.void == null ? 0 : this.void.hashCode());
        n2 = 37 * n2 + (this.c ? 0 : 1);
        n2 = 37 * n2 + (this.d ? 0 : 1);
        return n2;
    }

    public String toString() {
        return "r(" + (this.c ? "[" : "(") + this.b + ".." + this.void + (this.d ? "]" : ")") + ")";
    }
}

