/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.formulas.functions.financial;

import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.formulas.FormulaEnvironment;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions.reports.formulas.FormulaFunctionDefinition;
import com.crystaldecisions.reports.formulas.FormulaResources;
import com.crystaldecisions.reports.formulas.FormulaValueReference;
import com.crystaldecisions.reports.formulas.functions.CommonArguments;
import com.crystaldecisions.reports.formulas.functions.FormulaFunctionFactory;
import com.crystaldecisions.reports.formulas.functions.financial.ae;
import com.crystaldecisions.reports.formulas.functions.financial.an;

class aq
implements FormulaFunctionFactory {
    private static final aq hq = new aq();
    private static final FormulaFunctionArgumentDefinition[][] hr = new FormulaFunctionArgumentDefinition[][]{{CommonArguments.issueDate, CommonArguments.firstInterestDate, CommonArguments.settlementDate, CommonArguments.rate, CommonArguments.parValue, CommonArguments.frequency}, {CommonArguments.issueDate, CommonArguments.firstInterestDate, CommonArguments.settlementDate, CommonArguments.rate, CommonArguments.parValue, CommonArguments.frequency, CommonArguments.basis}};
    private static final FormulaFunctionDefinition[] hs = new FormulaFunctionDefinition[]{new a(hr[0]), new a(hr[1])};

    private aq() {
    }

    public static aq bg() {
        return hq;
    }

    public FormulaFunctionDefinition getFunctionInstance(int n2) {
        return hs[n2];
    }

    public int getNFunctionInstances() {
        return hs.length;
    }

    private static class a
    extends FormulaFunctionBase {
        public a(FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray) {
            super("ACCRINT", "accrint", formulaFunctionArgumentDefinitionArray);
        }

        public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            int n2;
            int n3;
            double d10;
            double d11;
            if (formulaValueReferenceArray[0].getFormulaValue() != null && formulaValueReferenceArray[2].getFormulaValue() != null) {
                DateValue dateValue = ((DateTimeValue)formulaValueReferenceArray[0].getFormulaValue()).getDateValue();
                DateValue dateValue2 = ((DateTimeValue)formulaValueReferenceArray[2].getFormulaValue()).getDateValue();
                if (dateValue.getCRDate() >= dateValue2.getCRDate()) {
                    String[] stringArray = new String[]{"issueDate", "interestDate"};
                    throw new FormulaFunctionArgumentException("JRC00002416", "", FormulaResources.a(), "BadOrder", stringArray, 0);
                }
            }
            if (formulaValueReferenceArray[3].getFormulaValue() != null && (d11 = ((NumberValue)formulaValueReferenceArray[3].getFormulaValue()).getDouble()) <= 0.0) {
                throw new FormulaFunctionArgumentException("JRC00002417", "", FormulaResources.a(), "ArgumentOutOfRange", 3);
            }
            if (formulaValueReferenceArray[4].getFormulaValue() != null && (d10 = ((NumberValue)formulaValueReferenceArray[4].getFormulaValue()).getDouble()) <= 0.0) {
                throw new FormulaFunctionArgumentException("JRC00002418", "", FormulaResources.a(), "ArgumentOutOfRange", 4);
            }
            if (formulaValueReferenceArray[5].getFormulaValue() != null && (n3 = ((NumberValue)formulaValueReferenceArray[5].getFormulaValue()).getInt()) != 1 && n3 != 2 && n3 != 4) {
                throw new FormulaFunctionArgumentException("JRC00002419", "", FormulaResources.a(), "ArgumentOutOfRange", 5);
            }
            if (formulaValueReferenceArray.length == 7 && formulaValueReferenceArray[6].getFormulaValue() != null && ((n2 = ((NumberValue)formulaValueReferenceArray[6].getFormulaValue()).getInt()) < 0 || n2 > 4)) {
                throw new FormulaFunctionArgumentException("JRC00002420", "", FormulaResources.a(), "ArgumentOutOfRange", 6);
            }
            return FormulaValueType.currency;
        }

        public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            double d10;
            int n2;
            this.validate(formulaValueReferenceArray, formulaEnvironment);
            DateValue dateValue = ((DateTimeValue)formulaValueReferenceArray[0].getFormulaValue()).getDateValue();
            DateValue dateValue2 = ((DateTimeValue)formulaValueReferenceArray[1].getFormulaValue()).getDateValue();
            DateValue dateValue3 = ((DateTimeValue)formulaValueReferenceArray[2].getFormulaValue()).getDateValue();
            double d11 = ((NumberValue)formulaValueReferenceArray[3].getFormulaValue()).getDouble();
            double d12 = ((NumberValue)formulaValueReferenceArray[4].getFormulaValue()).getScaledDouble();
            int n3 = ((NumberValue)formulaValueReferenceArray[5].getFormulaValue()).getInt();
            an an2 = an.do;
            if (formulaValueReferenceArray.length == 7) {
                n2 = ((NumberValue)formulaValueReferenceArray[6].getFormulaValue()).getInt();
                an2 = an.a(n2);
            }
            boolean bl2 = true;
            boolean bl3 = false;
            double[] dArray = ae.a(dateValue, dateValue2, n3, an2, true);
            double d13 = dArray[0];
            n2 = (int)dArray[1];
            dArray = ae.a(dateValue3, dateValue2, n3, an2, false);
            double d14 = dArray[0];
            int n4 = (int)dArray[1];
            CrystalAssert.ASSERT((n2 >= n4 ? 1 : 0) != 0);
            if (n2 == n4 && an2 != an.a) {
                double[] dArray2 = ae.a(dateValue, dateValue3, an2);
                int n5 = (int)dArray2[0];
                double d15 = dArray2[1];
                d10 = (double)n5 / d15 * (double)n3;
            } else {
                d10 = d13 + d14 + (double)n2 - (double)n4 - 1.0;
            }
            double d16 = d12 * d11 / (double)n3 * d10;
            return CurrencyValue.fromScaledDouble((double)d16);
        }
    }
}

