/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.NumberUtil;
import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputArchive;
import com.crystaldecisions.reports.common.archive.IOutputArchive;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataOutput;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.NumericValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.io.DataInput;
import java.io.IOException;

public final class CurrencyValue
extends NumericValue {
    public static final CurrencyValue zero = new CurrencyValue(0.0, true);
    public static final CurrencyValue one = new CurrencyValue(100.0, true);
    public static final CurrencyValue two = new CurrencyValue(200.0, true);
    public static final CurrencyValue ten = new CurrencyValue(1000.0, true);

    private CurrencyValue(double d, boolean bl) {
        super(d, bl);
    }

    public void store(ValueType valueType, ExtendedDataOutput extendedDataOutput) throws IOException {
        assert (valueType == this.getValueType());
        extendedDataOutput.writeDouble(this.getScaledDouble());
    }

    public void storeToArchive(ValueType valueType, IOutputArchive iOutputArchive) throws ArchiveException {
        assert (valueType == this.getValueType());
        iOutputArchive.storeDouble(this.getScaledDouble());
    }

    public static CurrencyValue Load(DataInput dataInput) throws IOException {
        return CurrencyValue.fromScaledDouble(dataInput.readDouble());
    }

    public static CurrencyValue LoadFromArchive(IInputArchive iInputArchive) throws ArchiveException {
        return CurrencyValue.fromScaledDouble(iInputArchive.loadDouble());
    }

    public static int GetMaxEncodedSize() {
        return 8;
    }

    public int getEncodedSizeForArchive(ValueType valueType) {
        return CurrencyValue.GetMaxEncodedSize();
    }

    public int getEncodedSize(ValueType valueType) {
        assert (valueType == this.getValueType());
        return CurrencyValue.GetMaxEncodedSize();
    }

    static CurrencyValue fromScaledDouble(double d, boolean bl) {
        if (d == zero.getScaledDouble()) {
            return zero;
        }
        if (d == one.getScaledDouble()) {
            return one;
        }
        if (d == two.getScaledDouble()) {
            return two;
        }
        if (d == ten.getScaledDouble()) {
            return ten;
        }
        return new CurrencyValue(d, bl);
    }

    public static CurrencyValue fromScaledDouble(double d) {
        return CurrencyValue.fromScaledDouble(d, false);
    }

    public static CurrencyValue fromScaledLong(long l) {
        return CurrencyValue.fromScaledDouble((double)l, NumberUtil.isNormalized(l));
    }

    public static CurrencyValue fromDouble(double d) {
        return CurrencyValue.fromScaledDouble(d * 100.0);
    }

    public static CurrencyValue fromLong(long l) {
        return CurrencyValue.fromScaledDouble((double)l * 100.0, NumberUtil.isNormalizedUnscaledLong(l));
    }

    public static CurrencyValue fromNumberValue(NumberValue numberValue) {
        return CurrencyValue.fromScaledDouble(numberValue.getScaledDouble(), numberValue.normalized);
    }

    public FormulaValue coerceToNumber() {
        return NumberValue.fromCurrencyValue(this);
    }

    public FormulaValue coerceToCurrency() {
        return this;
    }

    public FormulaValue coerceToBoolean() {
        return this.getScaledDouble() == 0.0 ? BooleanValue.FALSE : BooleanValue.TRUE;
    }

    public ValueType getValueType() {
        return ValueType.currency;
    }

    public String toString() {
        return "c" + super.toString();
    }
}

