/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.collection;

import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.common.collection.ISortedCollectionBase;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SortedSubCollection
extends AbstractCollection
implements ISortedCollectionBase {
    private static final int void = 10;
    private static final int long = -1;
    Object[] items = new Object[10];
    int nItems = 0;
    private int b = 0;
    private final Comparator goto;

    public SortedSubCollection() {
        this.goto = null;
    }

    public SortedSubCollection(Collection collection) {
        this.goto = null;
        this.addAll(collection);
    }

    public SortedSubCollection(int n) {
        this.goto = null;
        this.items = new Object[n];
    }

    public SortedSubCollection(Comparator comparator) {
        this.goto = comparator;
    }

    public Iterator iterator() {
        return new CollectionIterator();
    }

    public int size() {
        return this.nItems;
    }

    public Comparator comparator() {
        return this.goto;
    }

    public Object first() {
        return this.get(0);
    }

    public Object last() {
        return this.get(this.size() - 1);
    }

    public boolean contains(Object object) {
        return this.findPos(object, this.goto) != -1;
    }

    public Object get(int n) {
        return this.items[n];
    }

    public SortedSubCollection getCollection(int n) {
        return (SortedSubCollection)this.items[n];
    }

    public int indexOf(Object object) {
        return this.findPos(object, this.goto);
    }

    public int indexOf(Object object, Comparator comparator) {
        return this.findPos(object, comparator);
    }

    public int getLastLookupPoint() {
        return this.b;
    }

    public boolean add(Object object) {
        int n = this.findPos(object, this.goto);
        if (n != -1) {
            return false;
        }
        return this.add(this.b, object);
    }

    public boolean add(int n, Object object) {
        CrystalAssert.ASSERT(n != -1);
        if (this.items.length == this.size()) {
            this.ensureCapacity(this.items.length * 2 + 1);
        }
        if (!this.isEmpty() && n < this.size()) {
            System.arraycopy(this.items, n, this.items, n + 1, this.size() - n);
        }
        this.items[n] = object;
        ++this.nItems;
        return true;
    }

    public void set(int n, Object object) {
        CrystalAssert.ASSERT(n < this.size());
        this.items[n] = object;
    }

    public Object get(String string) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int n) {
        Object object = this.items[n];
        if (this.isEmpty()) {
            return null;
        }
        if (this.size() > 1) {
            System.arraycopy(this.items, n + 1, this.items, n, this.size() - n - 1);
        }
        this.items[this.size() - 1] = null;
        --this.nItems;
        return object;
    }

    public void removeFrom(int n) {
        if (!this.isEmpty() && n < this.size()) {
            Object[] objectArray = new Object[n + 1];
            System.arraycopy(this.items, 0, objectArray, 0, n);
            this.items = objectArray;
            this.nItems = n;
        }
    }

    public Object removeByName(String string) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.items[i] = null;
        }
        this.nItems = 0;
        this.b = 0;
    }

    public void ensureCapacity(int n) {
        if (this.items.length < n) {
            Object[] objectArray = this.items;
            this.items = new Object[n];
            System.arraycopy(objectArray, 0, this.items, 0, this.size());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return new SortedSubCollection(this);
    }

    protected int findPos(Object object, Comparator comparator) {
        int n;
        if (this.isEmpty()) {
            this.b = 0;
            return -1;
        }
        int n2 = 0;
        int n3 = this.size();
        int n4 = n = this.b >= 0 && this.b < this.size() ? this.b : (n2 + n3) / 2;
        while (n2 < n3) {
            Object object2 = this.items[n];
            int n5 = 0;
            n5 = comparator == null ? (object == null ? (object2 == null ? 0 : -1 * ((Comparable)object2).compareTo(object)) : ((Comparable)object).compareTo(object2)) : comparator.compare(object, object2);
            if (n5 == 0) {
                this.b = n;
                return n;
            }
            if (n5 < 0) {
                n3 = n;
            } else {
                n2 = n + 1;
            }
            n = (n2 + n3) / 2;
        }
        this.b = n;
        return -1;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CollectionIterator
    implements Iterator {
        private int if = 0;
        private boolean a = false;

        CollectionIterator() {
        }

        public boolean hasNext() {
            return this.if < SortedSubCollection.this.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.a = true;
            return SortedSubCollection.this.items[this.if++];
        }

        public void remove() {
            if (!this.a) {
                throw new IllegalStateException();
            }
            SortedSubCollection.this.remove(--this.if);
            this.a = false;
        }
    }
}

