/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.AbstractPaintContext;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class AngularGradientPaintExtContext
extends AbstractPaintContext {
    private double centerX;
    private double centerY;
    double startX;
    double deltaX;

    public AngularGradientPaintExtContext(Rectangle2D boundRect, double[] intervals, Color[] colors, Point2D centerPoint, double startX, double endX, AffineTransform trans) throws NoninvertibleTransformException {
        super(boundRect, intervals, colors, trans);
        this.centerX = centerPoint.getX();
        this.centerY = centerPoint.getY();
        this.startX = startX;
        this.deltaX = endX - startX;
        if (!FP.nonzero(this.deltaX)) {
            this.deltaX = 0.0;
        }
    }

    public final double calcGradientValue(double X, double Y) {
        double fValue = 0.0;
        double x = X - this.centerX;
        double y = Y - this.centerY;
        double tang = x / y;
        fValue = (tang - this.startX) / this.deltaX;
        if (fValue >= 0.0 && fValue <= 1.0) {
            return fValue;
        }
        if (fValue < 0.0) {
            return 0.0;
        }
        return 1.0;
    }
}

