/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;

public final class Matrix3d {
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;

    public Matrix3d() {
        this(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    }

    public Matrix3d(double mm00, double mm01, double mm02, double mm10, double mm11, double mm12, double mm20, double mm21, double mm22) {
        this.m00 = mm00;
        this.m01 = mm01;
        this.m02 = mm02;
        this.m10 = mm10;
        this.m11 = mm11;
        this.m12 = mm12;
        this.m20 = mm20;
        this.m21 = mm21;
        this.m22 = mm22;
    }

    public Matrix3d(Matrix3d m) {
        this(m.m00, m.m01, m.m02, m.m10, m.m11, m.m12, m.m20, m.m21, m.m22);
    }

    public Matrix3d(double angle, double x, double y) {
        this(1.0, 0.0, x, 0.0, 1.0, y, 0.0, 0.0, 1.0);
        double cosZ = Math.cos(angle);
        double sinZ = Math.sin(angle);
        Matrix3d m = new Matrix3d(cosZ, -sinZ, 0.0, sinZ, cosZ, 0.0, 0.0, 0.0, 1.0);
        this.mult(m);
        m = new Matrix3d(1.0, 0.0, -x, 0.0, 1.0, -y, 0.0, 0.0, 1.0);
        this.mult(m);
    }

    public void mult(int[] x, int[] y, int count) {
        for (int i = 0; i < count; ++i) {
            double x1 = this.m00 * (double)x[i] + this.m01 * (double)y[i] + this.m02;
            double y1 = this.m10 * (double)x[i] + this.m11 * (double)y[i] + this.m12;
            x[i] = (int)x1;
            y[i] = (int)y1;
        }
    }

    public void translate(double x, double y) {
        Matrix3d m = new Matrix3d(1.0, 0.0, x, 0.0, 1.0, y, 0.0, 0.0, 1.0);
        this.mult(m);
    }

    public void identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public void mult(Matrix3d m2) {
        double t00 = this.m00 * m2.m00 + this.m01 * m2.m10 + this.m02 * m2.m20;
        double t01 = this.m00 * m2.m01 + this.m01 * m2.m11 + this.m02 * m2.m21;
        double t02 = this.m00 * m2.m02 + this.m01 * m2.m12 + this.m02 * m2.m22;
        double t10 = this.m10 * m2.m00 + this.m11 * m2.m10 + this.m12 * m2.m20;
        double t11 = this.m10 * m2.m01 + this.m11 * m2.m11 + this.m12 * m2.m21;
        double t12 = this.m10 * m2.m02 + this.m11 * m2.m12 + this.m12 * m2.m22;
        double t20 = this.m20 * m2.m00 + this.m21 * m2.m10 + this.m22 * m2.m20;
        double t21 = this.m20 * m2.m01 + this.m21 * m2.m11 + this.m22 * m2.m21;
        double t22 = this.m20 * m2.m02 + this.m21 * m2.m12 + this.m22 * m2.m22;
        this.m00 = t00;
        this.m01 = t01;
        this.m02 = t02;
        this.m10 = t10;
        this.m11 = t11;
        this.m12 = t12;
        this.m20 = t20;
        this.m21 = t21;
        this.m22 = t22;
    }

    public Matrix3d multBy(Matrix3d m2) {
        Matrix3d m3 = new Matrix3d(this.m00 * m2.m00 + this.m01 * m2.m10 + this.m02 * m2.m20, this.m00 * m2.m01 + this.m01 * m2.m11 + this.m02 * m2.m21, this.m00 * m2.m02 + this.m01 * m2.m12 + this.m02 * m2.m22, this.m10 * m2.m00 + this.m11 * m2.m10 + this.m12 * m2.m20, this.m10 * m2.m01 + this.m11 * m2.m11 + this.m12 * m2.m21, this.m10 * m2.m02 + this.m11 * m2.m12 + this.m12 * m2.m22, this.m20 * m2.m00 + this.m21 * m2.m10 + this.m22 * m2.m20, this.m20 * m2.m01 + this.m21 * m2.m11 + this.m22 * m2.m21, this.m20 * m2.m02 + this.m21 * m2.m12 + this.m22 * m2.m22);
        return m3;
    }

    public final void rotX(double radians) {
        this.rotX(Math.cos(radians), Math.sin(radians));
    }

    public final void rotX(double cosX, double sinX) {
        double t01 = this.m01 * cosX + this.m02 * -sinX;
        double t02 = this.m01 * sinX + this.m02 * cosX;
        double t11 = this.m11 * cosX + this.m12 * -sinX;
        double t12 = this.m11 * sinX + this.m12 * cosX;
        double t21 = this.m21 * cosX + this.m22 * -sinX;
        double t22 = this.m21 * sinX + this.m22 * cosX;
        this.m01 = t01;
        this.m02 = t02;
        this.m11 = t11;
        this.m12 = t12;
        this.m21 = t21;
        this.m22 = t22;
    }

    public final void rotY(double radians) {
        this.rotY(Math.cos(radians), Math.sin(radians));
    }

    public final void rotY(double cosY, double sinY) {
        double t00 = this.m00 * cosY + this.m02 * sinY;
        double t02 = this.m00 * -sinY + this.m02 * cosY;
        double t10 = this.m10 * cosY + this.m12 * sinY;
        double t12 = this.m10 * -sinY + this.m12 * cosY;
        double t20 = this.m20 * cosY + this.m22 * sinY;
        double t22 = this.m20 * -sinY + this.m22 * cosY;
        this.m00 = t00;
        this.m02 = t02;
        this.m10 = t10;
        this.m12 = t12;
        this.m20 = t20;
        this.m22 = t22;
    }

    public final void rotZ(double radians) {
        this.rotZ(Math.cos(radians), Math.sin(radians));
    }

    public void rotZ(double cosZ, double sinZ) {
        double t00 = this.m00 * cosZ + this.m01 * -sinZ;
        double t01 = this.m00 * sinZ + this.m01 * cosZ;
        double t10 = this.m10 * cosZ + this.m11 * -sinZ;
        double t11 = this.m10 * sinZ + this.m11 * cosZ;
        double t20 = this.m20 * cosZ + this.m21 * -sinZ;
        double t21 = this.m20 * sinZ + this.m21 * cosZ;
        this.m00 = t00;
        this.m01 = t01;
        this.m10 = t10;
        this.m11 = t11;
        this.m20 = t20;
        this.m21 = t21;
    }

    public void scale(double fx, double fy, double fz) {
        this.m00 *= fx;
        this.m01 *= fx;
        this.m02 *= fx;
        this.m10 *= fy;
        this.m11 *= fy;
        this.m12 *= fy;
        this.m20 *= fz;
        this.m21 *= fz;
        this.m22 *= fz;
    }

    public void scale(double s) {
        this.m00 *= s;
        this.m01 *= s;
        this.m02 *= s;
        this.m10 *= s;
        this.m11 *= s;
        this.m12 *= s;
        this.m20 *= s;
        this.m21 *= s;
        this.m22 *= s;
    }

    public Matrix3d transpose() {
        Matrix3d m = new Matrix3d(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
        return m;
    }

    public void transformPoint3d(Point3d p, Point3d returnPoint) {
        double tempX = p.x;
        double tempY = p.y;
        double tempZ = p.z;
        returnPoint.x = tempX * this.m00 + tempY * this.m10 + tempZ * this.m20;
        returnPoint.y = tempX * this.m01 + tempY * this.m11 + tempZ * this.m21;
        returnPoint.z = tempX * this.m02 + tempY * this.m12 + tempZ * this.m22;
    }

    public void transformCovector3d(Point3d p, Point3d returnPoint) {
        double tempX = p.x;
        double tempY = p.y;
        double tempZ = p.z;
        returnPoint.x = tempX * this.m00 + tempY * this.m01 + tempZ * this.m02;
        returnPoint.y = tempX * this.m10 + tempY * this.m11 + tempZ * this.m12;
        returnPoint.z = tempX * this.m20 + tempY * this.m21 + tempZ * this.m22;
    }

    final double get(int i, int j) {
        if (i == 0) {
            if (j == 0) {
                return this.m00;
            }
            if (j == 1) {
                return this.m01;
            }
            if (j == 2) {
                return this.m02;
            }
        } else if (i == 1) {
            if (j == 0) {
                return this.m10;
            }
            if (j == 1) {
                return this.m11;
            }
            if (j == 2) {
                return this.m12;
            }
        } else if (i == 2) {
            if (j == 0) {
                return this.m20;
            }
            if (j == 1) {
                return this.m21;
            }
            if (j == 2) {
                return this.m22;
            }
        }
        throw new IllegalArgumentException("Bad index (i,j) = (" + i + "," + j + ")");
    }

    final void set(int i, int j, double d) {
        if (i == 0) {
            if (j == 0) {
                this.m00 = d;
            }
            if (j == 1) {
                this.m01 = d;
            }
            if (j == 2) {
                this.m02 = d;
            }
        } else if (i == 1) {
            if (j == 0) {
                this.m10 = d;
            }
            if (j == 1) {
                this.m11 = d;
            }
            if (j == 2) {
                this.m12 = d;
            }
        } else if (i == 2) {
            if (j == 0) {
                this.m20 = d;
            }
            if (j == 1) {
                this.m21 = d;
            }
            if (j == 2) {
                this.m22 = d;
            }
        }
        throw new IllegalArgumentException("Bad index (i,j) = (" + i + "," + j + ")");
    }
}

