/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IDataProcessor;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.ITrendlineEngine;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MovingAverageEngine
implements ITrendlineEngine {
    private boolean isValid = false;
    private final int order;
    private final boolean isScientific;
    private List<Point2D> dataSet = new ArrayList<Point2D>();

    public MovingAverageEngine(int order, boolean isScientific) {
        this.order = order;
        this.isScientific = isScientific;
    }

    @Override
    public void processDataValues(List<Point2D> data) {
        assert (this.dataSet.isEmpty());
        for (Point2D pt : data) {
            if (pt == null) continue;
            this.dataSet.add(pt);
        }
        if (this.dataSet.size() > this.order) {
            this.isValid = true;
        }
    }

    @Override
    public List<Point> generateCurve(int seriesId, IDataProcessor dataProcessor) {
        if (!this.isValid) {
            return Collections.EMPTY_LIST;
        }
        return this.generateSMA(seriesId, dataProcessor);
    }

    private List<Point> generateSMA(int seriesId, IDataProcessor dataProcessor) {
        ArrayList<Point> vcPts = new ArrayList<Point>();
        double sumY = 0.0;
        double sumX = 0.0;
        for (int i = 0; i < this.order; ++i) {
            sumX += this.dataSet.get(i).getX();
            sumY += this.dataSet.get(i).getY();
        }
        double movingAvgX = sumX / (double)this.order;
        double movingAvgY = sumY / (double)this.order;
        if (this.isScientific) {
            movingAvgX = this.getMaxX(0);
        }
        int x1 = dataProcessor.getXAxisCoord(seriesId, movingAvgX);
        int y1 = dataProcessor.getYAxisCoord(seriesId, movingAvgY);
        vcPts.add(new Point(x1, y1));
        for (int i = this.order; i < this.dataSet.size(); ++i) {
            if (this.isScientific) {
                movingAvgX = this.getMaxX(i - this.order + 1);
            } else {
                movingAvgX -= this.dataSet.get(i - this.order).getX() / (double)this.order;
                movingAvgX += this.dataSet.get(i).getX() / (double)this.order;
            }
            movingAvgY -= this.dataSet.get(i - this.order).getY() / (double)this.order;
            int x = dataProcessor.getXAxisCoord(seriesId, movingAvgX);
            int y = dataProcessor.getYAxisCoord(seriesId, movingAvgY += this.dataSet.get(i).getY() / (double)this.order);
            vcPts.add(new Point(x, y));
        }
        return vcPts;
    }

    private double getMaxX(int startIndex) {
        double maxX = Double.MIN_VALUE;
        for (int i = startIndex; i < startIndex + this.order; ++i) {
            double x = this.dataSet.get(i).getX();
            if (!(x > maxX)) continue;
            maxX = x;
        }
        return maxX;
    }

    @Override
    public void setSmoothingFactor(int smoothFactor) {
    }

    @Override
    public String getCorrelationText(Format format) {
        return "";
    }

    @Override
    public String getEquationText(Format format) {
        return "";
    }
}

