/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.PerspectiveBase;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DatumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillGradientObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D_Surf;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_Base;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IOrdinalAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.IModel3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Matrix3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Matrix4d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DCubeWall;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DCutCorner;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DModRectSolid;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DOctagonSolid;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DRectPyramid;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DRectSolid;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DRibbonGroupSolid;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DRibbonSeriesSolid;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.model3d.Model3DCone;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.model3d.Model3DSphere;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceUtilities;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JChart_3D
extends JChart_Base {
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_Z = 2;
    public static final int CHANGED_ALL = 0;
    public static final int CHANGED_COLOR = 1;
    public static final int CHANGED_CUBE = 2;
    public static final int CHANGED_GRID = 3;
    public static final int CHANGED_RISER = 4;
    public static final int CHANGED_SCALE = 5;
    public static final int CHANGED_VIEW = 6;
    public static final double LIGHTSOURCE_FACTOR = 0.01;
    public static final int LIGHTSOURCE_OFFSET = 0;
    public static final int SIZE_FACTOR = 200;
    public static final int SIZE_OFFSET = 2000;
    public static final int WALL_FACTOR = 20;
    public static final int WALL_OFFSET = 0;
    public static final int TRANS_FACTOR = 200;
    public static final int TRANS_OFFSET = -10000;
    public static final int VIEW_XY_FACTOR = 100;
    public static final int VIEW_XY_OFFSET = -5000;
    public static final int VIEW_Z_FACTOR = 500;
    public static final int VIEW_Z_OFFSET = 0;
    public static final int PAN_FACTOR = 300;
    public static final int PAN_OFFSET = -15000;
    public static final double ZOOM_BASE = 1.028113827;
    public static final double ZOOM_MULT = 0.25;
    public static final double ZOOM_MIN = 0.25;
    public static final double ZOOM_MAX = 4.0;
    public static final double FOCUS_BASE = 1.011778466;
    public static final double FOCUS_MULT = 0.556837407;
    public static final int INTERP_LARGE_DATASETS = 0;
    public static final int INTERP_ISOMETRIC = 1;
    public static final int INTERP_NEVER = 2;
    static final int WIREPOINTS = 17;
    static final int CONNECTIONS = 21;
    static final int[][] m_Connect = new int[][]{{0, 1}, {0, 2}, {0, 3}, {7, 3}, {1, 7}, {1, 8}, {3, 9}, {9, 2}, {2, 8}, {10, 11}, {11, 12}, {12, 13}, {13, 10}, {10, 14}, {11, 15}, {13, 16}, {14, 15}, {16, 14}, {9, 16}, {15, 8}, {12, 7}};
    Point3d[] m_wirePts3D;
    Point[] m_wirePts2D;
    boolean m_bAlreadyDrawn;
    protected boolean m_bSafeAngle;
    protected boolean m_bCanUseSimpleVis;
    protected boolean m_bColorAutoshading;
    protected boolean m_bColorAutoshadingWalls;
    public double m_fColorLightSourceX;
    public double m_fColorLightSourceY;
    public double m_fColorLightSourceZ;
    public Point3d m_ColorLightVersor;
    protected boolean m_bCubeDisplay3DFloor;
    protected boolean m_bCubeDisplay3DLeftWall;
    protected boolean m_bCubeDisplay3DRightWall;
    protected double m_fCubeSizeX;
    protected double m_fCubeSizeY;
    protected double m_fCubeSizeZ;
    protected double m_fCubeWallThickX;
    protected double m_fCubeWallThickY;
    protected double m_fCubeWallThickZ;
    protected double m_fHalfCubeX;
    protected double m_fHalfCubeY;
    protected double m_fHalfCubeZ;
    protected boolean m_bGrid3DFloorDisplayX;
    protected boolean m_bGrid3DFloorDisplayZ;
    protected boolean m_bGrid3DLeftWallDisplayY;
    protected boolean m_bGrid3DLeftWallDisplayZ;
    protected boolean m_bGrid3DRightWallDisplayX;
    protected boolean m_bGrid3DRightWallDisplayY;
    protected boolean m_bGrid3DRiserDisplayX;
    protected boolean m_bGrid3DRiserDisplayY;
    protected boolean m_bGrid3DRiserDisplayZ;
    protected int m_nRiser3DThicknessY;
    protected boolean m_bRiserScaleFromZero;
    protected boolean m_bRiserSquareRisers;
    protected boolean m_bDataTextDisplay = true;
    protected boolean m_bScaleY1AxisAscending;
    protected boolean m_bScaleMustIncludeZero;
    protected boolean m_bScaleO1LabelDisplay;
    protected boolean m_bScaleO2LabelDisplay;
    protected boolean m_bScaleY1LabelDisplay;
    protected boolean m_bY1LogScale;
    protected double m_fViewTranslationX;
    protected double m_fViewTranslationY;
    protected double m_fViewTranslationZ;
    protected double m_fViewPanX;
    protected double m_fViewPanY;
    protected double m_fViewZoomFactor;
    protected double m_fViewViewerX;
    protected double m_fViewViewerY;
    protected double m_fViewViewerZ;
    protected boolean m_bViewRawViewerZ;
    protected boolean m_bViewForceIsometric;
    protected Matrix3d m_rotationMatrix;
    IOrdinalAxis m_O1Axis;
    IOrdinalAxis m_O2Axis;
    INumericAxis m_Y1Axis;
    protected List<IModel3D> m_objectList;
    protected Model3DCubeWall m_Floor;
    protected Model3DCubeWall m_LWall;
    protected Model3DCubeWall m_RWall;
    protected Model3DRectSolid m_wholeCube;
    protected Matrix4d m_matrix = new Matrix4d();
    protected int[][] m_numYCoords;
    protected boolean[][] m_dataOK;
    protected double[][] m_rawValues;
    protected String[][] m_DataLabel;
    private FillGradientObj m_fillGradientObj = null;
    public static final IChartEngineFactory engineFactory = new IChartEngineFactory(){

        public IChartEngine createChartEngine(Perspective perspective) {
            return new JChart_3D(perspective);
        }
    };

    JChart_3D(Perspective perspective) {
        this(perspective, 0.0, 0.0, 0.0);
    }

    JChart_3D(Perspective perspective, double x, double y, double z) {
        super(perspective);
        this.m_fViewViewerX = x;
        this.m_fViewViewerY = y;
        this.m_fViewViewerZ = z;
    }

    public final FillGradientObj getFillGradientObj() {
        Perspective pers = this.getPerspective();
        BlackBoxObj bb = new BlackBoxObj(pers, Identity.ColorByHeight);
        this.m_fillGradientObj = bb.getFillGradientObj();
        if (this.m_fillGradientObj == null) {
            System.out.println("WARNING: hardcoded  static instance of FfillGradientObject");
            this.m_fillGradientObj = FillGradientObj.getInstance();
        }
        return this.m_fillGradientObj;
    }

    protected boolean isInvertedForNegativeValue() {
        return false;
    }

    @Override
    public void calc() {
        int AxisLabelCalcPhase = 0;
        int saveMode = 0;
        super.calc();
        this.createMatrix();
        this.createAxes3D();
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.calc();
        }
        if (this.m_O1Axis != null) {
            this.m_O1Axis.calc();
        }
        if (this.m_O2Axis != null) {
            this.m_O2Axis.calc();
        }
        this.calcDataAbsolute();
        this.defineCube();
        this.setDrawOrder();
        if (this.m_bSafeAngle) {
            if (this.m_Perspective.getPDECalc()) {
                this.m_Floor.saveProjectedPoints();
                this.m_LWall.saveProjectedPoints();
                this.m_RWall.saveProjectedPoints();
            } else {
                this.m_Floor.preDisplay();
                this.m_LWall.preDisplay();
                this.m_RWall.preDisplay();
            }
            this.define3DMatrixObjects();
            if (this.m_Perspective.getPDECalc()) {
                this.m_Floor.saveProjectedPoints();
                this.m_LWall.saveProjectedPoints();
                this.m_RWall.saveProjectedPoints();
            } else {
                this.m_RWall.postDisplay();
                this.m_LWall.postDisplay();
                this.m_Floor.postDisplay();
            }
        } else {
            this.define3DMatrixObjects();
            this.sort3DObjects();
            this.displayAll3DObjects();
        }
        this.calculateAxisTitlePosition();
        while (true) {
            if (AxisLabelCalcPhase < 1) {
                this.m_Perspective.setMinimumAxisTextSizeVC(16000);
                saveMode = this.m_Perspective.getAxisTextAutofitMode();
                this.m_Perspective.setAxisTextAutofitMode(0);
                if (saveMode != 0) {
                    this.m_Perspective.setTestLabelCalc(true);
                } else {
                    this.m_Perspective.setTestLabelCalc(false);
                }
            }
            if (this.m_O1Axis != null && this.m_bScaleO1LabelDisplay) {
                this.m_O1Axis.calcLabels();
                if (AxisLabelCalcPhase < 1 && this.m_O1Axis.getAxisTextLabelSizeVC() < this.m_Perspective.getMinimumAxisTextSizeVC()) {
                    this.m_Perspective.setMinimumAxisTextSizeVC(this.m_O1Axis.getAxisTextLabelSizeVC());
                }
            }
            if (this.m_O2Axis != null && this.m_bScaleO2LabelDisplay) {
                this.m_O2Axis.calcLabels();
                if (AxisLabelCalcPhase < 1 && this.m_O2Axis.getAxisTextLabelSizeVC() < this.m_Perspective.getMinimumAxisTextSizeVC()) {
                    this.m_Perspective.setMinimumAxisTextSizeVC(this.m_O2Axis.getAxisTextLabelSizeVC());
                }
            }
            if (this.m_Y1Axis != null && this.m_bScaleY1LabelDisplay) {
                this.m_Y1Axis.calcLabels();
                if (AxisLabelCalcPhase < 1 && this.m_Y1Axis.getAxisTextLabelSizeVC() < this.m_Perspective.getMinimumAxisTextSizeVC()) {
                    this.m_Perspective.setMinimumAxisTextSizeVC(this.m_Y1Axis.getAxisTextLabelSizeVC());
                }
            }
            if (AxisLabelCalcPhase < 1) {
                this.m_Perspective.setAxisTextAutofitMode(saveMode);
                this.m_Perspective.setTestLabelCalc(false);
            }
            if (this.m_Perspective.getAxisTextAutofitMode() == 0 || AxisLabelCalcPhase == 1) break;
            ++AxisLabelCalcPhase;
        }
        if (this.m_O1Axis != null) {
            this.m_O1Axis.calcGrids();
        }
        if (this.m_O2Axis != null) {
            this.m_O2Axis.calcGrids();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.calcGrids();
        }
    }

    protected void calcDataAbsolute() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        INumericAxis axisObj = this.m_Y1Axis;
        double fValue = 0.0;
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_rawValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            gEnum.reset();
            while (gEnum.hasNext()) {
                int g = gEnum.next();
                this.m_dataOK[s][g] = true;
                DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                fValue = dObj.value;
                if (!dObj.m_bOK) {
                    this.m_dataOK[s][g] = false;
                }
                if (this.m_bY1LogScale && fValue <= 0.0) {
                    this.m_dataOK[s][g] = false;
                    fValue = 0.0;
                }
                if (this.isIgnoredOffScale(axisObj, fValue)) {
                    this.m_dataOK[s][g] = false;
                    fValue = 0.0;
                }
                this.m_rawValues[s][g] = fValue;
                this.m_numYCoords[s][g] = (int)axisObj.getValueCoord(fValue);
                if (!this.m_bDataTextDisplay) continue;
                this.m_DataLabel[s][g] = axisObj.getDataTextFormat().format(fValue);
            }
        }
    }

    @Override
    public void copyParams() {
        super.copyParams();
        this.copyColorParams();
        this.copyCubeParams();
        this.copyGridParams();
        this.copyRiserParams();
        this.copyScaleParams();
        this.copyViewParams();
    }

    public void copyColorParams() {
        this.m_bColorAutoshading = this.m_Perspective.getAutoshading();
        this.m_bColorAutoshadingWalls = this.m_Perspective.getAutoshadingWalls();
        this.m_fColorLightSourceX = this.denormalize(this.m_Perspective.getCubeLightSourceX(), 0.0, 100.0, 0.01, 0.0);
        this.m_fColorLightSourceY = this.denormalize(this.m_Perspective.getCubeLightSourceY(), 0.0, 100.0, 0.01, 0.0);
        this.m_fColorLightSourceZ = this.denormalize(this.m_Perspective.getCubeLightSourceZ(), 0.0, 100.0, 0.01, 0.0);
        this.m_ColorLightVersor = new Point3d(this.m_fColorLightSourceX, this.m_fColorLightSourceY, this.m_fColorLightSourceZ);
        this.m_ColorLightVersor.normalize();
    }

    public void copyCubeParams() {
        this.m_bCubeDisplay3DFloor = this.m_Perspective.getDisplay3DFloor();
        this.m_bCubeDisplay3DLeftWall = this.m_Perspective.getDisplay3DLeftWall();
        this.m_bCubeDisplay3DRightWall = this.m_Perspective.getDisplay3DRightWall();
        this.m_fCubeWallThickX = this.m_Perspective.getCubeWallThickX();
        this.m_fCubeWallThickY = this.m_Perspective.getCubeWallThickY();
        this.m_fCubeWallThickZ = this.m_Perspective.getCubeWallThickZ();
        this.m_fCubeSizeX = this.m_Perspective.getCubeSizeX();
        this.m_fCubeSizeY = this.m_Perspective.getCubeSizeY();
        this.m_fCubeSizeZ = this.m_Perspective.getCubeSizeZ();
        this.setHalfCube();
    }

    private void setHalfCube() {
        this.m_fHalfCubeX = this.m_fCubeSizeX / 2.0;
        this.m_fHalfCubeY = this.m_fCubeSizeY / 2.0;
        this.m_fHalfCubeZ = this.m_fCubeSizeZ / 2.0;
    }

    public void copyGridParams() {
        this.m_bGrid3DFloorDisplayX = this.m_Perspective.getGrid3DFloorDisplayX();
        this.m_bGrid3DFloorDisplayZ = this.m_Perspective.getGrid3DFloorDisplayZ();
        this.m_bGrid3DLeftWallDisplayY = this.m_Perspective.getGrid3DLeftWallDisplayY();
        this.m_bGrid3DLeftWallDisplayZ = this.m_Perspective.getGrid3DLeftWallDisplayZ();
        this.m_bGrid3DRightWallDisplayX = this.m_Perspective.getGrid3DRightWallDisplayX();
        this.m_bGrid3DRightWallDisplayY = this.m_Perspective.getGrid3DRightWallDisplayY();
        this.m_bGrid3DRiserDisplayX = this.m_Perspective.getGrid3DRiserDisplayX();
        this.m_bGrid3DRiserDisplayY = this.m_Perspective.getGrid3DRiserDisplayY();
        this.m_bGrid3DRiserDisplayZ = this.m_Perspective.getGrid3DRiserDisplayZ();
    }

    public void copyRiserParams() {
        this.m_nRiser3DThicknessY = this.m_Perspective.getRiser3DThicknessY();
        this.m_bRiserScaleFromZero = this.m_Perspective.getScaleFromZero() && (this.m_gt.is3DRiser() || this.m_gt.is3DSurface() || this.m_gt.equals(5));
        this.m_bRiserSquareRisers = this.m_Perspective.getCubeSquareRisers() && (this.m_gt.is3DFloating() || this.m_gt.is3DRiser());
    }

    public void copyScaleParams() {
        this.m_bScaleY1AxisAscending = true;
        this.m_bScaleMustIncludeZero = this.m_Perspective.getY1MustIncludeZero();
        this.m_bScaleO1LabelDisplay = this.m_Perspective.getO1LabelDisplay();
        this.m_bScaleO2LabelDisplay = this.m_Perspective.getO2LabelDisplay();
        this.m_bScaleY1LabelDisplay = this.m_Perspective.getY1LabelDisplay();
        this.m_bY1LogScale = this.m_Perspective.getY1LogScale();
    }

    public void copyViewParams() {
        this.m_fViewTranslationX = this.m_Perspective.getCubeTranslationX();
        this.m_fViewTranslationY = this.m_Perspective.getCubeTranslationY();
        this.m_fViewTranslationZ = this.m_Perspective.getCubeTranslationZ();
        this.m_fViewViewerX = this.m_Perspective.getCubeViewerX();
        this.m_fViewViewerY = this.m_Perspective.getCubeViewerY();
        this.m_fViewViewerZ = this.m_Perspective.getCubeViewerZ();
        this.m_bViewRawViewerZ = true;
        this.m_fViewPanX = this.m_Perspective.getCubePanX();
        this.m_fViewPanY = this.m_Perspective.getCubePanY();
        this.m_fViewZoomFactor = this.m_Perspective.getCubeZoomFactor();
        this.m_bViewForceIsometric = this.m_Perspective.getCubeIsometricProjection();
        this.m_rotationMatrix = this.m_Perspective.getCubeRotationMatrix();
    }

    private void createAxes3D() {
        int orient = 2;
        int scaling = 1;
        int offsetY1 = 0;
        int sizeY1 = 100;
        boolean bAscending = !this.m_gt.is3DSurface();
        this.m_O1Axis = AxisFactory.create3DOrdinalAxis(this, this.m_Perspective, this.getDataView(), AxisTemplate.O1_AXIS, this.m_gt.is3DConnectSeries() ? 5 : 7, orient, bAscending, (int)this.m_fCubeWallThickZ, (int)(this.m_fCubeSizeZ - this.m_fCubeWallThickZ));
        this.m_O2Axis = AxisFactory.create3DOrdinalAxis(this, this.m_Perspective, this.getDataView(), AxisTemplate.O2_AXIS, this.m_gt.is3DConnectGroups() ? 4 : 8, orient, true, (int)this.m_fCubeWallThickX, (int)(this.m_fCubeSizeX - this.m_fCubeWallThickX));
        MinMaxObj y1MinMaxObj = this.findLimits(0, scaling, this.m_bScaleMustIncludeZero);
        this.m_Y1Axis = AxisFactory.create3DNumericAxis(this, this.m_Perspective, this.getDataView(), AxisTemplate.Y1_AXIS, y1MinMaxObj, orient, this.m_bScaleY1AxisAscending, offsetY1, sizeY1, (int)this.m_fCubeWallThickY, (int)(this.m_fCubeSizeY - this.m_fCubeWallThickY));
    }

    public void createMatrix() {
        this.m_matrix = new Matrix4d();
        this.m_matrix.rotate(this.m_rotationMatrix);
        this.m_matrix.translate(this.m_fViewTranslationX, this.m_fViewTranslationY, this.m_fViewTranslationZ);
    }

    public void defineCube() {
        Point3d origin = new Point3d(0.0, 0.0, 0.0);
        Point3d size = new Point3d(this.m_fCubeSizeX, this.m_fCubeSizeY, this.m_fCubeSizeZ);
        boolean[][] bGridStatus = new boolean[2][3];
        bGridStatus[0][0] = false;
        bGridStatus[0][1] = false;
        bGridStatus[0][2] = false;
        if (this.m_bViewRawViewerZ) {
            double fMinZ = this.getMinCubeViewerZ();
            if (Math.abs(this.m_fViewViewerZ) < fMinZ) {
                this.m_fViewViewerZ = this.m_fViewViewerZ != 0.0 ? Math.signum(this.m_fViewViewerZ) * fMinZ : fMinZ;
            }
            this.m_bViewRawViewerZ = false;
        }
        IdentObj id = new IdentObj(-3);
        bGridStatus[1][0] = false;
        bGridStatus[1][1] = false;
        bGridStatus[1][2] = false;
        this.m_wholeCube = new Model3DRectSolid(this, id, null, origin, size, bGridStatus, false, false);
        this.m_bSafeAngle = this.m_gt.is3DSurface() ? false : this.m_wholeCube.visibility(0) != null && this.m_wholeCube.visibility(2) != null && this.m_wholeCube.visibility(4) != null;
        this.m_bCanUseSimpleVis = this.m_bSafeAngle && !this.m_bColorAutoshadeRisers;
        size.y = this.m_fCubeWallThickY;
        id = new IdentObj(1002);
        bGridStatus[1][0] = this.m_bGrid3DFloorDisplayX;
        bGridStatus[1][1] = false;
        bGridStatus[1][2] = this.m_bGrid3DFloorDisplayZ;
        this.m_Floor = new Model3DCubeWall(this, id, null, origin, size, bGridStatus, this.m_bColorAutoshadingWalls);
        this.m_Floor.calcGrids();
        origin.y = this.m_fCubeWallThickY;
        size.x = this.m_fCubeWallThickX;
        size.y = this.m_fCubeSizeY - this.m_fCubeWallThickY;
        id = new IdentObj(1003);
        bGridStatus[1][0] = false;
        bGridStatus[1][1] = this.m_bGrid3DLeftWallDisplayY;
        bGridStatus[1][2] = this.m_bGrid3DLeftWallDisplayZ;
        this.m_LWall = new Model3DCubeWall(this, id, null, origin, size, bGridStatus, this.m_bColorAutoshadingWalls);
        this.m_LWall.calcGrids();
        origin.x = this.m_fCubeWallThickX;
        size.x = this.m_fCubeSizeX - this.m_fCubeWallThickX;
        size.z = this.m_fCubeWallThickZ;
        id = new IdentObj(1004);
        bGridStatus[1][0] = this.m_bGrid3DRightWallDisplayX;
        bGridStatus[1][1] = this.m_bGrid3DRightWallDisplayY;
        bGridStatus[1][2] = false;
        this.m_RWall = new Model3DCubeWall(this, id, null, origin, size, bGridStatus, this.m_bColorAutoshadingWalls);
        this.m_RWall.calcGrids();
    }

    public void define3DMatrixObjects() {
        double minSize;
        double sizeZ;
        double sizeX;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator(false);
        Point3d origin = new Point3d();
        Point3d size = new Point3d();
        this.m_objectList = new ArrayList<IModel3D>(this.m_nSeries * this.m_nGroups);
        origin.y = this.getOriginYCoord();
        boolean[][] bGridStatus = new boolean[2][3];
        bGridStatus[0][0] = false;
        bGridStatus[0][1] = false;
        bGridStatus[0][2] = false;
        bGridStatus[1][0] = this.m_bGrid3DRiserDisplayX;
        bGridStatus[1][1] = this.m_bGrid3DRiserDisplayY;
        bGridStatus[1][2] = this.m_bGrid3DRiserDisplayZ;
        double oldsizeX = sizeX = this.m_O2Axis.getHighCoord(0, 0) - this.m_O2Axis.getLowCoord(0, 0);
        double oldsizeZ = sizeZ = this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0);
        double d = minSize = sizeX < sizeZ ? sizeX : sizeZ;
        if (this.m_bRiserSquareRisers) {
            sizeX = sizeZ = minSize;
        }
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            int sRel = sEnum.getRelative(s);
            assert (sRel >= 0 && sRel < this.m_nSeries);
            origin.x = this.m_O2Axis.getLowCoord(0, sRel);
            size.x = sizeX;
            if (this.m_bRiserSquareRisers && oldsizeX != minSize) {
                origin.x += (oldsizeX - minSize) / 2.0;
            }
            gEnum.reset();
            while (gEnum.hasNext()) {
                int g = gEnum.next();
                int gRel = gEnum.getRelative(g);
                if (!this.m_dataOK[s][g]) continue;
                origin.z = this.m_O1Axis.getLowCoord(0, gRel);
                size.z = sizeZ;
                if (this.m_bRiserSquareRisers && oldsizeZ != minSize) {
                    origin.z += (oldsizeZ - minSize) / 2.0;
                }
                size.y = (double)this.m_numYCoords[s][g] - origin.y;
                IdentObj id = new IdentObj(1005, s, g);
                if (this.m_Perspective.getPDECalc()) continue;
                IBlackBox bb = this.getMissingDataBlackBox(s, g);
                if (bb == null) {
                    bb = this.assignSeriesColor(s, g);
                }
                this.defineRiserObject(sEnum, gEnum, id, bb, origin, size, bGridStatus);
            }
        }
    }

    protected double getOriginYCoord() {
        if (this.m_bRiserScaleFromZero) {
            return this.m_Y1Axis.getValueCoord(0.0);
        }
        return this.m_Y1Axis.getBaseCoord();
    }

    public final IModel3D defineRiserObject(SeriesEnumerator sEnum, GroupsEnumerator gEnum, IdentObj id, IBlackBox bb, Point3d origin, Point3d size, boolean[][] bGridStatus) {
        IModel3D m = null;
        Point3d modOrigin = new Point3d(origin);
        Point3d modSize = new Point3d(size);
        double cubeThick = 0.0;
        boolean bInverted = false;
        boolean isRaisedOrigin = this.m_gt.is3DRaisedOrigin(this.m_Perspective.getSeriesType(id.getSeriesID()));
        boolean isConnectedGroup = this.m_gt.is3DConnectGroups();
        if (isRaisedOrigin) {
            double oldOrigin = modOrigin.y;
            cubeThick = this.m_gt.is3DConnectSeries() ? modSize.x * (double)this.m_nRiser3DThicknessY / 100.0 : (isConnectedGroup ? modSize.z * (double)this.m_nRiser3DThicknessY / 100.0 : Math.max(modSize.x, modSize.z) * (double)this.m_nRiser3DThicknessY / 100.0);
            if (this.m_gt.is3DFloating()) {
                modOrigin.y = bInverted ? (modOrigin.y -= cubeThick / 2.0) : modOrigin.y + modSize.y - cubeThick / 2.0;
                modSize.y = cubeThick;
                if (modOrigin.y < this.m_fCubeWallThickY) {
                    modSize.y -= this.m_fCubeWallThickY - modOrigin.y;
                    modOrigin.y = this.m_fCubeWallThickY;
                }
            } else {
                modOrigin.y = modOrigin.y + modSize.y - cubeThick;
                if (modOrigin.y < this.m_fCubeWallThickY && !this.m_gt.is3DRibbonType()) {
                    modOrigin.y = this.m_fCubeWallThickY;
                }
                modSize.y = modSize.y + oldOrigin - modOrigin.y;
            }
        }
        if (!this.isInvertedForNegativeValue() && modSize.y < 0.0) {
            bInverted = true;
            modOrigin.y += modSize.y;
            modSize.y = -modSize.y;
        }
        if ((m = this.defineRiserObject(bInverted, sEnum, gEnum, id, bb, modOrigin, modSize, bGridStatus)) != null) {
            m.calcGrids();
            this.display(m);
            if (this.m_bDataTextDisplay) {
                ITextStyle textStyle = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, Identity.DataText);
                this.drawDataValue(m.getIdentObj().getSeriesID(), m.getIdentObj().getGroupID(), textStyle);
            }
        }
        return m;
    }

    protected void display(IModel3D m) {
        if (m != null) {
            this.m_objectList.add(m);
            if (this.m_bSafeAngle) {
                m.display();
            }
        }
    }

    protected IModel3D defineRiserObject(boolean bInverted, SeriesEnumerator sEnum, GroupsEnumerator gEnum, IdentObj id, IBlackBox bb, Point3d modOrigin, Point3d modSize, boolean[][] bGridStatus) {
        boolean isDefaultRiserType;
        IModel3D m = null;
        int s = id.getSeriesID();
        int g = id.getGroupID();
        double f0 = this.m_numYCoords[s][g];
        double f1 = 0.0;
        int riserType = this.m_Perspective.getSeriesType(s);
        boolean bl = isDefaultRiserType = riserType == PerspectiveBase.RiserType3D.Default.ordinal();
        if (this.m_gt.equals(3) && isDefaultRiserType || riserType == PerspectiveBase.RiserType3D.Cylinder.ordinal()) {
            m = new Model3DCone(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis, true);
        } else if (this.m_gt.equals(8) && isDefaultRiserType || riserType == PerspectiveBase.RiserType3D.Cone.ordinal()) {
            m = new Model3DCone(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis, false);
        } else if (this.m_gt.equals(11) && isDefaultRiserType || riserType == PerspectiveBase.RiserType3D.Sphere.ordinal()) {
            m = new Model3DSphere(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        } else if (this.m_gt.equals(0) && isDefaultRiserType || riserType == PerspectiveBase.RiserType3D.Bar3D.ordinal()) {
            m = new Model3DRectSolid(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        } else if (this.m_gt.equals(1) && isDefaultRiserType || riserType == PerspectiveBase.RiserType3D.Pyramid.ordinal()) {
            m = new Model3DRectPyramid(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers, bInverted);
        } else if (this.m_gt.equals(2) && isDefaultRiserType || riserType == PerspectiveBase.RiserType3D.Octagon.ordinal()) {
            m = new Model3DOctagonSolid(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers);
        } else if (this.m_gt.equals(4) && isDefaultRiserType || riserType == PerspectiveBase.RiserType3D.Cube.ordinal()) {
            m = new Model3DRectSolid(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        } else if (this.m_gt.equals(5) && isDefaultRiserType || riserType == PerspectiveBase.RiserType3D.Diamond.ordinal()) {
            m = new Model3DRectPyramid(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers, bInverted);
        } else if (this.m_gt.equals(131) && isDefaultRiserType || riserType == PerspectiveBase.RiserType3D.CutCorner.ordinal()) {
            m = new Model3DCutCorner(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers);
        } else if (this.m_gt.equals(6) && isDefaultRiserType || riserType == PerspectiveBase.RiserType3D.RowArea.ordinal()) {
            int gNext;
            if (gEnum.hasNext() && this.m_dataOK[s][gNext = gEnum.peekNext()] && (!this.m_bCubeDisplay3DFloor || f0 >= this.m_fCubeWallThickY || (double)this.m_numYCoords[s][gNext] >= this.m_fCubeWallThickY)) {
                Point3d size = new Point3d(modSize);
                Point3d origin = new Point3d(modOrigin);
                size.z = this.m_O1Axis.getHighCoord(s, g) - this.m_O1Axis.getHighCoord(s, gNext);
                origin.z = modOrigin.z + modSize.z / 2.0;
                m = new Model3DModRectSolid(this, id, bb, origin, size, bGridStatus, this.m_bColorAutoshadeRisers);
                double newTop = this.m_numYCoords[s][gNext];
                boolean bDescendingO1 = this.m_O1Axis.isDescending();
                if (bDescendingO1) {
                    ((Model3DModRectSolid)m).modBackFace(newTop, origin.y, this.m_bCubeDisplay3DFloor, this.m_fCubeWallThickY);
                } else {
                    ((Model3DModRectSolid)m).modFrontFace(newTop, origin.y, this.m_bCubeDisplay3DFloor, this.m_fCubeWallThickY);
                }
            }
        } else if (this.m_gt.equals(7) && isDefaultRiserType || riserType == PerspectiveBase.RiserType3D.RowLine.ordinal()) {
            if (gEnum.hasNext()) {
                int gNext = gEnum.peekNext();
                if (gNext == -1 || !this.m_dataOK[s][gNext]) {
                    return null;
                }
                f1 = f0;
                f0 = this.m_numYCoords[s][gNext];
                Point3d size = new Point3d(modSize);
                Point3d origin = new Point3d(modOrigin);
                size.z = this.m_O1Axis.getHighCoord(s, g) - this.m_O1Axis.getHighCoord(s, gNext);
                origin.z = modOrigin.z + modSize.z / 2.0;
                size.y = Math.min(modSize.z, modSize.x);
                f0 += size.y;
                f1 += size.y;
                if (!this.m_bCubeDisplay3DFloor || f0 >= this.m_fCubeWallThickY || f1 >= this.m_fCubeWallThickY) {
                    double z4;
                    double y4;
                    double z8;
                    double z6;
                    double y8;
                    double y6;
                    double z2;
                    double z0;
                    double y2;
                    double y0;
                    int nClipFront;
                    int nClipBack;
                    if (!this.m_bCubeDisplay3DFloor) {
                        nClipBack = 0;
                        nClipFront = 0;
                    } else {
                        nClipFront = f0 - size.y >= this.m_fCubeWallThickY ? 0 : (f0 >= this.m_fCubeWallThickY ? 1 : 2);
                        nClipBack = f1 - size.y >= this.m_fCubeWallThickY ? 0 : (f1 >= this.m_fCubeWallThickY ? 1 : 2);
                    }
                    if (nClipFront == 0) {
                        y0 = f0 - size.y;
                        y2 = f0;
                        z0 = 1.0;
                        z2 = 1.0;
                    } else if (nClipFront == 1) {
                        y0 = this.m_fCubeWallThickY;
                        y2 = f0;
                        z0 = 1.0;
                        z2 = 1.0;
                    } else if (nClipFront == 2) {
                        y0 = this.m_fCubeWallThickY;
                        y2 = this.m_fCubeWallThickY;
                        z2 = (f1 - this.m_fCubeWallThickY) / (f1 - f0);
                        z0 = nClipBack == 0 ? (f1 - size.y - this.m_fCubeWallThickY) / (f1 - f0) : z2;
                    } else {
                        throw new RuntimeException("oops, unknown nClipFront = " + nClipFront);
                    }
                    if (nClipBack == 0) {
                        y6 = f1 - size.y;
                        y8 = f1;
                        z6 = 0.0;
                        z8 = 0.0;
                    } else if (nClipBack == 1) {
                        y6 = this.m_fCubeWallThickY;
                        y8 = f1;
                        z6 = 0.0;
                        z8 = 0.0;
                    } else if (nClipBack == 2) {
                        y6 = this.m_fCubeWallThickY;
                        y8 = this.m_fCubeWallThickY;
                        z8 = (this.m_fCubeWallThickY - f1) / (f0 - f1);
                        z6 = nClipFront == 0 ? (this.m_fCubeWallThickY - (f1 - size.y)) / (f0 - f1) : z8;
                    } else {
                        throw new RuntimeException("oops, unknown nClipBack = " + nClipBack);
                    }
                    if (nClipFront == 0 && nClipBack == 1) {
                        y4 = this.m_fCubeWallThickY;
                        z4 = (this.m_fCubeWallThickY - (f1 - size.y)) / (f0 - f1);
                    } else if (nClipFront == 1 && nClipBack == 0) {
                        y4 = this.m_fCubeWallThickY;
                        z4 = (f1 - size.y - this.m_fCubeWallThickY) / (f1 - f0);
                    } else {
                        y4 = y6;
                        z4 = z6;
                    }
                    Point3d[] pts = new Point3d[]{new Point3d(origin.x, y0, origin.z + z0 * size.z), new Point3d(origin.x + size.x, y0, origin.z + z0 * size.z), new Point3d(origin.x, y2, origin.z + z2 * size.z), new Point3d(origin.x + size.x, y2, origin.z + z2 * size.z), new Point3d(origin.x, y4, origin.z + z4 * size.z), new Point3d(origin.x + size.x, y4, origin.z + z4 * size.z), new Point3d(origin.x, y6, origin.z + z6 * size.z), new Point3d(origin.x + size.x, y6, origin.z + z6 * size.z), new Point3d(origin.x, y8, origin.z + z8 * size.z), new Point3d(origin.x + size.x, y8, origin.z + z8 * size.z)};
                    m = new Model3DRibbonSeriesSolid(this, id, bb, origin, size, pts, bGridStatus, this.m_bColorAutoshadeRisers);
                }
            }
        } else if (this.m_gt.equals(9) && isDefaultRiserType || riserType == PerspectiveBase.RiserType3D.ColumnArea.ordinal()) {
            int sNext;
            if (sEnum.hasNext() && this.m_dataOK[sNext = sEnum.peekNext()][g] && (!this.m_bCubeDisplay3DFloor || f0 >= this.m_fCubeWallThickY || (double)this.m_numYCoords[sNext][g] >= this.m_fCubeWallThickY)) {
                Point3d size = new Point3d(modSize);
                Point3d origin = new Point3d(modOrigin);
                size.x = this.m_O2Axis.getHighCoord(s, g) - this.m_O2Axis.getHighCoord(sNext, g);
                origin.x = modOrigin.x + modSize.x / 2.0;
                m = new Model3DModRectSolid(this, id, bb, origin, size, bGridStatus, this.m_bColorAutoshadeRisers);
                double newTop = this.m_numYCoords[sNext][g];
                ((Model3DModRectSolid)m).modRightFace(newTop, origin.y, this.m_bCubeDisplay3DFloor, this.m_fCubeWallThickY);
            }
        } else if ((this.m_gt.equals(10) && isDefaultRiserType || riserType == PerspectiveBase.RiserType3D.ColumnLine.ordinal()) && sEnum.hasNext()) {
            int sNext = sEnum.peekNext();
            if (sNext == -1 || !this.m_dataOK[sNext][g]) {
                return null;
            }
            f1 = this.m_numYCoords[sNext][g];
            Point3d size = new Point3d(modSize);
            Point3d origin = new Point3d(modOrigin);
            size.x = this.m_O1Axis.getHighCoord(s, g) - this.m_O1Axis.getHighCoord(sNext, g);
            origin.x = modOrigin.x + modSize.x / 2.0;
            size.y = Math.min(modSize.z, modSize.x);
            f0 += size.y;
            f1 += size.y;
            if (!this.m_bCubeDisplay3DFloor || f0 >= this.m_fCubeWallThickY || f1 >= this.m_fCubeWallThickY) {
                double x4;
                double y4;
                double x8;
                double x6;
                double y8;
                double y6;
                double x2;
                double x0;
                double y2;
                double y0;
                int nClipFront;
                int nClipBack;
                if (!this.m_bCubeDisplay3DFloor) {
                    nClipBack = 0;
                    nClipFront = 0;
                } else {
                    nClipBack = f0 - size.y >= this.m_fCubeWallThickY ? 0 : (f0 >= this.m_fCubeWallThickY ? 1 : 2);
                    nClipFront = f1 - size.y >= this.m_fCubeWallThickY ? 0 : (f1 >= this.m_fCubeWallThickY ? 1 : 2);
                }
                if (nClipBack == 0) {
                    y0 = f0 - size.y;
                    y2 = f0;
                    x0 = 0.0;
                    x2 = 0.0;
                } else if (nClipBack == 1) {
                    y0 = this.m_fCubeWallThickY;
                    y2 = f0;
                    x0 = 0.0;
                    x2 = 0.0;
                } else if (nClipBack == 2) {
                    y0 = this.m_fCubeWallThickY;
                    y2 = this.m_fCubeWallThickY;
                    x2 = (this.m_fCubeWallThickY - f0) / (f1 - f0);
                    x0 = nClipFront == 0 ? (this.m_fCubeWallThickY - (f0 - size.y)) / (f1 - f0) : x2;
                } else {
                    throw new RuntimeException("oops, unknown nClipBack = " + nClipBack);
                }
                if (nClipFront == 0) {
                    y6 = f1 - size.y;
                    y8 = f1;
                    x6 = 1.0;
                    x8 = 1.0;
                } else if (nClipFront == 1) {
                    y6 = this.m_fCubeWallThickY;
                    y8 = f1;
                    x6 = 1.0;
                    x8 = 1.0;
                } else if (nClipFront == 2) {
                    y6 = this.m_fCubeWallThickY;
                    y8 = this.m_fCubeWallThickY;
                    x8 = (f0 - this.m_fCubeWallThickY) / (f0 - f1);
                    x6 = nClipBack == 0 ? (f0 - size.y - this.m_fCubeWallThickY) / (f0 - f1) : x8;
                } else {
                    throw new RuntimeException("oops, unknown nClipFront = " + nClipFront);
                }
                if (nClipFront == 0 && nClipBack == 1) {
                    y4 = this.m_fCubeWallThickY;
                    x4 = (this.m_fCubeWallThickY - (f1 - size.y)) / (f0 - f1);
                    x4 = 1.0 - x4;
                } else if (nClipFront == 1 && nClipBack == 0) {
                    y4 = this.m_fCubeWallThickY;
                    x4 = (f1 - size.y - this.m_fCubeWallThickY) / (f1 - f0);
                    x4 = 1.0 - x4;
                } else {
                    y4 = y6;
                    x4 = x6;
                }
                Point3d[] pts = new Point3d[]{new Point3d(origin.x + x0 * size.x, y0, origin.z), new Point3d(origin.x + x0 * size.x, y0, origin.z + size.z), new Point3d(origin.x + x2 * size.x, y2, origin.z), new Point3d(origin.x + x2 * size.x, y2, origin.z + size.z), new Point3d(origin.x + x4 * size.x, y4, origin.z), new Point3d(origin.x + x4 * size.x, y4, origin.z + size.z), new Point3d(origin.x + x6 * size.x, y6, origin.z), new Point3d(origin.x + x6 * size.x, y6, origin.z + size.z), new Point3d(origin.x + x8 * size.x, y8, origin.z), new Point3d(origin.x + x8 * size.x, y8, origin.z + size.z)};
                m = new Model3DRibbonGroupSolid(this, id, bb, origin, size, pts, bGridStatus, this.m_bColorAutoshadeRisers);
            }
        }
        return m;
    }

    protected double denormalize(double fNorm, double fNormMin, double fNormMax, double fFactor, double fOffset) {
        if (fNorm < fNormMin) {
            fNorm = fNormMin;
        } else if (fNorm > fNormMax) {
            fNorm = fNormMax;
        }
        double fWorld = fOffset + fFactor * fNorm;
        return fWorld;
    }

    public void displayAll3DObjects() {
        assert (!this.m_bSafeAngle && this.m_objectList != null);
        if (this.m_bSafeAngle) {
            return;
        }
        if (this.m_Perspective.getPDECalc()) {
            this.m_Floor.saveProjectedPoints();
            this.m_LWall.saveProjectedPoints();
            this.m_RWall.saveProjectedPoints();
        } else {
            this.m_Floor.preDisplay();
            this.m_LWall.preDisplay();
            this.m_RWall.preDisplay();
            if (!this.m_Perspective.getPDECalc()) {
                int objectCount = this.m_objectList.size();
                ITextStyle textStyle = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, Identity.DataText);
                for (int index = 0; index < objectCount; ++index) {
                    IModel3D obj = this.m_objectList.get(index);
                    obj.display();
                    if (!this.m_bDataTextDisplay) continue;
                    this.drawDataValue(obj.getIdentObj().getSeriesID(), obj.getIdentObj().getGroupID(), textStyle);
                }
            }
            this.m_RWall.postDisplay();
            this.m_LWall.postDisplay();
            this.m_Floor.postDisplay();
        }
    }

    protected void drawDataValue(int s, int g, ITextStyle textStyle) {
        IdentObj id = Identity.DataText;
        ArrayList<String> vectstrLabels = new ArrayList<String>(this.m_nSeries * this.m_nGroups);
        if (this.m_DataLabel[s][g] == null) {
            vectstrLabels.add("");
        } else {
            vectstrLabels.add(this.m_DataLabel[s][g]);
        }
        Dimension dimLabelDC = TextUtil.getDimLargestWidthLabelDC(this.m_Perspective.getVC(), vectstrLabels, textStyle);
        Dimension dimLabelVC = this.m_Perspective.getVC().destToVirt(dimLabelDC);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        int nDataTextPosition = 1;
        Java2DLine line2D = new Java2DLine(this.m_Perspective);
        boolean bDisplayDataTextForSeries = this.m_Perspective.getDisplay(this.m_Perspective.getDataText(s, g));
        if (!bDisplayDataTextForSeries) {
            return;
        }
        if (this.m_dataOK[s][g] && this.m_DataLabel[s][g] != null) {
            Point ptRiserTop = this.getRiserTop2D(s, g, 0);
            Point ptLabelPos = this.getRiserTop2D(s, g, nDataTextPosition);
            Rectangle rLabel = this.calcDataValuePosition(ptLabelPos, dimLabelVC);
            if (rLabel != null) {
                IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                DrawFactory.createLabel(this.m_Perspective.getDetectiv(), newID, this.m_DataLabel[s][g], rLabel, textStyle, blackBox, null);
                IdentObj idConnectLine = this.m_Perspective.getCubeDataTextLine(s);
                if (this.m_Perspective.getDisplay(idConnectLine)) {
                    BlackBoxObj bbConnectLine = new BlackBoxObj(this.m_Perspective, idConnectLine);
                    this.drawConnectingLine(ptRiserTop, rLabel, line2D, idConnectLine, bbConnectLine);
                }
            }
        }
    }

    private void drawConnectingLine(Point ptRiserTop, Rectangle rLabel, Java2DLine line2D, IdentObj id, IBlackBox bb) {
        Point ptLabel = new Point(rLabel.x + rLabel.width / 2, rLabel.y);
        line2D.createLine(id, id, ptLabel.x, ptLabel.y, ptRiserTop.x, ptRiserTop.y, bb, null, 1.0);
    }

    protected Rectangle calcDataValuePosition(Point ptRiserTop, Dimension dimLabel) {
        if (ptRiserTop == null) {
            System.out.println("oops no riser top calculated");
            return null;
        }
        Point center = new Point(ptRiserTop.x, ptRiserTop.y);
        Rectangle r = new Rectangle(center.x - dimLabel.width / 2, center.y - dimLabel.height / 2, dimLabel.width, dimLabel.height);
        return r;
    }

    protected Point getRiserTop2D(int s, int g, int nDataTextPosition) {
        Point pt = null;
        for (int i = 0; i < this.m_objectList.size(); ++i) {
            IModel3D m = this.m_objectList.get(i);
            IdentObj id = m.getIdentObj();
            if (id.getSeriesID() != s || id.getGroupID() != g) continue;
            try {
                Point2D p2d = m.getPosition(this.m_matrix, nDataTextPosition);
                if (p2d == null) break;
                pt = new Point((int)p2d.getX(), (int)p2d.getY());
                break;
            }
            catch (UnsupportedOperationException uoe) {
                assert (false);
                break;
            }
        }
        return pt;
    }

    protected MinMaxObj findLimits(int axis, int scaling, boolean bMustIncludeZero) {
        MinMaxObj minMaxObj = this.findPreScaledLimits(axis, scaling, bMustIncludeZero);
        if (minMaxObj != null) {
            return minMaxObj;
        }
        minMaxObj = new MinMaxObj(bMustIncludeZero);
        if (scaling == 1) {
            for (int s = 0; s < this.m_nTotalSeries; ++s) {
                for (int g = 0; g < this.m_nTotalGroups; ++g) {
                    DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                    double fValue = dObj.value;
                    if (!dObj.m_bOK || this.m_bY1LogScale && fValue <= 0.0) continue;
                    minMaxObj.testRawValue(fValue);
                }
            }
        } else {
            throw new RuntimeException();
        }
        return minMaxObj;
    }

    public IAxis getAxisObj(int nAxis) {
        switch (nAxis) {
            case 0: {
                return this.m_O2Axis;
            }
            case 2: {
                return this.m_O1Axis;
            }
            case 1: {
                return this.m_Y1Axis;
            }
        }
        throw new RuntimeException("Invalid Parameter passed !");
    }

    public IBlackBox getModelBlackBox(IdentObj id) {
        IBlackBox bb;
        int s = id.getSeriesID();
        int g = id.getGroupID();
        boolean bExact = this.m_Perspective.getExactColorByHeight();
        if (this instanceof JChart_3D_Surf && this.m_Perspective.isColorByHeight() && s != -3) {
            int yCoord = this.getYCoordForHeight(s, g);
            double fValue = this.getValueFromCoord(yCoord);
            if (!bExact) {
                List<Double> szLabels = this.m_Y1Axis.getNumericLabelsAsDouble();
                int nLabels = szLabels.size();
                assert (nLabels > 1);
                boolean bFound = false;
                for (int i = 1; i < nLabels && !bFound; ++i) {
                    double fCurr;
                    double fPrev = szLabels.get(i - 1);
                    double fMid = (fPrev + (fCurr = szLabels.get(i).doubleValue())) / 2.0;
                    if (!(fValue < fMid)) continue;
                    fValue = fPrev;
                    bFound = true;
                }
                if (!bFound) {
                    fValue = szLabels.get(nLabels - 1);
                }
            }
            double fRatio = this.m_Y1Axis.getValueRelCoord(fValue);
            bb = this.getBlackBox(id, fRatio);
        } else {
            bb = this.getBlackBox(id);
        }
        return bb;
    }

    protected int getYCoordForHeight(int s, int g) {
        int yCoord = 0;
        if (this.m_dataOK[s][g]) {
            yCoord = this.m_numYCoords[s][g];
        }
        return yCoord;
    }

    public Point3d getCubeSize() {
        return new Point3d(this.m_fCubeSizeX, this.m_fCubeSizeY, this.m_fCubeSizeZ);
    }

    public double getCubeWallThickY() {
        return this.m_fCubeWallThickY;
    }

    public IdentObj getMajorGridId(int nAxis) {
        return ((IAxis3D)((Object)this.getAxisObj(nAxis))).getMajorGridId();
    }

    public List<Double> getMajorGridPositions(int nAxis) {
        return ((IAxis3D)((Object)this.getAxisObj(nAxis))).getMajorGridPositions();
    }

    public IBlackBox getMajorGridsBlackBox(int nAxis) {
        return ((IAxis3D)((Object)this.getAxisObj(nAxis))).getMajorGridBlackBox();
    }

    public Matrix4d getMatrix() {
        return this.m_matrix;
    }

    public boolean getInverseMatrix(Matrix4d inverseMatrix) {
        return Matrix4d.inverse(this.m_matrix, inverseMatrix);
    }

    public double getMinCubeViewerZ() {
        Point3d origin = new Point3d(0.0, 0.0, 0.0);
        Point3d size = new Point3d(this.m_fCubeSizeX, this.m_fCubeSizeY, this.m_fCubeSizeZ);
        boolean[][] bGridStatus = new boolean[2][3];
        bGridStatus[0][0] = false;
        bGridStatus[0][1] = false;
        bGridStatus[0][2] = false;
        bGridStatus[1][0] = false;
        bGridStatus[1][1] = false;
        bGridStatus[1][2] = false;
        Model3DRectSolid cube = new Model3DRectSolid(this, null, null, origin, size, bGridStatus, false, false);
        double fMinZ = cube.getMinZ();
        return fMinZ + 2000.0;
    }

    public IdentObj getMinorGridId(int nAxis) {
        return ((IAxis3D)((Object)this.getAxisObj(nAxis))).getMinorGridId();
    }

    public List<Double> getMinorGridPositions(int nAxis) {
        return ((IAxis3D)((Object)this.getAxisObj(nAxis))).getMinorGridPositions();
    }

    public IBlackBox getMinorGridsBlackBox(int nAxis) {
        return ((IAxis3D)((Object)this.getAxisObj(nAxis))).getMinorGridBlackBox();
    }

    public double getPanX() {
        return this.m_fViewPanX;
    }

    public double getPanY() {
        return this.m_fViewPanY;
    }

    public Perspective getPerspective() {
        return this.m_Perspective;
    }

    @Override
    public double getQuantizedDataValue(int nSeries, int nGroup, DataItem item) {
        double fValue = this.getDataValue((int)nSeries, (int)nGroup, (DataItem)item).value;
        boolean bExact = this.m_Perspective.getExactColorByHeight();
        if (!bExact) {
            List<Double> dLabels = this.m_Y1Axis.getNumericLabelsAsDouble();
            int nLabels = dLabels.size();
            assert (nLabels > 1);
            boolean bFound = false;
            for (int i = 1; i < nLabels && !bFound; ++i) {
                double fCurr;
                double fPrev = dLabels.get(i - 1);
                double fMid = (fPrev + (fCurr = dLabels.get(i).doubleValue())) / 2.0;
                if (!(fValue < fMid)) continue;
                fValue = fPrev;
                bFound = true;
            }
            if (!bFound) {
                fValue = dLabels.get(nLabels - 1);
            }
        }
        return fValue;
    }

    public Point3d getViewer() {
        return new Point3d(this.m_fViewViewerX, this.m_fViewViewerY, this.m_fViewViewerZ);
    }

    @Override
    public void init() {
        super.init();
        this.m_O1Axis = null;
        this.m_O2Axis = null;
        this.m_Y1Axis = null;
        this.m_bAlreadyDrawn = false;
        this.m_bViewRawViewerZ = true;
        this.copyParams();
        this.createMatrix();
    }

    public boolean isAxisVisible(int nAxis, int nSide) {
        return true;
    }

    protected double normalizeGeom(double fWorld, double fNormMin, double fNormMax, double fBase, double fMult) {
        double fMedian;
        double fWorldMin = Math.pow(fBase, fNormMin) * fMult;
        double fWorldMax = Math.pow(fBase, fNormMax) * fMult;
        if (fWorld < fWorldMin) {
            fWorld = fWorldMin;
        } else if (fWorld > fWorldMax) {
            fWorld = fWorldMax;
        }
        assert (fBase != 0.0);
        assert (fMult != 0.0);
        double fNorm = fMult == 0.0 || fBase == 0.0 ? (fMedian = (fNormMin + fNormMax) / 2.0) : Math.log(fWorld / fMult) / Math.log(fBase);
        return fNorm;
    }

    public boolean isViewForceIsometric() {
        return this.m_bViewForceIsometric;
    }

    public Point projectPoint3d(Point3d pt3d) {
        double y;
        double x;
        double dz = this.m_fViewViewerZ - pt3d.z;
        if (this.m_bViewForceIsometric) {
            x = pt3d.x - this.m_fViewViewerX;
            y = pt3d.y - this.m_fViewViewerY;
        } else if (dz == 0.0) {
            x = 0.0;
            y = 0.0;
        } else {
            x = (pt3d.x - this.m_fViewViewerX) * (this.m_fViewViewerZ / dz);
            y = (pt3d.y - this.m_fViewViewerY) * (this.m_fViewViewerZ / dz);
        }
        return new Point((int)(x += this.m_fViewPanX), (int)(y += this.m_fViewPanY));
    }

    public Point2D projectPoint3dInDouble(Point3d pt3d) {
        double y;
        double x;
        double dz = this.m_fViewViewerZ - pt3d.z;
        if (this.m_bViewForceIsometric) {
            x = pt3d.x - this.m_fViewViewerX;
            y = pt3d.y - this.m_fViewViewerY;
        } else if (dz == 0.0) {
            x = 0.0;
            y = 0.0;
        } else {
            x = (pt3d.x - this.m_fViewViewerX) * (this.m_fViewViewerZ / dz);
            y = (pt3d.y - this.m_fViewViewerY) * (this.m_fViewViewerZ / dz);
        }
        return new Point2D.Double(x += this.m_fViewPanX, y += this.m_fViewPanY);
    }

    public void scaleCube(double scaleFactor) {
        Matrix4d mCurrent = this.getMatrix();
        if (mCurrent == null) {
            return;
        }
        double oldZoom = this.m_fViewZoomFactor;
        double newZoom = oldZoom * scaleFactor;
        if (newZoom >= 0.25 && newZoom <= 4.0) {
            mCurrent.scale(scaleFactor);
            this.m_Perspective.setCubeZoomFactor(this.normalizeGeom(newZoom, 0.0, 100.0, 1.028113827, 0.25));
        }
    }

    public void setDrawOrder() {
        this.m_Floor.calcDisplayWhen(this.m_bCubeDisplay3DFloor, 2);
        this.m_LWall.calcDisplayWhen(this.m_bCubeDisplay3DLeftWall, 4);
        this.m_RWall.calcDisplayWhen(this.m_bCubeDisplay3DRightWall, 0);
    }

    public void sort3DObjects() {
        assert (!this.m_bSafeAngle && this.m_objectList != null);
        Point3d viewer = new Point3d(this.m_fViewViewerX, this.m_fViewViewerY, this.m_fViewViewerZ);
        int objectCount = this.m_objectList.size();
        for (int index = 0; index < objectCount; ++index) {
            IModel3D obj = this.m_objectList.get(index);
            obj.calcDistance(this.m_matrix, viewer);
        }
        Collections.sort(this.m_objectList, new Comparator<IModel3D>(){

            @Override
            public int compare(IModel3D o1, IModel3D o2) {
                double d2 = o2.getDistance();
                double d1 = o1.getDistance();
                if (d1 == d2) {
                    return 0;
                }
                if (d1 < d2) {
                    return 1;
                }
                return -1;
            }
        });
    }

    public void transformPoint3d(Point3d p3D_X) {
        double tempX = p3D_X.x - this.m_fHalfCubeX;
        double tempY = p3D_X.y - this.m_fHalfCubeY;
        double tempZ = p3D_X.z - this.m_fHalfCubeZ;
        p3D_X.x = tempX * this.m_matrix.m00 + tempY * this.m_matrix.m10 + tempZ * this.m_matrix.m20 + this.m_matrix.m30;
        p3D_X.y = tempX * this.m_matrix.m01 + tempY * this.m_matrix.m11 + tempZ * this.m_matrix.m21 + this.m_matrix.m31;
        p3D_X.z = tempX * this.m_matrix.m02 + tempY * this.m_matrix.m12 + tempZ * this.m_matrix.m22 + this.m_matrix.m32;
    }

    @Override
    public boolean wantLegend() {
        return false;
    }

    public double getValueFromCoord(int coord) {
        return this.m_Y1Axis.getValueFromCoord(coord);
    }

    private Rectangle getWallBounds(Model3DCubeWall wall) {
        Rectangle rVC = this.getPerspective().getVC().getVirtCoords();
        int left = rVC.x + rVC.width;
        int right = rVC.x;
        int top = rVC.y;
        int bottom = rVC.y + rVC.height;
        Polygon poly = wall.getProjectedVertices();
        for (int i = 0; i < poly.npoints; ++i) {
            left = Math.min(left, poly.xpoints[i]);
            right = Math.max(right, poly.xpoints[i]);
            bottom = Math.min(bottom, poly.ypoints[i]);
            top = Math.max(top, poly.ypoints[i]);
        }
        return new Rectangle(left, bottom, right - left, top - bottom);
    }

    private void calculateAxisTitlePosition() {
        Rectangle r = this.getWallBounds(this.m_LWall);
        int left = r.x;
        int right = r.x + r.width;
        int bottom = r.y;
        int top = r.y + r.height;
        r = this.getWallBounds(this.m_RWall);
        left = Math.min(left, r.x);
        right = Math.max(right, r.x + r.width);
        bottom = Math.min(bottom, r.y);
        top = Math.max(top, r.y + r.height);
        r = this.getWallBounds(this.m_Floor);
        left = Math.min(left, r.x);
        right = Math.max(right, r.x + r.width);
        bottom = Math.min(bottom, r.y);
        top = Math.max(top, r.y + r.height);
        r = new Rectangle(left, bottom, right - left, top - bottom);
        r.grow(2000, 2000);
        ((IAxis3D)((Object)this.m_O1Axis)).setTitleRect(r);
        ((IAxis3D)((Object)this.m_O2Axis)).setTitleRect(r);
        ((IAxis3D)((Object)this.m_Y1Axis)).setTitleRect(r);
    }

    public Rectangle getFrameRectVC() {
        Rectangle unionRect = null;
        PlaceUtilities.calc(this.m_Perspective);
        Rectangle r = this.m_RWall.getProjectedVertices().getBounds();
        unionRect = new Rectangle();
        unionRect.add(r);
        r = this.m_LWall.getProjectedVertices().getBounds();
        unionRect.add(r);
        r = this.m_Floor.getProjectedVertices().getBounds();
        unionRect.add(r);
        return unionRect;
    }

    public Model3DCubeWall getFloor() {
        return this.m_Floor;
    }

    public Model3DCubeWall getLeftWall() {
        return this.m_LWall;
    }

    public Model3DCubeWall getRightWall() {
        return this.m_RWall;
    }

    void makeCubeProportional() {
        boolean bMakeCubeProportional = true;
        double dSaneCubeProportionalFactor = 0.7;
        double origX = this.m_fCubeSizeX;
        double origY = this.m_fCubeSizeY;
        if (bMakeCubeProportional) {
            int t = this.m_nSeries + this.m_nGroups;
            double width = this.m_fCubeSizeX + this.m_fCubeSizeY;
            double portion = (double)this.m_nSeries / (double)t;
            if (portion < 1.0 - dSaneCubeProportionalFactor) {
                portion = 1.0 - dSaneCubeProportionalFactor;
            } else if (portion > dSaneCubeProportionalFactor) {
                portion = dSaneCubeProportionalFactor;
            }
            this.m_fCubeSizeX = portion * width;
            this.m_fCubeSizeY = (1.0 - portion) * width;
        }
        this.setHalfCube();
    }

    public Point3d getViewerInWorldCoordinates() {
        Point3d p = this.getViewer();
        Matrix4d mInverse = new Matrix4d();
        Matrix4d.inverse(this.m_matrix, mInverse);
        mInverse.transformPoint3d(p, p);
        return p;
    }

    public final void inverseProjection(double x, double y, Point3d vector) {
        vector.x = x - this.m_fViewPanX;
        vector.y = y - this.m_fViewPanY;
        vector.z = -this.m_fViewViewerZ;
        this.m_matrix.transformCovector3d(vector, vector);
    }

    public final double getHeightRatio(double yCoord) {
        return ((IAxis3D)((Object)this.m_Y1Axis)).getRatioFromCoord(yCoord);
    }

    @Override
    public IAxis getAxis(int axisId) {
        switch (axisId) {
            case 514: {
                return this.getAxisObj(2);
            }
            case 528: {
                return this.getAxisObj(1);
            }
            case 518: {
                return this.getAxisObj(0);
            }
        }
        return null;
    }
}

