/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DatumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.AnnotationBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.FunnelLabel;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Multi;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Slice;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;

public class JChart_2D_Funnel
extends JChart_2D_Multi {
    public static final int FUNNEL_FEELER_MARGIN_VC = 500;
    private static final int START_DEPTH_ANGLE = 5;
    private static final int STOP_DEPTH_ANGLE = 175;
    private static final int BACK_START_DEPTH_ANGLE = 178;
    private static final int BACK_STOP_DEPTH_ANGLE = 364;
    private static final double FUNNEL_FRONT_ADJUST = 1.004;
    private static final int TEXT_ADJUSTMENT_MARGINVC = 5;
    private static final int LOCATION_LABELS_ONTOP_OF_VALUES_BOTH_ON_RIGHT = 0;
    private static final int LOCATION_LABELS_ONLEFT_VALUES_ON_RIGHT = 1;
    private static final int LOCATION_VALUES_ONLEFT_LABELS_ON_RIGHT = 2;
    private Point m_ptLRC;
    private Point m_ptULC;
    private int m_nXLabelLineEndPt;
    private int m_nPieMinDepth;
    private int m_nDepthEffect;
    private boolean m_bDepthEffect;
    private List<FunnelLabel> funnelLabels = null;
    private Dimension maxFunnelLabel = null;
    private Dimension maxFunnelValue = null;
    private int m_displayValuesFormat;
    public static final IChartEngineFactory engineFactory = new IChartEngineFactory(){

        public IChartEngine createChartEngine(Perspective perspective) {
            return new JChart_2D_Funnel(perspective);
        }
    };

    private JChart_2D_Funnel(Perspective perspective) {
        super(perspective);
    }

    public double getGroupTotal(int g) {
        double fGroupTotal = 0.0;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        int nTotalSeries = this.getDataView().getNumTotalSeries();
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < nTotalSeries);
            double fValue = this.getDataValue((int)s, (int)g).value;
            if (!(fValue > 0.0)) continue;
            fGroupTotal += fValue;
        }
        return fGroupTotal;
    }

    public int getNumSkips(int g, int nVerticalExplosionFactor, double fGroupTotal, double fBottomFunnelHeightPercent) {
        double fCheck = 0.0;
        int nSkips = 0;
        if (nVerticalExplosionFactor != 0) {
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
            int nTotalSeries = this.getDataView().getNumTotalSeries();
            while (sEnum.hasNext()) {
                int s = sEnum.next();
                assert (s >= 0 && s < nTotalSeries);
                double fSeries = this.getDataValue((int)s, (int)g).value;
                if (!((fCheck += fSeries) / fGroupTotal > fBottomFunnelHeightPercent)) continue;
                ++nSkips;
            }
        }
        return nSkips;
    }

    protected void processSubRect(Rectangle subFrameRect) {
    }

    protected IdentObj getGroupLabelID(int series, int group) {
        return this.m_Perspective.getFunnelGroupLabel(series, group);
    }

    protected IdentObj getGroupLabelBoxID(int series, int group) {
        return this.m_Perspective.getFunnelGroupLabel(series, group);
    }

    protected void copyParams() {
        super.copyParams();
        int nPieTilt = this.m_Perspective.getPieTilt();
        this.m_nPieMinDepth = 30 * nPieTilt / 5;
        this.m_nDepthEffect = 4 * (30 * nPieTilt) / 5;
        this.m_bDepthEffect = 4 * (30 * nPieTilt) / 5 > 0;
        this.m_bGTMultiple = this.m_nGroups > 1;
        this.m_rSuperFrame = this.m_Perspective.getRect(this.m_Perspective.getCurrentFrame());
        this.m_displayValuesFormat = this.m_Perspective.getPieValueFormat();
    }

    protected double drawSubChart(int nGroup) {
        double fGroupTotal;
        double retVal = fGroupTotal = this.getGroupTotal(nGroup);
        if (fGroupTotal == 0.0) {
            fGroupTotal = 1.0;
        }
        int nTotalSeries = this.getDataView().getNumTotalSeries();
        this.m_sEnumForward = SeriesEnumerator.getIterator(this.m_Perspective, this.getDataView());
        int nPieDepth = this.m_Perspective.getPieDepth();
        int nPieRotate = this.m_Perspective.getPieRotate();
        double fBottomFunnelWidth = Math.min((double)nPieDepth / 200.0, 0.5);
        double fBottomFunnelHeightPercent = Math.min((double)nPieRotate / 1000.0, 0.36);
        int nVerticalExplosionFactor = this.m_Perspective.getFunnelVertExplosionFactor() * 10;
        int nSkips = this.getNumSkips(nGroup, nVerticalExplosionFactor, fGroupTotal, fBottomFunnelHeightPercent);
        Rectangle rFrame = new Rectangle(this.m_rSubFrame);
        rFrame.height -= 2 * this.m_nPieMinDepth + this.m_nDepthEffect;
        VC vc = this.m_Perspective.getVC();
        this.ConstrainBoxAspect(rFrame, 2, 2, 2, 30, vc.getSquareAspectRatioY() / vc.getSquareAspectRatioX());
        this.m_ptULC = new Point();
        this.m_ptULC.x = rFrame.x;
        this.m_ptULC.y = rFrame.y + this.m_nPieMinDepth + rFrame.height;
        this.m_ptLRC = new Point();
        this.m_ptLRC.x = rFrame.x + rFrame.width;
        this.m_ptLRC.y = rFrame.y + this.m_nPieMinDepth;
        Rectangle rGroupLabel = new Rectangle(rFrame.x, this.m_rSubFrame.y - this.m_nGroupLabelHeight, rFrame.width, this.m_nGroupLabelHeight);
        int nTotalColumnHeight = this.heightOfBox();
        int nYNippleHeight = (int)(fBottomFunnelHeightPercent * (double)(nTotalColumnHeight -= (nTotalSeries - 1) * nVerticalExplosionFactor));
        double fAvailableY = nTotalColumnHeight - nYNippleHeight;
        int nBoxWidth = this.widthOfBox();
        double fAvailableX = (double)(nBoxWidth / 2) * (1.0 - fBottomFunnelWidth);
        int nXNippleInset = (int)fAvailableX;
        fAvailableY += (double)(nSkips * nVerticalExplosionFactor);
        double fExplosion = 0.0;
        double fStopPercent = 0.0;
        double fStartPercent = 0.0;
        this.funnelLabels = new ArrayList<FunnelLabel>(nTotalSeries);
        for (int i = this.groupDataSlices.size() - 1; i >= 0; --i) {
            Slice slice = (Slice)this.groupDataSlices.get(i);
            int nSeries = slice.getSeriesID();
            fStartPercent = fStopPercent;
            int nBarHeight = (int)(slice.getPercentage() * (double)nTotalColumnHeight);
            fStopPercent += slice.getPercentage();
            if (fStartPercent > fBottomFunnelHeightPercent) {
                int nXBottomInset = (int)(fAvailableX - fAvailableX * ((fStartPercent + fExplosion - fBottomFunnelHeightPercent) / (1.0 - fBottomFunnelHeightPercent)));
                int nXTopInset = (int)(fAvailableX - fAvailableX * ((fStopPercent + fExplosion - fBottomFunnelHeightPercent) / (1.0 - fBottomFunnelHeightPercent)));
                this.drawAboveNipple(nSeries, nGroup, nBarHeight, nXBottomInset, nXTopInset, fStartPercent, fStopPercent);
                fExplosion += (double)nVerticalExplosionFactor / fAvailableY;
            } else if (fStopPercent > fBottomFunnelHeightPercent) {
                int nXTopInset = (int)(fAvailableX - fAvailableX * ((fStopPercent + fExplosion - fBottomFunnelHeightPercent) / (1.0 - fBottomFunnelHeightPercent)));
                this.drawTransectsNipple(nSeries, nGroup, nBarHeight, nXNippleInset, nXTopInset, nYNippleHeight, fStartPercent, fStopPercent);
                fExplosion += (double)nVerticalExplosionFactor / fAvailableY;
            } else {
                this.drawBelowNipple(nSeries, nGroup, nBarHeight, nXNippleInset, nYNippleHeight, fStartPercent, fStopPercent);
            }
            FunnelLabel funLabel = this.saveFunnelLabelLocations(nSeries, nGroup, nBarHeight, this.m_nXLabelLineEndPt);
            funLabel.value = slice.getValue();
            funLabel.percent = slice.getPercentage();
            this.funnelLabels.add(funLabel);
            this.m_ptLRC.y += nBarHeight + nVerticalExplosionFactor;
        }
        if (nTotalSeries > 1) {
            this.adjustFunnelLabelLocations();
        }
        int nLabels = this.funnelLabels.size();
        this.maxFunnelLabel = new Dimension(0, 0);
        this.maxFunnelValue = new Dimension(0, 0);
        for (int i = 0; i < nLabels; ++i) {
            FunnelLabel labelToDraw = this.funnelLabels.get(i);
            if (labelToDraw == null) continue;
            if (labelToDraw.m_rLabelVC != null) {
                if (this.maxFunnelLabel.width < labelToDraw.m_rLabelVC.width) {
                    this.maxFunnelLabel.width = labelToDraw.m_rLabelVC.width;
                }
                if (this.maxFunnelLabel.height < labelToDraw.m_rLabelVC.height) {
                    this.maxFunnelLabel.height = labelToDraw.m_rLabelVC.height;
                }
            }
            if (labelToDraw.m_rValueVC != null) {
                if (this.maxFunnelValue.width < labelToDraw.m_rValueVC.width) {
                    this.maxFunnelValue.width = labelToDraw.m_rValueVC.width;
                }
                if (this.maxFunnelValue.height < labelToDraw.m_rValueVC.height) {
                    this.maxFunnelValue.height = labelToDraw.m_rValueVC.height;
                }
            }
            this.drawFunnelLabel(labelToDraw);
        }
        if (this.groupDataSlices.size() > 0 && this.m_Perspective.getDisplay(this.getGroupLabelID(-3, nGroup))) {
            this.drawGroupLabel(nGroup, rGroupLabel);
        }
        return retVal;
    }

    public Dimension getMaxFunnelLabelDim() {
        return this.maxFunnelLabel;
    }

    public Dimension getMaxFunnelValueDim() {
        return this.maxFunnelValue;
    }

    private void adjustFunnelLabelLocations() {
        boolean bShowValue = this.m_Perspective.getDisplay(Identity.FunnelValueLabel);
        boolean bShowLabel = this.m_Perspective.getDisplay(Identity.FunnelSliceLabel);
        int nLabelLocation = this.m_Perspective.getFunnelLabelValueLocation();
        switch (nLabelLocation) {
            case 0: {
                this.moveFunnelLabelsUpIfTheyCollide(bShowValue, bShowLabel);
                boolean bCollide = this.doFunnelLabelsCollide();
                if (!bCollide) break;
                this.stackFunnelLabelsFromFrameBottom(bShowValue, bShowLabel);
                break;
            }
            case 1: 
            case 2: {
                this.moveFunnelLabelsUpIfTheyCollide(bShowValue, false);
                this.moveFunnelLabelsUpIfTheyCollide(false, bShowLabel);
                boolean bCollide = this.doFunnelLabelsCollide();
                if (!bCollide) break;
                this.stackFunnelLabelsFromFrameBottom(bShowValue, false);
                this.stackFunnelLabelsFromFrameBottom(false, bShowLabel);
            }
        }
    }

    private void moveFunnelLabelsUpIfTheyCollide(boolean bShowValue, boolean bShowLabel) {
        int nLabels = this.funnelLabels.size();
        for (int i = 0; i < nLabels - 1; ++i) {
            int nYMove;
            int nCurrTop;
            FunnelLabel labelCurr = this.funnelLabels.get(i);
            FunnelLabel labelNext = this.funnelLabels.get(i + 1);
            if (bShowValue && bShowLabel && labelCurr.m_rLabelVC.intersects(labelNext.m_rValueVC)) {
                nCurrTop = labelCurr.m_rLabelVC.y + labelCurr.m_rLabelVC.height;
                nYMove = nCurrTop - labelNext.m_rValueVC.y + 5;
                labelNext.m_rLabelVC.y += nYMove;
                labelNext.m_rValueVC.y += nYMove;
                labelNext.m_ptRightLabelFeelerVC.y += nYMove;
                labelNext.m_ptRightValueFeelerVC.y += nYMove;
            }
            if (!bShowValue && bShowLabel && labelCurr.m_rLabelVC.intersects(labelNext.m_rLabelVC)) {
                nCurrTop = labelCurr.m_rLabelVC.y + labelCurr.m_rLabelVC.height;
                nYMove = nCurrTop - labelNext.m_rLabelVC.y + 5;
                labelNext.m_rLabelVC.y += nYMove;
                labelNext.m_ptRightLabelFeelerVC.y += nYMove;
            }
            if (!bShowValue || bShowLabel || !labelCurr.m_rValueVC.intersects(labelNext.m_rValueVC)) continue;
            nCurrTop = labelCurr.m_rValueVC.y + labelCurr.m_rValueVC.height;
            nYMove = nCurrTop - labelNext.m_rValueVC.y + 5;
            labelNext.m_rValueVC.y += nYMove;
            labelNext.m_ptRightValueFeelerVC.y += nYMove;
        }
    }

    private void stackFunnelLabelsFromFrameBottom(boolean bShowValue, boolean bShowLabel) {
        int nLabels = this.funnelLabels.size();
        for (int i = 0; i < nLabels - 1; ++i) {
            int nYCurrTop;
            FunnelLabel labelCurr = this.funnelLabels.get(i);
            FunnelLabel labelNext = this.funnelLabels.get(i + 1);
            if (bShowValue && bShowLabel) {
                nYCurrTop = labelCurr.m_rLabelVC.y + labelCurr.m_rLabelVC.height;
                labelNext.m_rValueVC.y = nYCurrTop + 5;
                int nYNextTop = labelNext.m_rValueVC.y + labelNext.m_rValueVC.height;
                labelNext.m_rLabelVC.y = nYNextTop + 5;
                labelNext.m_ptRightLabelFeelerVC.y = labelNext.m_rLabelVC.y + labelNext.m_rLabelVC.height / 2;
                labelNext.m_ptRightValueFeelerVC.y = labelNext.m_rValueVC.y + labelNext.m_rValueVC.height / 2;
            }
            if (!bShowValue && bShowLabel) {
                nYCurrTop = labelCurr.m_rLabelVC.y + labelCurr.m_rLabelVC.height;
                labelNext.m_rLabelVC.y = nYCurrTop + 5;
                labelNext.m_ptRightLabelFeelerVC.y = labelNext.m_rLabelVC.y + labelNext.m_rLabelVC.height / 2;
            }
            if (!bShowValue || bShowLabel) continue;
            nYCurrTop = labelCurr.m_rValueVC.y + labelCurr.m_rValueVC.height;
            labelNext.m_rValueVC.y = nYCurrTop + 5;
            labelNext.m_ptRightValueFeelerVC.y = labelNext.m_rValueVC.y + labelNext.m_rValueVC.height / 2;
        }
    }

    private boolean doFunnelLabelsCollide() {
        boolean bShowValue = this.m_Perspective.getDisplay(Identity.FunnelValueLabel);
        boolean bShowLabel = this.m_Perspective.getDisplay(Identity.FunnelSliceLabel);
        int nLabels = this.funnelLabels.size();
        boolean bCollide = false;
        for (int i = 0; i < nLabels - 1; ++i) {
            FunnelLabel labelPrev;
            FunnelLabel labelCurr = this.funnelLabels.get(i);
            FunnelLabel labelNext = this.funnelLabels.get(i + 1);
            if (bShowValue && bShowLabel && (labelCurr.m_rLabelVC.intersects(labelNext.m_rValueVC) || labelCurr.m_rValueVC.intersects(labelNext.m_rValueVC) || labelCurr.m_rValueVC.intersects(labelNext.m_rLabelVC))) {
                bCollide = true;
            }
            if (!bShowValue && bShowLabel) {
                if (labelCurr.m_rLabelVC.intersects(labelNext.m_rLabelVC)) {
                    bCollide = true;
                }
                if (i > 0) {
                    labelPrev = this.funnelLabels.get(i - 1);
                    if (labelPrev.m_rLabelVC.intersects(labelCurr.m_rLabelVC) || labelPrev.m_rLabelVC.intersects(labelNext.m_rLabelVC)) {
                        bCollide = true;
                    }
                }
            }
            if (!bShowValue || bShowLabel) continue;
            if (labelCurr.m_rValueVC.intersects(labelNext.m_rValueVC)) {
                bCollide = true;
            }
            if (i <= 0) continue;
            labelPrev = this.funnelLabels.get(i - 1);
            if (!labelPrev.m_rValueVC.intersects(labelCurr.m_rValueVC) && !labelPrev.m_rValueVC.intersects(labelNext.m_rValueVC)) continue;
            bCollide = true;
        }
        return bCollide;
    }

    private FunnelLabel saveFunnelLabelLocations(int nSeries, int nGroup, int nBarHeight, int nXLabelLineEndPtRight) {
        FunnelLabel funLabel = new FunnelLabel();
        funLabel.m_nSeries = nSeries;
        funLabel.m_nGroup = nGroup;
        int nLocation = this.m_Perspective.getFunnelLabelValueLocation();
        switch (nLocation) {
            case 0: {
                this.saveLabelsBothOnRight(nBarHeight, nXLabelLineEndPtRight, funLabel);
                break;
            }
            case 1: {
                this.saveLabelsOnLeftValuesOnRight(nBarHeight, nXLabelLineEndPtRight, funLabel);
                break;
            }
            case 2: {
                this.saveLabelsValuesOnLeftLabelsOnRight(nBarHeight, nXLabelLineEndPtRight, funLabel);
            }
        }
        return funLabel;
    }

    private void saveLabelsValuesOnLeftLabelsOnRight(int nBarHeight, int nXLabelLineEndPtRight, FunnelLabel funLabel) {
        IdentObj idFunnelValueLabel = Identity.FunnelValueLabel;
        boolean bShowValue = this.m_Perspective.getDisplay(idFunnelValueLabel);
        IdentObj idFunnelLabel = Identity.FunnelSliceLabel;
        boolean bShowLabel = this.m_Perspective.getDisplay(idFunnelLabel);
        int nYMidPoint = this.m_ptLRC.y + nBarHeight / 2;
        DatumObj dObj = this.getDataValue(funLabel.m_nSeries, funLabel.m_nGroup);
        if (bShowValue && dObj.m_bOK) {
            int nXValueLeft = this.m_ptULC.x - 1000;
            int nValueTextWidthVC = this.getTextWidthValueVC(funLabel);
            int nValueTextHeightVC = TextUtil.getFontSizeHeightVC(this.m_Perspective, idFunnelValueLabel);
            funLabel.m_rValueVC = new Rectangle(nXValueLeft - nValueTextWidthVC, nYMidPoint - nValueTextHeightVC, nValueTextWidthVC, nValueTextHeightVC);
            int nXDiffToEndOfFrameRight = this.m_ptLRC.x - nXLabelLineEndPtRight;
            int nXLabelLineEndPtLeft = this.m_ptULC.x + nXDiffToEndOfFrameRight;
            funLabel.m_ptRightValueFeelerVC = new Point(nXLabelLineEndPtLeft, nYMidPoint);
            funLabel.m_ptLeftValueFeelerVC = new Point(this.m_ptULC.x - 500, nYMidPoint - nValueTextHeightVC / 2);
        }
        if (bShowLabel) {
            int nXLabelRight = this.m_ptLRC.x + 1000;
            int nLabelTextHeightVC = TextUtil.getFontSizeHeightVC(this.m_Perspective, idFunnelLabel);
            int nLabelTextWidthVC = this.getTextWidthLabelVC(funLabel);
            funLabel.m_rLabelVC = new Rectangle(nXLabelRight, nYMidPoint - nLabelTextHeightVC, nLabelTextWidthVC, nLabelTextHeightVC);
            funLabel.m_ptRightLabelFeelerVC = new Point(nXLabelLineEndPtRight, nYMidPoint);
            funLabel.m_ptLeftLabelFeelerVC = new Point(this.m_ptLRC.x + 500, nYMidPoint - nLabelTextHeightVC / 2);
        }
    }

    private void saveLabelsOnLeftValuesOnRight(int nBarHeight, int nXLabelLineEndPtRight, FunnelLabel funLabel) {
        IdentObj idFunnelValueLabel = Identity.FunnelValueLabel;
        boolean bShowValue = this.m_Perspective.getDisplay(idFunnelValueLabel);
        IdentObj idFunnelLabel = Identity.FunnelSliceLabel;
        boolean bShowLabel = this.m_Perspective.getDisplay(idFunnelLabel);
        int nYMidPoint = this.m_ptLRC.y + nBarHeight / 2;
        DatumObj dObj = this.getDataValue(funLabel.m_nSeries, funLabel.m_nGroup);
        if (bShowValue && dObj.m_bOK) {
            int nXValueRight = this.m_ptLRC.x + 1000;
            int nValueTextWidthVC = this.getTextWidthValueVC(funLabel);
            int nValueTextHeightVC = TextUtil.getFontSizeHeightVC(this.m_Perspective, idFunnelValueLabel);
            funLabel.m_rValueVC = new Rectangle(nXValueRight, nYMidPoint - nValueTextHeightVC, nValueTextWidthVC, nValueTextHeightVC);
            funLabel.m_ptLeftValueFeelerVC = new Point(nXLabelLineEndPtRight, nYMidPoint);
            funLabel.m_ptRightValueFeelerVC = new Point(this.m_ptLRC.x + 500, nYMidPoint - nValueTextHeightVC / 2);
        }
        if (bShowLabel) {
            int nXLabelLeft = this.m_ptULC.x - 1000;
            int nLabelTextHeightVC = TextUtil.getFontSizeHeightVC(this.m_Perspective, idFunnelLabel);
            int nLabelTextWidthVC = this.getTextWidthLabelVC(funLabel);
            funLabel.m_rLabelVC = new Rectangle(nXLabelLeft - nLabelTextWidthVC, nYMidPoint - nLabelTextHeightVC, nLabelTextWidthVC, nLabelTextHeightVC);
            int nXDiffToEndOfFrameRight = this.m_ptLRC.x - nXLabelLineEndPtRight;
            int nXLabelLineEndPtLeft = this.m_ptULC.x + nXDiffToEndOfFrameRight;
            funLabel.m_ptRightLabelFeelerVC = new Point(nXLabelLineEndPtLeft, nYMidPoint);
            funLabel.m_ptLeftLabelFeelerVC = new Point(this.m_ptULC.x - 500, nYMidPoint - nLabelTextHeightVC / 2);
        }
    }

    private void saveLabelsBothOnRight(int nBarHeight, int nXLabelLineEndPt, FunnelLabel funLabel) {
        IdentObj idFunnelValueLabel = Identity.FunnelValueLabel;
        boolean bShowValue = this.m_Perspective.getDisplay(idFunnelValueLabel);
        IdentObj idFunnelLabel = Identity.FunnelSliceLabel;
        boolean bShowLabel = this.m_Perspective.getDisplay(idFunnelLabel);
        int nYMidPoint = this.m_ptLRC.y + nBarHeight / 2;
        int nXRight = this.m_ptLRC.x + 1000;
        DatumObj dObj = this.getDataValue(funLabel.m_nSeries, funLabel.m_nGroup);
        if (bShowValue && dObj.m_bOK) {
            int nValueTextWidthVC = this.getTextWidthValueVC(funLabel);
            int nValueTextHeightVC = TextUtil.getFontSizeHeightVC(this.m_Perspective, idFunnelValueLabel);
            funLabel.m_rValueVC = new Rectangle(nXRight, nYMidPoint - nValueTextHeightVC, nValueTextWidthVC, nValueTextHeightVC);
            funLabel.m_ptLeftValueFeelerVC = new Point(nXLabelLineEndPt, nYMidPoint);
            funLabel.m_ptRightValueFeelerVC = new Point(this.m_ptLRC.x + 500, nYMidPoint - nValueTextHeightVC / 2);
        }
        if (bShowLabel) {
            int nLabelTextHeightVC = TextUtil.getFontSizeHeightVC(this.m_Perspective, idFunnelLabel);
            int nLabelTextWidthVC = this.getTextWidthLabelVC(funLabel);
            funLabel.m_rLabelVC = new Rectangle(nXRight, nYMidPoint, nLabelTextWidthVC, nLabelTextHeightVC);
            funLabel.m_ptLeftLabelFeelerVC = new Point(nXLabelLineEndPt, nYMidPoint);
            funLabel.m_ptRightLabelFeelerVC = new Point(this.m_ptLRC.x + 500, nYMidPoint + nLabelTextHeightVC / 2);
        }
    }

    public int getTextWidthLabelVC(FunnelLabel funLabel) {
        int nTextWidthValueVC = 4000;
        String strLabel = this.m_Perspective.getSeriesLabel(funLabel.m_nSeries);
        IdentObj idFunnelValueLabel = Identity.FunnelSliceLabel;
        Dimension dimTextVC = TextUtil.getTextDimensionVC(this.m_Perspective, idFunnelValueLabel, strLabel);
        nTextWidthValueVC = dimTextVC.width;
        return nTextWidthValueVC;
    }

    public int getTextWidthValueVC(FunnelLabel funLabel) {
        int nTextWidthValueVC = 4000;
        DatumObj dObj = this.getDataValue(funLabel.m_nSeries, funLabel.m_nGroup);
        if (dObj.m_bOK) {
            double fSeries = dObj.value;
            String strValue = this.getTextFormat().format(fSeries);
            IdentObj idFunnelValueLabel = Identity.FunnelValueLabel;
            Dimension dimTextVC = TextUtil.getTextDimensionVC(this.m_Perspective, idFunnelValueLabel, strValue);
            nTextWidthValueVC = dimTextVC.width;
        }
        return nTextWidthValueVC;
    }

    private void drawFunnelLabel(FunnelLabel funLabel) {
        IdentObj idFunnelValueLabel = new IdentObj(784, funLabel.m_nSeries, funLabel.m_nGroup);
        IdentObj idFunnelValueLabelBox = new IdentObj(820, funLabel.m_nSeries, funLabel.m_nGroup);
        boolean bShowValue = this.m_Perspective.getDisplay(idFunnelValueLabel);
        IdentObj idFunnelFeeler = Identity.FunnelFeeler;
        boolean bShowFeeler = this.m_Perspective.getDisplay(idFunnelFeeler);
        double fFeelerLineWidth = this.m_Perspective.getLineWidth(idFunnelFeeler);
        BlackBoxObj blackBoxFeeler = new BlackBoxObj(this.m_Perspective, idFunnelFeeler);
        IdentObj idFunnelLabel = new IdentObj(783, funLabel.m_nSeries, funLabel.m_nGroup);
        IdentObj idFunnelLabelBox = new IdentObj(819, funLabel.m_nSeries, funLabel.m_nGroup);
        boolean bShowLabel = this.m_Perspective.getDisplay(idFunnelLabel);
        DatumObj dObj = this.getDataValue(funLabel.m_nSeries, funLabel.m_nGroup);
        if (bShowValue && dObj.m_bOK && funLabel.m_rValueVC.getMaxY() <= this.m_rSubFrame.getMaxY()) {
            ITextStyle textStyleValueLabel = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, idFunnelValueLabel);
            if (bShowFeeler) {
                Java2DLine line2D = new Java2DLine(this.m_Perspective);
                line2D.createLine(idFunnelFeeler, idFunnelFeeler, funLabel.m_ptLeftValueFeelerVC.x, funLabel.m_ptLeftValueFeelerVC.y, funLabel.m_ptRightValueFeelerVC.x, funLabel.m_ptRightValueFeelerVC.y, blackBoxFeeler, null, fFeelerLineWidth);
            }
            assert (dObj.value == funLabel.value);
            double fSeries = this.m_displayValuesFormat == 0 ? funLabel.percent : funLabel.value;
            String strValue = this.getTextFormat().format(fSeries);
            AnnotationBox.calcBorderedBox(this.m_Perspective, idFunnelValueLabelBox, funLabel.m_rValueVC, true);
            BlackBoxObj blackBoxValueLabel = new BlackBoxObj(this.m_Perspective, idFunnelValueLabel);
            DrawFactory.createLabel(this.m_Perspective.getDetectiv(), idFunnelValueLabel, strValue, funLabel.m_rValueVC, textStyleValueLabel, blackBoxValueLabel, null);
        }
        if (bShowLabel && funLabel.m_rLabelVC.getMaxY() <= this.m_rSubFrame.getMaxY()) {
            if (bShowFeeler) {
                Java2DLine line2D = new Java2DLine(this.m_Perspective);
                line2D.createLine(idFunnelFeeler, idFunnelFeeler, funLabel.m_ptLeftLabelFeelerVC.x, funLabel.m_ptLeftLabelFeelerVC.y, funLabel.m_ptRightLabelFeelerVC.x, funLabel.m_ptRightLabelFeelerVC.y, blackBoxFeeler, null, fFeelerLineWidth);
            }
            AnnotationBox.calcBorderedBox(this.m_Perspective, idFunnelLabelBox, funLabel.m_rLabelVC, true);
            BlackBoxObj blackBoxLabel = new BlackBoxObj(this.m_Perspective, idFunnelLabel);
            String strLabel = this.m_Perspective.getSeriesLabel(funLabel.m_nSeries);
            ITextStyle textStyleLabel = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, idFunnelLabel);
            DrawFactory.createLabel(this.m_Perspective.getDetectiv(), idFunnelLabel, strLabel, funLabel.m_rLabelVC, textStyleLabel, blackBoxLabel, null);
        }
    }

    private void drawAboveNipple(int nSeries, int nGroup, int nBarHeight, int nXBottomInset, int nXTopInset, double fStartPercent, double fStopPercent) {
        int nLRTopY = this.m_ptLRC.y + nBarHeight;
        Point pt0 = new Point(this.m_ptULC.x + nXTopInset, nLRTopY);
        Point pt1 = new Point(this.m_ptLRC.x - nXTopInset, nLRTopY);
        Point pt2 = new Point(this.m_ptLRC.x - nXBottomInset, this.m_ptLRC.y);
        Point pt3 = new Point(this.m_ptULC.x + nXBottomInset, this.m_ptLRC.y);
        Polygon polyFace = new Polygon();
        polyFace.addPoint(pt0.x, pt0.y);
        polyFace.addPoint(pt1.x, pt1.y);
        polyFace.addPoint(pt2.x, pt2.y);
        polyFace.addPoint(pt3.x, pt3.y);
        this.m_nXLabelLineEndPt = (pt1.x + pt2.x) / 2 + 500;
        IdentObj idPolyDepthFace = new IdentObj(542, nSeries, nGroup);
        IBlackBox blackBoxFace = this.assignSeriesColor(nSeries, nGroup);
        if (this.m_bDepthEffect) {
            int nBoxWidth = this.widthOfBox();
            int nHalfEllipseTopWidth = (nBoxWidth - 2 * nXTopInset) / 2;
            int nHalfEllipseBotWidth = (nBoxWidth - 2 * nXBottomInset) / 2;
            int nHalfEllipseStopHeight = (int)((double)this.m_nPieMinDepth + (double)this.m_nDepthEffect * fStopPercent);
            int nHalfEllipseStartHeight = (int)((double)this.m_nPieMinDepth + (double)this.m_nDepthEffect * fStartPercent);
            int nXOffsetPieCenter = (this.m_ptULC.x + this.m_ptLRC.x) / 2;
            Polygon polyDepthBackTop = new Polygon();
            int nTopCount = this.arcWalkXAxis(nHalfEllipseTopWidth, nHalfEllipseStopHeight, 178, 364, nXOffsetPieCenter, this.m_ptLRC.y + nBarHeight, 1, 990, polyDepthBackTop);
            Polygon polyDepthBackBot = new Polygon();
            int nBottomCount = this.arcWalkXAxis(nHalfEllipseBotWidth, nHalfEllipseStartHeight, 180, 360, nXOffsetPieCenter, this.m_ptLRC.y, 1, 990, polyDepthBackBot);
            for (int n = 0; n < nBottomCount; ++n) {
                polyDepthBackTop.addPoint(polyDepthBackBot.xpoints[nBottomCount - n - 1], polyDepthBackBot.ypoints[nBottomCount - n - 1]);
            }
            polyDepthBackTop.addPoint(polyDepthBackTop.xpoints[0], polyDepthBackTop.ypoints[0]);
            IdentObj idPolyDepthBackFaceCrust = new IdentObj(543);
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), idPolyDepthBackFaceCrust, polyDepthBackTop, blackBoxFace, 0.6);
            Polygon polyDepthFrontTop = new Polygon();
            nTopCount = this.arcWalkXAxis((int)((double)nHalfEllipseTopWidth * 1.004), nHalfEllipseStopHeight, 5, 175, nXOffsetPieCenter, this.m_ptLRC.y + nBarHeight, 1, 990, polyDepthFrontTop);
            Polygon polyDepthFrontBot = new Polygon();
            nBottomCount = this.arcWalkXAxis((int)((double)nHalfEllipseBotWidth * 1.004), nHalfEllipseStartHeight, 5, 175, nXOffsetPieCenter, this.m_ptLRC.y, 1, 990, polyDepthFrontBot);
            for (int n = 0; n < nBottomCount; ++n) {
                polyDepthFrontTop.addPoint(polyDepthFrontBot.xpoints[nBottomCount - n - 1], polyDepthFrontBot.ypoints[nBottomCount - n - 1]);
            }
            polyDepthFrontTop.addPoint(polyDepthFrontTop.xpoints[0], polyDepthFrontTop.ypoints[0]);
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), idPolyDepthFace, polyDepthFrontTop, blackBoxFace, null);
        } else {
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), idPolyDepthFace, polyFace, blackBoxFace, null);
        }
    }

    private void drawTransectsNipple(int nSeries, int nGroup, int nBarHeight, int nXNippleInset, int nXTopInset, int nYNippleHeight, double fStartPercent, double fStopPercent) {
        int nLRTopY = this.m_ptLRC.y + nBarHeight;
        Point pt0 = new Point(this.m_ptULC.x + nXTopInset, nLRTopY);
        Point pt1 = new Point(this.m_ptLRC.x - nXTopInset, nLRTopY);
        Point pt2 = new Point(this.m_ptLRC.x - nXNippleInset, this.m_ptLRC.y + nYNippleHeight);
        Point pt3 = new Point(this.m_ptLRC.x - nXNippleInset, this.m_ptLRC.y);
        Point pt4 = new Point(this.m_ptULC.x + nXNippleInset, this.m_ptLRC.y);
        Point pt5 = new Point(this.m_ptULC.x + nXNippleInset, this.m_ptLRC.y + nYNippleHeight);
        Polygon polyFace = new Polygon();
        polyFace.addPoint(pt0.x, pt0.y);
        polyFace.addPoint(pt1.x, pt1.y);
        polyFace.addPoint(pt2.x, pt2.y);
        polyFace.addPoint(pt3.x, pt3.y);
        polyFace.addPoint(pt4.x, pt4.y);
        polyFace.addPoint(pt5.x, pt5.y);
        this.m_nXLabelLineEndPt = (pt1.x + pt2.x) / 2 + 500;
        IdentObj idPolyFace = new IdentObj(542, nSeries, nGroup);
        IBlackBox blackBoxFace = this.assignSeriesColor(nSeries, nGroup);
        if (this.m_bDepthEffect) {
            int nBoxWidth = this.widthOfBox();
            int nHalfEllipseTopWidth = (nBoxWidth - 2 * nXTopInset) / 2;
            int nHalfEllipseBotWidth = (nBoxWidth - 2 * nXNippleInset) / 2;
            int nHalfEllipseStopHeight = (int)((double)this.m_nPieMinDepth + (double)this.m_nDepthEffect * fStopPercent);
            int nHalfEllipseStartHeight = (int)((double)this.m_nPieMinDepth + (double)this.m_nDepthEffect * fStartPercent);
            int nXOffsetPieCenter = (this.m_ptULC.x + this.m_ptLRC.x) / 2;
            Polygon polyBackTop = new Polygon();
            int nTopCount = this.arcWalkXAxis(nHalfEllipseTopWidth, nHalfEllipseStopHeight, 178, 364, nXOffsetPieCenter, this.m_ptLRC.y + nBarHeight, 1, 990, polyBackTop);
            Polygon polyBackBot = new Polygon();
            int nBottomCount = this.arcWalkXAxis(nHalfEllipseBotWidth, nHalfEllipseStartHeight, 180, 360, nXOffsetPieCenter, this.m_ptLRC.y, 1, 990, polyBackBot);
            polyBackTop.addPoint(polyBackBot.xpoints[nBottomCount - 1], this.m_ptLRC.y + nYNippleHeight);
            for (int n = 0; n < nBottomCount; ++n) {
                polyBackTop.addPoint(polyBackBot.xpoints[nBottomCount - n - 1], polyBackBot.ypoints[nBottomCount - n - 1]);
            }
            polyBackTop.addPoint(polyBackTop.xpoints[(nTopCount += nBottomCount) - 1], this.m_ptLRC.y + nYNippleHeight);
            polyBackTop.addPoint(polyBackTop.xpoints[0], polyBackTop.ypoints[0]);
            IdentObj idPolyDepthBackCrust = new IdentObj(543);
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), idPolyDepthBackCrust, polyBackTop, blackBoxFace, 0.6);
            Polygon polyFrontTop = new Polygon();
            nTopCount = this.arcWalkXAxis((int)((double)nHalfEllipseTopWidth * 1.004), nHalfEllipseStopHeight, 5, 175, nXOffsetPieCenter, this.m_ptLRC.y + nBarHeight, 1, 990, polyFrontTop);
            Polygon polyFrontBot = new Polygon();
            nBottomCount = this.arcWalkXAxis((int)((double)nHalfEllipseBotWidth * 1.004), nHalfEllipseStartHeight, 5, 175, nXOffsetPieCenter, this.m_ptLRC.y, 1, 990, polyFrontBot);
            polyFrontTop.addPoint(polyFrontBot.xpoints[nBottomCount - 1], this.m_ptLRC.y + nYNippleHeight);
            for (int n = 0; n < nBottomCount; ++n) {
                polyFrontTop.addPoint(polyFrontBot.xpoints[nBottomCount - n - 1], polyFrontBot.ypoints[nBottomCount - n - 1]);
            }
            polyFrontTop.addPoint(polyFrontTop.xpoints[(nTopCount += nBottomCount) - 1], this.m_ptLRC.y + nYNippleHeight);
            polyFrontTop.addPoint(polyFrontTop.xpoints[0], polyFrontTop.ypoints[0]);
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), idPolyFace, polyFrontTop, blackBoxFace, null);
        } else {
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), idPolyFace, polyFace, blackBoxFace, null);
        }
    }

    private void drawBelowNipple(int nSeries, int nGroup, int nBarHeight, int nXNippleInset, int nYNippleHeight, double fStartPercent, double fStopPercent) {
        Point pt0 = new Point(this.m_ptULC.x + nXNippleInset, this.m_ptLRC.y + nBarHeight);
        Point pt1 = new Point(this.m_ptLRC.x - nXNippleInset, this.m_ptLRC.y + nBarHeight);
        Point pt2 = new Point(this.m_ptLRC.x - nXNippleInset, this.m_ptLRC.y);
        Point pt3 = new Point(this.m_ptULC.x + nXNippleInset, this.m_ptLRC.y);
        Polygon polyFace = new Polygon();
        polyFace.addPoint(pt0.x, pt0.y);
        polyFace.addPoint(pt1.x, pt1.y);
        polyFace.addPoint(pt2.x, pt2.y);
        polyFace.addPoint(pt3.x, pt3.y);
        this.m_nXLabelLineEndPt = (pt1.x + pt2.x) / 2 + 500;
        IdentObj idPolyFace = new IdentObj(542, nSeries, nGroup);
        IBlackBox blackBoxFace = this.assignSeriesColor(nSeries, nGroup);
        if (this.m_bDepthEffect) {
            int nBoxWidth = this.widthOfBox();
            int nHalfEllipseWidth = (nBoxWidth - 2 * nXNippleInset) / 2;
            int nXOffsetPieCenter = (this.m_ptULC.x + this.m_ptLRC.x) / 2;
            Polygon polyBackTop = new Polygon();
            int nTopCount = this.arcWalkXAxis(nHalfEllipseWidth, this.m_nPieMinDepth, 180, 360, nXOffsetPieCenter, this.m_ptLRC.y + nBarHeight, 1, 1000, polyBackTop);
            Polygon polyBackBot = new Polygon();
            int nBottomCount = this.arcWalkXAxis(nHalfEllipseWidth, this.m_nPieMinDepth, 180, 360, nXOffsetPieCenter, this.m_ptLRC.y, 1, 1000, polyBackBot);
            for (int n = 0; n < nBottomCount; ++n) {
                polyBackTop.addPoint(polyBackBot.xpoints[nBottomCount - n - 1], polyBackBot.ypoints[nBottomCount - n - 1]);
            }
            nTopCount += nBottomCount;
            polyBackTop.addPoint(polyBackTop.xpoints[0], polyBackTop.ypoints[0]);
            IdentObj idPolyDepthBackCrust = new IdentObj(543);
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), idPolyDepthBackCrust, polyBackTop, blackBoxFace, 0.6);
            Polygon polyFrontTop = new Polygon();
            nTopCount = this.arcWalkXAxis((int)((double)nHalfEllipseWidth * 1.004), this.m_nPieMinDepth, 5, 175, nXOffsetPieCenter, this.m_ptLRC.y + nBarHeight, 1, 1000, polyFrontTop);
            Polygon polyFrontBot = new Polygon();
            nBottomCount = this.arcWalkXAxis((int)((double)nHalfEllipseWidth * 1.004), this.m_nPieMinDepth, 5, 175, nXOffsetPieCenter, this.m_ptLRC.y, 1, 1000, polyFrontBot);
            for (int n = 0; n < nBottomCount; ++n) {
                polyFrontTop.addPoint(polyFrontBot.xpoints[nBottomCount - n - 1], polyFrontBot.ypoints[nBottomCount - n - 1]);
            }
            nTopCount += nBottomCount;
            polyFrontTop.addPoint(polyFrontTop.xpoints[0], polyFrontTop.ypoints[0]);
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), idPolyFace, polyFrontTop, blackBoxFace, null);
        } else {
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), idPolyFace, polyFace, blackBoxFace, null);
        }
    }

    private int arcWalkXAxis(int a, int b, int nStart, int nEnd, int xOffset, int yOffset, int nStepSize, int nMaxPoints, Polygon polyPoints) {
        int nCount = 0;
        nStepSize = 1;
        while (a / nStepSize > 200) {
            ++nStepSize;
        }
        if (nStart < nEnd) {
            Point ptStart = this.findPtFromAngle(nStart, a, b);
            Point ptEnd = this.findPtFromAngle(nEnd, a, b);
            int nStartQuad = this.findQuadrantAngle(nStart);
            Point ptCurr = new Point(ptStart);
            int nCurrQuad = nStartQuad;
            Point ptLast = new Point(ptCurr);
            int nFullCircle = ptStart.x == ptEnd.x && ptStart.y == ptEnd.y && nStart + 180 < nEnd ? a * 2 : 0;
            while (!(this.ptOnRectangle(a, b, ptLast, ptEnd, ptCurr) && nFullCircle == 0 || nCount >= nMaxPoints - 4)) {
                double ry;
                if (nFullCircle != 0) {
                    --nFullCircle;
                }
                Point ptDest = this.transformSavePoint(ptCurr, xOffset, yOffset);
                polyPoints.addPoint(ptDest.x, ptDest.y);
                ++nCount;
                ptLast = new Point(ptCurr);
                for (int nLoop = 0; nLoop < nStepSize; ++nLoop) {
                    if (ptCurr.x == a && ptCurr.y < 0) {
                        nCurrQuad = 1;
                        break;
                    }
                    if (ptCurr.x == -a && ptCurr.y > 0) {
                        nCurrQuad = 3;
                        break;
                    }
                    ptCurr.x = ptCurr.x > -a && (nCurrQuad == 1 || nCurrQuad == 2) ? --ptCurr.x : ++ptCurr.x;
                    if (ptCurr.x == a) {
                        nCurrQuad = 1;
                    } else if (ptCurr.x == 0 || ptCurr.x == -a) {
                        ++nCurrQuad;
                    }
                    if (Math.abs(ptCurr.x) == a || ptCurr.x == 0) break;
                }
                if ((ry = this.findYOnEllipse(a, b, ptCurr.x, nCurrQuad)) > 0.0) {
                    ptCurr.y = (int)(ry + 0.5);
                    continue;
                }
                ptCurr.y = (int)(ry - 0.5);
            }
            ptEnd = this.transformSavePoint(ptEnd, xOffset, yOffset);
            polyPoints.addPoint(ptEnd.x, ptEnd.y);
            ++nCount;
        }
        return nCount;
    }

    public int widthOfBox() {
        int nWidth = Math.abs(this.m_ptLRC.x - this.m_ptULC.x);
        return nWidth;
    }

    public int heightOfBox() {
        int nHeight = Math.abs(this.m_ptULC.y - this.m_ptLRC.y);
        return nHeight;
    }

    private Point transformSavePoint(Point ptSrc, int xOffset, int yOffset) {
        Point ptDest = new Point();
        ptDest.x = ptSrc.x + xOffset;
        ptDest.y = -ptSrc.y + yOffset;
        return ptDest;
    }

    public boolean ptOnRectangle(int a, int b, Point ptLast, Point ptRef, Point ptCurr) {
        if (ptCurr.x <= ptRef.x && ptRef.x <= ptLast.x) {
            if (ptRef.y <= ptLast.y && ptRef.y >= ptCurr.y) {
                return true;
            }
            if (ptRef.y >= ptLast.y && ptRef.y <= ptCurr.y) {
                return true;
            }
        }
        if (ptLast.x <= ptRef.x && ptRef.x <= ptCurr.x) {
            if (ptRef.y <= ptLast.y && ptRef.y >= ptCurr.y) {
                return true;
            }
            if (ptRef.y >= ptLast.y && ptRef.y <= ptCurr.y) {
                return true;
            }
        }
        return false;
    }

    private int findQuadrantAngle(int nAngle) {
        while (nAngle >= 360) {
            nAngle -= 360;
        }
        if (nAngle < 90) {
            return 1;
        }
        if (nAngle < 180) {
            return 2;
        }
        if (nAngle < 270) {
            return 3;
        }
        return 4;
    }

    private Point findPtFromAngle(int nAngleDeg, int aa, int bb) {
        double ry;
        double rx;
        int nWidth = Math.abs(aa);
        int nHeight = Math.abs(bb);
        while (nAngleDeg >= 360) {
            nAngleDeg -= 360;
        }
        int nQuad = this.findQuadrantAngle(nAngleDeg);
        if (nQuad == 2) {
            nAngleDeg = 180 - nAngleDeg;
        } else if (nQuad == 3) {
            nAngleDeg -= 180;
        } else if (nQuad == 4) {
            nAngleDeg = 360 - nAngleDeg;
        }
        switch (nAngleDeg) {
            case 0: {
                rx = nWidth;
                ry = 0.0;
                break;
            }
            case 90: {
                rx = 0.0;
                ry = nHeight;
                break;
            }
            default: {
                double fAngleRadians = Math.tan((double)nAngleDeg * (Math.PI / 180));
                double rT = fAngleRadians * (double)nHeight / (double)nWidth;
                rx = Math.sqrt(1.0 / (1.0 / ((double)nWidth * (double)nWidth) + rT * rT / ((double)nHeight * (double)nHeight)));
                ry = this.findYOnEllipse(nWidth, nHeight, rx, 1);
                if ((int)(rx += 0.5) == nWidth && (int)(ry += 0.5) == 0) {
                    ry = 1.0;
                }
                if ((int)ry != nHeight || (int)rx != 0) break;
                rx = 1.0;
            }
        }
        Point pt = new Point();
        switch (nQuad) {
            case 1: {
                pt.x = (int)rx;
                pt.y = (int)ry;
                break;
            }
            case 2: {
                pt.x = (int)(-rx);
                pt.y = (int)ry;
                break;
            }
            case 3: {
                pt.x = (int)(-rx);
                pt.y = (int)(-ry);
                break;
            }
            case 4: {
                pt.x = (int)rx;
                pt.y = (int)(-ry);
            }
        }
        return pt;
    }

    private double findYOnEllipse(int a, int b, double fX, int nQuadrant) {
        double fY = 0.0;
        if (Math.abs(fX) <= (double)a) {
            if (Math.abs(fX) == (double)a) {
                fY = 0.0;
            } else {
                fY = Math.sqrt((double)b * (double)b * (1.0 - fX * fX / ((double)a * (double)a)));
                if (nQuadrant == 3 || nQuadrant == 4) {
                    fY = -fY;
                }
            }
        }
        return fY;
    }

    public Format getTextFormat() {
        return this.m_Perspective.getPieSliceValueLabelTextFormat();
    }
}

