/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DetLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;

public class Java2DLine {
    private static final BasicStroke BASIC_STROKE = new BasicStroke();
    private Perspective m_Perspective;
    static Java2DLine line = new Java2DLine(null);

    public Java2DLine(Perspective persp) {
        this.m_Perspective = persp;
    }

    public static void createLine(Perspective p, IdentObj id, int x1, int y1, int x2, int y2, IBlackBox blackBox) {
        Java2DLine.line.m_Perspective = p;
        line.createLine(id, id, x1, y1, x2, y2, blackBox, null, p.getLineWidth(id));
    }

    public DetLine createLine(IdentObj idUntouched, IdentObj id, int x1, int y1, int x2, int y2, IBlackBox blackBox, Rectangle rClip, double fLineWidth) {
        DetLine detLine = null;
        Stroke stroke = Java2DLine.getPenStroke(this.m_Perspective, idUntouched, fLineWidth);
        detLine = new DetLine(this.m_Perspective.getDetectiv(), id, x1, y1, x2, y2, blackBox, stroke, rClip);
        return detLine;
    }

    static void paintLine(Graphics2D g2, Color col, Point a, Point b, Stroke penStroke) {
        Stroke oldStroke = g2.getStroke();
        g2.setColor(col);
        g2.setStroke(penStroke);
        g2.drawLine(a.x, a.y, b.x, b.y);
        g2.setStroke(oldStroke);
    }

    static Stroke getPenStroke(Perspective p, IdentObj id, double lineWidth) {
        int nStrokeType = p.getLineBasicStrokeType(id);
        double fLineWidth = Math.max(lineWidth, (double)p.getMinLineWidthDC(id));
        int nCap = 0;
        int nJoin = 0;
        double fMiterlimit = 0.0;
        double[] fArrayDash = null;
        double fDashPhase = 0.0;
        if (nStrokeType > 2) {
            nCap = p.getLineCap(id);
            nJoin = p.getLineJoin(id);
            fMiterlimit = p.getLineMiterLimit(id);
            fArrayDash = p.getLineDashArray(id);
            fDashPhase = p.getLineDashPhase(id);
        } else {
            nStrokeType = 2;
        }
        return Java2DLine.createStroke(nStrokeType, fLineWidth, nCap, nJoin, fMiterlimit, fArrayDash, fDashPhase);
    }

    private static Stroke createStroke(int nStrokeType, double fWidth, int nCap, int nJoin, double fMiterlimit, double[] fArrayDash, double fDashPhase) {
        BasicStroke stroke;
        switch (nStrokeType) {
            default: {
                stroke = BASIC_STROKE;
                break;
            }
            case 2: {
                stroke = new BasicStroke((float)fWidth, 1, 1);
                break;
            }
            case 3: {
                stroke = new BasicStroke((float)fWidth, nCap, nJoin);
                break;
            }
            case 4: {
                stroke = new BasicStroke((float)fWidth, nCap, nJoin, (float)fMiterlimit);
                break;
            }
            case 5: {
                stroke = new BasicStroke((float)fWidth, nCap, nJoin, (float)fMiterlimit, Java2DLine.doubleToFloatArray(fArrayDash), (float)fDashPhase);
            }
        }
        return stroke;
    }

    static Stroke createSimpleStroke() {
        return BASIC_STROKE;
    }

    public static float[] doubleToFloatArray(double[] values) {
        float[] result = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = (float)values[i];
        }
        return result;
    }
}

