/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ColorPinObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.GradientPaintExt;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.RadialGradientPaintExt;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utilities.OutOfRangeException;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorPinStripeObj {
    private final List<ColorPinObj> pins = new ArrayList<ColorPinObj>();
    private Color[] m_colors = null;
    private double[] stopPoints = null;

    private ColorPinStripeObj(List<ColorPinObj> pins) {
        this.pins.addAll(pins);
        this.updateStopPoints();
    }

    private ColorPinStripeObj(Color leftColor, Color rightColor) {
        ColorPinObj pin = new ColorPinObj(0.0, leftColor, leftColor);
        this.pins.add(pin);
        pin = new ColorPinObj(1.0, rightColor, rightColor);
        this.pins.add(pin);
        this.updateStopPoints();
    }

    public ColorPinStripeObj() {
        this(Color.BLUE, Color.BLACK);
    }

    public ColorPinStripeObj(Color[] colors, double[] positions) {
        if (colors == null || positions == null) {
            throw new RuntimeException("null data.");
        }
        int nLen = positions.length;
        if (nLen == colors.length) {
            for (int i = 0; i < nLen; ++i) {
                ColorPinObj pin = new ColorPinObj(positions[i], colors[i], colors[i]);
                this.pins.add(pin);
            }
        } else if (2 * nLen == colors.length) {
            int i2 = 0;
            for (int i = 0; i < nLen; ++i) {
                Color rightColor = colors[i2];
                Color leftColor = colors[++i2];
                ++i2;
                ColorPinObj pin = new ColorPinObj(positions[i], rightColor, leftColor);
                this.pins.add(pin);
            }
        } else {
            throw new RuntimeException("Number of positions  should equal or double the number of colors.");
        }
        this.updateStopPoints();
    }

    ColorPinStripeObj restrictColorStripe(Point2D.Double ptStart, double fStart, Point2D.Double ptEnd, double fEnd) {
        if (fStart > fEnd) {
            throw new IllegalArgumentException("Start greater than end.");
        }
        if (fStart == fEnd) {
            Color color1 = this.getColorAt(fStart);
            return new ColorPinStripeObj(color1, color1);
        }
        double fStart1 = 0.0;
        double fEnd1 = 0.0;
        double fPos1 = 0.0;
        double fPos2 = 0.0;
        Iterator<ColorPinObj> it = this.pins.iterator();
        ColorPinObj pinObj1 = null;
        ColorPinObj pinObj2 = null;
        while (it.hasNext()) {
            pinObj1 = pinObj2;
            fPos1 = fPos2;
            pinObj2 = it.next();
            fPos2 = pinObj2.getPosition();
            if (!(fStart <= fPos2)) continue;
        }
        if (pinObj1 == null) {
            fStart1 = fPos2;
        } else if (pinObj2 != null) {
            fStart1 = fPos1;
        }
        while (it.hasNext() && !(fEnd < fPos2)) {
            pinObj1 = pinObj2;
            fPos1 = fPos2;
            pinObj2 = it.next();
            fPos2 = pinObj2.getPosition();
        }
        if (pinObj1 == pinObj2) {
            Color color1 = pinObj1.getRightColor();
            return new ColorPinStripeObj(color1, color1);
        }
        fEnd1 = fPos2;
        if (fStart1 >= fEnd1) {
            Color color1 = pinObj2.getLeftColor();
            return new ColorPinStripeObj(color1, color1);
        }
        ColorPinStripeObj returnObj = this.restrictColorStripe(fStart1, fEnd1);
        ColorPinStripeObj.relocateGradientPoints(fStart, fEnd, fStart1, fEnd1, ptStart, ptEnd);
        return returnObj;
    }

    private final ColorPinStripeObj restrictColorStripe(double fStart, double fEnd) {
        if (fStart > fEnd || FP.equal(fStart, fEnd)) {
            throw new IllegalArgumentException("Start greater/equal the end.");
        }
        ArrayList<ColorPinObj> pins = new ArrayList<ColorPinObj>();
        Color color1 = null;
        Color color2 = null;
        ColorPinObj pin = null;
        double fCoeff = 1.0 / (fEnd - fStart);
        double fPos = 0.0;
        for (ColorPinObj pinObj : pins) {
            fPos = pinObj.getPosition();
            if (fPos < fStart) continue;
            if (fPos > fEnd) break;
            color1 = pinObj.getLeftColor();
            color2 = pinObj.getRightColor();
            fPos = (fPos - fStart) * fCoeff;
            pin = new ColorPinObj(fPos, color1, color2);
            pins.add(pin);
        }
        return new ColorPinStripeObj(pins);
    }

    public static final void relocateGradientPoints(double fS, double fE, double fS1, double fE1, Point2D.Double ptStart, Point2D.Double ptEnd) {
        double fDelta = fE - fS;
        if (!FP.nonzero(fDelta)) {
            throw new IllegalArgumentException("fS equals fE");
        }
        double vectX = (ptEnd.getX() - ptStart.getX()) / fDelta;
        double vectY = (ptEnd.getY() - ptStart.getY()) / fDelta;
        double s = fS1 - fS;
        ptStart.x += s * vectX;
        ptStart.y += s * vectY;
        s = fE1 - fE;
        ptEnd.x += s * vectX;
        ptEnd.y += s * vectY;
    }

    public void copy(ColorPinStripeObj cpso) {
        this.pins.clear();
        for (int i = 0; i < cpso.pins.size(); ++i) {
            ColorPinObj pinFrom = cpso.pins.get(i);
            ColorPinObj pinTo = new ColorPinObj();
            pinTo.copy(pinFrom);
            this.pins.add(pinTo);
        }
        this.updateStopPoints();
    }

    public final boolean copyGradientColors(List<ColorPinObj> colors) {
        if (((Object)this.pins).equals(colors)) {
            return false;
        }
        colors.clear();
        for (int i = 0; i < this.pins.size(); ++i) {
            ColorPinObj pinFrom = this.pins.get(i);
            ColorPinObj pinTo = new ColorPinObj();
            pinTo.copy(pinFrom);
            colors.add(pinTo);
        }
        return true;
    }

    public final double[] getPositions() {
        int nLen = this.pins.size();
        double[] fPos = new double[nLen];
        int i = 0;
        for (ColorPinObj pin : this.pins) {
            fPos[i] = pin.getPosition();
            ++i;
        }
        return fPos;
    }

    public final Color[] getLowerColors() {
        int nLen = this.pins.size();
        Color[] colors = new Color[nLen];
        int i = 0;
        for (ColorPinObj pin : this.pins) {
            colors[i] = pin.getRightColor();
            ++i;
        }
        return colors;
    }

    public final Color[] getUpperColors() {
        int nLen = this.pins.size();
        Color[] colors = new Color[nLen];
        int i = -1;
        ColorPinObj pin = null;
        Iterator<ColorPinObj> it = this.pins.iterator();
        while (it.hasNext()) {
            if (i >= 0) {
                pin = it.next();
                colors[i] = pin.getLeftColor();
            }
            ++i;
        }
        colors[nLen - 1] = pin.getRightColor();
        return colors;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColorPinStripeObj)) {
            return false;
        }
        ColorPinStripeObj cpso = (ColorPinStripeObj)obj;
        return ((Object)this.pins).equals(cpso.pins);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + ((Object)this.pins).hashCode();
        return result;
    }

    public int findClosestPin(double fValue) {
        if (fValue < 0.0 || fValue > 1.0) {
            throw new IllegalArgumentException();
        }
        double fDist = 1.0;
        int nClosest = 0;
        for (int nPin = 0; nPin < this.pins.size(); ++nPin) {
            ColorPinObj pin = this.pins.get(nPin);
            if (!(Math.abs(pin.getPosition() - fValue) < fDist)) continue;
            fDist = Math.abs(pin.getPosition() - fValue);
            nClosest = nPin;
        }
        return nClosest;
    }

    public void updateStopPoints() {
        Color obj;
        ColorPinObj pin;
        int nLen = this.pins.size();
        if (nLen == 1) {
            pin = this.pins.get(0);
            obj = pin.getRightColor();
            pin.setColor(obj, obj);
        } else if (nLen > 1) {
            pin = this.pins.get(nLen - 1);
            obj = pin.getLeftColor();
            pin.setColor(obj, obj);
        }
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        Color color1 = null;
        Color color2 = null;
        double fStop = 0.0;
        for (ColorPinObj pin2 : this.pins) {
            fStop = pin2.getPosition();
            color1 = pin2.getLeftColor();
            list.add(new Float(fStop));
            list.add(color1);
            color2 = pin2.getRightColor();
            if (color2.equals(color1)) continue;
            list.add(new Float(fStop));
            list.add(color2);
        }
        int nSize = list.size() / 2;
        this.m_colors = new Color[nSize];
        this.stopPoints = new double[nSize];
        for (int i = 0; i < nSize; ++i) {
            int i2 = i + i;
            this.stopPoints[i] = ((Float)list.get(i2)).doubleValue();
            this.m_colors[i] = (Color)list.get(i2 + 1);
        }
    }

    public final Paint createGradientPaint(Point2D ptStart, Point2D ptEnd, double fIntensity) {
        int i;
        int nLen = this.m_colors.length;
        Color[] colors = null;
        Color color0 = null;
        Color color1 = null;
        if (nLen == 0) {
            throw new IllegalArgumentException("Illegal ColorPinStripeObj: no colors.");
        }
        if (nLen == 1 || ptStart.equals(ptEnd)) {
            color0 = ColorPinStripeObj.multiplyByIntensity(this.m_colors[0], fIntensity);
            return color0;
        }
        if (nLen == 2) {
            color0 = ColorPinStripeObj.multiplyByIntensity(this.m_colors[0], fIntensity);
            if (color0.equals(color1 = ColorPinStripeObj.multiplyByIntensity(this.m_colors[1], fIntensity))) {
                return color0;
            }
            return new GradientPaint(ptStart, color0, ptEnd, color1);
        }
        double[] intervals = new double[nLen - 1];
        if (fIntensity == 1.0) {
            colors = this.m_colors;
        } else {
            colors = new Color[this.m_colors.length];
            for (i = nLen - 1; i >= 0; --i) {
                colors[i] = ColorPinStripeObj.multiplyByIntensity(this.m_colors[i], fIntensity);
            }
        }
        for (i = nLen - 2; i > 0; --i) {
            intervals[i - 1] = this.stopPoints[i] - this.stopPoints[i - 1];
        }
        return new GradientPaintExt(ptStart, ptEnd, intervals, colors, false);
    }

    public static Color multiplyByIntensity(Color color, double fIntensity) {
        if (FP.equal(fIntensity, 1.0)) {
            return color;
        }
        float[] tempArray = new float[3];
        color.getRGBColorComponents(tempArray);
        int i = 0;
        while (i < 3) {
            int n = i++;
            tempArray[n] = (float)((double)tempArray[n] * fIntensity);
        }
        return new Color(tempArray[0], tempArray[1], tempArray[2]);
    }

    public final Paint createRadialGradientPaint(Rectangle2D bounds, double fIntensity) {
        int i;
        int nLen = this.m_colors.length;
        Color[] colors = null;
        if (nLen == 0) {
            throw new IllegalArgumentException("Illegal ColorPinStripeObj: no colors.");
        }
        double[] intervals = new double[nLen - 1];
        if (fIntensity == 1.0) {
            colors = this.m_colors;
        } else {
            colors = new Color[this.m_colors.length];
            for (i = this.m_colors.length; i >= 0; --i) {
                colors[i] = ColorPinStripeObj.multiplyByIntensity(this.m_colors[i], fIntensity);
            }
        }
        for (i = nLen - 1; i > 0; --i) {
            intervals[i - 1] = this.stopPoints[i] - this.stopPoints[i - 1];
        }
        RadialGradientPaintExt paint1 = new RadialGradientPaintExt(bounds, colors, intervals);
        return paint1;
    }

    public Color getColorAt(double fValue) {
        if (fValue < 0.0) {
            fValue = 0.0;
        } else if (fValue > 1.0) {
            fValue = 1.0;
        }
        fValue = (double)((int)(100.0 * fValue)) / 100.0;
        int nSize = this.pins.size();
        int red = 0;
        int green = 0;
        int blue = 0;
        int alpha = 0;
        for (int i = 0; i < nSize - 1; ++i) {
            ColorPinObj leftPin = this.pins.get(i);
            ColorPinObj rightPin = this.pins.get(i + 1);
            if (!(fValue >= leftPin.getPosition()) || !(fValue <= rightPin.getPosition())) continue;
            double fraction = (fValue - leftPin.getPosition()) / (rightPin.getPosition() - leftPin.getPosition());
            red = (int)((double)leftPin.getRightColor().getRed() + fraction * (double)(rightPin.getLeftColor().getRed() - leftPin.getRightColor().getRed()));
            green = (int)((double)leftPin.getRightColor().getGreen() + fraction * (double)(rightPin.getLeftColor().getGreen() - leftPin.getRightColor().getGreen()));
            blue = (int)((double)leftPin.getRightColor().getBlue() + fraction * (double)(rightPin.getLeftColor().getBlue() - leftPin.getRightColor().getBlue()));
            alpha = (int)((double)leftPin.getRightColor().getAlpha() + fraction * (double)(rightPin.getLeftColor().getAlpha() - leftPin.getRightColor().getAlpha()));
            break;
        }
        return new Color(red, green, blue, alpha);
    }

    public void insertPin(double fValue, Color color) {
        this.insertPin(fValue, color, color);
    }

    public void insertPin(double fValue, Color leftColor, Color rightColor) {
        if (fValue < 0.0 || fValue > 1.0) {
            throw new IllegalArgumentException();
        }
        int nClosestPin = this.findClosestPin(fValue);
        ColorPinObj closestPin = this.pins.get(nClosestPin);
        if (Math.abs(closestPin.getPosition() - fValue) < 0.001) {
            closestPin.setColor(leftColor, rightColor);
        } else {
            ColorPinObj pin = new ColorPinObj(fValue, leftColor, rightColor);
            if (closestPin.getPosition() > fValue) {
                this.pins.add(nClosestPin, pin);
            } else {
                this.pins.add(nClosestPin + 1, pin);
            }
        }
        this.updateStopPoints();
    }

    public int getNumPins() {
        return this.pins.size();
    }

    public void getPinColors(int nPin, Color leftColor, Color rightColor) {
        if (nPin < 0 || nPin >= this.pins.size()) {
            throw new OutOfRangeException(0.0, this.pins.size() - 1, (double)nPin);
        }
        ColorPinObj pin = this.pins.get(nPin);
        leftColor = pin.getLeftColor();
        rightColor = pin.getRightColor();
    }

    public void deletePin(int nPin) {
        if (nPin <= 0 || nPin >= this.pins.size() - 1) {
            throw new OutOfRangeException(1.0, this.pins.size() - 2, (double)nPin);
        }
        this.pins.remove(nPin);
        this.updateStopPoints();
    }

    public void setPinColors(int nPin, Color leftColor, Color rightColor) {
        if (nPin < 0 || nPin >= this.pins.size()) {
            throw new OutOfRangeException(0.0, this.pins.size() - 1, (double)nPin);
        }
        ColorPinObj pin = this.pins.get(nPin);
        pin.setColor(leftColor, rightColor);
        if (this.m_colors != null) {
            this.m_colors[2 * nPin] = leftColor;
            this.m_colors[2 * nPin + 1] = rightColor;
        }
    }

    public void setPinPosition(int nPin, double fPosition) {
        if (nPin <= 0 || nPin >= this.pins.size() - 1) {
            throw new OutOfRangeException(1.0, this.pins.size() - 2, (double)nPin);
        }
        ColorPinObj pin = this.pins.get(nPin);
        this.pins.remove(nPin);
        this.insertPin(fPosition, pin.getLeftColor(), pin.getRightColor());
    }

    public void getPinPosition(int nPin, double fPosition) {
        if (nPin < 0 || nPin > this.pins.size() - 1) {
            throw new OutOfRangeException(0.0, this.pins.size() - 1, (double)nPin);
        }
        ColorPinObj pin = this.pins.get(nPin);
        fPosition = pin.getPosition();
    }

    public String toString() {
        return this.pins.toString();
    }
}

