/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.data;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataRange;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.IDataStorage;

public class DataStorageFastDouble
implements IDataStorage {
    public static final int USER_PAGE = 0;
    public static final int MISSING_DATA_PAGE = 1;
    private double[][] m_data;
    private boolean[][] m_missingData;
    private DataRange m_DataExtents;

    public void dumpStorage() {
        System.out.println("Dump Storage fast double not implemented");
    }

    public void copy(IDataStorage ds) {
        if (ds instanceof DataStorageFastDouble) {
            throw new IllegalArgumentException("Not implemented yet");
        }
        throw new IllegalArgumentException("DataStorageFastDouble copy must use copy from same type");
    }

    public void setExtents(int numRows, int numColumns) {
        this.m_DataExtents = new DataRange();
        this.m_data = new double[numRows][numColumns];
        this.m_missingData = new boolean[numRows][numColumns];
        this.m_DataExtents.extendTo(numRows, numColumns);
    }

    public double getDataAsDouble(int row, int col) {
        return this.m_data[row][col];
    }

    public DataRange getDataExtents() {
        return this.m_DataExtents;
    }

    public boolean isCellNumeric(int row, int col) {
        return true;
    }

    public void setData(int row, int col, double fValue) {
        this.m_missingData[row][col] = false;
        this.m_data[row][col] = fValue;
    }

    public void setData(int row, int col, Object obj) {
        if (obj == null) {
            this.setData(row, col, Double.NaN);
        } else if (obj instanceof Number) {
            this.setData(row, col, ((Number)obj).doubleValue());
        } else {
            throw new IllegalArgumentException("setData() object parameter must be a number");
        }
    }

    public void setFillMissingData(int row, int col, boolean bFillMissingData) {
        this.m_missingData[row][col] = bFillMissingData;
    }

    public boolean isMissingDataFilledIn(int row, int col) {
        return this.m_missingData[row][col];
    }

    public Object getData(int row, int col) {
        double d = this.getDataAsDouble(row, col);
        if (Double.isNaN(d)) {
            return null;
        }
        return new Double(d);
    }

    public String getDataAsString(int row, int col) {
        double d = this.getDataAsDouble(row, col);
        if (Double.isNaN(d)) {
            return null;
        }
        return new Double(d).toString();
    }

    public static boolean isObjectNumeric(Object obj) {
        return true;
    }

    public void deleteRow(int row) {
        throw new IllegalArgumentException("Not Implemented");
    }

    public void deleteCol(int col) {
        throw new IllegalArgumentException("Not Implemented");
    }
}

