/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.ScaledNumberFormat;
import java.text.DecimalFormatSymbols;

public class PredefinedNumberFormat
extends ScaledNumberFormat {
    private String predefinedType = null;

    private PredefinedNumberFormat(String predefinedType, String pattern, DecimalFormatSymbols symbols, double scaleFactor) {
        super(pattern, symbols, scaleFactor);
        this.predefinedType = predefinedType;
    }

    public static PredefinedNumberFormat createPredefinedNumberFormat(String predefinedType, DecimalFormatSymbols symbols) {
        if ("nodecimal".equals(predefinedType)) {
            return new PredefinedNumberFormat(predefinedType, "#,##0", symbols, 1.0);
        }
        if ("onedecimal".equals(predefinedType)) {
            return new PredefinedNumberFormat(predefinedType, "#,##0.0", symbols, 1.0);
        }
        if ("twodecimal".equals(predefinedType)) {
            return new PredefinedNumberFormat(predefinedType, "#,##0.00", symbols, 1.0);
        }
        if ("currencynodecimal".equals(predefinedType)) {
            return new PredefinedNumberFormat(predefinedType, "\u00a4#,##0;(\u00a4\u00a4#,##0)", symbols, 1.0);
        }
        if ("currencytwodecimal".equals(predefinedType)) {
            return new PredefinedNumberFormat(predefinedType, "\u00a4#,##0.00;(\u00a4\u00a4#,##0.00)", symbols, 1.0);
        }
        if ("percentnodecimal".equals(predefinedType)) {
            return new PredefinedNumberFormat(predefinedType, "#0%", symbols, 1.0);
        }
        if ("percentonedecimal".equals(predefinedType)) {
            return new PredefinedNumberFormat(predefinedType, "#0.0%", symbols, 1.0);
        }
        if ("percenttwodecimal".equals(predefinedType)) {
            return new PredefinedNumberFormat(predefinedType, "#0.00%", symbols, 1.0);
        }
        if ("thousandsnodecimal".equals(predefinedType)) {
            return new PredefinedNumberFormat(predefinedType, "#,##0K", symbols, 1000.0);
        }
        if ("millionsnodecimal".equals(predefinedType)) {
            return new PredefinedNumberFormat(predefinedType, "#,##0M", symbols, 1000000.0);
        }
        if ("currencythousands".equals(predefinedType)) {
            return new PredefinedNumberFormat(predefinedType, "\u00a4#,##0K;(\u00a4\u00a4#,##0K)", symbols, 1000.0);
        }
        if ("currencymillions".equals(predefinedType)) {
            return new PredefinedNumberFormat(predefinedType, "\u00a4#,##0M;(\u00a4\u00a4#,##0M)", symbols, 1000000.0);
        }
        assert (false) : "invalid predefined number format";
        return null;
    }

    public String getPredefinedType() {
        return this.predefinedType;
    }
}

