/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;

public class MarkerTemplate {
    public static final int MARKER_NULL = 0;
    public static final int MARKER_RECT = 1;
    public static final int MARKER_OVAL = 2;
    public static final int MARKER_POLYGON = 3;
    public static final int MARKER_REFERENCELINE = 4;
    public static final int UNIT = 900;
    private static final int HALF = 450;
    private static final int THIRD = 300;
    private static final int QUARTER = 225;
    private static final int THREEQUARTERS = 675;
    public static final Rectangle MARKER_SQUARE = new Rectangle(-900, -900, 1800, 1800);
    public static final Rectangle MARKER_LINE = new Rectangle(-900, -450, 1800, 450);
    private static final int[] MARKER_REF_X = new int[]{-900, 900, 900, -900};
    private static final int[] MARKER_REF_Y = new int[]{-1, -1, 1, 1};
    public static final Polygon MARKER_REFERENCE_LINE = new Polygon(MARKER_REF_X, MARKER_REF_Y, 4);
    private static final int nXFortyFiveDeg = (int)(900.0 * Math.cos(0.7853981633974483));
    private static final int nYFortyFiveDeg = (int)(900.0 * Math.sin(0.7853981633974483));
    private static final int[] MARKER_DEPTHCIRCLE_X = new int[]{900, nXFortyFiveDeg, 0, -nXFortyFiveDeg, -900, -nXFortyFiveDeg, 0, nXFortyFiveDeg};
    private static final int[] MARKER_DEPTHCIRCLE_Y = new int[]{0, nYFortyFiveDeg, 900, nYFortyFiveDeg, 0, -nYFortyFiveDeg, -900, -nYFortyFiveDeg};
    public static final Polygon MARKER_DEPTHCIRCLE = new Polygon(MARKER_DEPTHCIRCLE_X, MARKER_DEPTHCIRCLE_Y, 8);
    private static final int[] MARKER_DIAMOND_X = new int[]{900, 0, -900, 0};
    private static final int[] MARKER_DIAMOND_Y = new int[]{0, 900, 0, -900};
    public static final Polygon MARKER_DIAMOND = new Polygon(MARKER_DIAMOND_X, MARKER_DIAMOND_Y, 4);
    private static final int[] MARKER_PLUS_X = new int[]{900, 300, 300, -300, -300, -900, -900, -300, -300, 300, 300, 900};
    private static final int[] MARKER_PLUS_Y = new int[]{300, 300, 900, 900, 300, 300, -300, -300, -900, -900, -300, -300};
    public static final Polygon MARKER_PLUS = new Polygon(MARKER_PLUS_X, MARKER_PLUS_Y, 12);
    private static final int[] MARKER_THICKPLUS_X = new int[]{900, 450, 450, -450, -450, -900, -900, -450, -450, 450, 450, 900};
    private static final int[] MARKER_THICKPLUS_Y = new int[]{450, 450, 900, 900, 450, 450, -450, -450, -900, -900, -450, -450};
    public static final Polygon MARKER_THICKPLUS = new Polygon(MARKER_THICKPLUS_X, MARKER_THICKPLUS_Y, 12);
    private static final int YVAL = (int)(900.0 * Math.sqrt(3.0) / 2.0);
    private static final int[] MARKER_TRIANGLE_DOWN_X = new int[]{900, 0, -900};
    private static final int[] MARKER_TRIANGLE_DOWN_Y = new int[]{YVAL, -YVAL, YVAL};
    public static final Polygon MARKER_TRIANGLE_DOWN = new Polygon(MARKER_TRIANGLE_DOWN_X, MARKER_TRIANGLE_DOWN_Y, 3);
    private static final int[] MARKER_TRIANGLE_UP_X = new int[]{900, 0, -900};
    private static final int[] MARKER_TRIANGLE_UP_Y = new int[]{-YVAL, YVAL, -YVAL};
    public static final Polygon MARKER_TRIANGLE_UP = new Polygon(MARKER_TRIANGLE_UP_X, MARKER_TRIANGLE_UP_Y, 3);
    private static final int A = 600;
    private static final int[] MARKER_PIRATE_PLUS_X = new int[]{0, -600, 600, 0, 900, 900, 0, 600, -600, 0, -900, -900};
    private static final int[] MARKER_PIRATE_PLUS_Y = new int[]{0, 900, 900, 0, 600, -600, 0, -900, -900, 0, -600, 600};
    public static final Polygon MARKER_PIRATE_PLUS = new Polygon(MARKER_PIRATE_PLUS_X, MARKER_PIRATE_PLUS_Y, 12);
    private static final int[] MARKER_TRIANGLE_RIGHT_X = new int[]{-900, 900, -900};
    private static final int[] MARKER_TRIANGLE_RIGHT_Y = new int[]{900, 0, -900};
    public static final Polygon MARKER_TRIANGLE_RIGHT = new Polygon(MARKER_TRIANGLE_RIGHT_X, MARKER_TRIANGLE_RIGHT_Y, 3);
    private static final int[] MARKER_TRIANGLE_LEFT_X = new int[]{-900, 900, 900};
    private static final int[] MARKER_TRIANGLE_LEFT_Y = new int[]{0, 900, -900};
    public static final Polygon MARKER_TRIANGLE_LEFT = new Polygon(MARKER_TRIANGLE_LEFT_X, MARKER_TRIANGLE_LEFT_Y, 3);
    private static final int[] MARKER_HOUSE_X = new int[]{-900, 900, 900, 0, -900};
    private static final int[] MARKER_HOUSE_Y = new int[]{-900, -900, 0, 900, 0};
    public static final Polygon MARKER_HOUSE = new Polygon(MARKER_HOUSE_X, MARKER_HOUSE_Y, 5);
    private static final int[] MARKER_HEXAGON_X = new int[]{-300, -900, -300, 300, 900, 300};
    private static final int[] MARKER_HEXAGON_Y = new int[]{-900, 0, 900, 900, 0, -900};
    public static final Polygon MARKER_HEXAGON = new Polygon(MARKER_HEXAGON_X, MARKER_HEXAGON_Y, 6);
    private static final int[] MARKER_FATX_X = new int[]{-675, 0, 675, 900, 225, 900, 675, 0, -675, -900, -225, -900, -675};
    private static final int[] MARKER_FATX_Y = new int[]{900, 225, 900, 675, 0, -675, -900, -225, -900, -675, 0, 675, 900};
    public static final Polygon MARKER_FATX = new Polygon(MARKER_FATX_X, MARKER_FATX_Y, 13);
    private static final int[] MARKER_FIVESTAR_X = new int[]{-855, -153, 0, 153, 855, 243, 531, 0, -531, -243, -855};
    private static final int[] MARKER_FIVESTAR_Y = new int[]{279, 279, 900, 279, 279, -81, -729, -252, -729, -81, 279};
    public static final Polygon MARKER_FIVESTAR = new Polygon(MARKER_FIVESTAR_X, MARKER_FIVESTAR_Y, 11);
    private static final int[] MARKER_SIXSTAR_X = new int[]{-783, -261, 0, 261, 783, 513, 783, 261, 0, -261, -783, -513, -783};
    private static final int[] MARKER_SIXSTAR_Y = new int[]{450, 450, 900, 450, 450, 0, -450, -450, -900, -450, -450, 0, 450};
    public static final Polygon MARKER_SIXSTAR = new Polygon(MARKER_SIXSTAR_X, MARKER_SIXSTAR_Y, 13);
    private static final int[] MARKER_HOURGLASS_X = new int[]{-900, 900, 0, 900, -900, 0, -900};
    private static final int[] MARKER_HOURGLASS_Y = new int[]{900, 900, 0, -900, -900, 0, 900};
    public static final Polygon MARKER_HOURGLASS = new Polygon(MARKER_HOURGLASS_X, MARKER_HOURGLASS_Y, 7);
    private static final int[] MARKER_HOURGLASSROTATED_X = new int[]{-900, 0, 900, 900, 0, -900, -900};
    private static final int[] MARKER_HOURGLASSROTATED_Y = new int[]{900, 0, 900, -900, 0, -900, 900};
    public static final Polygon MARKER_HOURGLASSROTATED = new Polygon(MARKER_HOURGLASSROTATED_X, MARKER_HOURGLASSROTATED_Y, 7);
    private static final int[] MARKER_FOURSTAR_X = new int[]{-900, 0, 900, 450, 900, 0, -900, -450, -900};
    private static final int[] MARKER_FOURSTAR_Y = new int[]{900, 450, 900, 0, -900, -450, -900, 0, 900};
    public static final Polygon MARKER_FOURSTAR = new Polygon(MARKER_FOURSTAR_X, MARKER_FOURSTAR_Y, 9);
    private final Rectangle rect;
    private final Polygon polygon;
    private final int markerType;
    double m_fLineWidth;
    Color m_LineColor;
    int m_nLineWidthVC;

    public MarkerTemplate() {
        this.markerType = 0;
        this.rect = null;
        this.polygon = null;
    }

    public MarkerTemplate(Polygon polygon) {
        this(null, polygon, 3);
    }

    public MarkerTemplate(Rectangle rect) {
        this(rect, null, 1);
    }

    public MarkerTemplate(Rectangle rect, Polygon polygon, int markerType) {
        this.rect = rect;
        this.polygon = polygon;
        this.markerType = markerType;
    }

    public MarkerTemplate(Rectangle rect, boolean bOval) {
        this(rect, null, bOval ? 2 : 1);
    }

    public boolean isValid() {
        boolean bValid = true;
        switch (this.markerType) {
            case 0: {
                break;
            }
            case 3: 
            case 4: {
                if (this.polygon == null) {
                    bValid = false;
                    break;
                }
                Rectangle r = this.polygon.getBounds();
                if (r != null && r.width > 0 && r.width <= 1800 && r.height > 0 && r.height <= 1800) break;
                bValid = false;
                break;
            }
            case 1: 
            case 2: {
                if (this.rect != null && this.rect.width > 0 && this.rect.width <= 1800 && this.rect.height > 0 && this.rect.height <= 1800) break;
                bValid = false;
                break;
            }
            default: {
                bValid = false;
            }
        }
        return bValid;
    }

    public String toString() {
        String s;
        switch (this.markerType) {
            case 0: {
                s = "Null Marker";
                break;
            }
            case 1: {
                s = "Rect = " + this.rect;
                break;
            }
            case 2: {
                s = "Oval whose rect = " + this.rect;
                break;
            }
            case 3: 
            case 4: {
                s = "Polygon = " + this.polygon;
                break;
            }
            default: {
                s = "Unknown marker type!";
            }
        }
        return s;
    }

    public int getMarkerType() {
        return this.markerType;
    }

    public MarkerTemplate(Rectangle rect, int markerType, int nLineWidth, Color clr) {
        this(rect, null, markerType, nLineWidth, clr);
    }

    public MarkerTemplate(Rectangle rect, Polygon polygon, int markerType, double fLineWidth, Color color) {
        this.rect = rect;
        this.polygon = polygon;
        this.markerType = markerType;
        this.m_fLineWidth = fLineWidth;
        this.m_LineColor = color;
    }

    public MarkerTemplate(Polygon polygon, int markerType, double fLineWidth, Color color) {
        this.rect = null;
        this.polygon = polygon;
        this.markerType = markerType;
        this.m_fLineWidth = fLineWidth;
        this.m_LineColor = color;
    }

    public Rectangle getRect() {
        return this.rect;
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public double getLineWidth() {
        return this.m_fLineWidth;
    }

    public void setLineWidthVC(int lineWidth) {
        this.m_nLineWidthVC = lineWidth;
    }

    public int getLineWidthVC() {
        return this.m_nLineWidthVC;
    }

    public Color getLineColor() {
        return this.m_LineColor;
    }
}

