/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.formulas.functions.typeconversion;

import com.crystaldecisions12.reports.common.asserts.CrystalAssert;
import com.crystaldecisions12.reports.common.value.DTSParser;
import com.crystaldecisions12.reports.common.value.DateTimeValue;
import com.crystaldecisions12.reports.common.value.DateValue;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.FormulaValueType;
import com.crystaldecisions12.reports.common.value.NumberValue;
import com.crystaldecisions12.reports.common.value.StringValue;
import com.crystaldecisions12.reports.formulas.FormulaEnvironment;
import com.crystaldecisions12.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions12.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions12.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions12.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions12.reports.formulas.FormulaInfo;
import com.crystaldecisions12.reports.formulas.FormulaResources;
import com.crystaldecisions12.reports.formulas.FormulaValueReference;
import com.crystaldecisions12.reports.formulas.functions.dateandtime.DateTimeHelper;

class d
extends FormulaFunctionBase {
    public d(String string, String string2, FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray) {
        super(string, string2, formulaFunctionArgumentDefinitionArray);
    }

    public d(String string, String string2, FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray, FormulaInfo.Syntax syntax) {
        super(string, string2, formulaFunctionArgumentDefinitionArray, false, syntax, true);
    }

    public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
        if (formulaValueReferenceArray.length == 3 && formulaValueReferenceArray[0].getFormulaValue() != null && formulaValueReferenceArray[1].getFormulaValue() != null && formulaValueReferenceArray[2].getFormulaValue() != null) {
            int n2 = ((NumberValue)formulaValueReferenceArray[0].getFormulaValue()).getInt();
            int n3 = ((NumberValue)formulaValueReferenceArray[1].getFormulaValue()).getInt();
            int n4 = ((NumberValue)formulaValueReferenceArray[2].getFormulaValue()).getInt();
            if (n2 != 0 || n3 != 0 || n4 != 0) {
                DateTimeHelper.if(n2, n3, n4);
            }
        }
        return FormulaValueType.date;
    }

    public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
        this.validate(formulaValueReferenceArray, formulaEnvironment);
        if (formulaValueReferenceArray.length == 3) {
            int n2 = ((NumberValue)formulaValueReferenceArray[0].getFormulaValue()).getInt();
            int n3 = ((NumberValue)formulaValueReferenceArray[1].getFormulaValue()).getInt();
            int n4 = ((NumberValue)formulaValueReferenceArray[2].getFormulaValue()).getInt();
            if (n2 == 0 && n3 == 0 && n4 == 0) {
                return null;
            }
            return DateValue.fromYMD(n2, n3, n4);
        }
        FormulaValue formulaValue = formulaValueReferenceArray[0].getFormulaValue();
        if (formulaValue.getFormulaValueType() == FormulaValueType.number) {
            double d10 = Math.floor(((NumberValue)formulaValue).getDouble());
            try {
                return DateValue.fromOleDate(d10);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new FormulaFunctionArgumentException(FormulaResources.a(), "DateYearOutOfRange", 0);
            }
        }
        if (formulaValue.getFormulaValueType() == FormulaValueType.string) {
            String string = ((StringValue)formulaValue).getString();
            if (string.length() == 0) {
                return null;
            }
            DTSParser dTSParser = DTSParser.a(formulaEnvironment.getFormulaClient().getLocale());
            DateTimeValue dateTimeValue = dTSParser.a(string, true, false);
            if (dateTimeValue == null) {
                throw new FormulaFunctionArgumentException(FormulaResources.a(), "BadDateTimeString", 0);
            }
            return dateTimeValue.getDateValue();
        }
        if (formulaValue.getFormulaValueType() == FormulaValueType.dateTime) {
            DateTimeValue dateTimeValue = (DateTimeValue)formulaValue;
            return dateTimeValue.getDateValue();
        }
        CrystalAssert.a(false);
        return formulaValue;
    }
}

