/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.formulas.functions.string;

import com.crystaldecisions.reports.common.CrystalResources;
import com.crystaldecisions.reports.common.CrystalResourcesFactory;
import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.formulas.functions.string.ToWordsUtil;
import com.ibm.icu.text.RuleBasedNumberFormat;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ToWordsUtil {
    private static final String[] K = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
    private static final String[] as = new String[]{"ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static final String[] aE = new String[]{"", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static final String[] ac = new String[]{"", " thousand", " million", " billion", " trillion", " quadrillion", " quintillion", " sextillion", " septillion", " octillion", " nonillion", " decillion", " zillion"};
    private static final String j = "negative ";
    private static final String F = " and ";
    private static final String t = " / 1";
    private static final char v = 'x';
    private static final String[] k = new String[]{"z\u00e9ro", "un", "deux", "trois", "quatre", "cinq", "six", "sept", "huit", "neuf"};
    private static final String[] P = new String[]{"dix", "onze", "douze", "treize", "quatorze", "quinze", "seize", "dix-sept", "dix-huit", "dix-neuf"};
    private static final String[] al = new String[]{"", "dix", "vingt", "trente", "quarante", "cinquante", "soixante", "soixante-dix", "quatre-vingt", "quatre-vingt-dix"};
    private static final String[] D = new String[]{"", "mille", " million", " milliard", " billion", "mille billions", " trillion", "mille trillions", " septillion", " octillion", " nonillion", " decillion", " zillion"};
    private static final String case = "moins ";
    private static final String i = " et ";
    private static final String d = " / 1";
    private static final char f = 'x';
    private static final String[] G = new String[]{"cero", "un", "dos", "tres", "cuatro", "cinco", "seis", "siete", "ocho", "nueve"};
    private static final String[] ao = new String[]{"diez", "once", "doce", "trece", "catorce", "quince", "diecis\u00e9is", "diecisiete", "dieciocho", "diecinueve"};
    private static final String[] q = new String[]{"veinte", "veintiuno", "veintid\u00f3s", "veintitr\u00e9s", "veinticuatro", "veinticinco", "veintis\u00e9is", "veintisiete", "veintiocho", "veintinueve"};
    private static final String[] aA = new String[]{"", "diez", "veinte", "treinta", "cuarenta", "cincuenta", "sesenta", "setenta", "ochenta", "noventa"};
    private static final String[] u = new String[]{"", "ciento", "doscientos", "trescientos", "cuatrocientos", "quinientos", "seiscientos", "setecientos", "ochocientos", "novecientos"};
    private static final String[] Y = new String[]{"", "mil", " mill\u00f3n", "mil millones", " bill\u00f3n", " trill\u00f3n", " cuatrill\u00f3n", " quintill\u00f3n", " sextill\u00f3n", " septill\u00f3n", " octill\u00f3n", " nonill\u00f3n", " decill\u00f3n"};
    private static final String[] B = new String[]{"", " mil", " millones", " mil millones", " billones", " trillones", " cuatrillones", " quintillones", " sextillones", " septillones", " octillones", " nonillones", " decillones"};
    private static final String g = "menos ";
    private static final String C = " y ";
    private static final char s = '0';
    private static final String r = " / 1";
    private static final char E = '\u00e8';
    private static final String[] ax = new String[]{"zero", "uno", "due", "tre", "quattro", "cinque", "sei", "sette", "otto", "nove"};
    private static final String[] aZ = new String[]{"dieci", "undici", "dodici", "tredici", "quattordici", "quindici", "sedici", "diciassette", "diciotto", "diciannove"};
    private static final String[] c = new String[]{"", "dieci", "venti", "trenta", "quaranta", "cinquanta", "sessanta", "settanta", "ottanta", "novanta"};
    private static final String[] aP = new String[]{"", "mille", "milione", "miliardo", "millemiliardi", "milionedimiliardi", "miliardodimiliardi", "millemiliardidimiliardi", "milionedimiliardidimiliardi", "miliardodimiliardidimiliardi", "millemiliardidimiliardidimiliardi", "milionedimiliardidimiliardidimiliardi", "miliardodimiliardidimiliardidimiliardi"};
    private static final String[] au = new String[]{"", "mila", "milioni", "miliardi", "milamiliardi", "milionidimiliardi", "miliardidimiliardi", "milamiliardidimiliardi", "milionidimiliardidimiliardi", "miliardidimiliardidimiliardi", "milamiliardidimiliardidimiliardi", "milionidimiliardidimiliardidimiliardi", "miliardidimiliardidimiliardidimiliardi"};
    private static final String aa = "meno ";
    private static final String av = " e ";
    private static final char ap = 'x';
    private static final String an = " / 1";
    private static final String[] aq = new String[]{"null", "ein", "zwei", "drei", "vier", "f\u00fcnf", "sechs", "sieben", "acht", "neun"};
    private static final String[] aN = new String[]{"zehn", "elf", "zw\u00f6lf", "dreizehn", "vierzehn", "f\u00fcnfzehn", "sechzehn", "siebzehn", "achtzehn", "neunzehn"};
    private static final String[] do = new String[]{"", "zehn", "zwanzig", "drei\u00dfig", "vierzig", "f\u00fcnfzig", "sechzig", "siebzig", "achtzig", "neunzig"};
    private static final String[] aC = new String[]{"", "tausend", " Million", " Milliarde", " Billion", " Billiarde", " Trillion", " Trilliarde", " Quadrillion", " Quadrilliarde", " Quintillion", " Quintilliarde", " Sextillion"};
    private static final String[] ah = new String[]{"", "tausend", " Millionen", " Milliarden", " Billionen", " Billiarden", " Trillionen", " Trilliarden", " Quadrillionen", " Quadrilliarden", " Quintillionen", " Quintilliarden", " Sextillionen"};
    private static final String L = "minus ";
    private static final String aj = " und ";
    private static final char X = 'x';
    private static final String V = " / 1";
    private static final String[] ak = new String[]{"zero", "um", "dois", "tr\u00eas", "quatro", "cinco", "seis", "sete", "oito", "nove"};
    private static final String[] aI = new String[]{"dez", "onze", "doze", "treze", "catorze", "quinze", "dezesseis", "dezessete", "dezoito", "dezenove"};
    private static final String[] a0 = new String[]{"", "dez", "vinte", "trinta", "quarenta", "cinq\u00fcenta", "sessenta", "setenta", "oitenta", "noventa"};
    private static final String[] W = new String[]{"", "cento", "duzentos", "trezentos", "quatrocentos", "quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos"};
    private static final String[] ay = new String[]{"", " mil", " milh\u00e3o", " bilh\u00e3o", " trilh\u00e3o", " quadrilh\u00e3o", "quintilh\u00e3o", " sextilh\u00e3o", " septilh\u00e3o", " octilh\u00e3o", " nonilh\u00e3o", " decilh\u00e3o", " zilh\u00e3o"};
    private static final String[] ad = new String[]{"", " mil", " milh\u00f5es", " bilh\u00f5es", " trilh\u00f5es", " quadrilh\u00f5es", " quintilh\u00f5es", " sextilh\u00f5es", " septilh\u00f5es", " octilh\u00f5es", " nonilh\u00f5es", " decilh\u00f5es", " zilh\u00f5es"};
    private static final String I = "menos ";
    private static final String ae = " e ";
    private static final char T = 'x';
    private static final String S = " / 1";
    private static final String[][] ai = new String[][]{{"\u3007", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"}, {"\u96f6", "\u58f1", "\u5f10", "\u53c2", "\u56db", "\u4f0d", "\u516d", "\u4e03", "\u516b", "\u4e5d"}};
    private static final String[][] new = new String[][]{{"", "\u5341", "\u767e", "\u5343"}, {"", "\u62fe", "\u767e", "\u9621"}};
    private static final String[][] aw = new String[][]{{"", "\u4e07", "\u5104", "\u5146", "\u4eac"}, {"", "\u842c", "\u5104", "\u5146", "\u4eac"}};
    private static final String H = "\u30de\u30a4\u30ca\u30b9";
    private static final String e = ".";
    private static final String[] M = new String[]{"\uc601", "\uc77c", "\uc774", "\uc0bc", "\uc0ac", "\uc624", "\uc721", "\uce60", "\ud314", "\uad6c"};
    private static final String[] aM = new String[]{"", "\uc2ed", "\ubc31", "\ucc9c"};
    private static final String[] af = new String[]{"", "\ub9cc", "\uc5b5", "\uc870", "\uacbd"};
    private static final String l = "\ub9c8\uc774\ub108\uc2a4";
    private static final String aY = "\uc810";
    private static final String[] a1 = new String[]{"nul", "\u00e9\u00e9n", "twee", "drie", "vier", "vijf", "zes", "zeven", "acht", "negen"};
    private static final String[] h = new String[]{"tien", "elf", "twaalf", "dertien", "veertien", "vijftien", "zestien", "zeventien", "achttien", "negentien"};
    private static final String[] z = new String[]{"", "tien", "twintig", "dertig", "veertig", "vijftig", "zestig", "zeventig", "tachtig", "negentig"};
    private static final String[] b = new String[]{"", " duizend", " miljoen", " miljard", " biljoen", " quadriljoen", " quintiljoen", " sextiljoen", " septiljoen", " triljard", " noniljoen", " deciljoen", " ziljoen"};
    private static final String aB = "min ";
    private static final String else = "\u00ebn";
    private static final String aU = "en";
    private static final String A = " en ";
    private static final String aK = " / 1";
    private static final char aL = 'x';
    private static final String[] az = new String[]{"\u3007", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] aJ = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] aT = new String[]{"", "\u4e07", "\u4ebf", "\u4e07", "\u4ebf"};
    private static final String O = "\u8d1f";
    private static final String aH = "\u70b9";
    private static final String[] am = new String[]{"\u3007", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] int = new String[]{"\u96f6", "\u58f9", "\u8cb3", "\u53c3", "\u8086", "\u4f0d", "\u9678", "\u67d2", "\u634c", "\u7396"};
    private static final String[] aR = new String[]{"", "\u842c", "\u5104", "\u842c", "\u5104"};
    private static final String N = "\u8ca0";
    private static final String aF = "\u9ede";
    private static final String[] try = new String[]{"", "\u5341", "\u767e", "\u5343"};
    private static final String[] aD = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] void = new String[]{"noll", "ett", "tv\u00e5", "tre", "fyra", "fem", "sex", "sju", "\u00e5tta", "nio"};
    private static final String[] y = new String[]{"tio", "elva", "tolv", "tretton", "fjorton", "femton", "sexton", "sjutton", "arton", "nitton"};
    private static final String[] R = new String[]{"", "ti", "tjug", "tretti", "fyrti", "femti", "sexti", "sjutti", "\u00e5tti", "nitti"};
    private static final String[] n = new String[]{"", "tusen", "miljon", "miljard", "biljon", "biljard", "quintillion", "sextillion", "septillion", "octillion", "nonillion", "decillion", "zillion"};
    private static final String aQ = "minus ";
    private static final String goto = " och ";
    private static final char a6 = 'x';
    private static final String a5 = " / 1";
    private static final int if = 2;
    private static final int for = 1;
    private static final int a4 = 2;
    private static final int a2 = 4;
    private static final int x = 8;
    private static final int p = 16;
    private static final int w = 32;
    private static final int aO = 64;
    private static final int o = 128;
    private static final int aV = 256;
    private static final int m = 512;
    private static final int ar = 1024;
    private static final int char = 2048;
    public static final int aX = 0;
    public static final int at = 1;
    public static final int byte = 2;
    private static final int Z = 0;
    private static final int aW = 1;
    static int ab = -1;
    private static final String aG = "%CheckIntegerRule";
    private static final String a = "%CheckFractionRule";
    private static final String Q = "%CasualIntegerRule";
    private static final String J = "%CasualFractionRule";
    private static final String U = "%DailyIntegerRule";
    private static final String a3 = "%DailyFractionRule";
    private static final String aS = "NA";
    private static final String ag = ": x.0: <%CheckIntegerRule<;";
    private static final String long = ": x.0: <%CheckFractionRule<;";

    private ToWordsUtil() {
    }

    private static String if(String[] stringArray, String string, int n2, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append(j);
        }
        boolean bl3 = true;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n3 = stringArray[i2].length();
            if (n3 <= 0) continue;
            if (bl3) {
                bl3 = false;
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(stringArray[i2]);
            stringBuilder.append(ac[i2]);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static String do(int n2) {
        int n3 = n2 % 10;
        int n4 = n2 / 10 % 10;
        int n5 = n2 / 100;
        StringBuilder stringBuilder = new StringBuilder();
        if (n5 > 0) {
            stringBuilder.append(K[n5]);
            stringBuilder.append(" hundred");
            if (n4 > 0 || n3 > 0) {
                stringBuilder.append(" ");
            }
        }
        if (n4 >= 2) {
            stringBuilder.append(aE[n4]);
            if (n3 > 0) {
                stringBuilder.append("-");
            }
        }
        if (n4 == 1) {
            stringBuilder.append(as[n3]);
        } else if (n3 > 0) {
            stringBuilder.append(K[n3]);
        }
        return stringBuilder.toString();
    }

    private static String int(String[] stringArray, String string, int n2, boolean bl2, double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append(case);
        }
        boolean bl3 = true;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            boolean bl4;
            int n3 = stringArray[i2].length();
            if (n3 <= 0) continue;
            if (!bl3) {
                stringBuilder.append(" ");
            }
            if (i2 != 1 && i2 != 5 && i2 != 7 || dArray[i2] != 1.0) {
                stringBuilder.append(stringArray[i2]);
                if (i2 == 1) {
                    stringBuilder.append(" ");
                }
            }
            boolean bl5 = bl4 = dArray[i2] > 1.0 && i2 > 1;
            if (i2 == 1 && dArray[i2 - 1] == 0.0 && dArray[i2] == 1.0) {
                stringBuilder.append("un millier");
            } else if (i2 == 5 || i2 == 7) {
                if (dArray[i2] > 1.0) {
                    stringBuilder.append(" ");
                }
                if (dArray[i2 - 1] == 0.0) {
                    stringBuilder.append(D[i2]);
                    bl4 = false;
                } else {
                    stringBuilder.append(D[1]);
                }
            } else {
                stringBuilder.append(D[i2]);
            }
            if (bl4) {
                stringBuilder.append("s");
            }
            if (!bl3) continue;
            bl3 = false;
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static String if(int n2) {
        int n3 = n2 % 10;
        int n4 = n2 / 10 % 10;
        int n5 = n2 / 100;
        StringBuilder stringBuilder = new StringBuilder();
        if (n5 > 0) {
            if (n5 != 1) {
                stringBuilder.append(k[n5]);
                stringBuilder.append(" ");
            }
            stringBuilder.append("cent");
            if (n5 != 1 && n4 == 0 && n3 == 0) {
                stringBuilder.append("s");
            }
            if (n4 > 0 || n3 > 0) {
                stringBuilder.append(" ");
            }
        }
        if (n4 >= 2) {
            if (n4 == 7) {
                stringBuilder.append(al[n4 - 1]);
                if (n3 == 1) {
                    stringBuilder.append(i);
                } else {
                    stringBuilder.append("-");
                }
            } else if (n4 == 9) {
                stringBuilder.append(al[n4 - 1]);
                stringBuilder.append("-");
            } else if (n4 == 8) {
                stringBuilder.append(al[n4]);
                if (n3 > 0) {
                    stringBuilder.append("-");
                }
            } else {
                stringBuilder.append(al[n4]);
                if (n3 == 1) {
                    stringBuilder.append(i);
                } else if (n3 > 0) {
                    stringBuilder.append("-");
                }
            }
        }
        if (n4 == 8 && n3 == 0) {
            stringBuilder.append("s");
        }
        if (n4 == 1 || n4 == 7 || n4 == 9) {
            stringBuilder.append(P[n3]);
        } else if (n3 > 0) {
            stringBuilder.append(k[n3]);
        }
        return stringBuilder.toString();
    }

    private static String do(String[] stringArray, String string, int n2, boolean bl2, double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append("menos ");
        }
        boolean bl3 = true;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n3 = stringArray[i2].length();
            if (n3 <= 0) continue;
            if (!bl3) {
                stringBuilder.append(" ");
            }
            if (i2 != 3 && i2 != 1 || dArray[i2] != 1.0) {
                if (dArray[i2] == 1.0 && (i2 > 3 || i2 == 2)) {
                    stringBuilder.append("un");
                } else {
                    stringBuilder.append(stringArray[i2]);
                }
            }
            if (i2 == 3) {
                if (dArray[3] > 1.0) {
                    stringBuilder.append(" ");
                }
                if (dArray[2] != 0.0) {
                    stringBuilder.append(Y[1]);
                } else {
                    stringBuilder.append(Y[3]);
                }
            } else if (dArray[i2] > 1.0) {
                stringBuilder.append(B[i2]);
            } else {
                stringBuilder.append(Y[i2]);
            }
            if (!bl3) continue;
            bl3 = false;
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static String a(int n2, boolean bl2) {
        int n3 = n2 % 10;
        int n4 = n2 / 10 % 10;
        int n5 = n2 / 100;
        if (n2 == 1) {
            if (bl2) {
                return "un";
            }
            return "uno";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (n5 == 1) {
            if (n4 != 0 || n3 != 0) {
                stringBuilder.append("ciento");
            } else {
                stringBuilder.append("cien");
            }
        } else {
            stringBuilder.append(u[n5]);
        }
        if (n5 > 0 && (n4 != 0 || n3 != 0)) {
            stringBuilder.append(" ");
        }
        if (n4 > 2) {
            stringBuilder.append(aA[n4]);
            if (n3 != 0) {
                stringBuilder.append(C);
            }
        }
        if (n4 == 2) {
            if (bl2 && n3 == 1) {
                stringBuilder.append("veintiun");
            } else {
                stringBuilder.append(q[n3]);
            }
        } else if (n4 == 1) {
            stringBuilder.append(ao[n3]);
        } else if (n3 > 0) {
            stringBuilder.append(G[n3]);
        }
        return stringBuilder.toString();
    }

    private static String a(String[] stringArray, String string, int n2, boolean bl2, double[] dArray) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append(aa);
        }
        int n4 = n2 - 1;
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            int n5 = stringArray[n3].length();
            int n6 = n3 % 3;
            if (n6 == 0) {
                n6 = n3;
            }
            if (dArray[n3] > 0.0) {
                n4 = n3;
            }
            if (n5 > 0) {
                if (n6 != 1 || dArray[n3] != 1.0) {
                    stringBuilder.append(stringArray[n3]);
                }
                if (dArray[n3] > 1.0) {
                    stringBuilder.append(au[n6]);
                    continue;
                }
                stringBuilder.append(aP[n6]);
                continue;
            }
            if (n3 % 3 != 0) continue;
            if (n4 % 3 > 1 && n3 != 0) {
                stringBuilder.append("di");
            }
            if (dArray[n4] > 1.0 || n4 > 4) {
                stringBuilder.append(au[n3]);
                continue;
            }
            stringBuilder.append(aP[n3]);
        }
        n3 = stringBuilder.length();
        if (stringBuilder.substring(n3 - 3).equalsIgnoreCase(ax[3]) && n3 != 3) {
            stringBuilder.setCharAt(n3 - 1, '\u00e8');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static String do(int n2, int n3) {
        int n4 = n2 % 10;
        int n5 = n2 / 10 % 10;
        int n6 = n2 / 100;
        StringBuilder stringBuilder = new StringBuilder();
        if (n6 > 0) {
            if (n6 != 1) {
                stringBuilder.append(ax[n6]);
            }
            stringBuilder.append("cento");
        }
        if (n5 >= 2) {
            int n7;
            stringBuilder.append(c[n5]);
            if (ToWordsUtil.a(ax[n4].charAt(0)) && ToWordsUtil.a(stringBuilder.charAt((n7 = stringBuilder.length()) - 1))) {
                stringBuilder.deleteCharAt(n7 - 1);
            }
        }
        if (n5 == 1) {
            stringBuilder.append(aZ[n4]);
        } else if (n4 > 0) {
            if (n4 == 1) {
                if (n6 == 0 && n5 == 0 && n3 != 0) {
                    stringBuilder.append("un");
                } else {
                    stringBuilder.append("uno");
                }
            } else {
                stringBuilder.append(ax[n4]);
            }
        }
        return stringBuilder.toString();
    }

    private static String if(String[] stringArray, String string, int n2, boolean bl2, double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append("minus ");
        }
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n3 = stringArray[i2].length();
            if (n3 <= 0) continue;
            stringBuilder.append(stringArray[i2]);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static String if(int n2, int n3) {
        int n4 = n2 % 10;
        int n5 = n2 / 10 % 10;
        int n6 = n2 / 100;
        StringBuilder stringBuilder = new StringBuilder();
        if (n6 > 0) {
            stringBuilder.append(aq[n6]);
            stringBuilder.append("hundert");
        }
        if (n5 == 1) {
            stringBuilder.append(aN[n4]);
        } else if (n4 > 0) {
            stringBuilder.append(aq[n4]);
        }
        if (n5 >= 2) {
            if (n4 > 0) {
                stringBuilder.append("und");
            }
            stringBuilder.append(do[n5]);
        }
        if (n5 == 0 && n4 == 1) {
            switch (n3) {
                case 0: {
                    stringBuilder.append("s");
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    if (n6 != 0) break;
                    stringBuilder.append("e");
                }
            }
        }
        if (n2 > 0) {
            if (n2 == 1) {
                stringBuilder.append(aC[n3]);
            } else {
                stringBuilder.append(ah[n3]);
            }
            if (n3 >= 2 && ab >= 0) {
                stringBuilder.append(" ");
            }
            ab = n3;
        }
        return stringBuilder.toString();
    }

    private static String a(double d10, int n2) {
        if (d10 == 0.0) {
            return "";
        }
        switch (n2) {
            case 0: {
                return "";
            }
        }
        int n3 = 0;
        return ToWordsUtil.a(d10, n2, n3 | 0x20);
    }

    private static String a(String[] stringArray, int n2, String string, boolean bl2, double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append("menos ");
        }
        boolean bl3 = true;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n3 = stringArray[i2].length();
            if (n3 <= 0) continue;
            if (bl3) {
                bl3 = false;
            } else if (dArray[i2] > 0.0 && dArray[i2] < 100.0) {
                stringBuilder.append(" e ");
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(stringArray[i2]);
            if (dArray[i2] > 1.0) {
                stringBuilder.append(ad[i2]);
                continue;
            }
            stringBuilder.append(ay[i2]);
        }
        if (string.length() > 0) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String a(int n2, int n3) {
        int n4 = n2 % 10;
        int n5 = n2 / 10 % 10;
        int n6 = n2 / 100;
        StringBuilder stringBuilder = new StringBuilder();
        if (n6 == 1) {
            if (n5 != 0 || n4 != 0) {
                stringBuilder.append("cento");
            } else {
                stringBuilder.append("cem");
            }
        } else {
            stringBuilder.append(W[n6]);
        }
        if (n6 > 0 && (n5 > 0 || n4 > 0)) {
            stringBuilder.append(" e ");
        }
        if (n5 >= 2) {
            stringBuilder.append(a0[n5]);
            if (n4 != 0) {
                stringBuilder.append(" e ");
            }
        }
        if (n5 == 1) {
            stringBuilder.append(aI[n4]);
        } else if (n4 > 0) {
            stringBuilder.append(ak[n4]);
        }
        return stringBuilder.toString();
    }

    private static String a(String[] stringArray, int n2, String string, boolean bl2, String string2, String[] stringArray2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append(string2);
        }
        boolean bl3 = true;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n3 = stringArray[i2].length();
            if (n3 > 0 || bl3) {
                stringBuilder.append(stringArray[i2]);
                stringBuilder.append(stringArray2[i2]);
            }
            bl3 = false;
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static String a(long l2, int n2, int n3, String[] stringArray, String[] stringArray2, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        CrystalAssert.ASSERT((l2 < 10000L ? 1 : 0) != 0);
        for (int i2 = 3; i2 >= 0; --i2) {
            int n4;
            switch (i2) {
                case 3: {
                    n4 = 1000;
                    break;
                }
                case 2: {
                    n4 = 100;
                    break;
                }
                case 1: {
                    n4 = 10;
                    break;
                }
                default: {
                    n4 = 1;
                }
            }
            int n5 = (int)(l2 / (long)n4 % 10L);
            if (n5 <= 0) continue;
            if (n5 > 1 || i2 == 0 && n2 == 0 || bl2 && (n3 == 0 || n3 == 1)) {
                stringBuilder.append(stringArray[n5]);
            }
            stringBuilder.append(stringArray2[i2]);
        }
        return stringBuilder.toString();
    }

    private static String a(double d10, double d11, int n2, boolean bl2, String string, String string2, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append(string);
        }
        stringBuilder.append(ToWordsUtil.a(d10, stringArray).toString());
        if (n2 > 0 && d11 > 0.0) {
            String string3 = ToWordsUtil.a(d11, n2, string2, stringArray);
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    private static String a(String[] stringArray, int n2, String string, boolean bl2, String string2, String[] stringArray2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append(string2);
        }
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n3 = stringArray[i2].length();
            if (n3 > 0) {
                stringBuilder.append(stringArray[i2]);
                stringBuilder.append(stringArray2[i2]);
                continue;
            }
            if (n3 != 0 || i2 != 2 || !bl3) continue;
            stringBuilder.append(stringArray2[i2]);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static String a(long l2, int n2, int n3, String[] stringArray, String[] stringArray2, c c10) {
        StringBuilder stringBuilder = new StringBuilder();
        CrystalAssert.ASSERT((l2 < 10000L ? 1 : 0) != 0);
        for (int i2 = 3; i2 >= 0; --i2) {
            int n4;
            switch (i2) {
                case 3: {
                    n4 = 1000;
                    break;
                }
                case 2: {
                    n4 = 100;
                    break;
                }
                case 1: {
                    n4 = 10;
                    break;
                }
                default: {
                    n4 = 1;
                }
            }
            int n5 = (int)(l2 / (long)n4 % 10L);
            if (n5 > 0) {
                if (n5 > 1 || i2 != 1) {
                    if (c10.if) {
                        stringBuilder.append(stringArray[0]);
                    }
                    stringBuilder.append(stringArray[n5]);
                    c10.a = true;
                }
                stringBuilder.append(stringArray2[i2]);
                c10.if = false;
                continue;
            }
            if (!c10.a) continue;
            c10.if = true;
        }
        return stringBuilder.toString();
    }

    private static String a(double d10, int n2, int n3) {
        CharSequence charSequence;
        int n4;
        String string;
        String string2;
        if (n2 == 0) {
            return "";
        }
        if ((n3 & 1) != 0) {
            string2 = F;
            string = " / 1";
            n4 = 120;
        } else if ((n3 & 2) != 0) {
            string2 = i;
            string = " / 1";
            n4 = 120;
        } else if ((n3 & 4) != 0) {
            string2 = C;
            string = " / 1";
            n4 = 48;
        } else if ((n3 & 8) != 0) {
            string2 = " e ";
            string = " / 1";
            n4 = 120;
        } else if ((n3 & 0x10) != 0) {
            string2 = aj;
            string = " / 1";
            n4 = 120;
        } else if ((n3 & 0x20) != 0) {
            string2 = " e ";
            string = " / 1";
            n4 = 120;
        } else if ((n3 & 0x100) != 0) {
            string2 = A;
            string = " / 1";
            n4 = 120;
        } else if ((n3 & 0x800) != 0) {
            string2 = goto;
            string = " / 1";
            n4 = 120;
        } else {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        if (d10 == 0.0) {
            ToWordsUtil.a(stringBuilder, (char)n4, n2);
        } else {
            charSequence = String.valueOf((long)d10);
            int n5 = ((String)charSequence).length();
            ToWordsUtil.a(stringBuilder, ' ', n2 - n5);
            stringBuilder.insert(n2 - n5, (String)charSequence);
            if (n5 < n2) {
                ToWordsUtil.a(stringBuilder, '0', n2 - n5);
            }
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append(stringBuilder.toString());
        ((StringBuilder)charSequence).append(string);
        ToWordsUtil.a(stringBuilder, '0', n2);
        ((StringBuilder)charSequence).append(stringBuilder.toString());
        return ((StringBuilder)charSequence).toString();
    }

    private static String a(double d10, int n2, String string, String[] stringArray) {
        if (n2 == 0) {
            return "";
        }
        if (d10 == 0.0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.charAt(0));
        StringBuilder stringBuilder2 = ToWordsUtil.a(d10, stringArray);
        int n3 = stringBuilder2.length();
        while (n3++ < n2) {
            stringBuilder.append(stringArray[0].charAt(0));
        }
        n3 = stringBuilder2.length() - 1;
        while (n3 >= 0 && stringBuilder2.charAt(n3) == stringArray[0].charAt(0)) {
            stringBuilder2.deleteCharAt(n3--);
        }
        stringBuilder.append(stringBuilder2.toString());
        return stringBuilder.toString();
    }

    private static String for(String[] stringArray, String string, int n2, boolean bl2, double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append(aB);
        }
        boolean bl3 = true;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n3 = stringArray[i2].length();
            if (n3 <= 0) continue;
            if (!bl3) {
                stringBuilder.append(" ");
            } else {
                bl3 = false;
            }
            stringBuilder.append(stringArray[i2]);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static String for(int n2, int n3) {
        int n4 = n2 % 10;
        int n5 = n2 / 10 % 10;
        int n6 = n2 / 100;
        StringBuilder stringBuilder = new StringBuilder();
        if (n6 > 0) {
            if (n6 != 1) {
                stringBuilder.append(a1[n6]);
                if (n6 < 6) {
                    stringBuilder.append(" ");
                }
            }
            stringBuilder.append("honderd");
            if (n5 > 0 || n4 > 0) {
                stringBuilder.append(" ");
            }
        }
        if (n5 == 1) {
            stringBuilder.append(h[n4]);
        } else if (n4 > 0 && (n3 != 1 || n2 != 1)) {
            stringBuilder.append(a1[n4]);
        }
        if (n5 >= 2) {
            if (n4 == 2 || n4 == 3) {
                stringBuilder.append(else);
            } else if (n4 > 0) {
                stringBuilder.append(aU);
            }
            stringBuilder.append(z[n5]);
        }
        if (n2 > 0) {
            stringBuilder.append(b[n3]);
        }
        return stringBuilder.toString();
    }

    private static String a(String[] stringArray, String string, int n2, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append("minus ");
        }
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n3 = stringArray[i2].length();
            if (n3 <= 0) continue;
            stringBuilder.append(stringArray[i2]);
            stringBuilder.append(n[i2]);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static String a(int n2) {
        int n3 = n2 % 10;
        int n4 = n2 / 10 % 10;
        int n5 = n2 / 100;
        StringBuilder stringBuilder = new StringBuilder();
        if (n5 > 0) {
            if (n5 > 1) {
                stringBuilder.append(void[n5]);
            }
            stringBuilder.append("hundra");
        }
        if (n4 >= 2) {
            stringBuilder.append(R[n4]);
            if (n4 == 2 || n5 == 0 && n3 == 0) {
                stringBuilder.append("o");
            }
        }
        if (n4 == 1) {
            stringBuilder.append(y[n3]);
        } else if (n3 > 0) {
            stringBuilder.append(void[n3]);
        }
        return stringBuilder.toString();
    }

    private static String a(String string, boolean bl2, int n2, int n3) {
        String string2;
        String string3;
        if ((n2 & 1) != 0) {
            string3 = K[0];
            string2 = j;
        } else if ((n2 & 2) != 0) {
            string3 = k[0];
            string2 = case;
        } else if ((n2 & 4) != 0) {
            string3 = G[0];
            string2 = "menos ";
        } else if ((n2 & 8) != 0) {
            string3 = ax[0];
            string2 = aa;
        } else if ((n2 & 0x10) != 0) {
            string3 = aq[0];
            string2 = "minus ";
        } else if ((n2 & 0x20) != 0) {
            string3 = string.length() > 0 ? "" : ak[0];
            string2 = "menos ";
        } else if ((n2 & 0x40) != 0) {
            string3 = n3 == 0 ? ai[1][0] : ai[0][0];
            string2 = H;
        } else if ((n2 & 0x80) != 0) {
            string3 = M[0];
            string2 = l;
        } else if ((n2 & 0x100) != 0) {
            string3 = a1[0];
            string2 = aB;
        } else if ((n2 & 0x800) != 0) {
            string3 = void[0];
            string2 = "minus ";
        } else {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(string3);
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static double[] if(double d10, int n2) {
        BigDecimal bigDecimal = new BigDecimal(d10);
        bigDecimal = bigDecimal.round(new MathContext(15));
        int n3 = Math.min(15, bigDecimal.precision() - bigDecimal.scale() + n2);
        bigDecimal = bigDecimal.round(new MathContext(n3));
        bigDecimal = bigDecimal.setScale(n2, RoundingMode.HALF_UP);
        String[] stringArray = bigDecimal.toPlainString().split("\\.");
        BigDecimal bigDecimal2 = new BigDecimal(stringArray[0]);
        if (stringArray.length == 1) {
            return new double[]{bigDecimal2.doubleValue(), 0.0};
        }
        BigDecimal bigDecimal3 = new BigDecimal(stringArray[1]);
        return new double[]{bigDecimal2.doubleValue(), bigDecimal3.doubleValue()};
    }

    private static void a(StringBuilder stringBuilder, char c10, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 >= stringBuilder.length()) {
                stringBuilder.append(c10);
                continue;
            }
            stringBuilder.setCharAt(i2, c10);
        }
    }

    private static boolean a(char c10) {
        return c10 == 'a' || c10 == 'e' || c10 == 'i' || c10 == 'o' || c10 == 'u';
    }

    private static StringBuilder a(double d10, String[] stringArray) {
        double d11 = d10;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (d11 != 0.0) {
            int n3 = (int)(d11 % 10.0);
            d11 = Math.floor(d11 / 10.0);
            stringBuilder.append(stringArray[n3].charAt(0));
            ++n2;
        }
        return stringBuilder.reverse();
    }

    public static final String a(Locale locale, double d10, int n2, int n3) {
        boolean bl2;
        double d11 = d10;
        int n4 = n3;
        int n5 = 0;
        String string = locale.getLanguage();
        if (string.equals(Locale.ENGLISH.getLanguage())) {
            n5 |= 1;
        } else if (string.equals(Locale.FRENCH.getLanguage())) {
            n5 |= 2;
        } else if (string.equals("es")) {
            n5 |= 4;
        } else if (string.equals(Locale.ITALIAN.getLanguage())) {
            n5 |= 8;
        } else if (string.equals(Locale.GERMAN.getLanguage())) {
            n5 |= 0x10;
        } else if (string.equals("pt")) {
            n5 |= 0x20;
        } else if (string.equals(Locale.JAPANESE.getLanguage())) {
            n5 |= 0x40;
        } else if (string.equals(Locale.KOREAN.getLanguage())) {
            n5 |= 0x80;
        } else if (string.equals("nl")) {
            n5 |= 0x100;
        } else if (string.equals(Locale.CHINESE.getLanguage())) {
            n5 = locale.getCountry().equals("TW") ? (n5 |= 0x400) : (n5 |= 0x200);
        } else if (string.equals("sv")) {
            n5 |= 0x800;
        } else if (string.equals("ru") || string.equals("pl") || string.equals("cs") || string.equals("hu")) {
            return ToWordsUtil.if(locale, d11, n2, n4);
        }
        boolean bl3 = bl2 = d11 < 0.0;
        if (bl2) {
            d11 = -d11;
        }
        double[] dArray = ToWordsUtil.if(d11, n4);
        double d12 = dArray[0];
        double d13 = dArray[1];
        String string2 = "";
        if ((n5 & 0x40) != 0 || (n5 & 0x80) != 0) {
            int n6;
            String string3;
            String string4;
            if (bl2) {
                d11 = -d11;
            }
            String[] stringArray = null;
            String[] stringArray2 = null;
            String[] stringArray3 = null;
            if ((n5 & 0x40) != 0) {
                if (n2 == 0 || n2 == 1) {
                    n4 = 0;
                }
                int n7 = n2 == 0 ? 1 : 0;
                stringArray = ai[n7];
                stringArray2 = new[n7];
                stringArray3 = aw[n7];
                string4 = e;
                string3 = H;
            } else {
                stringArray = M;
                stringArray2 = aM;
                stringArray3 = af;
                string4 = aY;
                string3 = l;
            }
            if (d11 == 0.0) {
                string2 = ToWordsUtil.a("", false, n5, n2);
                return string2;
            }
            if (n2 == 2) {
                string2 = ToWordsUtil.a(d12, d13, n4, bl2, string3, string4, stringArray);
                return string2;
            }
            String string5 = ToWordsUtil.a(d13, n4, string4, stringArray);
            if (d12 == 0.0) {
                string2 = ToWordsUtil.a(string5, n4 > 0 && bl2, n5, n2);
                return string2;
            }
            String[] stringArray4 = new String[stringArray3.length];
            for (n6 = 0; d12 > 0.0 && n6 < stringArray3.length; ++n6) {
                double d14 = d12 % 10000.0;
                d12 = Math.floor((d12 - d14) / 10000.0);
                long l2 = (long)d14;
                stringArray4[n6] = ToWordsUtil.a(l2, n6, n2, stringArray, stringArray2, (n5 & 0x40) != 0);
            }
            string2 = ToWordsUtil.a(stringArray4, n6, string5, bl2, string3, stringArray3);
        } else if ((n5 & 0x400) != 0 || (n5 & 0x200) != 0) {
            String[] stringArray = null;
            String[] stringArray5 = null;
            String[] stringArray6 = null;
            String string6 = null;
            String string7 = null;
            if ((n5 & 0x400) != 0) {
                if (n2 == 0) {
                    stringArray = int;
                    stringArray5 = aD;
                } else {
                    stringArray = am;
                    stringArray5 = try;
                }
                stringArray6 = aR;
                string6 = N;
                string7 = aF;
            } else {
                if (n2 == 0) {
                    stringArray = aJ;
                    stringArray5 = aD;
                } else {
                    stringArray = az;
                    stringArray5 = try;
                }
                stringArray6 = aT;
                string6 = O;
                string7 = aH;
            }
            if (d11 == 0.0) {
                string2 = ToWordsUtil.a("", false, n5, n2);
                return string2;
            }
            if (d13 == 0.0) {
                n4 = 0;
            }
            if (n2 == 2) {
                string2 = ToWordsUtil.a(d12, d13, n4, bl2, string6, string7, stringArray);
                return string2;
            }
            String string8 = ToWordsUtil.a(d13, n4, string7, stringArray);
            if (d12 == 0.0) {
                string2 = ToWordsUtil.a(string8, n4 > 0 && bl2, n5, n2);
                return string2;
            }
            String[] stringArray7 = new String[stringArray6.length];
            boolean bl4 = d11 > 1.0E8;
            double d15 = Math.pow(10000.0, stringArray6.length);
            c c10 = new c();
            for (int i2 = stringArray6.length - 1; i2 >= 0; --i2) {
                double d16 = Math.floor(d12 / (d15 /= 10000.0));
                d12 %= d15;
                long l3 = (long)d16;
                stringArray7[i2] = ToWordsUtil.a(l3, i2, n2, stringArray, stringArray5, c10);
                if (i2 != 2 && d16 != 0.0) continue;
                c10.if = false;
            }
            string2 = ToWordsUtil.a(stringArray7, stringArray6.length, string8, bl2, string6, stringArray6, bl4);
        } else if ((n5 & 0x20) != 0) {
            String string9 = ToWordsUtil.a(d13, n4);
            if (d12 == 0.0) {
                string2 = ToWordsUtil.a(string9, n4 > 0 && bl2, n5, n2);
            } else {
                int n8;
                int n9 = ay.length;
                String[] stringArray = new String[n9];
                double[] dArray2 = new double[n9];
                for (n8 = 0; d12 > 0.0 && n8 < n9; ++n8) {
                    dArray2[n8] = d12 % 1000.0;
                    d12 = Math.floor((d12 - dArray2[n8]) / 1000.0);
                    stringArray[n8] = ToWordsUtil.a((int)dArray2[n8], n8);
                }
                string2 = ToWordsUtil.a(stringArray, n8, string9, bl2, dArray2);
            }
        } else {
            String string10 = d13 == 0.0 && n5 == 16 ? "" : ToWordsUtil.a(d13, n4, n5);
            if (d12 == 0.0) {
                return ToWordsUtil.a(string10, n4 > 0 && bl2, n5, n2);
            }
            if ((n5 & 2) != 0) {
                int n10;
                int n11 = D.length;
                String[] stringArray = new String[n11];
                double[] dArray3 = new double[n11];
                for (n10 = 0; d12 > 0.0 && n10 < n11; ++n10) {
                    dArray3[n10] = d12 % 1000.0;
                    d12 = Math.floor((d12 - dArray3[n10]) / 1000.0);
                    stringArray[n10] = ToWordsUtil.if((int)dArray3[n10]);
                }
                string2 = ToWordsUtil.int(stringArray, string10, n10, bl2, dArray3);
            } else if ((n5 & 4) != 0) {
                int n12;
                int n13 = Y.length;
                String[] stringArray = new String[n13];
                double[] dArray4 = new double[n13];
                for (n12 = 0; d12 > 0.0 && n12 < n13; ++n12) {
                    dArray4[n12] = d12 % 1000.0;
                    d12 = Math.floor((d12 - dArray4[n12]) / 1000.0);
                    stringArray[n12] = ToWordsUtil.a((int)dArray4[n12], n12 != 0);
                }
                string2 = ToWordsUtil.do(stringArray, string10, n12, bl2, dArray4);
            } else if ((n5 & 8) != 0) {
                int n14;
                int n15 = aP.length;
                String[] stringArray = new String[n15];
                double[] dArray5 = new double[n15];
                for (n14 = 0; d12 > 0.0 && n14 < n15; ++n14) {
                    dArray5[n14] = d12 % 1000.0;
                    d12 = Math.floor((d12 - dArray5[n14]) / 1000.0);
                    stringArray[n14] = ToWordsUtil.do((int)dArray5[n14], n14);
                }
                string2 = ToWordsUtil.a(stringArray, string10, n14, bl2, dArray5);
            } else if ((n5 & 0x10) != 0) {
                int n16;
                int n17 = aC.length;
                String[] stringArray = new String[n17];
                double[] dArray6 = new double[n17];
                ab = -1;
                for (n16 = 0; d12 > 0.0 && n16 < n17; ++n16) {
                    dArray6[n16] = d12 % 1000.0;
                    d12 = Math.floor((d12 - dArray6[n16]) / 1000.0);
                    stringArray[n16] = ToWordsUtil.if((int)dArray6[n16], n16);
                }
                string2 = ToWordsUtil.if(stringArray, string10, n16, bl2, dArray6);
            } else if ((n5 & 0x100) != 0) {
                int n18;
                int n19 = b.length;
                String[] stringArray = new String[n19];
                double[] dArray7 = new double[n19];
                for (n18 = 0; d12 > 0.0 && n18 < n19; ++n18) {
                    dArray7[n18] = d12 % 1000.0;
                    d12 = Math.floor((d12 - dArray7[n18]) / 1000.0);
                    stringArray[n18] = ToWordsUtil.for((int)dArray7[n18], n18);
                }
                string2 = ToWordsUtil.for(stringArray, string10, n18, bl2, dArray7);
            } else if ((n5 & 0x800) != 0) {
                int n20;
                int n21 = n.length;
                String[] stringArray = new String[n21];
                double[] dArray8 = new double[n21];
                for (n20 = 0; d12 > 0.0 && n20 < n21; ++n20) {
                    dArray8[n20] = d12 % 1000.0;
                    d12 = Math.floor((d12 - dArray8[n20]) / 1000.0);
                    stringArray[n20] = ToWordsUtil.a((int)dArray8[n20]);
                }
                string2 = ToWordsUtil.a(stringArray, string10, n20, bl2);
            } else {
                int n22;
                int n23 = ac.length;
                String[] stringArray = new String[n23];
                for (n22 = 0; d12 > 0.0 && n22 < n23; ++n22) {
                    double d17 = d12 % 1000.0;
                    d12 = Math.floor((d12 - d17) / 1000.0);
                    stringArray[n22] = ToWordsUtil.do((int)d17);
                }
                string2 = ToWordsUtil.if(stringArray, string10, n22, bl2);
            }
        }
        return string2;
    }

    private static final String if(Locale locale, double d10, int n2, int n3) {
        RuleBasedNumberFormat ruleBasedNumberFormat = com.crystaldecisions.reports.formulas.functions.string.ToWordsUtil$b.a(new a(locale, n3));
        double[] dArray = ToWordsUtil.if(d10, n3);
        double d11 = dArray[0];
        double d12 = dArray[1];
        switch (n2) {
            case 2: {
                return ruleBasedNumberFormat.format(d11, Q) + ruleBasedNumberFormat.format(d12, J);
            }
            case 1: {
                return ruleBasedNumberFormat.format(d11, U) + ruleBasedNumberFormat.format(d12, a3);
            }
        }
        return ruleBasedNumberFormat.format(d11, aG) + ruleBasedNumberFormat.format(d12, a);
    }

    private static String if(a a10) {
        String string;
        String string2;
        String string3;
        CharSequence charSequence;
        Locale locale = a10.a;
        int n2 = a10.if;
        CrystalResources crystalResources = com.crystaldecisions.reports.formulas.functions.string.ToWordsUtil$d.a(locale);
        String string4 = crystalResources.loadMessage("CheckIntegerRule", new Object[]{aG});
        if (n2 > 0) {
            charSequence = crystalResources.loadString("xLetter");
            string3 = charSequence;
            string2 = "0";
            for (int i2 = 1; i2 < n2; ++i2) {
                string3 = string3 + (String)charSequence;
                string2 = string2 + "0";
            }
            string = crystalResources.loadMessage("CheckFractionRule", new Object[]{a, string3, string2});
        } else {
            string = crystalResources.loadMessage("CheckFractionRuleNoDecimals", new Object[]{a});
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(string4);
        ((StringBuilder)charSequence).append(string);
        string3 = crystalResources.loadMessage("CasualIntegerRule", new Object[]{Q});
        string2 = n2 > 0 ? crystalResources.loadMessage("CasualFractionRule", new Object[]{J}) : crystalResources.loadMessage("CasualFractionRuleNoDecimals", new Object[]{J});
        if (!string3.equals(aS)) {
            ((StringBuilder)charSequence).append(string3);
        } else {
            ((StringBuilder)charSequence).append("%CasualIntegerRule: x.0: <%CheckIntegerRule<;");
        }
        if (!string2.equals(aS)) {
            ((StringBuilder)charSequence).append(string2);
        } else {
            ((StringBuilder)charSequence).append("%CasualFractionRule: x.0: <%CheckFractionRule<;");
        }
        String string5 = crystalResources.loadMessage("DailyIntegerRule", new Object[]{U});
        String string6 = n2 > 0 ? crystalResources.loadMessage("DailyFractionRule", new Object[]{a3}) : crystalResources.loadMessage("DailyFractionRuleNoDecimals", new Object[]{a3});
        if (!string5.equals(aS)) {
            ((StringBuilder)charSequence).append(string5);
        } else {
            ((StringBuilder)charSequence).append("%DailyIntegerRule: x.0: <%CheckIntegerRule<;");
        }
        if (!string6.equals(aS)) {
            ((StringBuilder)charSequence).append(string6);
        } else {
            ((StringBuilder)charSequence).append("%DailyFractionRule: x.0: <%CheckFractionRule<;");
        }
        return ((StringBuilder)charSequence).toString();
    }

    private static final class d {
        private static CrystalResourcesFactory a = new CrystalResourcesFactory("com.crystaldecisions.reports.formulas.functions.string.ToWords");

        public static CrystalResourcesFactory a() {
            return a;
        }

        public static CrystalResources a(Locale locale) {
            return a.getInstance(locale);
        }

        private d() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class a {
        public Locale a;
        public int if;

        public a(Locale locale, int n2) {
            this.a = locale;
            this.if = n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof a)) {
                return false;
            }
            a a10 = (a)object;
            return this.a.equals(a10.a) && this.if == a10.if;
        }

        public int hashCode() {
            int n2 = 17;
            n2 = 37 * n2 + this.a.hashCode();
            n2 = 37 * n2 + this.if;
            return n2;
        }
    }

    private static class b {
        private static final ThreadLocal<Map<RuleDescriptionInfo, RuleBasedNumberFormat>> a = new ThreadLocal<Map<RuleDescriptionInfo, RuleBasedNumberFormat>>(){

            protected Map<RuleDescriptionInfo, RuleBasedNumberFormat> a() {
                return new HashMap<RuleDescriptionInfo, RuleBasedNumberFormat>();
            }
        };

        private b() {
        }

        public static synchronized RuleBasedNumberFormat a(a a10) {
            Map<RuleDescriptionInfo, RuleBasedNumberFormat> map = a.get();
            RuleBasedNumberFormat ruleBasedNumberFormat = map.get(a10);
            if (ruleBasedNumberFormat == null) {
                ruleBasedNumberFormat = new RuleBasedNumberFormat(ToWordsUtil.if(a10));
                map.put((RuleDescriptionInfo)a10, ruleBasedNumberFormat);
            }
            return ruleBasedNumberFormat;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class c {
        private boolean if = false;
        private boolean a = false;

        private c() {
        }
    }
}

