/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.formulas.functions.financial;

import com.crystaldecisions.reports.common.value.ArrayValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.NumericValue;
import com.crystaldecisions.reports.formulas.FormulaEnvironment;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions.reports.formulas.FormulaFunctionDefinition;
import com.crystaldecisions.reports.formulas.FormulaResources;
import com.crystaldecisions.reports.formulas.FormulaValueReference;
import com.crystaldecisions.reports.formulas.functions.CommonArguments;
import com.crystaldecisions.reports.formulas.functions.FormulaFunctionFactory;

class f
implements FormulaFunctionFactory {
    private static final f fj = new f();
    private static final FormulaFunctionArgumentDefinition[][] fk = new FormulaFunctionArgumentDefinition[][]{{CommonArguments.currencyValuesArray, CommonArguments.financeRate, CommonArguments.reinvestRate}};
    private static final FormulaFunctionDefinition[] fl = new FormulaFunctionDefinition[]{new a(fk[0])};

    private f() {
    }

    public static f aK() {
        return fj;
    }

    public FormulaFunctionDefinition getFunctionInstance(int n2) {
        return fl[n2];
    }

    public int getNFunctionInstances() {
        return fl.length;
    }

    private static class a
    extends FormulaFunctionBase {
        public a(FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray) {
            super("MIRR", "mirr", formulaFunctionArgumentDefinitionArray);
        }

        public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            if (formulaValueReferenceArray[0].getFormulaValue() != null) {
                FormulaValue[] formulaValueArray = ((ArrayValue)formulaValueReferenceArray[0].getFormulaValue()).getArray();
                boolean bl2 = false;
                boolean bl3 = false;
                for (FormulaValue formulaValue : formulaValueArray) {
                    double d10 = ((NumericValue)formulaValue).getScaledDouble();
                    if (d10 < 0.0) {
                        bl3 = true;
                        continue;
                    }
                    if (bl2 || !(d10 > 0.0)) continue;
                    bl2 = true;
                }
                if (!bl2 || !bl3) {
                    String[] stringArray = new String[]{"MIRR"};
                    throw new FormulaFunctionArgumentException("JRC00002393", "", FormulaResources.a(), "InvalidValuesArray", stringArray, 0);
                }
            }
            return FormulaValueType.number;
        }

        public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            this.validate(formulaValueReferenceArray, formulaEnvironment);
            FormulaValue[] formulaValueArray = ((ArrayValue)formulaValueReferenceArray[0].getFormulaValue()).getArray();
            double d10 = ((NumberValue)formulaValueReferenceArray[1].getFormulaValue()).getDouble();
            double d11 = ((NumberValue)formulaValueReferenceArray[2].getFormulaValue()).getDouble();
            double d12 = 1.0;
            double d13 = 1.0;
            double d14 = 0.0;
            double d15 = 0.0;
            int n2 = formulaValueArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                double d16;
                double d17 = ((NumericValue)formulaValueArray[n2 - i2 - 1]).getScaledDouble();
                if (d17 > 0.0) {
                    d15 += d17 * d12;
                }
                if ((d16 = ((NumericValue)formulaValueArray[i2]).getScaledDouble()) < 0.0) {
                    d14 += d16 / d13;
                }
                d12 *= 1.0 + d11;
                d13 *= 1.0 + d10;
            }
            double d18 = Math.pow(-d15 / d14, 1.0 / (double)(n2 - 1)) - 1.0;
            return NumberValue.fromDouble((double)d18);
        }
    }
}

