/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.File;
import java.io.IOException;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NLParamParser;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.resolver.NamingAdapterInterface;

public class TNSNamesNamingAdapter
implements NamingAdapterInterface {
    private NLParamParser tnsEntriesHdl;
    private String tnsDir;
    private long lastModifiedTime;
    private long nextPollTime;
    private static final String TNSFILE = "tnsnames.ora";
    private static final long REFRESH_INTERVAL = 0L;

    public TNSNamesNamingAdapter(String string) {
        this.tnsDir = string;
        this.resetAttr();
    }

    private void resetAttr() {
        this.tnsEntriesHdl = null;
        this.lastModifiedTime = 0L;
        this.nextPollTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolve(String string) throws NetException {
        NVPair nVPair = null;
        TNSNamesNamingAdapter tNSNamesNamingAdapter = this;
        synchronized (tNSNamesNamingAdapter) {
            this.checkAndReload();
            nVPair = this.tnsEntriesHdl.getNLPListElement(string);
        }
        if (nVPair == null) {
            throw new NetException(122, "\"" + string + "\"");
        }
        return nVPair.valueToString();
    }

    private void loadFile() throws NetException {
        File file = new File(this.tnsDir, TNSFILE);
        String string = file.getAbsolutePath();
        if (!file.isFile() || !file.canRead()) {
            this.resetAttr();
            throw new NetException(123, ": " + string);
        }
        long l2 = file.lastModified();
        if (this.lastModifiedTime != l2) {
            try {
                this.tnsEntriesHdl = new NLParamParser(string, 1);
                this.lastModifiedTime = l2;
            }
            catch (IOException iOException) {
                this.resetAttr();
                throw new NetException(123, ": " + string);
            }
            catch (NLException nLException) {
                // empty catch block
            }
        }
    }

    private void checkAndReload() throws NetException {
        long l2 = System.currentTimeMillis();
        if (l2 > this.nextPollTime) {
            this.nextPollTime = l2 + 0L;
            this.loadFile();
        }
    }
}

