/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.logging.log4j;

import com.businessobjects.foundation.logging.ILogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class Log4jLogger
extends Logger
implements ILogger {
    private static String FQCN = Log4jLogger.class.getName();

    Log4jLogger(String name) {
        super(name);
    }

    public void assertTrue(boolean assertion) {
        if (!assertion && this.isEnabledFor((Priority)Level.ERROR)) {
            this.forcedLog(FQCN, (Priority)Level.ERROR, "Assertion failed.", (Throwable)((Object)new AssertionError()));
        }
    }

    public void assertTrue(boolean assertion, String msg) {
        if (!assertion && this.isEnabledFor((Priority)Level.ERROR)) {
            this.forcedLog(FQCN, (Priority)Level.ERROR, "Assertion failed: " + msg, (Throwable)((Object)new AssertionError()));
        }
    }

    public void assertNotNull(Object object) {
        if (object == null && this.isEnabledFor((Priority)Level.ERROR)) {
            this.forcedLog(FQCN, (Priority)Level.ERROR, "Assertion failed: reference is null.", (Throwable)((Object)new AssertionError()));
        }
    }

    public void assertNotNull(Object object, String msg) {
        if (object == null && this.isEnabledFor((Priority)Level.ERROR)) {
            this.forcedLog(FQCN, (Priority)Level.ERROR, "Assertion failed: " + msg, (Throwable)((Object)new AssertionError()));
        }
    }

    public void assertEqual(Object obj1, Object obj2) {
        if (this.isEnabledFor((Priority)Level.ERROR) && obj1 != obj2 && (obj1 == null || !obj1.equals(obj2))) {
            this.forcedLog(FQCN, (Priority)Level.ERROR, "Assertion failed: " + obj1 + " is not equal to " + obj2 + ".", (Throwable)((Object)new AssertionError()));
        }
    }

    public void logEntry(String className, String methodName, Object[] parameters) {
        if (this.isEnabledFor((Priority)Level.DEBUG)) {
            StringBuffer msgBuffer = new StringBuffer("Entering ");
            msgBuffer.append(className).append(".").append(methodName);
            if (parameters != null && parameters.length > 0) {
                msgBuffer.append(" (").append(parameters[0]);
                for (int i = 1; i < parameters.length; ++i) {
                    msgBuffer.append(", ").append(parameters[i]);
                }
                msgBuffer.append(")");
            }
            this.forcedLog(FQCN, (Priority)Level.DEBUG, msgBuffer, null);
        }
    }

    public Object logReturn(String className, String methodName, Object returnValue) {
        if (this.isEnabledFor((Priority)Level.DEBUG)) {
            this.forcedLog(FQCN, (Priority)Level.DEBUG, "Leaving " + className + "." + methodName + " (" + returnValue + ")", null);
        }
        return returnValue;
    }

    public void logReturn(String className, String methodName) {
        if (this.isEnabledFor((Priority)Level.DEBUG)) {
            this.forcedLog(FQCN, (Priority)Level.DEBUG, "Leaving " + className + "." + methodName, null);
        }
    }

    public boolean isErrorEnabled() {
        return this.isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.isEnabledFor((Priority)Level.FATAL);
    }

    public boolean isWarnEnabled() {
        return this.isEnabledFor((Priority)Level.WARN);
    }
}

