/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputArchive;
import com.crystaldecisions.reports.common.archive.IOutputArchive;
import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataOutput;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.io.DataInput;
import java.io.IOException;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public final class DateTimeValue
extends FormulaValue
implements Comparable {
    private final DateValue b;
    private final TimeValue c;

    private DateTimeValue(DateValue dateValue, TimeValue timeValue) {
        assert (dateValue != null || timeValue != null) : "dateValue and timeValue canot be simaltaneously null";
        this.b = dateValue;
        this.c = timeValue;
    }

    public void store(ValueType valueType, ExtendedDataOutput extendedDataOutput) throws IOException {
        assert (valueType == this.getValueType());
        extendedDataOutput.writeBoolean(this.b != null);
        extendedDataOutput.writeBoolean(this.c != null);
        if (this.b != null) {
            this.b.store(this.b.getValueType(), extendedDataOutput);
        }
        if (this.c != null) {
            this.c.store(this.c.getValueType(), extendedDataOutput);
        }
    }

    public void storeToArchive(ValueType valueType, IOutputArchive iOutputArchive) throws ArchiveException {
        assert (valueType == this.getValueType());
        iOutputArchive.storeBoolean(this.b != null);
        iOutputArchive.storeBoolean(this.c != null);
        if (this.b != null) {
            this.b.storeToArchive(this.b.getValueType(), iOutputArchive);
        }
        if (this.c != null) {
            this.c.storeToArchive(this.c.getValueType(), iOutputArchive);
        }
    }

    public static DateTimeValue Load(DataInput dataInput) throws IOException {
        boolean bl = dataInput.readBoolean();
        boolean bl2 = dataInput.readBoolean();
        DateValue dateValue = bl ? DateValue.Load(dataInput) : null;
        TimeValue timeValue = bl2 ? TimeValue.Load(dataInput) : null;
        return DateTimeValue.fromDateAndTimeValues(dateValue, timeValue);
    }

    public static DateTimeValue LoadFromArchive(IInputArchive iInputArchive) throws ArchiveException {
        boolean bl = iInputArchive.loadBoolean();
        boolean bl2 = iInputArchive.loadBoolean();
        DateValue dateValue = bl ? DateValue.LoadFromArchive(iInputArchive) : null;
        TimeValue timeValue = bl2 ? TimeValue.LoadFromArchive(iInputArchive) : null;
        return DateTimeValue.fromDateAndTimeValues(dateValue, timeValue);
    }

    public int getEncodedSizeForArchive(ValueType valueType) {
        assert (valueType == this.getValueType());
        int n = 4;
        n += this.b != null ? this.b.getEncodedSizeForArchive(this.b.getValueType()) : 0;
        return n += this.c != null ? this.c.getEncodedSizeForArchive(this.c.getValueType()) : 0;
    }

    public static int GetMaxEncodedSize() {
        return 2 + DateValue.GetMaxEncodedSize() + TimeValue.GetMaxEncodedSize();
    }

    public int getEncodedSize(ValueType valueType) {
        assert (valueType == this.getValueType());
        int n = 2;
        n += this.b != null ? this.b.getEncodedSize(this.b.getValueType()) : 0;
        return n += this.c != null ? this.c.getEncodedSize(this.c.getValueType()) : 0;
    }

    public static DateTimeValue Normalize(Integer n, Long l) {
        if (n == null && l == null) {
            return null;
        }
        int n2 = 0;
        boolean bl = false;
        TimeValue timeValue = null;
        if (l != null) {
            boolean bl2 = bl = l < 0L;
            if (l < 0L || l >= 86400000000000L) {
                if (bl) {
                    l = -l.longValue() - 1L;
                }
                n2 = (int)(l / 86400000000000L);
                long l2 = l % 86400000000000L;
                l = bl ? Long.valueOf(86400000000000L - l2 - 1L) : Long.valueOf(l2);
            }
            timeValue = TimeValue.fromTimeInNs(l);
        }
        DateValue dateValue = null;
        if (n != null) {
            n = bl ? Integer.valueOf(n - (n2 + 1)) : Integer.valueOf(n + n2);
            dateValue = DateValue.fromCRDate(n);
        }
        return new DateTimeValue(dateValue, timeValue);
    }

    public static DateTimeValue now() {
        return DateTimeValue.fromCalendar(new GregorianCalendar(Locale.US));
    }

    public static DateTimeValue fromDateAndTimeValues(DateValue dateValue, TimeValue timeValue) {
        if (dateValue == null && timeValue == null) {
            return null;
        }
        return new DateTimeValue(dateValue, timeValue);
    }

    public static DateTimeValue fromDateValue(DateValue dateValue) {
        if (dateValue == null) {
            return null;
        }
        return new DateTimeValue(dateValue, null);
    }

    public static DateTimeValue fromCalendar(Calendar calendar) {
        return DateTimeValue.fromDateAndTimeValues(DateValue.fromCalendar(calendar), TimeValue.fromCalendar(calendar));
    }

    public static DateTimeValue fromOleDate(double d) {
        return DateTimeValue.fromDateAndTimeValues(DateValue.fromOleDate(d), TimeValue.fromOleDate(d));
    }

    public FormulaValue coerceToDate() {
        return this.getDateValue();
    }

    public FormulaValue coerceToTime() {
        return this.getTimeValue();
    }

    public FormulaValue coerceToDateTime() {
        return this;
    }

    public double getOleDate() {
        double d = this.b.getOleDate();
        double d2 = this.c.getOleDate();
        return d >= 0.0 ? d + d2 : d - d2;
    }

    public DateValue getDateValue() {
        return this.b;
    }

    public TimeValue getTimeValue() {
        return this.c;
    }

    public ValueType getValueType() {
        return ValueType.dateTime;
    }

    public int hashCode(boolean bl) {
        int n = 17;
        n = 37 * n + (this.b == null ? 0 : this.b.hashCode());
        n = 37 * n + (this.c == null ? 0 : this.c.hashCode());
        return n;
    }

    public boolean equals(Object object, boolean bl) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object, Comparator comparator) {
        return this.compareTo(object);
    }

    public int compareTo(Object object) {
        DateTimeValue dateTimeValue = (DateTimeValue)object;
        if (this.b == null && dateTimeValue.getDateValue() != null || this.c == null && dateTimeValue.getTimeValue() != null) {
            return -1;
        }
        int n = 0;
        if (this.b != null) {
            n = this.b.compareTo(dateTimeValue.b);
        }
        if (n == 0 && this.c != null) {
            n = this.c.compareTo(dateTimeValue.c);
        }
        return n;
    }

    public DateTimeValue addNumberToDateTime(double d) {
        int n = (int)d;
        Long l = null;
        if (this.c != null) {
            double d2 = d - (double)n;
            long l2 = Math.round(d2 * 86400.0);
            l = this.c.getTimeInNs() + l2 * 1000000000L;
        }
        Integer n2 = null;
        if (this.b != null) {
            n2 = this.b.getCRDate() + n;
        }
        return DateTimeValue.Normalize(n2, l);
    }

    public String toString() {
        return "dt(" + this.b + "," + this.c + ")";
    }

    public static double To1900Format(DateTimeValue dateTimeValue) {
        if (dateTimeValue.getDateValue().getCRDate() == -1 && dateTimeValue.getTimeValue().getCRTime() == -1) {
            return 1.0;
        }
        double d = DateValue.To1900Format(dateTimeValue.getDateValue());
        double d2 = TimeValue.To1900Format(dateTimeValue.getTimeValue());
        CrystalAssert.ASSERT(d2 < 1.0);
        if (d < 0.0) {
            d2 = -d2;
        }
        return d + d2;
    }

    public static DateTimeValue From1900Format(double d) {
        int n = (int)Math.floor(d);
        double d2 = Math.abs(d - (double)n);
        DateValue dateValue = DateValue.From1900Format(n);
        TimeValue timeValue = TimeValue.From1900Format(d2);
        return new DateTimeValue(dateValue, timeValue);
    }

    public Date getJavaDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(this.b.getYear(), this.b.getMonth() - 1, this.b.getDay(), this.c == null ? 0 : this.c.getHours(), this.c == null ? 0 : this.c.getMinutes(), this.c == null ? 0 : this.c.getWholeSeconds());
        return calendar.getTime();
    }

    public boolean crEquals(DateTimeValue dateTimeValue) {
        if (dateTimeValue == null) {
            return false;
        }
        return this.getDateValue().equals(dateTimeValue.getDateValue()) && this.getTimeValue().getCRTime() == dateTimeValue.getTimeValue().getCRTime();
    }
}

