/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.net.ano.Ano;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.SQLnetDef;
import oracle.net.nt.ConnOption;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.TcpsNTAdapter;

public class SessionAtts
implements SQLnetDef {
    private int sdu;
    private int tdu;
    protected NSProtocol ns;
    protected NTAdapter nt;
    protected InputStream ntInputStream;
    protected OutputStream ntOutputStream;
    protected NetInputStream nsInputStream;
    protected NetOutputStream nsOutputStream;
    protected ConnOption cOption;
    protected boolean dataEOF;
    protected boolean connected;
    public boolean onBreakReset;
    public ClientProfile profile;
    public Ano ano;
    public boolean anoEnabled;
    public boolean isEncryptionActive;
    public boolean isChecksumActive;
    public boolean areEncryptionAndChecksumActive;
    boolean noAnoServices;
    int negotiatedOptions;
    public boolean poolEnabled = false;
    protected byte[] sessionId;
    protected int timeout;
    protected int tick;
    protected byte[] reconnectAddress;
    protected long timestampLastIO;
    protected boolean attemptingReconnect = false;
    boolean enableJavaNetFastPath = false;
    public boolean anoActive;
    String traceId;

    public SessionAtts(NSProtocol nsp, int sdu, int tdu) {
        this.sdu = sdu;
        this.tdu = tdu;
        this.ns = nsp;
        this.anoActive = false;
    }

    public void setSDU(int sdu) {
        this.sdu = sdu <= 0 ? 8192 : (sdu > 65535 ? 65535 : (sdu < 512 ? 512 : sdu));
    }

    public int getSDU() {
        return this.sdu;
    }

    public void setTDU(int tdu) {
        this.tdu = tdu <= 0 ? Short.MAX_VALUE : (tdu > 65535 ? 65535 : (tdu < 255 ? 255 : tdu));
    }

    public int getTDU() {
        return this.tdu;
    }

    public NTAdapter getNTAdapter() {
        return this.nt;
    }

    void renegotiateSSLSession() throws IOException {
        ((TcpsNTAdapter)this.nt).renegotiateSession();
        this.ntInputStream = this.nt.getInputStream();
        this.ntOutputStream = this.nt.getOutputStream();
    }

    public String toString() {
        return "Session Attributes: \nsdu=" + this.sdu + ", tdu=" + this.tdu + "\nnt: " + this.nt + "\n\nntInputStream : " + this.ntInputStream + "\nntOutputStream: " + this.ntOutputStream + "\nnsInputStream : " + this.nsInputStream + "\nnsOutputStream: " + this.nsOutputStream + "\n\nClient Profile: " + this.profile + "\n\nConnection Options: " + this.cOption + "\n\nonBreakReset=" + this.onBreakReset + ", dataEOF=" + this.dataEOF + ", negotiatedOptions=0x" + Integer.toHexString(this.negotiatedOptions) + ", connected=" + this.connected;
    }

    public void turnEncryptionOn(NetInputStream anoIn, NetOutputStream anoOut) throws NetException {
        if (anoIn == null || anoOut == null) {
            throw new NetException(300);
        }
        this.nsInputStream = anoIn;
        this.nsOutputStream = anoOut;
        this.anoActive = true;
    }

    public int getANOFlags() {
        int flags = 1;
        if (this.ano != null) {
            flags = this.ano.getNAFlags();
        }
        return flags;
    }

    public OutputStream getOutputStream() {
        return this.nsOutputStream;
    }

    public InputStream getInputStream() {
        return this.nsInputStream;
    }

    public void setNegotiatedOptions(int value) {
        this.negotiatedOptions = value;
    }

    public int getNegotiatedOptions() {
        return this.negotiatedOptions;
    }
}

