/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import oracle.jdbc.NotificationRegistration;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFAQRegistration;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NTFEventListener;
import oracle.jdbc.driver.NTFXSEvent;
import oracle.jdbc.driver.Namespace;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C7Ocommoncall;
import oracle.jdbc.driver.T4C7Oversion;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4C8Oclose;
import oracle.jdbc.driver.T4C8Odscrarr;
import oracle.jdbc.driver.T4C8TTIBfile;
import oracle.jdbc.driver.T4C8TTIBlob;
import oracle.jdbc.driver.T4C8TTIClob;
import oracle.jdbc.driver.T4C8TTIdty;
import oracle.jdbc.driver.T4C8TTIpro;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CStatement;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.driver.T4CTTIoauthenticate;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.driver.T4CTTIokeyval;
import oracle.jdbc.driver.T4CTTIokpn;
import oracle.jdbc.driver.T4CTTIoping;
import oracle.jdbc.driver.T4CTTIoscid;
import oracle.jdbc.driver.T4CTTIoses;
import oracle.jdbc.driver.T4CTTIoxsscs;
import oracle.jdbc.driver.T4CTTIoxsspo;
import oracle.jdbc.driver.T4CTTIoxssro;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.driver.T4CTTIspfp;
import oracle.jdbc.driver.T4CTTIsto;
import oracle.jdbc.driver.T4CTTIxsnsop;
import oracle.jdbc.driver.T4CXAResource;
import oracle.jdbc.driver.T4Caqdq;
import oracle.jdbc.driver.T4Caqe;
import oracle.jdbc.internal.KeywordValue;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.XSEventListener;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.net.ns.Communication;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.LobPlsqlUtil;
import oracle.sql.TIMESTAMPTZ;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class T4CConnection
extends PhysicalConnection
implements BfileDBAccess,
BlobDBAccess,
ClobDBAccess {
    static final short MIN_TTCVER_SUPPORTED = 4;
    static final short V8_TTCVER_SUPPORTED = 5;
    static final short MAX_TTCVER_SUPPORTED = 6;
    static final int DEFAULT_LONG_PREFETCH_SIZE = 4080;
    static final String DEFAULT_CONNECT_STRING = "localhost:1521:orcl";
    static final int STREAM_CHUNK_SIZE = 255;
    static final int REFCURSOR_SIZE = 5;
    long LOGON_MODE = 0L;
    boolean isLoggedOn;
    private boolean useZeroCopyIO;
    boolean useLobPrefetch;
    private String password;
    Communication net;
    int eocs;
    private NTFEventListener[] xsListeners = new NTFEventListener[0];
    boolean readAsNonStream;
    T4CTTIoer oer;
    T4CMAREngine mare;
    T4C8TTIpro pro;
    T4CTTIrxd rxd;
    T4CTTIsto sto;
    T4CTTIspfp spfp;
    T4CTTIoauthenticate auth;
    T4C8Odscrarr describe;
    T4C8Oall all8;
    T4C8Oclose close8;
    T4C7Ocommoncall commoncall;
    T4Caqe aqe;
    T4Caqdq aqdq;
    T4C8TTIBfile bfileMsg;
    T4C8TTIBlob blobMsg;
    T4C8TTIClob clobMsg;
    T4CTTIoses oses;
    T4CTTIoping oping;
    T4CTTIokpn okpn;
    byte[] EMPTY_BYTE = new byte[0];
    T4CTTIOtxen otxen;
    T4CTTIOtxse otxse;
    T4CTTIk2rpc k2rpc;
    T4CTTIoscid oscid;
    T4CTTIokeyval okeyval;
    T4CTTIoxsscs oxsscs;
    T4CTTIoxssro oxssro;
    T4CTTIoxsspo oxsspo;
    T4CTTIxsnsop xsnsop;
    int[] cursorToClose;
    int cursorToCloseOffset;
    int lastCursorToCloseOffset;
    int[] queryToClose;
    int queryToCloseOffset;
    int[] lusFunctionId2;
    byte[][] lusSessionId2;
    KeywordValueLong[][] lusInKeyVal2;
    int[] lusInFlags2;
    int lusOffset2;
    int sessionId;
    int serialNumber;
    byte negotiatedTTCversion;
    byte[] serverRuntimeCapabilities;
    byte[] serverCompileTimeCapabilities;
    Hashtable namespaces;
    byte[] internalName;
    byte[] externalName;
    static final int FREE = -1;
    static final int SEND = 1;
    static final int RECEIVE = 2;
    int pipeState = -1;
    boolean sentCancel = false;
    String currentSchema;
    boolean cancelInProgressFlag = false;
    boolean statementCancel = true;
    byte currentTTCSeqNumber = 0;
    private final CRC32 checksumEngine = new CRC32();
    private final Hashtable<Long, Integer> tempLobRefCount = new Hashtable();
    static final int MAX_SIZE_VSESSION_OSUSER = 30;
    static final int MAX_SIZE_VSESSION_PROCESS = 24;
    static final int MAX_SIZE_VSESSION_MACHINE = 64;
    static final int MAX_SIZE_VSESSION_TERMINAL = 30;
    static final int MAX_SIZE_VSESSION_PROGRAM = 48;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CConnection(String ur, Properties info, OracleDriverExtension ext) throws SQLException {
        super(ur, info, ext);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(ur) + ", " + OracleLog.argument(info) + ", " + OracleLog.argument(ext));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.cursorToClose = new int[4];
            this.cursorToCloseOffset = 0;
            this.queryToClose = new int[10];
            this.queryToCloseOffset = 0;
            this.lusFunctionId2 = new int[10];
            this.lusSessionId2 = new byte[10][];
            this.lusInKeyVal2 = new KeywordValueLong[10][];
            this.lusInFlags2 = new int[10];
            this.lusOffset2 = 0;
            this.minVcsBindSize = 0;
            this.streamChunkSize = 255;
            this.namespaces = new Hashtable(5);
            this.currentSchema = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    final void initializePassword(String p2) throws SQLException {
        this.password = p2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void logon() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException savedSQLException = null;
            try {
                if (this.isLoggedOn) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 428);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 428);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.database == null) {
                    this.database = DEFAULT_CONNECT_STRING;
                }
                this.connect(this.database);
                this.all8 = new T4C8Oall(this);
                this.okpn = new T4CTTIokpn(this);
                this.close8 = new T4C8Oclose(this);
                this.sto = new T4CTTIsto(this);
                this.spfp = new T4CTTIspfp(this);
                this.commoncall = new T4C7Ocommoncall(this);
                this.describe = new T4C8Odscrarr(this);
                this.bfileMsg = new T4C8TTIBfile(this);
                this.blobMsg = new T4C8TTIBlob(this);
                this.clobMsg = new T4C8TTIClob(this);
                this.otxen = new T4CTTIOtxen(this);
                this.otxse = new T4CTTIOtxse(this);
                this.oping = new T4CTTIoping(this);
                this.k2rpc = new T4CTTIk2rpc(this);
                this.oses = new T4CTTIoses(this);
                this.okeyval = new T4CTTIokeyval(this);
                this.oxssro = new T4CTTIoxssro(this);
                this.oxsspo = new T4CTTIoxsspo(this);
                this.oxsscs = new T4CTTIoxsscs(this);
                this.xsnsop = new T4CTTIxsnsop(this);
                this.aqe = new T4Caqe(this);
                this.aqdq = new T4Caqdq(this);
                this.oscid = new T4CTTIoscid(this);
                this.LOGON_MODE = 0L;
                if (this.internalLogon != null) {
                    if (this.internalLogon.equalsIgnoreCase("sysoper")) {
                        this.LOGON_MODE = 64L;
                    } else if (this.internalLogon.equalsIgnoreCase("sysdba")) {
                        this.LOGON_MODE = 32L;
                    } else if (this.internalLogon.equalsIgnoreCase("sysasm")) {
                        this.LOGON_MODE = 0x400000L;
                    } else if (this.internalLogon.equalsIgnoreCase("sysbackup")) {
                        this.LOGON_MODE = 0x1000000L;
                    } else if (this.internalLogon.equalsIgnoreCase("sysdg")) {
                        this.LOGON_MODE = 0x2000000L;
                    } else if (this.internalLogon.equalsIgnoreCase("syskm")) {
                        this.LOGON_MODE = 0x4000000L;
                    }
                }
                if (this.prelimAuth) {
                    this.LOGON_MODE |= 0x80L;
                }
                this.auth = new T4CTTIoauthenticate(this, this.resourceManagerId, this.serverCompileTimeCapabilities);
                if (this.userName != null && this.userName.length() != 0) {
                    try {
                        this.auth.doOSESSKEY(this.userName, this.LOGON_MODE);
                    }
                    catch (SQLException qe) {
                        if (qe.getErrorCode() == 1017) {
                            savedSQLException = qe;
                            this.userName = null;
                        }
                        throw qe;
                    }
                }
                this.auth.doOAUTH(this.userName, this.password, this.LOGON_MODE);
                this.sessionId = this.getSessionId();
                this.serialNumber = this.getSerialNumber();
                this.internalName = this.auth.internalName;
                this.externalName = this.auth.externalName;
                this.instanceName = this.sessionProperties.getProperty("AUTH_INSTANCENAME");
                if (!this.prelimAuth) {
                    T4C7Oversion ver = new T4C7Oversion(this);
                    ver.doOVERSION();
                    byte[] resultBytes = ver.getVersion();
                    try {
                        this.databaseProductVersion = new String(resultBytes, "UTF8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    this.versionNumber = ver.getVersionNumber();
                } else {
                    this.versionNumber = 0;
                }
                this.isLoggedOn = true;
                if (this.getVersionNumber() < 11000) {
                    this.enableTempLobRefCnt = false;
                }
            }
            catch (NetException e2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (SQLException se) {
                block69: {
                    if (savedSQLException != null) {
                        se.initCause(savedSQLException);
                    }
                    try {
                        this.net.disconnect();
                    }
                    catch (Exception e3) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block69;
                        try {
                            T4CConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CConnection.logon: Exception in net.disconnect: " + e3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                this.isLoggedOn = false;
                throw se;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleIOException(IOException ea) throws SQLException {
        try {
            block19: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(ea));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                try {
                    this.pipeState = -1;
                    this.net.disconnect();
                    this.net = null;
                }
                catch (Exception e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block19;
                    try {
                        T4CConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CConnection.handleIOException: Exception in net.disconnect: " + e2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            this.isLoggedOn = false;
            this.lifecycle = 4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void logoff() throws SQLException {
        block51: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                try {
                    this.assertLoggedOn("T4CConnection.logoff");
                    if (this.lifecycle == 8) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        return;
                    }
                    this.sendPiggyBackedMessages();
                    this.commoncall.doOLOGOFF();
                    this.net.disconnect();
                    this.net = null;
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    if (this.lifecycle == 8) break block51;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                finally {
                    block53: {
                        try {
                            if (this.net != null) {
                                this.net.disconnect();
                            }
                        }
                        catch (Exception e2) {
                            if (!TRACE || !OracleLog.recursiveEnter()) break block53;
                            try {
                                T4CConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CConnection.logon: Exception in net.disconnect: " + e2);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                    }
                    this.isLoggedOn = false;
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    T4CMAREngine getMarshalEngine() {
        return this.mare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void doCommit(int flags) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(flags));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("T4CConnection.do_commit");
            try {
                this.sendPiggyBackedMessages();
                if (flags == 0) {
                    this.commoncall.doOCOMMIT();
                } else {
                    int txnflgs = 0;
                    if ((flags & OracleConnection.CommitOption.WRITEBATCH.getCode()) != 0) {
                        txnflgs = txnflgs | 2 | 1;
                    } else if ((flags & OracleConnection.CommitOption.WRITEIMMED.getCode()) != 0) {
                        txnflgs |= 2;
                    }
                    if ((flags & OracleConnection.CommitOption.NOWAIT.getCode()) != 0) {
                        txnflgs = txnflgs | 8 | 4;
                    } else if ((flags & OracleConnection.CommitOption.WAIT.getCode()) != 0) {
                        txnflgs |= 8;
                    }
                    this.otxen.doOTXEN(1, null, null, 0, 0, 0, 0, 4, txnflgs);
                    int outState = this.otxen.getOutStateFromServer();
                    if (outState != 2 && outState == 4) {
                        // empty if block
                    }
                }
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void doRollback() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                this.assertLoggedOn("T4CConnection.do_rollback");
                this.sendPiggyBackedMessages();
                this.commoncall.doOROLLBACK();
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void doSetAutoCommit(boolean on) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.autocommit = on;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open(OracleStatement stmt) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("T4CConnection.open");
            stmt.setCursorId(0);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized String doGetDatabaseProductVersion() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("T4CConnection.do_getDatabaseProductVersion");
            T4C7Oversion ver = new T4C7Oversion(this);
            try {
                ver.doOVERSION();
            }
            catch (IOException e2) {
                this.handleIOException(e2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String databaseProductVersion = null;
            byte[] resultBytes = ver.getVersion();
            try {
                databaseProductVersion = new String(resultBytes, "UTF8");
            }
            catch (UnsupportedEncodingException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + databaseProductVersion);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = databaseProductVersion;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized short doGetVersionNumber() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("T4CConnection.do_getVersionNumber");
            T4C7Oversion ver = new T4C7Oversion(this);
            try {
                ver.doOVERSION();
            }
            catch (IOException e2) {
                this.handleIOException(e2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ver.getVersionNumber());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short s2 = ver.getVersionNumber();
            return s2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleStatement RefCursorBytesToStatement(byte[] bytes, OracleStatement parent) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(parent));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CStatement newstmt = new T4CStatement(this, -1, -1);
            try {
                int cursor = this.mare.unmarshalRefCursor(bytes);
                newstmt.setCursorId(cursor);
                newstmt.isOpen = true;
                newstmt.sqlObject = parent.sqlObject;
                newstmt.serverCursor = true;
                parent.addChild(newstmt);
                newstmt.prepareForNewResults(true, false);
            }
            catch (IOException e2) {
                this.handleIOException(e2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            newstmt.sqlStringChanged = false;
            newstmt.needToParse = false;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + newstmt);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CStatement t4CStatement = newstmt;
            return t4CStatement;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void cancelOperationOnServer(boolean isStatementCancel) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = this.cancelInProgressLockForThin;
            synchronized (object) {
                if (this.cancelInProgressFlag) return;
                try {
                    switch (this.pipeState) {
                        case -1: {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CConnection.cancelOperationOnServer: pipeState = FREE, aborting cancel.");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            if (!TRACE) return;
                            if (!OracleLog.recursiveEnter()) return;
                            try {
                                T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                            return;
                        }
                        case 1: {
                            this.net.sendBreak();
                            break;
                        }
                        case 2: {
                            this.net.sendInterrupt();
                            break;
                        }
                    }
                    this.sentCancel = true;
                }
                catch (NetException ne) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ne);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ne);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (IOException ne) {
                    this.handleIOException(ne);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ne);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ne);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.cancelInProgressFlag = true;
                this.statementCancel = isStatementCancel;
                return;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(String database) throws IOException, SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(database));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (database == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 433);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 433);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Properties nsProperties = new Properties();
            if (this.thinNetProfile != null) {
                nsProperties.setProperty("oracle.net.profile", this.thinNetProfile);
            }
            if (this.thinNetAuthenticationServices != null) {
                nsProperties.setProperty("oracle.net.authentication_services", this.thinNetAuthenticationServices);
            }
            if (this.thinNetAuthenticationKrb5Mutual != null) {
                nsProperties.setProperty("oracle.net.kerberos5_mutual_authentication", this.thinNetAuthenticationKrb5Mutual);
            }
            if (this.thinNetAuthenticationKrb5CcName != null) {
                nsProperties.setProperty("oracle.net.kerberos5_cc_name", this.thinNetAuthenticationKrb5CcName);
            }
            if (this.thinNetEncryptionLevel != null) {
                nsProperties.setProperty("oracle.net.encryption_client", this.thinNetEncryptionLevel);
            }
            if (this.thinNetEncryptionTypes != null) {
                nsProperties.setProperty("oracle.net.encryption_types_client", this.thinNetEncryptionTypes);
            }
            if (this.thinNetChecksumLevel != null) {
                nsProperties.setProperty("oracle.net.crypto_checksum_client", this.thinNetChecksumLevel);
            }
            if (this.thinNetChecksumTypes != null) {
                nsProperties.setProperty("oracle.net.crypto_checksum_types_client", this.thinNetChecksumTypes);
            }
            if (this.thinNetCryptoSeed != null) {
                nsProperties.setProperty("oracle.net.crypto_seed", this.thinNetCryptoSeed);
            }
            if (this.thinTcpNoDelay) {
                nsProperties.setProperty("TCP.NODELAY", "YES");
            }
            if (this.thinReadTimeout != null) {
                nsProperties.setProperty("oracle.net.READ_TIMEOUT", this.thinReadTimeout);
            }
            if (this.thinNetConnectTimeout != null) {
                nsProperties.setProperty("oracle.net.CONNECT_TIMEOUT", this.thinNetConnectTimeout);
            }
            if (this.thinSslServerDnMatch != null) {
                nsProperties.setProperty("oracle.net.ssl_server_dn_match", this.thinSslServerDnMatch);
            }
            if (this.walletLocation != null) {
                nsProperties.setProperty("oracle.net.wallet_location", this.walletLocation);
            }
            if (this.walletPassword != null) {
                nsProperties.setProperty("oracle.net.wallet_password", this.walletPassword);
            }
            if (this.thinSslVersion != null) {
                nsProperties.setProperty("oracle.net.ssl_version", this.thinSslVersion);
            }
            if (this.thinSslCipherSuites != null) {
                nsProperties.setProperty("oracle.net.ssl_cipher_suites", this.thinSslCipherSuites);
            }
            if (this.thinJavaxNetSslKeystore != null) {
                nsProperties.setProperty("javax.net.ssl.keyStore", this.thinJavaxNetSslKeystore);
            }
            if (this.thinJavaxNetSslKeystoretype != null) {
                nsProperties.setProperty("javax.net.ssl.keyStoreType", this.thinJavaxNetSslKeystoretype);
            }
            if (this.thinJavaxNetSslKeystorepassword != null) {
                nsProperties.setProperty("javax.net.ssl.keyStorePassword", this.thinJavaxNetSslKeystorepassword);
            }
            if (this.thinJavaxNetSslTruststore != null) {
                nsProperties.setProperty("javax.net.ssl.trustStore", this.thinJavaxNetSslTruststore);
            }
            if (this.thinJavaxNetSslTruststoretype != null) {
                nsProperties.setProperty("javax.net.ssl.trustStoreType", this.thinJavaxNetSslTruststoretype);
            }
            if (this.thinJavaxNetSslTruststorepassword != null) {
                nsProperties.setProperty("javax.net.ssl.trustStorePassword", this.thinJavaxNetSslTruststorepassword);
            }
            if (this.thinSslKeymanagerfactoryAlgorithm != null) {
                nsProperties.setProperty("ssl.keyManagerFactory.algorithm", this.thinSslKeymanagerfactoryAlgorithm);
            }
            if (this.thinSslTrustmanagerfactoryAlgorithm != null) {
                nsProperties.setProperty("ssl.trustManagerFactory.algorithm", this.thinSslTrustmanagerfactoryAlgorithm);
            }
            if (this.thinNetOldsyntax != null) {
                nsProperties.setProperty("oracle.net.oldSyntax", this.thinNetOldsyntax);
            }
            if (this.thinNamingContextInitial != null) {
                nsProperties.setProperty("java.naming.factory.initial", this.thinNamingContextInitial);
            }
            if (this.thinNamingProviderUrl != null) {
                nsProperties.setProperty("java.naming.provider.url", this.thinNamingProviderUrl);
            }
            if (this.thinNamingSecurityAuthentication != null) {
                nsProperties.setProperty("java.naming.security.authentication", this.thinNamingSecurityAuthentication);
            }
            if (this.thinNamingSecurityPrincipal != null) {
                nsProperties.setProperty("java.naming.security.principal", this.thinNamingSecurityPrincipal);
            }
            if (this.thinNamingSecurityCredentials != null) {
                nsProperties.setProperty("java.naming.security.credentials", this.thinNamingSecurityCredentials);
            }
            if (this.thinNetDisableOutOfBandBreak) {
                nsProperties.setProperty("DISABLE_OOB", "" + this.thinNetDisableOutOfBandBreak);
            }
            if (this.thinNetEnableSDP) {
                nsProperties.setProperty("oracle.net.SDP", "" + this.thinNetEnableSDP);
            }
            nsProperties.setProperty("USE_ZERO_COPY_IO", "" + this.thinNetUseZeroCopyIO);
            nsProperties.setProperty("FORCE_DNS_LOAD_BALANCING", "" + this.thinForceDnsLoadBalancing);
            nsProperties.setProperty("ENABLE_JAVANET_FASTPATH", "" + this.enableJavaNetFastPath);
            nsProperties.setProperty("oracle.jdbc.v$session.osuser", this.thinVsessionOsuser);
            nsProperties.setProperty("oracle.jdbc.v$session.program", this.thinVsessionProgram);
            nsProperties.setProperty("T4CConnection.hashCode", Integer.toHexString(this.hashCode()).toUpperCase());
            nsProperties.setProperty("oracle.net.keepAlive", Boolean.toString(this.keepAlive));
            this.net = new NSProtocol();
            this.net.connect(database, nsProperties);
            this.mare = new T4CMAREngine(this.net, this.enableJavaNetFastPath);
            this.oer = new T4CTTIoer(this);
            this.mare.setConnectionDuringExceptionHandling(this);
            this.pro = new T4C8TTIpro(this);
            this.pro.marshal();
            this.serverCompileTimeCapabilities = this.pro.receive();
            this.serverRuntimeCapabilities = this.pro.getServerRuntimeCapabilities();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    this.pro.printServerInfo();
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short oVersion = this.pro.getOracleVersion();
            short ServerCharSet = this.pro.getCharacterSet();
            short accessCharSet = DBConversion.findDriverCharSet(ServerCharSet, oVersion);
            this.conversion = new DBConversion(ServerCharSet, accessCharSet, this.pro.getncharCHARSET(), this.isStrictAsciiConversion, this.isQuickAsciiConversion);
            this.mare.types.setServerConversion(accessCharSet != ServerCharSet);
            if (DBConversion.isCharSetMultibyte(accessCharSet)) {
                if (DBConversion.isCharSetMultibyte(this.pro.getCharacterSet())) {
                    this.mare.types.setFlags((byte)1);
                } else {
                    this.mare.types.setFlags((byte)2);
                }
            } else {
                this.mare.types.setFlags(this.pro.getFlags());
            }
            this.mare.conv = this.conversion;
            T4C8TTIdty dty = new T4C8TTIdty(this, this.serverCompileTimeCapabilities, this.serverRuntimeCapabilities, this.logonCap != null && this.logonCap.trim().equals("o3"), this.thinNetUseZeroCopyIO);
            dty.doRPC();
            this.negotiatedTTCversion = this.serverCompileTimeCapabilities[7];
            if (dty.jdbcThinCompileTimeCapabilities[7] < this.serverCompileTimeCapabilities[7]) {
                this.negotiatedTTCversion = dty.jdbcThinCompileTimeCapabilities[7];
            }
            this.useZeroCopyIO = this.serverRuntimeCapabilities != null && this.serverRuntimeCapabilities.length > 6 && (this.serverRuntimeCapabilities[6] & T4C8TTIdty.KPCCAP_RTB_TTC_ZCPY) != 0 && this.thinNetUseZeroCopyIO && (this.net.getSessionAttributes().getNegotiatedOptions() & 0x40) != 0 && this.getDataIntegrityAlgorithmName().equals("") && this.getEncryptionAlgorithmName().equals("");
            this.useLobPrefetch = this.serverCompileTimeCapabilities.length > 23 && (this.serverCompileTimeCapabilities[23] & 0x40) != 0 && (dty.jdbcThinCompileTimeCapabilities[23] & 0x40) != 0;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isZeroCopyIOEnabled() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.useZeroCopyIO);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = this.useZeroCopyIO;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    final T4CTTIoer getT4CTTIoer() {
        return this.oer;
    }

    final byte getTTCVersion() {
        return this.negotiatedTTCversion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doStartup(int mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(mode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                int stomode = 0;
                if (mode == OracleConnection.DatabaseStartupMode.FORCE.getMode()) {
                    stomode = 16;
                } else if (mode == OracleConnection.DatabaseStartupMode.RESTRICT.getMode()) {
                    stomode = 1;
                }
                this.spfp.doOSPFPPUT();
                this.sto.doOV6STRT(stomode);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doShutdown(int mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(mode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                int stomode = 4;
                if (mode == OracleConnection.DatabaseShutdownMode.TRANSACTIONAL.getMode()) {
                    stomode = 128;
                } else if (mode == OracleConnection.DatabaseShutdownMode.TRANSACTIONAL_LOCAL.getMode()) {
                    stomode = 256;
                } else if (mode == OracleConnection.DatabaseShutdownMode.IMMEDIATE.getMode()) {
                    stomode = 2;
                } else if (mode == OracleConnection.DatabaseShutdownMode.FINAL.getMode()) {
                    stomode = 8;
                } else if (mode == OracleConnection.DatabaseShutdownMode.ABORT.getMode()) {
                    stomode = 64;
                }
                this.sendPiggyBackedMessages();
                this.sto.doOV6STOP(stomode);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPiggyBackedMessages() throws SQLException, IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.sendPiggyBackedClose();
            if (this.endToEndAnyChanged && this.getTTCVersion() >= 3) {
                this.oscid.doOSCID(this.endToEndHasChanged, this.endToEndValues, this.endToEndECIDSequenceNumber);
                for (int i2 = 0; i2 < 4; ++i2) {
                    if (!this.endToEndHasChanged[i2]) continue;
                    this.endToEndHasChanged[i2] = false;
                }
            }
            this.endToEndAnyChanged = false;
            if (!this.namespaces.isEmpty()) {
                if (this.getTTCVersion() >= 4) {
                    Object[] namespacesArr = this.namespaces.values().toArray();
                    for (int i3 = 0; i3 < namespacesArr.length; ++i3) {
                        this.okeyval.doOKEYVAL((Namespace)namespacesArr[i3]);
                    }
                }
                this.namespaces.clear();
            }
            if (this.lusOffset2 > 0) {
                for (int i4 = 0; i4 < this.lusOffset2; ++i4) {
                    this.oxsspo.doOXSSPO(this.lusFunctionId2[i4], this.lusSessionId2[i4], this.lusInKeyVal2[i4], this.lusInFlags2[i4]);
                }
                this.lusOffset2 = 0;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPiggyBackedClose() throws SQLException, IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.queryToCloseOffset > 0) {
                this.close8.doOCANA(this.queryToClose, this.queryToCloseOffset);
                this.queryToCloseOffset = 0;
            }
            if (this.cursorToCloseOffset > 0) {
                this.close8.doOCCA(this.cursorToClose, this.cursorToCloseOffset);
                this.lastCursorToCloseOffset = this.cursorToCloseOffset;
                this.cursorToCloseOffset = 0;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    void redoCursorClose() {
        if (this.cursorToCloseOffset == 0 && this.lastCursorToCloseOffset != 0) {
            this.cursorToCloseOffset = this.lastCursorToCloseOffset;
            this.lastCursorToCloseOffset = 0;
        }
    }

    synchronized void closeCursor(int cursorId) throws SQLException {
        if (this.cursorToCloseOffset == this.cursorToClose.length) {
            int[] cursorToClose2 = new int[this.cursorToClose.length * 2];
            System.arraycopy(this.cursorToClose, 0, cursorToClose2, 0, this.cursorToClose.length);
            this.cursorToClose = cursorToClose2;
        }
        this.cursorToClose[this.cursorToCloseOffset++] = cursorId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doProxySession(int type, Properties prop) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(prop));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                this.sendPiggyBackedMessages();
                this.auth.doOAUTH(type, prop, this.sessionId, this.serialNumber);
                int prox_session_id = this.getSessionId();
                int prox_serial_nb = this.getSerialNumber();
                this.oses.doO80SES(prox_session_id, prox_serial_nb, 1);
                this.savedUser = this.userName;
                this.userName = type == 1 ? prop.getProperty("PROXY_USER_NAME") : null;
                this.isProxy = true;
            }
            catch (IOException ioe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ioe);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void closeProxySession() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                this.sendPiggyBackedMessages();
                this.commoncall.doOLOGOFF();
                this.oses.doO80SES(this.sessionId, this.serialNumber, 1);
                this.userName = this.savedUser;
            }
            catch (IOException ioe) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ioe);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSessionProperties(KeywordValue[] kvalArr) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(kvalArr));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            for (int i2 = 0; i2 < kvalArr.length; ++i2) {
                int keyword = kvalArr[i2].getKeyword();
                byte[] value = kvalArr[i2].getBinaryValue();
                if (keyword < T4C8Oall.NLS_KEYS.length) {
                    String key = T4C8Oall.NLS_KEYS[keyword];
                    if (key == null) continue;
                    if (value != null) {
                        this.sessionProperties.setProperty(key, this.mare.conv.CharBytesToString(value, value.length));
                        continue;
                    }
                    if (kvalArr[i2].getTextValue() == null) continue;
                    this.sessionProperties.setProperty(key, kvalArr[i2].getTextValue().trim());
                    continue;
                }
                if (keyword == 163) {
                    if (value == null) continue;
                    int hour = value[4];
                    int minute = value[5];
                    if ((value[4] & 0xFF) > 120) {
                        hour = (value[4] & 0xFF) - 181;
                        minute = (value[5] & 0xFF) - 60;
                    } else {
                        hour = (value[4] & 0xFF) - 60;
                        minute = (value[5] & 0xFF) - 60;
                    }
                    String tz = (hour > 0 ? "+" : "") + hour + (minute <= 9 ? ":0" : ":") + minute;
                    this.sessionProperties.setProperty("SESSION_TIME_ZONE", tz);
                    continue;
                }
                if (keyword == 165 || keyword == 166 || keyword == 167) continue;
                if (keyword == 168) {
                    String schema = kvalArr[i2].getTextValue();
                    if (schema == null) continue;
                    this.currentSchema = schema.trim();
                    continue;
                }
                if (keyword != 169 && keyword != 170 && keyword != 171) continue;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentSchema() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.currentSchema == null || this.getVersionNumber() < 11100) {
                this.currentSchema = super.getCurrentSchema();
            }
            String __result__ = this.currentSchema;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getServerSessionInfo() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.getVersionNumber() >= 10000 && this.getVersionNumber() < 10200) {
                this.queryFCFProperties(this.sessionProperties);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.sessionProperties);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Properties properties = this.sessionProperties;
            return properties;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSessionTimeZoneOffset() throws SQLException {
        String string;
        try {
            String ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ret = (ret = this.getServerSessionInfo().getProperty("SESSION_TIME_ZONE")) == null ? super.getSessionTimeZoneOffset() : this.tzToOffset(ret);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    int getSessionId() {
        int sessionId = -1;
        String valueStr = this.sessionProperties.getProperty("AUTH_SESSION_ID");
        try {
            sessionId = Integer.parseInt(valueStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sessionId;
    }

    int getSerialNumber() {
        int serialNumber = -1;
        String valueStr = this.sessionProperties.getProperty("AUTH_SERIAL_NUM");
        try {
            serialNumber = Integer.parseInt(valueStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return serialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getInstanceProperty(OracleConnection.InstanceProperty whatProperty) throws SQLException {
        byte by;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte ret = 0;
            if (whatProperty == OracleConnection.InstanceProperty.ASM_VOLUME_SUPPORTED) {
                if (this.serverRuntimeCapabilities == null || this.serverRuntimeCapabilities.length < 6) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 256);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 256);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                ret = this.serverRuntimeCapabilities[5];
            } else if (whatProperty == OracleConnection.InstanceProperty.INSTANCE_TYPE) {
                if (this.serverRuntimeCapabilities == null || this.serverRuntimeCapabilities.length < 4) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 256);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 256);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                ret = this.serverRuntimeCapabilities[3];
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            by = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BlobDBAccess createBlobDBAccess() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CConnection t4CConnection = this;
            return t4CConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ClobDBAccess createClobDBAccess() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CConnection t4CConnection = this;
            return t4CConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BfileDBAccess createBfileDBAccess() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CConnection t4CConnection = this;
            return t4CConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long length(BFILE bfile) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("length");
            this.assertNotNull(bfile.shareBytes(), "length");
            this.needLine();
            long result = 0L;
            try {
                result = this.bfileMsg.getLength(bfile.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = result;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long position(BFILE bfile, byte[] pattern, long start) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertNotNull(bfile.shareBytes(), "position");
            if (start < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "position()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            long result = LobPlsqlUtil.hasPattern(bfile, pattern, start);
            long l2 = result = result == 0L ? -1L : result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(BFILE bfile, BFILE pattern, long start) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertNotNull(bfile.shareBytes(), "position");
            if (start < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "position()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            long result = LobPlsqlUtil.isSubLob(bfile, pattern, start);
            long l2 = result = result == 0L ? -1L : result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getBytes(BFILE bfile, long pos, int length, byte[] bytes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(length) + ", " + OracleLog.argument(bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("getBytes");
            this.assertNotNull(bfile.shareBytes(), "getBytes");
            if (pos < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "getBytes()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (length <= 0 || bytes == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int __ex__ = 0;
                return __ex__;
            }
            if (this.pipeState != -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 453 + "getBytes()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 453, "getBytes()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.needLine();
            long result = 0L;
            if (length != 0) {
                try {
                    result = this.bfileMsg.read(bfile.shareBytes(), pos, length, bytes, 0);
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (int)result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = (int)result;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName(BFILE bfile) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("getName");
            this.assertNotNull(bfile.shareBytes(), "getName");
            String result = LobPlsqlUtil.fileGetName(bfile);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = result;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDirAlias(BFILE bfile) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("getDirAlias");
            this.assertNotNull(bfile.shareBytes(), "getDirAlias");
            String result = LobPlsqlUtil.fileGetDirAlias(bfile);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = result;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void openFile(BFILE bfile) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("openFile");
            this.assertNotNull(bfile.shareBytes(), "openFile");
            this.needLine();
            try {
                this.bfileMsg.open(bfile.shareBytes(), 11);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isFileOpen(BFILE bfile) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("openFile");
            this.assertNotNull(bfile.shareBytes(), "openFile");
            this.needLine();
            boolean result = false;
            try {
                result = this.bfileMsg.isOpen(bfile.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean fileExists(BFILE bfile) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("fileExists");
            this.assertNotNull(bfile.shareBytes(), "fileExists");
            this.needLine();
            boolean result = false;
            try {
                result = this.bfileMsg.doesExist(bfile.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void closeFile(BFILE bfile) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("closeFile");
            this.assertNotNull(bfile.shareBytes(), "closeFile");
            this.needLine();
            try {
                this.bfileMsg.close(bfile.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open(BFILE bfile, int mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(mode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("open");
            this.assertNotNull(bfile.shareBytes(), "open");
            this.needLine();
            try {
                this.bfileMsg.open(bfile.shareBytes(), mode);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(BFILE bfile) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("close");
            this.assertNotNull(bfile.shareBytes(), "close");
            this.needLine();
            try {
                this.bfileMsg.close(bfile.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isOpen(BFILE bfile) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("isOpen");
            this.assertNotNull(bfile.shareBytes(), "isOpen");
            this.needLine();
            boolean result = false;
            try {
                result = this.bfileMsg.isOpen(bfile.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newInputStream(BFILE bfile, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (pos == 0L) {
                OracleBlobInputStream __result__ = new OracleBlobInputStream(bfile, chunkSize);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleBlobInputStream oracleBlobInputStream = __result__;
                return oracleBlobInputStream;
            }
            OracleBlobInputStream __result__ = new OracleBlobInputStream(bfile, chunkSize, pos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleBlobInputStream oracleBlobInputStream = __result__;
            return oracleBlobInputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newConversionInputStream(BFILE bfile, int conversionType) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(conversionType));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertNotNull(bfile.shareBytes(), "newConversionInputStream");
            OracleConversionInputStream result = new OracleConversionInputStream(this.conversion, bfile.getBinaryStream(), conversionType);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConversionInputStream oracleConversionInputStream = result;
            return oracleConversionInputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader newConversionReader(BFILE bfile, int conversionType) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(conversionType));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertNotNull(bfile.shareBytes(), "newConversionReader");
            OracleConversionReader result = new OracleConversionReader(this.conversion, bfile.getBinaryStream(), conversionType);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConversionReader oracleConversionReader = result;
            return oracleConversionReader;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long length(BLOB blob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("length");
            this.assertNotNull(blob.shareBytes(), "length");
            this.needLine();
            long result = 0L;
            try {
                result = this.blobMsg.getLength(blob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = result;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(BLOB blob, byte[] pattern, long start) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("position");
            this.assertNotNull(blob.shareBytes(), "position");
            if (start < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "position()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            long result = LobPlsqlUtil.hasPattern(blob, pattern, start);
            long l2 = result = result == 0L ? -1L : result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(BLOB blob, BLOB pattern, long start) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("position");
            this.assertNotNull(blob.shareBytes(), "position");
            this.assertNotNull(pattern.shareBytes(), "position");
            if (start < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "position()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            long result = LobPlsqlUtil.isSubLob(blob, pattern, start);
            long l2 = result = result == 0L ? -1L : result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getBytes(BLOB blob, long pos, int length, byte[] bytes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(length) + ", " + OracleLog.argument(bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("getBytes");
            this.assertNotNull(blob.shareBytes(), "getBytes");
            if (pos < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "getBytes()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.pipeState != -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 453 + "getBytes()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 453, "getBytes()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (length <= 0 || bytes == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int __ex__ = 0;
                return __ex__;
            }
            long result = 0L;
            long lobLength = -1L;
            if (blob.isActivePrefetch()) {
                byte[] prefetchedBytes = blob.getPrefetchedData();
                int prefetchedBytesSize = blob.getPrefetchedDataSize();
                lobLength = blob.length();
                int usablePrefetchDataLength = 0;
                if (prefetchedBytes != null) {
                    usablePrefetchDataLength = Math.min(prefetchedBytesSize, prefetchedBytes.length);
                }
                if (usablePrefetchDataLength > 0 && pos <= (long)usablePrefetchDataLength) {
                    int nbOfBytesToGetFromPrefetched = Math.min(usablePrefetchDataLength - (int)pos + 1, length);
                    System.arraycopy(prefetchedBytes, (int)pos - 1, bytes, 0, nbOfBytesToGetFromPrefetched);
                    result += (long)nbOfBytesToGetFromPrefetched;
                }
            }
            if (result < (long)length && (lobLength == -1L || pos - 1L + result < lobLength)) {
                this.needLine();
                try {
                    result += this.blobMsg.read(blob.shareBytes(), pos + result, (long)length - result, bytes, (int)result);
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (int)result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = (int)result;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int putBytes(BLOB blob, long pos, byte[] bytes, int bytesOffset, int length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(bytesOffset) + ", " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("putBytes");
            this.assertNotNull(blob.shareBytes(), "putBytes");
            if (pos < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "putBytes()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "putBytes()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (bytes == null || length <= 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int __ex__ = 0;
                return __ex__;
            }
            this.needLine();
            long result = 0L;
            if (length != 0) {
                try {
                    blob.setActivePrefetch(false);
                    blob.clearCachedData();
                    result = this.blobMsg.write(blob.shareBytes(), pos, bytes, bytesOffset, length);
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (int)result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = (int)result;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getChunkSize(BLOB blob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("getChunkSize");
            this.assertNotNull(blob.shareBytes(), "getChunkSize");
            this.needLine();
            long result = 0L;
            try {
                result = this.blobMsg.getChunkSize(blob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (int)result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = (int)result;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void trim(BLOB blob, long length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("trim");
            this.assertNotNull(blob.shareBytes(), "trim");
            if (length < 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "trim()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "trim()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.needLine();
            try {
                blob.setActivePrefetch(false);
                blob.clearCachedData();
                this.blobMsg.trim(blob.shareBytes(), length);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BLOB createTemporaryBlob(Connection conn, boolean cache, int duration) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cache) + ", " + OracleLog.argument(duration));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("createTemporaryBlob");
            this.needLine();
            BLOB result = null;
            try {
                result = (BLOB)this.blobMsg.createTemporaryLob(this, cache, duration);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BLOB bLOB = result;
            return bLOB;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized Long getLocatorHash(byte[] locator) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.checksumEngine.reset();
            this.checksumEngine.update(locator, 10, 10);
            long checksum = this.checksumEngine.getValue();
            Long checksumLong = checksum;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CConnection.getLocatorHash (locator " + locator + ") returns " + checksum);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + checksumLong);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Long l2 = checksumLong;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized int decrementTempLobReferenceCount(byte[] locator) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int remainingCnt = 0;
            if (this.enableTempLobRefCnt && locator != null && locator.length == 40 && ((locator[7] & 1) > 0 || (locator[4] & 0x40) > 0)) {
                Long hashKey = this.getLocatorHash(locator);
                Integer refCnt = this.tempLobRefCount.get(hashKey);
                if (refCnt != null) {
                    remainingCnt = refCnt - 1;
                    if (remainingCnt == 0) {
                        this.tempLobRefCount.remove(hashKey);
                    } else {
                        this.tempLobRefCount.put(hashKey, remainingCnt);
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CConnection.decrementTempLobReferenceCount (LOB ID hash " + hashKey + ") to " + remainingCnt);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                } else if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CConnection.decrementTempLobReferenceCount (LOB ID hash " + hashKey + ") not found in hashtable");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + remainingCnt);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = remainingCnt;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void incrementTempLobReferenceCount(byte[] locator) {
        block23: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!this.enableTempLobRefCnt || locator == null || locator.length != 40 || (locator[7] & 1) <= 0 && (locator[4] & 0x40) <= 0) break block23;
                Long hashKey = this.getLocatorHash(locator);
                Integer refCnt = this.tempLobRefCount.get(hashKey);
                if (refCnt != null) {
                    int refCntInt = refCnt;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CConnection.incrementTempLobReferenceCount (LOB ID hash " + hashKey + ") to " + (refCntInt + 1));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    this.tempLobRefCount.put(hashKey, refCntInt + 1);
                    break block23;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CConnection.incrementTempLobReferenceCount (LOB ID hash " + hashKey + ") to 1");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.tempLobRefCount.put(hashKey, 1);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void freeTemporary(BLOB blob, boolean fromObjectIgnore) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("freeTemporary");
            this.assertNotNull(blob.shareBytes(), "freeTemporary");
            this.needLine();
            try {
                this.blobMsg.freeTemporaryLob(blob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTemporary(BLOB blob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertNotNull(blob.shareBytes(), "isTemporary");
            boolean result = false;
            byte[] locator = blob.shareBytes();
            if ((locator[7] & 1) > 0 || (locator[4] & 0x40) > 0) {
                result = true;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open(BLOB blob, int mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(mode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("open");
            this.assertNotNull(blob.shareBytes(), "open");
            this.needLine();
            try {
                this.blobMsg.open(blob.shareBytes(), mode);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(BLOB blob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("close");
            this.assertNotNull(blob.shareBytes(), "close");
            this.needLine();
            try {
                this.blobMsg.close(blob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isOpen(BLOB blob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("isOpen");
            this.assertNotNull(blob.shareBytes(), "isOpen");
            this.needLine();
            boolean result = false;
            try {
                result = this.blobMsg.isOpen(blob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newInputStream(BLOB blob, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (pos == 0L) {
                OracleBlobInputStream __result__ = new OracleBlobInputStream(blob, chunkSize);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleBlobInputStream oracleBlobInputStream = __result__;
                return oracleBlobInputStream;
            }
            OracleBlobInputStream __result__ = new OracleBlobInputStream(blob, chunkSize, pos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleBlobInputStream oracleBlobInputStream = __result__;
            return oracleBlobInputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream newOutputStream(BLOB blob, int chunkSize, long pos, boolean zeroInvalid) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (pos == 0L) {
                if (zeroInvalid & this.lobStreamPosStandardCompliant) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                OracleBlobOutputStream __result__ = new OracleBlobOutputStream(blob, chunkSize);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleBlobOutputStream oracleBlobOutputStream = __result__;
                return oracleBlobOutputStream;
            }
            OracleBlobOutputStream __result__ = new OracleBlobOutputStream(blob, chunkSize, pos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleBlobOutputStream oracleBlobOutputStream = __result__;
            return oracleBlobOutputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newConversionInputStream(BLOB blob, int conversionType) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(conversionType));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertNotNull(blob.shareBytes(), "newConversionInputStream");
            OracleConversionInputStream result = new OracleConversionInputStream(this.conversion, blob.getBinaryStream(), conversionType);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConversionInputStream oracleConversionInputStream = result;
            return oracleConversionInputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader newConversionReader(BLOB blob, int conversionType) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(conversionType));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertNotNull(blob.shareBytes(), "newConversionReader");
            OracleConversionReader result = new OracleConversionReader(this.conversion, blob.getBinaryStream(), conversionType);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConversionReader oracleConversionReader = result;
            return oracleConversionReader;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long length(CLOB clob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("length");
            this.assertNotNull(clob.shareBytes(), "length");
            this.needLine();
            long result = 0L;
            try {
                result = this.clobMsg.getLength(clob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = result;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(CLOB clob, String pattern, long start) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (pattern == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "position()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.assertLoggedOn("position");
            this.assertNotNull(clob.shareBytes(), "position");
            if (start < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "position()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            char[] chars = new char[pattern.length()];
            pattern.getChars(0, chars.length, chars, 0);
            long result = LobPlsqlUtil.hasPattern(clob, chars, start);
            long l2 = result = result == 0L ? -1L : result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(CLOB clob, CLOB pattern, long start) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (pattern == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "position()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.assertLoggedOn("position");
            this.assertNotNull(clob.shareBytes(), "position");
            this.assertNotNull(pattern.shareBytes(), "position");
            if (start < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "position()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            long result = LobPlsqlUtil.isSubLob(clob, pattern, start);
            long l2 = result = result == 0L ? -1L : result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = result;
            return l3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getChars(CLOB clob, long pos, int length, char[] chars) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(length) + ", " + OracleLog.argument(chars));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("getChars");
            this.assertNotNull(clob.shareBytes(), "getChars");
            if (pos < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "getChars()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getChars()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.pipeState != -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 453 + "getChars()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 453, "getChars()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (length <= 0 || chars == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int __ex__ = 0;
                return __ex__;
            }
            long result = 0L;
            long lobLength = -1L;
            if (clob.isActivePrefetch()) {
                lobLength = clob.length();
                char[] prefetchedChars = clob.getPrefetchedData();
                int prefetchedCharsSize = clob.getPrefetchedDataSize();
                int usablePrefetchDataLength = 0;
                if (prefetchedChars != null) {
                    usablePrefetchDataLength = Math.min(prefetchedCharsSize, prefetchedChars.length);
                }
                if (usablePrefetchDataLength > 0 && pos <= (long)usablePrefetchDataLength) {
                    int nbOfCharsToGetFromPrefetched = Math.min(usablePrefetchDataLength - (int)pos + 1, length);
                    System.arraycopy(prefetchedChars, (int)pos - 1, chars, 0, nbOfCharsToGetFromPrefetched);
                    result += (long)nbOfCharsToGetFromPrefetched;
                }
            }
            if (result < (long)length && (lobLength == -1L || pos - 1L + result < lobLength)) {
                this.needLine();
                try {
                    boolean isNCLOB = clob.isNCLOB();
                    result += this.clobMsg.read(clob.shareBytes(), pos + result, (long)length - result, isNCLOB, chars, (int)result);
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (int)result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = (int)result;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int putChars(CLOB clob, long pos, char[] chars, int charsOffset, int length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(charsOffset) + ", " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("putChars");
            this.assertNotNull(clob.shareBytes(), "putChars");
            if (pos < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "putChars()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "putChars()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (chars == null || length <= 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int __ex__ = 0;
                return __ex__;
            }
            this.needLine();
            long result = 0L;
            if (length != 0) {
                try {
                    boolean isNCLOB = clob.isNCLOB();
                    clob.setActivePrefetch(false);
                    clob.clearCachedData();
                    result = this.clobMsg.write(clob.shareBytes(), pos, isNCLOB, chars, charsOffset, length);
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (int)result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = (int)result;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getChunkSize(CLOB clob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("getChunkSize");
            this.assertNotNull(clob.shareBytes(), "getChunkSize");
            this.needLine();
            long result = 0L;
            try {
                result = this.clobMsg.getChunkSize(clob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (int)result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = (int)result;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void trim(CLOB clob, long length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("trim");
            this.assertNotNull(clob.shareBytes(), "trim");
            if (length < 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "trim()");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "trim()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.needLine();
            try {
                clob.setActivePrefetch(false);
                clob.clearCachedData();
                this.clobMsg.trim(clob.shareBytes(), length);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CLOB createTemporaryClob(Connection conn, boolean cache, int duration, short form_of_use) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cache) + ", " + OracleLog.argument(duration) + ", " + OracleLog.argument(form_of_use));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("createTemporaryClob");
            if (form_of_use != 2 && form_of_use != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 184);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 184);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.needLine();
            CLOB result = null;
            try {
                result = (CLOB)this.clobMsg.createTemporaryLob(this, cache, duration, form_of_use);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB cLOB = result;
            return cLOB;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void freeTemporary(CLOB clob, boolean fromObjectIgnore) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("freeTemporary");
            this.assertNotNull(clob.shareBytes(), "freeTemporary");
            this.needLine();
            try {
                this.clobMsg.freeTemporaryLob(clob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTemporary(CLOB clob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean result = false;
            byte[] locator = clob.shareBytes();
            if ((locator[7] & 1) > 0 || (locator[4] & 0x40) > 0) {
                result = true;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open(CLOB clob, int mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(mode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("open");
            this.assertNotNull(clob.shareBytes(), "open");
            this.needLine();
            try {
                this.clobMsg.open(clob.shareBytes(), mode);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(CLOB clob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("close");
            this.assertNotNull(clob.shareBytes(), "close");
            this.needLine();
            try {
                this.clobMsg.close(clob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isOpen(CLOB clob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.assertLoggedOn("isOpen");
            this.assertNotNull(clob.shareBytes(), "isOpen");
            boolean result = false;
            this.needLine();
            try {
                result = this.clobMsg.isOpen(clob.shareBytes());
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newInputStream(CLOB clob, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (pos == 0L) {
                OracleClobInputStream __result__ = new OracleClobInputStream(clob, chunkSize);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleClobInputStream oracleClobInputStream = __result__;
                return oracleClobInputStream;
            }
            OracleClobInputStream __result__ = new OracleClobInputStream(clob, chunkSize, pos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleClobInputStream oracleClobInputStream = __result__;
            return oracleClobInputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream newOutputStream(CLOB clob, int chunkSize, long pos, boolean zeroInvalid) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (pos == 0L) {
                if (zeroInvalid & this.lobStreamPosStandardCompliant) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                OracleClobOutputStream __result__ = new OracleClobOutputStream(clob, chunkSize);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleClobOutputStream oracleClobOutputStream = __result__;
                return oracleClobOutputStream;
            }
            OracleClobOutputStream __result__ = new OracleClobOutputStream(clob, chunkSize, pos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleClobOutputStream oracleClobOutputStream = __result__;
            return oracleClobOutputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader newReader(CLOB clob, int chunkSize, long pos) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (pos == 0L) {
                OracleClobReader __result__ = new OracleClobReader(clob, chunkSize);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleClobReader oracleClobReader = __result__;
                return oracleClobReader;
            }
            OracleClobReader __result__ = new OracleClobReader(clob, chunkSize, pos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleClobReader oracleClobReader = __result__;
            return oracleClobReader;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader newReader(CLOB clob, int chunkSize, long pos, long length) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleClobReader __result__ = new OracleClobReader(clob, chunkSize, pos, length);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleClobReader oracleClobReader = __result__;
            return oracleClobReader;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer newWriter(CLOB clob, int chunkSize, long pos, boolean zeroInvalid) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (pos == 0L) {
                if (zeroInvalid & this.lobStreamPosStandardCompliant) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                OracleClobWriter __result__ = new OracleClobWriter(clob, chunkSize);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleClobWriter oracleClobWriter = __result__;
                return oracleClobWriter;
            }
            OracleClobWriter __result__ = new OracleClobWriter(clob, chunkSize, pos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleClobWriter oracleClobWriter = __result__;
            return oracleClobWriter;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertLoggedOn(String caller) throws SQLException {
        if (!this.isLoggedOn) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 430);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 430);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
    }

    boolean isLoggedOn() {
        return this.isLoggedOn;
    }

    void assertNotNull(byte[] bytes, String caller) throws NullPointerException {
        if (bytes == null) {
            throw new NullPointerException("bytes are null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void internalClose() throws SQLException {
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                super.internalClose();
                this.isLoggedOn = false;
                try {
                    if (this.net != null) {
                        this.net.disconnect();
                    }
                }
                catch (Exception e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block20;
                    try {
                        T4CConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CConnection.logon: Exception in net.disconnect: " + e2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doAbort() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                this.net.abort();
            }
            catch (NetException ne) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ne);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ne);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (IOException ne) {
                this.handleIOException(ne);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ne);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ne);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDescribeTable(AutoKeyInfo info) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(info));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CStatement t4cStmt = new T4CStatement(this, -1, -1);
            t4cStmt.open();
            String tableName = info.getTableName();
            String sql = "SELECT * FROM " + tableName;
            t4cStmt.sqlObject.initialize(sql);
            Accessor[] accessors = null;
            try {
                this.describe.doODNY(t4cStmt, 0, accessors, t4cStmt.sqlObject.getSqlBytes(false, false));
                accessors = this.describe.getAccessors();
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int numColumns = this.describe.numuds;
            info.allocateSpaceForDescribedData(numColumns);
            for (int i2 = 0; i2 < numColumns; ++i2) {
                Accessor accessor = accessors[i2];
                String columnName = accessor.columnName;
                int type = accessor.describeType;
                int maxLength = accessor.describeMaxLength;
                boolean nullable = accessor.nullable;
                short formOfUse = accessor.formOfUse;
                int precision = accessor.precision;
                int scale = accessor.scale;
                String typeName = accessor.describeTypeName;
                info.fillDescribedData(i2, columnName, type, maxLength, nullable, formOfUse, precision, scale, typeName);
            }
            t4cStmt.close();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doSetApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        try {
            Namespace ns;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(nameSpace) + ", " + OracleLog.argument(attribute) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((ns = (Namespace)this.namespaces.get(nameSpace)) == null) {
                ns = new Namespace(nameSpace);
                this.namespaces.put(nameSpace, ns);
            }
            ns.setAttribute(attribute, value);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doClearAllApplicationContext(String nameSpace) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(nameSpace));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Namespace ns = new Namespace(nameSpace);
            ns.clear();
            this.namespaces.put(nameSpace, ns);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getPropertyForPooledConnection(OraclePooledConnection pc) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            super.getPropertyForPooledConnection(pc, this.password);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void getPasswordInternal(T4CXAResource caller) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(caller));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            caller.setPasswordInternal(this.password);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void doEnqueue(String queueName, AQEnqueueOptions enqueueOptions, AQMessagePropertiesI prop, byte[] payloadTDO, byte[] payload, byte[][] msgId, boolean isRawPayload) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(queueName) + ", " + OracleLog.argument(enqueueOptions) + ", " + OracleLog.argument(prop) + ", " + OracleLog.argument(payloadTDO) + ", " + OracleLog.argument(payload) + ", " + OracleLog.argument(msgId) + ", " + OracleLog.argument(isRawPayload));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                this.needLine();
                this.sendPiggyBackedMessages();
                this.aqe.doOAQEQ(queueName, enqueueOptions, prop, payload, payloadTDO, isRawPayload);
                if (enqueueOptions.getRetrieveMessageId()) {
                    msgId[0] = this.aqe.getMessageId();
                }
            }
            catch (IOException ioex) {
                this.handleIOException(ioex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ioex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized boolean doDequeue(String queueName, AQDequeueOptions dequeueOptions, AQMessagePropertiesI msgProp, byte[] payloadTDO, byte[][] payload, byte[][] msgid, boolean isRawQueue) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(queueName) + ", " + OracleLog.argument(dequeueOptions) + ", " + OracleLog.argument(msgProp) + ", " + OracleLog.argument(payloadTDO) + ", " + OracleLog.argument(payload) + ", " + OracleLog.argument(msgid) + ", " + OracleLog.argument(isRawQueue));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean hasAMessageBeenDequeued = false;
            try {
                this.needLine();
                this.sendPiggyBackedMessages();
                this.aqdq.doOAQDQ(queueName, dequeueOptions, payloadTDO, isRawQueue, msgProp);
                payload[0] = this.aqdq.getPayload();
                msgid[0] = this.aqdq.getDequeuedMessageId();
                hasAMessageBeenDequeued = this.aqdq.hasAMessageBeenDequeued();
            }
            catch (IOException ioex) {
                this.handleIOException(ioex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ioex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + hasAMessageBeenDequeued);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = hasAMessageBeenDequeued;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    synchronized int doPingDatabase() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.versionNumber >= 10102) {
                try {
                    this.needLine();
                    this.sendPiggyBackedMessages();
                    this.oping.doOPING();
                }
                catch (IOException ioe) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n2 = -1;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    return n2;
                }
                catch (SQLException ioe) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n3 = -1;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    return n3;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int ioe = 0;
                return ioe;
            }
            int __result__ = super.doPingDatabase();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n4 = __result__;
            return n4;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized NTFAQRegistration[] doRegisterAQNotification(String[] name, String dcnhost, int tcpport, Properties[] options) throws SQLException {
        try {
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(dcnhost) + ", " + OracleLog.argument(tcpport) + ", " + OracleLog.argument(options));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int nbOfRegistration = name.length;
            int[] jdbcRegIdArr = new int[nbOfRegistration];
            byte[][] contextArr = new byte[nbOfRegistration][];
            int[] namespaceArr = new int[nbOfRegistration];
            int[] payloadTypeArr = new int[nbOfRegistration];
            int[] qosFlagsArr = new int[nbOfRegistration];
            int[] timeoutArr = new int[nbOfRegistration];
            int[] dbchangeOpFilterArr = new int[nbOfRegistration];
            int[] dbchangeTxnLagArr = new int[nbOfRegistration];
            long[] dbchangeRegistrationIdArr = new long[nbOfRegistration];
            byte[] kpdnrgrpcla = new byte[nbOfRegistration];
            int[] kpdnrgrpval = new int[nbOfRegistration];
            byte[] kpdnrgrptyp = new byte[nbOfRegistration];
            TIMESTAMPTZ[] kpdnrgrpstatim = new TIMESTAMPTZ[nbOfRegistration];
            int[] kpdnrgrprepcnt = new int[nbOfRegistration];
            boolean forceFindPort = false;
            if (tcpport == 0) {
                forceFindPort = true;
                tcpport = 47632;
            }
            for (int i3 = 0; i3 < nbOfRegistration; ++i3) {
                jdbcRegIdArr[i3] = PhysicalConnection.ntfManager.getNextJdbcRegId();
                contextArr[i3] = new byte[4];
                contextArr[i3][0] = (byte)((jdbcRegIdArr[i3] & 0xFF000000) >> 24);
                contextArr[i3][1] = (byte)((jdbcRegIdArr[i3] & 0xFF0000) >> 16);
                contextArr[i3][2] = (byte)((jdbcRegIdArr[i3] & 0xFF00) >> 8);
                contextArr[i3][3] = (byte)(jdbcRegIdArr[i3] & 0xFF);
                namespaceArr[i3] = 1;
                payloadTypeArr[i3] = 23;
                if (options.length <= i3 || options[i3] == null) continue;
                if (options[i3].getProperty("NTF_QOS_RELIABLE", "false").compareToIgnoreCase("true") == 0) {
                    int n2 = i3;
                    qosFlagsArr[n2] = qosFlagsArr[n2] | 1;
                }
                if (options[i3].getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0) {
                    int n3 = i3;
                    qosFlagsArr[n3] = qosFlagsArr[n3] | 0x10;
                }
                if (options[i3].getProperty("NTF_AQ_PAYLOAD", "false").compareToIgnoreCase("true") == 0) {
                    int n4 = i3;
                    qosFlagsArr[n4] = qosFlagsArr[n4] | 2;
                }
                timeoutArr[i3] = this.readNTFtimeout(options[i3]);
            }
            this.setNtfGroupingOptions(kpdnrgrpcla, kpdnrgrpval, kpdnrgrptyp, kpdnrgrpstatim, kpdnrgrprepcnt, options);
            int[] tcpportArr = new int[]{tcpport};
            boolean isNewClient = PhysicalConnection.ntfManager.listenOnPortT4C(tcpportArr, forceFindPort);
            tcpport = tcpportArr[0];
            String location = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + dcnhost + ")(PORT=" + tcpport + "))?PR=0";
            try {
                try {
                    int mod = isNewClient ? 1 : 0;
                    this.sendPiggyBackedMessages();
                    this.okpn.doOKPN(1, mod, this.userName, location, nbOfRegistration, namespaceArr, name, contextArr, payloadTypeArr, qosFlagsArr, timeoutArr, dbchangeOpFilterArr, dbchangeTxnLagArr, dbchangeRegistrationIdArr, kpdnrgrpcla, kpdnrgrpval, kpdnrgrptyp, kpdnrgrpstatim, kpdnrgrprepcnt);
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            catch (SQLException generalEx) {
                if (isNewClient) {
                    PhysicalConnection.ntfManager.cleanListenersT4C(tcpport);
                }
                throw generalEx;
            }
            NTFAQRegistration[] registrations = new NTFAQRegistration[nbOfRegistration];
            for (i2 = 0; i2 < nbOfRegistration; ++i2) {
                registrations[i2] = new NTFAQRegistration(jdbcRegIdArr[i2], true, this.instanceName, this.userName, dcnhost, tcpport, options[i2], name[i2], this.versionNumber);
            }
            for (i2 = 0; i2 < registrations.length; ++i2) {
                PhysicalConnection.ntfManager.addRegistration(registrations[i2]);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + registrations);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NTFAQRegistration[] nTFAQRegistrationArray = registrations;
            return nTFAQRegistrationArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNtfGroupingOptions(byte[] kpdnrgrpcla, int[] kpdnrgrpval, byte[] kpdnrgrptyp, TIMESTAMPTZ[] kpdnrgrpstatim, int[] kpdnrgrprepcnt, Properties[] options) throws SQLException {
        for (int i2 = 0; i2 < options.length; ++i2) {
            String ntfGroupingClass = options[i2].getProperty("NTF_GROUPING_CLASS", "NTF_GROUPING_CLASS_NONE");
            String ntfGroupingValue = options[i2].getProperty("NTF_GROUPING_VALUE");
            String ntfGroupingType = options[i2].getProperty("NTF_GROUPING_TYPE");
            TIMESTAMPTZ ntfGroupingStartTime = null;
            if (options[i2].get("NTF_GROUPING_START_TIME") != null) {
                ntfGroupingStartTime = (TIMESTAMPTZ)options[i2].get("NTF_GROUPING_START_TIME");
            }
            String ntfGroupingRepeatTime = options[i2].getProperty("NTF_GROUPING_REPEAT_TIME", "NTF_GROUPING_REPEAT_FOREVER");
            if (ntfGroupingClass.compareTo("NTF_GROUPING_CLASS_TIME") != 0 && ntfGroupingClass.compareTo("NTF_GROUPING_CLASS_NONE") != 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (ntfGroupingClass.compareTo("NTF_GROUPING_CLASS_NONE") != 0 && this.getTTCVersion() < 5) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (ntfGroupingClass.compareTo("NTF_GROUPING_CLASS_TIME") != 0) continue;
            kpdnrgrpcla[i2] = 1;
            kpdnrgrpval[i2] = 600;
            if (ntfGroupingValue != null) {
                kpdnrgrpval[i2] = Integer.parseInt(ntfGroupingValue);
            }
            kpdnrgrptyp[i2] = 1;
            if (ntfGroupingType != null) {
                if (ntfGroupingType.compareTo("NTF_GROUPING_TYPE_SUMMARY") == 0) {
                    kpdnrgrptyp[i2] = 1;
                } else if (ntfGroupingType.compareTo("NTF_GROUPING_TYPE_LAST") == 0) {
                    kpdnrgrptyp[i2] = 2;
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            kpdnrgrpstatim[i2] = ntfGroupingStartTime;
            kpdnrgrprepcnt[i2] = ntfGroupingRepeatTime.compareTo("NTF_GROUPING_REPEAT_FOREVER") == 0 ? 0 : Integer.parseInt(ntfGroupingRepeatTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void doUnregisterAQNotification(NTFAQRegistration registration) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(registration));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String host = registration.getClientHost();
            int port = registration.getClientTCPPort();
            if (host == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            PhysicalConnection.ntfManager.removeRegistration(registration);
            PhysicalConnection.ntfManager.freeJdbcRegId(registration.getJdbcRegId());
            PhysicalConnection.ntfManager.cleanListenersT4C(registration.getClientTCPPort());
            registration.setState(NotificationRegistration.RegistrationState.CLOSED);
            String location = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + host + ")(PORT=" + port + "))?PR=0";
            int[] namespaceArr = new int[]{1};
            String[] registeredAgentNameArr = new String[]{registration.getQueueName()};
            int[] payloadTypeArr = new int[]{0};
            int[] qosFlagsArr = new int[]{0};
            int[] timeoutArr = new int[]{0};
            int[] dbchangeOpFilterArr = new int[]{0};
            int[] dbchangeTxnLagArr = new int[]{0};
            long[] dbchangeRegistrationIdArr = new long[]{0L};
            byte[] kpdnrgrpcla = new byte[]{0};
            int[] kpdnrgrpval = new int[]{0};
            byte[] kpdnrgrptyp = new byte[]{0};
            TIMESTAMPTZ[] kpdnrgrpstatim = new TIMESTAMPTZ[]{null};
            int[] kpdnrgrprepcnt = new int[]{0};
            byte[][] contextArr = new byte[1][];
            int jdbcRegIdArr = registration.getJdbcRegId();
            contextArr[0] = new byte[4];
            contextArr[0][0] = (byte)((jdbcRegIdArr & 0xFF000000) >> 24);
            contextArr[0][1] = (byte)((jdbcRegIdArr & 0xFF0000) >> 16);
            contextArr[0][2] = (byte)((jdbcRegIdArr & 0xFF00) >> 8);
            contextArr[0][3] = (byte)(jdbcRegIdArr & 0xFF);
            try {
                this.sendPiggyBackedMessages();
                this.okpn.doOKPN(2, 0, this.userName, location, 1, namespaceArr, registeredAgentNameArr, contextArr, payloadTypeArr, qosFlagsArr, timeoutArr, dbchangeOpFilterArr, dbchangeTxnLagArr, dbchangeRegistrationIdArr, kpdnrgrpcla, kpdnrgrpval, kpdnrgrptyp, kpdnrgrpstatim, kpdnrgrprepcnt);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized NTFDCNRegistration doRegisterDatabaseChangeNotification(String dcnhost, int tcpport, Properties options, int kpdnrtmout, int kpdcntxl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(dcnhost) + ", " + OracleLog.argument(tcpport) + ", " + OracleLog.argument(options) + ", " + OracleLog.argument(kpdnrtmout) + ", " + OracleLog.argument(kpdcntxl));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int kpdcnflg = 0;
            int kpdnrqos = 0;
            boolean kpdnrgrpcla = false;
            boolean kpdnrgrpval = false;
            boolean kpdnrgrptyp = false;
            Object kpdnrgrpstatim = null;
            boolean kpdnrgrprepcnt = false;
            boolean forceFindPort = false;
            if (tcpport == 0) {
                forceFindPort = true;
                tcpport = 47632;
            }
            if (options.getProperty("NTF_QOS_RELIABLE", "false").compareToIgnoreCase("true") == 0) {
                kpdnrqos |= 1;
            }
            if (options.getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0) {
                kpdnrqos |= 0x10;
            }
            if (options.getProperty("DCN_NOTIFY_ROWIDS", "false").compareToIgnoreCase("true") == 0) {
                kpdcnflg |= 0x10;
            }
            if (options.getProperty("DCN_QUERY_CHANGE_NOTIFICATION", "false").compareToIgnoreCase("true") == 0) {
                kpdcnflg |= 0x20;
            }
            if (options.getProperty("DCN_BEST_EFFORT", "false").compareToIgnoreCase("true") == 0) {
                kpdcnflg |= 0x40;
            }
            boolean ignoreInsert = false;
            boolean ignoreUpdate = false;
            boolean ignoreDelete = false;
            if (options.getProperty("DCN_IGNORE_INSERTOP", "false").compareToIgnoreCase("true") == 0) {
                ignoreInsert = true;
            }
            if (options.getProperty("DCN_IGNORE_UPDATEOP", "false").compareToIgnoreCase("true") == 0) {
                ignoreUpdate = true;
            }
            if (options.getProperty("DCN_IGNORE_DELETEOP", "false").compareToIgnoreCase("true") == 0) {
                ignoreDelete = true;
            }
            if (ignoreInsert || ignoreUpdate || ignoreDelete) {
                kpdcnflg |= 0xF;
                if (ignoreInsert) {
                    kpdcnflg -= 2;
                }
                if (ignoreUpdate) {
                    kpdcnflg -= 4;
                }
                if (ignoreDelete) {
                    kpdcnflg -= 8;
                }
            }
            byte[] kpdnrgrpclaArr = new byte[1];
            int[] kpdnrgrpvalArr = new int[1];
            byte[] kpdnrgrptypArr = new byte[1];
            TIMESTAMPTZ[] kpdnrgrpstatimArr = new TIMESTAMPTZ[1];
            int[] kpdnrgrprepcntArr = new int[1];
            Properties[] optionsArr = new Properties[]{options};
            this.setNtfGroupingOptions(kpdnrgrpclaArr, kpdnrgrpvalArr, kpdnrgrptypArr, kpdnrgrpstatimArr, kpdnrgrprepcntArr, optionsArr);
            int[] tcpportArr = new int[]{tcpport};
            boolean isNewClient = PhysicalConnection.ntfManager.listenOnPortT4C(tcpportArr, forceFindPort);
            tcpport = tcpportArr[0];
            String location = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + dcnhost + ")(PORT=" + tcpport + "))?PR=0";
            int[] namespaceArr = new int[]{2};
            String[] registeredAgentNameArr = new String[1];
            int[] payloadTypeArr = new int[]{23};
            int[] qosFlagsArr = new int[]{kpdnrqos};
            int[] timeoutArr = new int[]{kpdnrtmout};
            int[] dbchangeOpFilterArr = new int[]{kpdcnflg};
            int[] dbchangeTxnLagArr = new int[]{kpdcntxl};
            long[] dbchangeRegistrationIdArr = new long[]{0L};
            int jdbcRegId = PhysicalConnection.ntfManager.getNextJdbcRegId();
            byte[][] contextArr = new byte[][]{new byte[4]};
            contextArr[0][0] = (byte)((jdbcRegId & 0xFF000000) >> 24);
            contextArr[0][1] = (byte)((jdbcRegId & 0xFF0000) >> 16);
            contextArr[0][2] = (byte)((jdbcRegId & 0xFF00) >> 8);
            contextArr[0][3] = (byte)(jdbcRegId & 0xFF);
            long regid = 0L;
            try {
                try {
                    int mod = isNewClient ? 1 : 0;
                    this.sendPiggyBackedMessages();
                    this.okpn.doOKPN(1, mod, this.userName, location, 1, namespaceArr, registeredAgentNameArr, contextArr, payloadTypeArr, qosFlagsArr, timeoutArr, dbchangeOpFilterArr, dbchangeTxnLagArr, dbchangeRegistrationIdArr, kpdnrgrpclaArr, kpdnrgrpvalArr, kpdnrgrptypArr, kpdnrgrpstatimArr, kpdnrgrprepcntArr);
                    regid = this.okpn.getRegistrationId();
                }
                catch (IOException ex) {
                    this.handleIOException(ex);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            catch (SQLException generalEx) {
                if (isNewClient) {
                    PhysicalConnection.ntfManager.cleanListenersT4C(tcpport);
                }
                throw generalEx;
            }
            NTFDCNRegistration registration = new NTFDCNRegistration(jdbcRegId, true, this.instanceName, regid, this.userName, dcnhost, tcpport, options, this.versionNumber);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + registration);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NTFDCNRegistration nTFDCNRegistration = registration;
            return nTFDCNRegistration;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void doUnregisterDatabaseChangeNotification(long registrationId, String location) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(registrationId) + ", " + OracleLog.argument(location));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int[] namespaceArr = new int[]{2};
            String[] registeredAgentNameArr = new String[1];
            int[] payloadTypeArr = new int[]{0};
            int[] qosFlagsArr = new int[]{0};
            int[] timeoutArr = new int[]{0};
            int[] dbchangeOpFilterArr = new int[]{0};
            int[] dbchangeTxnLagArr = new int[]{0};
            byte[] kpdnrgrpclaArr = new byte[]{0};
            int[] kpdnrgrpvalArr = new int[]{0};
            byte[] kpdnrgrptypArr = new byte[]{0};
            TIMESTAMPTZ[] kpdnrgrpstatimArr = new TIMESTAMPTZ[]{null};
            int[] kpdnrgrprepcntArr = new int[]{0};
            long[] dbchangeRegistrationIdArr = new long[]{registrationId};
            byte[][] contextArr = new byte[1][];
            try {
                this.sendPiggyBackedMessages();
                this.okpn.doOKPN(2, 0, null, location, 1, namespaceArr, registeredAgentNameArr, contextArr, payloadTypeArr, qosFlagsArr, timeoutArr, dbchangeOpFilterArr, dbchangeTxnLagArr, dbchangeRegistrationIdArr, kpdnrgrpclaArr, kpdnrgrpvalArr, kpdnrgrptypArr, kpdnrgrpstatimArr, kpdnrgrprepcntArr);
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void doUnregisterDatabaseChangeNotification(NTFDCNRegistration dcnregistration) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(dcnregistration));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PhysicalConnection.ntfManager.removeRegistration(dcnregistration);
            PhysicalConnection.ntfManager.freeJdbcRegId(dcnregistration.getJdbcRegId());
            PhysicalConnection.ntfManager.cleanListenersT4C(dcnregistration.getClientTCPPort());
            dcnregistration.setState(NotificationRegistration.RegistrationState.CLOSED);
            this.doUnregisterDatabaseChangeNotification(dcnregistration.getRegId(), "(ADDRESS=(PROTOCOL=tcp)(HOST=" + dcnregistration.getClientHost() + ")(PORT=" + dcnregistration.getClientTCPPort() + "))?PR=0");
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDataIntegrityAlgorithmName() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.net.getDataIntegrityName());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.net.getDataIntegrityName();
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEncryptionAlgorithmName() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.net.getEncryptionName());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.net.getEncryptionName();
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAuthenticationAdaptorName() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.net.getAuthenticationAdaptorName());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.net.getAuthenticationAdaptorName();
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void validateConnectionProperties() throws SQLException {
        super.validateConnectionProperties();
        String pattern = ".*[\\00\\(\\)].*";
        if (this.thinVsessionOsuser != null && (this.thinVsessionOsuser.matches(pattern) || this.thinVsessionOsuser.length() > 30)) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.SEVERE, "         Throwing SQLException: 190Property is 'v$session.osuser' and value is '" + this.thinVsessionOsuser + "'");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 190, "Property is 'v$session.osuser' and value is '" + this.thinVsessionOsuser + "'");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.thinVsessionTerminal != null && (this.thinVsessionTerminal.matches(pattern) || this.thinVsessionTerminal.length() > 30)) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.SEVERE, "         Throwing SQLException: 190Property is 'v$session.terminal' and value is '" + this.thinVsessionTerminal + "'");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 190, "Property is 'v$session.terminal' and value is '" + this.thinVsessionTerminal + "'");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.thinVsessionMachine != null && (this.thinVsessionMachine.matches(pattern) || this.thinVsessionMachine.length() > 64)) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.SEVERE, "         Throwing SQLException: 190Property is 'v$session.machine' and value is '" + this.thinVsessionMachine + "'");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 190, "Property is 'v$session.machine' and value is '" + this.thinVsessionMachine + "'");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.thinVsessionProgram != null && (this.thinVsessionProgram.matches(pattern) || this.thinVsessionProgram.length() > 48)) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.SEVERE, "         Throwing SQLException: 190Property is 'v$session.program' and value is '" + this.thinVsessionProgram + "'");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 190, "Property is 'v$session.program' and value is '" + this.thinVsessionProgram + "'");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.thinVsessionProcess != null && (this.thinVsessionProcess.matches(pattern) || this.thinVsessionProcess.length() > 24)) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.SEVERE, "         Throwing SQLException: 190Property is 'v$session.process' and value is '" + this.thinVsessionProcess + "'");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 190, "Property is 'v$session.process' and value is '" + this.thinVsessionProcess + "'");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.thinVsessionIname != null && this.thinVsessionIname.matches(pattern)) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.SEVERE, "         Throwing SQLException: 190Property is 'v$session.iname' and value is '" + this.thinVsessionIname + "'");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 190, "Property is 'v$session.iname' and value is '" + this.thinVsessionIname + "'");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.thinVsessionEname != null && this.thinVsessionEname.matches(pattern)) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.SEVERE, "         Throwing SQLException: 190Property is 'v$session.ename' and value is '" + this.thinVsessionEname + "'");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 190, "Property is 'v$session.ename' and value is '" + this.thinVsessionEname + "'");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] createLightweightSession(String userName, KeywordValueLong[] inKeyVal, int inFlags, KeywordValueLong[][] outKeyVal, int[] outFlags) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(userName) + ", " + OracleLog.argument(inKeyVal) + ", " + OracleLog.argument(inFlags) + ", " + OracleLog.argument(outKeyVal) + ", " + OracleLog.argument(outFlags));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (outKeyVal.length != 1 || outFlags.length != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            byte[] ret = null;
            try {
                this.sendPiggyBackedMessages();
                this.oxsscs.doOXSSCS(userName, inKeyVal, inFlags);
                ret = this.oxsscs.getSessionId();
                outKeyVal[0] = this.oxsscs.getOutKV();
                outFlags[0] = this.oxsscs.getOutFlags();
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doXSNamespaceOp(OracleConnection.XSOperationCode operationCode, byte[] sessionId, XSNamespace[] namespaces, XSNamespace[][] returnedNamespaces, boolean roundTripRPC) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument((Object)operationCode) + ", " + OracleLog.argument(sessionId) + ", " + OracleLog.argument(namespaces) + ", " + OracleLog.argument(returnedNamespaces) + ", " + OracleLog.argument(roundTripRPC));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            XSNamespace[] ret = null;
            try {
                if (roundTripRPC) {
                    this.sendPiggyBackedMessages();
                }
                this.xsnsop.doOXSNS(operationCode, sessionId, namespaces, roundTripRPC);
                if (roundTripRPC) {
                    ret = this.xsnsop.getNamespaces();
                }
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (returnedNamespaces != null && returnedNamespaces.length > 0) {
                returnedNamespaces[0] = ret;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    public void doXSNamespaceOp(OracleConnection.XSOperationCode operationCode, byte[] sessionId, XSNamespace[] namespaces, XSNamespace[][] returnedNamespaces) throws SQLException {
        this.doXSNamespaceOp(operationCode, sessionId, namespaces, returnedNamespaces, true);
    }

    @Override
    public void doXSNamespaceOp(OracleConnection.XSOperationCode operationCode, byte[] sessionId, XSNamespace[] namespaces) throws SQLException {
        this.doXSNamespaceOp(operationCode, sessionId, namespaces, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void executeLightweightSessionRoundtrip(int functionId, byte[] sessionId, KeywordValueLong[] inKeyVal, int inFlags, KeywordValueLong[][] outKeyVal, int[] outFlags) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(functionId) + ", " + OracleLog.argument(sessionId) + ", " + OracleLog.argument(inKeyVal) + ", " + OracleLog.argument(inFlags) + ", " + OracleLog.argument(outKeyVal) + ", " + OracleLog.argument(outFlags));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (outKeyVal.length != 1 || outFlags.length != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            try {
                this.sendPiggyBackedMessages();
                this.oxssro.doOXSSRO(functionId, sessionId, inKeyVal, inFlags);
                outKeyVal[0] = this.oxssro.getOutKV();
                outFlags[0] = this.oxssro.getOutFlags();
            }
            catch (IOException ex) {
                this.handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void executeLightweightSessionPiggyback(int functionId, byte[] sessionId, KeywordValueLong[] inKeyVal, int inFlags) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(functionId) + ", " + OracleLog.argument(sessionId) + ", " + OracleLog.argument(inKeyVal) + ", " + OracleLog.argument(inFlags));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.lusOffset2 == this.lusFunctionId2.length) {
                int currentLength = this.lusFunctionId2.length;
                int[] lusFunctionId2_temp = new int[currentLength * 2];
                System.arraycopy(this.lusFunctionId2, 0, lusFunctionId2_temp, 0, currentLength);
                byte[][] lusSessionId2_temp = new byte[currentLength * 2][];
                System.arraycopy(this.lusSessionId2, 0, lusSessionId2_temp, 0, currentLength);
                KeywordValueLong[][] lusInKeyVal2_temp = new KeywordValueLong[currentLength * 2][];
                System.arraycopy(this.lusInKeyVal2, 0, lusInKeyVal2_temp, 0, currentLength);
                int[] lusInFlags2_temp = new int[currentLength * 2];
                System.arraycopy(this.lusInFlags2, 0, lusInFlags2_temp, 0, currentLength);
                this.lusFunctionId2 = lusFunctionId2_temp;
                this.lusSessionId2 = lusSessionId2_temp;
                this.lusInKeyVal2 = lusInKeyVal2_temp;
                this.lusInFlags2 = lusInFlags2_temp;
            }
            this.lusFunctionId2[this.lusOffset2] = functionId;
            this.lusSessionId2[this.lusOffset2] = sessionId;
            this.lusInKeyVal2[this.lusOffset2] = inKeyVal;
            this.lusInFlags2[this.lusOffset2] = inFlags;
            ++this.lusOffset2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addXSEventListener(XSEventListener l2, Executor e2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(l2) + ", " + OracleLog.argument(e2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            NTFEventListener listener = new NTFEventListener(l2);
            listener.setExecutor(e2);
            NTFEventListener[] nTFEventListenerArray = this.xsListeners;
            synchronized (this.xsListeners) {
                int length = this.xsListeners.length;
                for (int i2 = 0; i2 < length; ++i2) {
                    if (this.xsListeners[i2].getXSEventListener() != l2) continue;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 248);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 248);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                NTFEventListener[] listeners2 = new NTFEventListener[length + 1];
                System.arraycopy(this.xsListeners, 0, listeners2, 0, length);
                listeners2[length] = listener;
                this.xsListeners = listeners2;
                // ** MonitorExit[var4_7] (shouldn't be in output)
            }
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addXSEventListener(XSEventListener l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(l2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.addXSEventListener(l2, null);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeXSEventListener(XSEventListener listener) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(listener));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NTFEventListener[] nTFEventListenerArray = this.xsListeners;
            synchronized (this.xsListeners) {
                int i2 = 0;
                int length = this.xsListeners.length;
                for (i2 = 0; i2 < length && this.xsListeners[i2].getXSEventListener() != listener; ++i2) {
                }
                if (i2 == length) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 249);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 249);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                NTFEventListener[] listeners2 = new NTFEventListener[length - 1];
                int offset = 0;
                for (i2 = 0; i2 < length; ++i2) {
                    if (this.xsListeners[i2].getXSEventListener() == listener) continue;
                    listeners2[offset++] = this.xsListeners[i2];
                }
                this.xsListeners = listeners2;
                // ** MonitorExit[var2_3] (shouldn't be in output)
            }
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notify(final NTFXSEvent event) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(event));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "DCNRegistration got an event.");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NTFEventListener[] localListeners = this.xsListeners;
            int length = localListeners.length;
            for (int i2 = 0; i2 < length; ++i2) {
                Executor exec = localListeners[i2].getExecutor();
                if (exec != null) {
                    final XSEventListener l2 = localListeners[i2].getXSEventListener();
                    exec.execute(new Runnable(){

                        public void run() {
                            l2.onXSEvent(event);
                        }
                    });
                    continue;
                }
                localListeners[i2].getXSEventListener().onXSEvent(event);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    final boolean hasServerCompileTimeCapability(int index, int flag) {
        boolean ret = false;
        if (this.serverCompileTimeCapabilities != null && this.serverCompileTimeCapabilities.length > index && (this.serverCompileTimeCapabilities[index] & flag) != 0) {
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long doGetCurrentSCN() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.outScn);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = this.outScn;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EnumSet<OracleConnection.TransactionState> doGetTransactionState() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            EnumSet<OracleConnection.TransactionState> ret = EnumSet.noneOf(OracleConnection.TransactionState.class);
            if ((this.eocs & 1) != 0) {
                ret.add(OracleConnection.TransactionState.TRANSACTION_READONLY);
            }
            if ((this.eocs & 2) != 0) {
                ret.add(OracleConnection.TransactionState.TRANSACTION_STARTED);
            }
            if ((this.eocs & 4) != 0) {
                ret.add(OracleConnection.TransactionState.TRANSACTION_ENDED);
            }
            if ((this.eocs & 0x400) != 0) {
                ret.add(OracleConnection.TransactionState.TRANSACTION_INTENTION);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            EnumSet<OracleConnection.TransactionState> enumSet = ret;
            return enumSet;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.net.isConnectionSocketKeepAlive());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.net.isConnectionSocketKeepAlive();
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    byte getNextSeqNumber() {
        if (this.currentTTCSeqNumber == 127) {
            this.currentTTCSeqNumber = 1;
            return this.currentTTCSeqNumber;
        }
        this.currentTTCSeqNumber = (byte)(this.currentTTCSeqNumber + 1);
        return this.currentTTCSeqNumber;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

