/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CMAREngine;

class T4CBinaryDoubleAccessor
extends BinaryDoubleAccessor {
    T4CMAREngine mare;
    boolean underlyingLongRaw = false;
    final int[] meta = new int[1];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CBinaryDoubleAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, forBind);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBinaryDoubleAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind) + ", " + OracleLog.argument(_mare));
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBinaryDoubleAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CBinaryDoubleAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    T4CBinaryDoubleAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len == -1 ? _definedColumnSize : max_len, nullable, flags, precision, scale, contflag, total_elems, form);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBinaryDoubleAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(_definedColumnType) + ", " + OracleLog.argument(_definedColumnSize) + ", " + OracleLog.argument(_mare));
                    Object var14_13 = null;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            if (stmt != null && stmt.implicitDefineForLobPrefetchDone) {
                this.definedColumnType = 0;
                this.definedColumnSize = 0;
            } else {
                this.definedColumnType = _definedColumnType;
                this.definedColumnSize = _definedColumnSize;
            }
            if (max_len == -1) {
                this.underlyingLongRaw = true;
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBinaryDoubleAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var18_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var18_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CBinaryDoubleAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var18_18 = null;
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getString(int currentRow) throws SQLException {
        String string;
        try {
            String ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBinaryDoubleAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((ret = super.getString(currentRow)) != null && this.definedColumnSize > 0 && ret.length() > this.definedColumnSize) {
                ret = ret.substring(0, this.definedColumnSize);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBinaryDoubleAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = ret;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBinaryDoubleAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CBinaryDoubleAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            byte[] buff = new byte[16000];
            this.mare.unmarshalCLR(buff, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
            ++this.lastRowProcessed;
            if (this.statement.connection.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        int tmpSpaceByteOffset = this.columnIndex + this.lastRowProcessed * this.byteLength;
        this.mare.unmarshalCLR(this.rowSpaceByte, tmpSpaceByteOffset, this.meta, this.byteLength);
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
        } else {
            this.rowSpaceIndicator[tmpLengthOffset] = (short)this.meta[0];
            this.rowSpaceIndicator[tmpIndicatorOffset] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    void copyRow() throws SQLException, IOException {
        int lastRowOffset = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch - 1 : this.lastRowProcessed - 1;
        int tmpSpaceByteOffset = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int tmpSpaceByteOffsetLastRow = this.columnIndex + lastRowOffset * this.byteLength;
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpIndicatorOffsetLastRow = this.indicatorIndex + lastRowOffset;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        int tmpLengthOffsetLastRow = this.lengthIndex + lastRowOffset;
        short nbBytes = this.rowSpaceIndicator[tmpLengthOffsetLastRow];
        int indexmetadata = this.metaDataIndex + this.lastRowProcessed * 1;
        int indexmetadataLastRow = this.metaDataIndex + lastRowOffset * 1;
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = this.rowSpaceIndicator[tmpIndicatorOffsetLastRow];
        if (!this.isNullByDescribe) {
            System.arraycopy(this.rowSpaceByte, tmpSpaceByteOffsetLastRow, this.rowSpaceByte, tmpSpaceByteOffset, nbBytes);
        }
        System.arraycopy(this.rowSpaceMetaData, indexmetadataLastRow, this.rowSpaceMetaData, indexmetadata, 1);
        ++this.lastRowProcessed;
    }

    void saveDataFromOldDefineBuffers(byte[] rowSpaceByteLastRow, char[] rowSpaceCharLastRow, short[] rowSpaceIndicatorLastRow, int oldPrefetchSize, int newPrefetchSize) throws SQLException {
        int tmpSpaceByteOffset = this.columnIndex + (newPrefetchSize - 1) * this.byteLength;
        int tmpSpaceByteOffsetLastRow = this.columnIndexLastRow + (oldPrefetchSize - 1) * this.byteLength;
        int tmpIndicatorOffset = this.indicatorIndex + newPrefetchSize - 1;
        int tmpIndicatorOffsetLastRow = this.indicatorIndexLastRow + oldPrefetchSize - 1;
        int tmpLengthOffset = this.lengthIndex + newPrefetchSize - 1;
        int tmpLengthOffsetLastRow = this.lengthIndexLastRow + oldPrefetchSize - 1;
        short nbBytes = rowSpaceIndicatorLastRow[tmpLengthOffsetLastRow];
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = rowSpaceIndicatorLastRow[tmpIndicatorOffsetLastRow];
        if (nbBytes != 0) {
            System.arraycopy(rowSpaceByteLastRow, tmpSpaceByteOffsetLastRow, this.rowSpaceByte, tmpSpaceByteOffset, nbBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(currentRow);
        }
        Object result = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBinaryDoubleAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            switch (this.definedColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    return this.getString(currentRow);
                }
                case 2: 
                case 3: {
                    return this.getBigDecimal(currentRow);
                }
                case 6: 
                case 8: {
                    return this.getDouble(currentRow);
                }
                case 101: {
                    return this.getBINARY_DOUBLE(currentRow);
                }
                case 7: {
                    return Float.valueOf(this.getFloat(currentRow));
                }
                case -5: {
                    return this.getLong(currentRow);
                }
                case -6: {
                    return this.getByte(currentRow);
                }
                case 5: {
                    return this.getShort(currentRow);
                }
                case 4: {
                    return this.getInt(currentRow);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getBytes(currentRow);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CBinaryDoubleAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        return result;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CBinaryDoubleAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

