/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.KeywordValueI;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.jdbc.driver.T4C8TTIrxh;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIdcb;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIiov;
import oracle.jdbc.driver.T4CTTIoac;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.internal.KeywordValue;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.oracore.OracleTypeADT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class T4C8Oall
extends T4CTTIfun {
    Vector<IOException> nonFatalIOExceptions = null;
    static final byte[] EMPTY_BYTES = new byte[0];
    static final int UOPF_PRS = 1;
    static final int UOPF_BND = 8;
    static final int UOPF_EXE = 32;
    static final int UOPF_FEX = 512;
    static final int UOPF_FCH = 64;
    static final int UOPF_CAN = 128;
    static final int UOPF_COM = 256;
    static final int UOPF_DSY = 8192;
    static final int UOPF_SIO = 1024;
    static final int UOPF_NPL = 32768;
    static final int UOPF_DFN = 16;
    static final int EXE_COMMIT_ON_SUCCESS = 1;
    static final int EXE_LEAVE_CUR_MAPPED = 2;
    static final int EXE_BATCH_DML_ERRORS = 4;
    static final int EXE_SCROL_READ_ONLY = 8;
    static final int AL8KW_MAXLANG = 63;
    static final int AL8KW_TIMEZONE = 163;
    static final int AL8KW_ERR_OVLAP = 164;
    static final int AL8KW_SESSION_ID = 165;
    static final int AL8KW_SERIAL_NUM = 166;
    static final int AL8KW_TAG_FOUND = 167;
    static final int AL8KW_SCHEMA_NAME = 168;
    static final int AL8KW_SCHEMA_ID = 169;
    static final int AL8KW_ENABLED_ROLES = 170;
    static final int AL8KW_AUX_SESSSTATE = 171;
    static final String[] NLS_KEYS = new String[]{"AUTH_NLS_LXCCURRENCY", "AUTH_NLS_LXCISOCURR", "AUTH_NLS_LXCNUMERICS", null, null, null, null, "AUTH_NLS_LXCDATEFM", "AUTH_NLS_LXCDATELANG", "AUTH_NLS_LXCTERRITORY", "SESSION_NLS_LXCCHARSET", "AUTH_NLS_LXCSORT", "AUTH_NLS_LXCCALENDAR", null, null, null, "AUTH_NLS_LXLAN", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "AUTH_NLS_LXCSORT", null, "AUTH_NLS_LXCUNIONCUR", null, null, null, null, "AUTH_NLS_LXCTIMEFM", "AUTH_NLS_LXCSTMPFM", "AUTH_NLS_LXCTTZNFM", "AUTH_NLS_LXCSTZNFM", "SESSION_NLS_LXCNLSLENSEM", "SESSION_NLS_LXCNCHAREXCP", "SESSION_NLS_LXCNCHARIMP"};
    static final int LDIREGIDFLAG = 120;
    static final int LDIREGIDSET = 181;
    static final int LDIMAXTIMEFIELD = 60;
    int rowsProcessed;
    int numberOfDefinePositions;
    long options;
    int cursor;
    byte[] sqlStmt = new byte[0];
    final long[] al8i4 = new long[13];
    boolean plsql = false;
    Accessor[] definesAccessors;
    int definesLength;
    Accessor[] outBindAccessors;
    int numberOfBindPositions;
    InputStream[][] parameterStream;
    byte[][][] parameterDatum;
    OracleTypeADT[][] parameterOtype;
    short[] bindIndicators;
    byte[] bindBytes;
    char[] bindChars;
    int bindIndicatorSubRange;
    byte[] tmpBindsByteArray;
    DBConversion conversion;
    byte[] ibtBindBytes;
    char[] ibtBindChars;
    short[] ibtBindIndicators;
    boolean sendBindsDefinition = false;
    OracleStatement oracleStatement;
    short dbCharSet;
    short NCharSet;
    T4CTTIrxd rxd;
    T4C8TTIrxh rxh;
    T4CTTIdcb dcb;
    OracleStatement.SqlKind typeOfStatement;
    int defCols = 0;
    int rowsToFetch;
    boolean aFetchWasDone = false;
    T4CTTIoac[] oacdefBindsSent;
    T4CTTIoac[] oacdefDefines;
    int[] definedColumnSize;
    int[] definedColumnType;
    int[] definedColumnFormOfUse;
    NTFDCNRegistration registration = null;
    static final int AL8TXCUR = 1;
    static final int AL8TXDON = 2;
    static final int AL8TXRON = 4;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4C8Oall(T4CConnection _connection) {
        super(_connection, (byte)3);
        this.setFunCode((short)94);
        this.rxh = new T4C8TTIrxh(_connection);
        this.rxd = new T4CTTIrxd(_connection);
        this.dcb = new T4CTTIdcb(_connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doOALL(boolean doParse, boolean doExecute, boolean doFetch, boolean doDescribe, boolean doDefine, OracleStatement.SqlKind _typeOfStatement, int _cursor, byte[] _sqlStmt, int _rowsToFetch, Accessor[] _outBindAccessors, int _numberOfBindPositions, Accessor[] _definesAccessors, int _definesLength, byte[] _bindBytes, char[] _bindChars, short[] _bindIndicators, int _bindIndicatorSubRange, DBConversion _conversion, byte[] _tmpBindsByteArray, InputStream[][] _parameterStream, byte[][][] _parameterDatum, OracleTypeADT[][] _parameterOtype, OracleStatement _oracleStatement, byte[] _ibtBindBytes, char[] _ibtBindChars, short[] _ibtBindIndicators, T4CTTIoac[] _oacdefBindsSent, int[] _definedColumnType, int[] _definedColumnSize, int[] _definedColumnFormOfUse, NTFDCNRegistration _registration) throws SQLException, IOException {
        this.typeOfStatement = _typeOfStatement;
        this.cursor = _cursor;
        this.sqlStmt = doParse ? _sqlStmt : EMPTY_BYTES;
        this.rowsToFetch = _rowsToFetch;
        this.outBindAccessors = _outBindAccessors;
        this.numberOfBindPositions = _numberOfBindPositions;
        this.definesAccessors = _definesAccessors;
        this.definesLength = _definesLength;
        this.bindBytes = _bindBytes;
        this.bindChars = _bindChars;
        this.bindIndicators = _bindIndicators;
        this.bindIndicatorSubRange = _bindIndicatorSubRange;
        this.conversion = _conversion;
        this.tmpBindsByteArray = _tmpBindsByteArray;
        this.parameterStream = _parameterStream;
        this.parameterDatum = _parameterDatum;
        this.parameterOtype = _parameterOtype;
        this.oracleStatement = _oracleStatement;
        this.ibtBindBytes = _ibtBindBytes;
        this.ibtBindChars = _ibtBindChars;
        this.ibtBindIndicators = _ibtBindIndicators;
        this.oacdefBindsSent = _oacdefBindsSent;
        this.definedColumnType = _definedColumnType;
        this.definedColumnSize = _definedColumnSize;
        this.definedColumnFormOfUse = _definedColumnFormOfUse;
        this.registration = _registration;
        this.dbCharSet = _conversion.getServerCharSetId();
        this.NCharSet = _conversion.getNCharSetId();
        int number_of_bound_rows = 0;
        if (this.bindIndicators != null) {
            number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
        }
        if (_sqlStmt == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4C8Oall.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 431);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 431);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (!this.typeOfStatement.isDML() && number_of_bound_rows > 1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4C8Oall.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 433);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 433);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        this.rowsProcessed = 0;
        this.options = 0L;
        this.plsql = this.typeOfStatement.isPlsqlOrCall();
        this.sendBindsDefinition = false;
        if (this.receiveState != 0) {
            this.receiveState = 0;
        }
        this.rxh.init();
        this.rxd.init();
        this.oer.init();
        if (doDefine) {
            this.initDefinesDefinition();
        }
        if (this.numberOfBindPositions > 0 && this.bindIndicators != null) {
            if (this.oacdefBindsSent == null) {
                this.oacdefBindsSent = new T4CTTIoac[this.numberOfBindPositions];
            }
            this.sendBindsDefinition = this.initBindsDefinition(this.oacdefBindsSent);
        }
        this.options = this.setOptions(doParse, doExecute, doFetch, doDefine);
        this.al8i4[0] = (this.options & 1L) > 0L ? 1L : 0L;
        this.al8i4[1] = this.plsql || this.typeOfStatement.isOTHER() ? 1L : (doDescribe ? (doFetch && this.oracleStatement.connection.useFetchSizeWithLongColumn ? (long)this.rowsToFetch : 0L) : (this.typeOfStatement.isDML() ? (number_of_bound_rows == 0 ? (long)this.oracleStatement.batch : (long)number_of_bound_rows) : (doFetch && !doDescribe ? (long)this.rowsToFetch : 0L)));
        this.al8i4[7] = this.typeOfStatement.isSELECT() ? 1L : 0L;
        long scn = this.oracleStatement.inScn;
        int leastSignificantHalfScn = (int)scn;
        int mostSignificantHalfScn = (int)(scn >> 32);
        this.al8i4[5] = leastSignificantHalfScn;
        this.al8i4[6] = mostSignificantHalfScn;
        this.rowsProcessed = 0;
        this.aFetchWasDone = false;
        this.rxd.setNumberOfColumns(this.definesLength);
        if ((this.options & 0x40L) != 0L && (this.options & 0x20L) == 0L && (this.options & 1L) == 0L && (this.options & 8L) == 0L && (this.options & 0x10L) == 0L && !this.oracleStatement.needToSendOalToFetch) {
            this.setFunCode((short)5);
        } else {
            this.setFunCode((short)94);
        }
        this.nonFatalIOExceptions = null;
        this.doRPC();
        if ((this.options & 0x20L) != 0L) {
            this.oracleStatement.inScn = 0L;
        }
        this.ibtBindIndicators = null;
        this.ibtBindChars = null;
        this.ibtBindBytes = null;
        this.tmpBindsByteArray = null;
        this.outBindAccessors = null;
        this.bindBytes = null;
        this.bindChars = null;
        this.bindIndicators = null;
        this.oracleStatement = null;
        if (this.nonFatalIOExceptions != null) {
            IOException firstIOex = this.nonFatalIOExceptions.get(0);
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4C8Oall.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 266);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 266);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (SQLException sqlex) {
                sqlex.initCause(firstIOex);
                throw sqlex;
            }
        }
    }

    @Override
    void readBVC() throws IOException, SQLException {
        int nbOfColumnSent = this.meg.unmarshalUB2();
        this.rxd.unmarshalBVC(nbOfColumnSent);
    }

    @Override
    void readIOV() throws IOException, SQLException {
        T4CTTIiov iov = new T4CTTIiov(this.connection, this.rxh, this.rxd);
        iov.init();
        iov.unmarshalV10();
        if (this.oracleStatement.returnParamAccessors == null && !iov.isIOVectorEmpty()) {
            byte[] ioVector = iov.getIOVector();
            this.outBindAccessors = iov.processRXD(this.outBindAccessors, this.numberOfBindPositions, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.conversion, this.tmpBindsByteArray, ioVector, this.parameterStream, this.parameterDatum, this.parameterOtype, this.oracleStatement, null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void readRXH() throws IOException, SQLException {
        this.rxh.init();
        this.rxh.unmarshalV10(this.rxd);
        if (this.rxh.uacBufLength > 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4C8Oall.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 405);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 405);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if ((this.rxh.rxhflg & 8) == 8) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4C8Oall.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 449);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 449);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if ((this.rxh.rxhflg & 0x10) == 16) {
            for (int i2 = 0; i2 < this.definesAccessors.length; ++i2) {
                if (this.definesAccessors[i2].udskpos < 0 || this.definesAccessors[i2].udskpos == i2) continue;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4C8Oall.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 450);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 450);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
    }

    @Override
    void processSLG() throws IOException, SQLException {
        this.readRXH();
        int[] oacmxlArr = new int[this.numberOfBindPositions];
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            oacmxlArr[i2] = this.oacdefBindsSent[i2].oacmxl;
        }
        this.nonFatalIOExceptions = this.marshalBinds(oacmxlArr, true);
    }

    @Override
    boolean readRXD() throws IOException, SQLException {
        this.aFetchWasDone = true;
        if (this.oracleStatement.returnParamAccessors != null && this.numberOfBindPositions > 0) {
            boolean memoryHasBeenAllocated = false;
            for (int col = 0; col < this.oracleStatement.numberOfBindPositions; ++col) {
                Accessor acc = this.oracleStatement.returnParamAccessors[col];
                if (acc == null) continue;
                int nbOfRowsSent = (int)this.meg.unmarshalUB4();
                if (!memoryHasBeenAllocated) {
                    this.oracleStatement.rowsDmlReturned = nbOfRowsSent;
                    this.oracleStatement.allocateDmlReturnStorage();
                    this.oracleStatement.setupReturnParamAccessors();
                    memoryHasBeenAllocated = true;
                }
                for (int row = 0; row < nbOfRowsSent; ++row) {
                    acc.unmarshalOneRow();
                }
            }
            this.oracleStatement.returnParamsFetched = true;
        } else if (this.iovProcessed || this.outBindAccessors != null && this.definesAccessors == null ? this.rxd.unmarshal(this.outBindAccessors, this.numberOfBindPositions) : this.rxd.unmarshal(this.definesAccessors, this.definesLength)) {
            return true;
        }
        return false;
    }

    @Override
    void readRPA() throws IOException, SQLException {
        int al8o4l = this.meg.unmarshalUB2();
        int[] al8o4 = new int[al8o4l];
        for (int i2 = 0; i2 < al8o4l; ++i2) {
            al8o4[i2] = (int)this.meg.unmarshalUB4();
        }
        int leastSignificantHalfScn = al8o4[0];
        int mostSignificantHalfScn = al8o4[1];
        long scn = (long)leastSignificantHalfScn & 0xFFFFFFFFL | ((long)mostSignificantHalfScn & 0xFFFFFFFFL) << 32;
        if (scn != 0L) {
            this.oracleStatement.connection.outScn = scn;
        }
        this.cursor = al8o4[2];
        int al8txl = this.meg.unmarshalUB2();
        byte[] al8txn = null;
        if (al8txl > 0) {
            al8txn = this.meg.unmarshalNBytes(al8txl);
        }
        int al8kvl = this.meg.unmarshalUB2();
        KeywordValue[] al8kv = new KeywordValue[al8kvl];
        for (int i3 = 0; i3 < al8kvl; ++i3) {
            al8kv[i3] = KeywordValueI.unmarshal(this.meg);
        }
        this.connection.updateSessionProperties(al8kv);
        this.oracleStatement.dcnQueryId = -1L;
        this.oracleStatement.dcnTableName = null;
        if (this.connection.getTTCVersion() >= 4) {
            int registrationFeedbackLength = (int)this.meg.unmarshalUB4();
            byte[] registrationFeedback = this.meg.unmarshalNBytes(registrationFeedbackLength);
            if (registrationFeedbackLength > 0 && this.registration != null) {
                String qcOption;
                boolean isQC = false;
                Properties regOptions = this.registration.getRegistrationOptions();
                if (regOptions != null && (qcOption = regOptions.getProperty("DCN_QUERY_CHANGE_NOTIFICATION")) != null && qcOption.compareToIgnoreCase("true") == 0) {
                    isQC = true;
                }
                int tablesDescriptionLength = registrationFeedbackLength;
                if (isQC) {
                    tablesDescriptionLength = registrationFeedbackLength - 8;
                }
                String tablesAll = new String(registrationFeedback, 0, tablesDescriptionLength);
                char[] delimitor = new char[]{'\u0000'};
                String[] tables = tablesAll.split(new String(delimitor));
                this.registration.addTablesName(tables, tables.length);
                this.oracleStatement.dcnTableName = tables;
                if (isQC) {
                    long queryId;
                    int queryId2 = registrationFeedback[registrationFeedbackLength - 1] & 0xFF | (registrationFeedback[registrationFeedbackLength - 2] & 0xFF) << 8 | (registrationFeedback[registrationFeedbackLength - 3] & 0xFF) << 16 | (registrationFeedback[registrationFeedbackLength - 4] & 0xFF) << 24;
                    int queryId1 = registrationFeedback[registrationFeedbackLength - 5] & 0xFF | (registrationFeedback[registrationFeedbackLength - 6] & 0xFF) << 8 | (registrationFeedback[registrationFeedbackLength - 7] & 0xFF) << 16 | (registrationFeedback[registrationFeedbackLength - 8] & 0xFF) << 24;
                    this.oracleStatement.dcnQueryId = queryId = (long)queryId1 & 0xFFFFFFFFL | ((long)queryId2 & 0xFFFFFFFFL) << 32;
                }
            }
        }
    }

    @Override
    void readDCB() throws IOException, SQLException {
        this.dcb.init(this.oracleStatement, 0);
        this.definesAccessors = this.dcb.receive(this.definesAccessors);
        this.definesLength = this.numberOfDefinePositions = this.dcb.numuds;
        this.rxd.setNumberOfColumns(this.numberOfDefinePositions);
    }

    @Override
    void processError() throws SQLException {
        this.cursor = this.oer.currCursorID;
        this.rowsProcessed = this.oer.getCurRowNumber();
        if (this.typeOfStatement.isSELECT() && this.oer.retCode == 1403) {
            this.aFetchWasDone = true;
        }
        if (!this.typeOfStatement.isSELECT() || this.typeOfStatement.isSELECT() && this.oer.retCode != 1403) {
            if (this.oracleStatement.connection.calculateChecksum && this.oer.retCode != 0) {
                long _checkSum;
                this.oracleStatement.checkSum = _checkSum = this.oer.updateChecksum(this.oracleStatement.checkSum);
            }
            this.oer.processError(this.oracleStatement);
        }
    }

    int getCursorId() {
        return this.cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void continueReadRow(int start, OracleStatement s2) throws SQLException, IOException {
        try {
            this.oracleStatement = s2;
            this.receiveState = 2;
            if (this.rxd.unmarshal(this.definesAccessors, start, this.definesLength)) {
                this.receiveState = 3;
                return;
            }
            this.resumeReceive();
        }
        finally {
            this.oracleStatement = null;
        }
    }

    int getNumRows() {
        int rows = 0;
        if (this.typeOfStatement == null) {
            return rows;
        }
        if (this.receiveState == 3) {
            rows = -2;
        } else if (this.typeOfStatement != null) {
            switch (this.typeOfStatement) {
                case DELETE: 
                case INSERT: 
                case MERGE: 
                case UPDATE: 
                case ALTER_SESSION: 
                case OTHER: 
                case PLSQL_BLOCK: 
                case CALL_BLOCK: {
                    rows = this.rowsProcessed;
                    break;
                }
                case SELECT_FOR_UPDATE: 
                case SELECT: {
                    rows = this.definesAccessors != null && this.definesLength > 0 ? this.definesAccessors[0].lastRowProcessed : 0;
                }
            }
        }
        return rows;
    }

    @Override
    void marshal() throws IOException {
        if (this.getFunCode() == 5) {
            this.meg.marshalSWORD(this.cursor);
            this.meg.marshalSWORD((int)this.al8i4[1]);
        } else {
            int i2;
            if (this.oracleStatement.needToSendOalToFetch) {
                this.oracleStatement.needToSendOalToFetch = false;
            }
            this.marshalPisdef();
            this.meg.marshalCHR(this.sqlStmt);
            this.meg.marshalUB4Array(this.al8i4);
            int[] oacmxlArr = new int[this.numberOfBindPositions];
            for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                oacmxlArr[i2] = this.oacdefBindsSent[i2].oacmxl;
            }
            if ((this.options & 8L) != 0L && this.numberOfBindPositions > 0 && this.bindIndicators != null && this.sendBindsDefinition) {
                this.marshalBindsTypes(this.oacdefBindsSent);
            }
            if (this.connection.getTTCVersion() >= 2 && (this.options & 0x10L) != 0L) {
                for (i2 = 0; i2 < this.defCols; ++i2) {
                    this.oacdefDefines[i2].marshal();
                }
            }
            if ((this.options & 0x20L) != 0L && this.numberOfBindPositions > 0 && this.bindIndicators != null) {
                this.nonFatalIOExceptions = this.marshalBinds(oacmxlArr, false);
            }
        }
    }

    void marshalPisdef() throws IOException {
        this.meg.marshalUB4(this.options);
        this.meg.marshalSWORD(this.cursor);
        if (this.sqlStmt.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSWORD(this.sqlStmt.length);
        if (this.al8i4.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSWORD(this.al8i4.length);
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        if ((this.options & 0x40L) == 0L && (this.options & 0x20L) != 0L && (this.options & 1L) != 0L && this.typeOfStatement.isSELECT()) {
            this.meg.marshalUB4(Long.MAX_VALUE);
            this.meg.marshalUB4(this.rowsToFetch);
        } else {
            this.meg.marshalUB4(0L);
            this.meg.marshalUB4(0L);
        }
        if (!this.typeOfStatement.isPlsqlOrCall()) {
            this.meg.marshalUB4(Integer.MAX_VALUE);
        } else {
            this.meg.marshalUB4(32760L);
        }
        if ((this.options & 8L) != 0L && this.numberOfBindPositions > 0 && this.sendBindsDefinition) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.numberOfBindPositions);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        if (this.connection.getTTCVersion() >= 2) {
            if (this.defCols > 0 && (this.options & 0x10L) != 0L) {
                this.meg.marshalPTR();
                this.meg.marshalSWORD(this.defCols);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
        }
        if (this.connection.getTTCVersion() >= 4) {
            int regid_lb = 0;
            int regid_mb = 0;
            if (this.registration != null) {
                long regid = this.registration.getRegId();
                regid_lb = (int)(regid & 0xFFFFFFFFFFFFFFFFL);
                regid_mb = (int)((regid & 0xFFFFFFFF00000000L) >> 32);
            }
            this.meg.marshalUB4(regid_lb);
            this.meg.marshalNULLPTR();
            this.meg.marshalPTR();
            if (this.connection.getTTCVersion() >= 5) {
                this.meg.marshalNULLPTR();
                this.meg.marshalUB4(0L);
                this.meg.marshalNULLPTR();
                this.meg.marshalUB4(0L);
                this.meg.marshalUB4(regid_mb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean initBindsDefinition(T4CTTIoac[] oacdefArr) throws SQLException, IOException {
        boolean needToUpdateDefinition = false;
        if (oacdefArr.length != this.numberOfBindPositions) {
            needToUpdateDefinition = true;
            oacdefArr = new T4CTTIoac[this.numberOfBindPositions];
        }
        short[] l_bindIndicators = this.bindIndicators;
        int _oacmxl = 0;
        int nbOfIbt = 0;
        for (int P = 0; P < this.numberOfBindPositions; ++P) {
            T4CTTIoac oac = new T4CTTIoac(this.connection);
            int subRangeOffset = this.bindIndicatorSubRange + 5 + 10 * P;
            short formOfUse = l_bindIndicators[subRangeOffset + 9];
            int _oactype = l_bindIndicators[subRangeOffset + 0] & 0xFFFF;
            switch (_oactype) {
                case 8: 
                case 24: {
                    _oacmxl = this.plsql ? 32760 : Integer.MAX_VALUE;
                    oac.init((short)_oactype, _oacmxl);
                    oac.setFormOfUse(formOfUse);
                    oac.setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
                    break;
                }
                case 998: {
                    if (this.outBindAccessors != null && this.outBindAccessors[P] != null) {
                        PlsqlIndexTableAccessor acc = (PlsqlIndexTableAccessor)this.outBindAccessors[P];
                        oac.init((short)acc.elementInternalType, acc.elementMaxLen);
                        oac.setMal(acc.maxNumberOfElements);
                        oac.addFlg((short)64);
                        ++nbOfIbt;
                        break;
                    }
                    if (this.ibtBindIndicators[6 + nbOfIbt * 8] != 0) {
                        short typeElem = this.ibtBindIndicators[6 + nbOfIbt * 8];
                        int oacmal = (this.ibtBindIndicators[6 + nbOfIbt * 8 + 2] & 0xFFFF) << 16 | this.ibtBindIndicators[6 + nbOfIbt * 8 + 3] & 0xFFFF;
                        _oacmxl = this.ibtBindIndicators[6 + nbOfIbt * 8 + 1] * this.conversion.sMaxCharSize;
                        oac.init(typeElem, _oacmxl);
                        oac.setMal(oacmal);
                        oac.addFlg((short)64);
                        ++nbOfIbt;
                        break;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4C8Oall.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + "INTERNAL ERROR: Binding PLSQL index-by table but no type defined" + -1);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), "INTERNAL ERROR: Binding PLSQL index-by table but no type defined", -1);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                case 109: 
                case 111: {
                    if (this.outBindAccessors != null && this.outBindAccessors[P] != null) {
                        if (this.outBindAccessors[P].internalOtype == null) break;
                        oac.init((short)_oactype, _oactype == 109 ? 11 : 4000);
                        oac.setADT((OracleTypeADT)((TypeAccessor)this.outBindAccessors[P]).internalOtype);
                        break;
                    }
                    if (this.parameterOtype != null && this.parameterOtype[this.oracleStatement.firstRowInBatch] != null) {
                        oac.init((short)_oactype, _oactype == 109 ? 11 : 4000);
                        oac.setADT(this.parameterOtype[this.oracleStatement.firstRowInBatch][P]);
                        break;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4C8Oall.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + "INTERNAL ERROR: Binding NAMED_TYPE but no type defined" + -1);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), "INTERNAL ERROR: Binding NAMED_TYPE but no type defined", -1);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                case 994: {
                    int[] returnParamMetaLocal = this.oracleStatement.returnParamMeta;
                    _oactype = returnParamMetaLocal[3 + P * 4 + 0];
                    _oacmxl = returnParamMetaLocal[3 + P * 4 + 2];
                    formOfUse = (short)returnParamMetaLocal[3 + P * 4 + 3];
                    if (_oactype == 109 || _oactype == 111) {
                        TypeAccessor typeAccessor = (TypeAccessor)this.oracleStatement.returnParamAccessors[P];
                        oac.init((short)_oactype, _oactype == 109 ? 11 : 4000);
                        oac.setADT((OracleTypeADT)typeAccessor.internalOtype);
                        break;
                    }
                    oac.init((short)_oactype, _oacmxl);
                    oac.setFormOfUse(formOfUse);
                    oac.setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
                    break;
                }
                case 180: {
                    int valueLengthOffset;
                    short valueLength;
                    _oacmxl = l_bindIndicators[subRangeOffset + 1] & 0xFFFF;
                    oac.init((short)_oactype, _oacmxl);
                    oac.addFlg2(0x8000000);
                    oac.setTimestampFractionalSecondsPrecision((short)9);
                    int number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
                    if (number_of_bound_rows != 1 || (valueLength = l_bindIndicators[valueLengthOffset = ((l_bindIndicators[subRangeOffset + 7] & 0xFFFF) << 16) + (l_bindIndicators[subRangeOffset + 8] & 0xFFFF)]) != 7) break;
                    oac.setTimestampFractionalSecondsPrecision((short)0);
                    break;
                }
                case 182: 
                case 183: {
                    _oacmxl = l_bindIndicators[subRangeOffset + 1] & 0xFFFF;
                    oac.init((short)_oactype, _oacmxl);
                    oac.setFormOfUse(formOfUse);
                    oac.setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
                    oac.setPrecision((short)9);
                    break;
                }
                default: {
                    _oacmxl = l_bindIndicators[subRangeOffset + 1] & 0xFFFF;
                    if (_oacmxl == 0) {
                        _oacmxl = l_bindIndicators[subRangeOffset + 2] & 0xFFFF;
                        if (_oactype == 996) {
                            _oacmxl *= 2;
                        } else if (_oacmxl > 1) {
                            --_oacmxl;
                        }
                        if (formOfUse == 2) {
                            _oacmxl *= this.conversion.maxNCharSize;
                        }
                        if (this.typeOfStatement == OracleStatement.SqlKind.PLSQL_BLOCK || this.connection.versionNumber >= 10200 && this.typeOfStatement == OracleStatement.SqlKind.CALL_BLOCK) {
                            _oacmxl = _oacmxl == 0 ? 32766 : (_oacmxl *= this.conversion.sMaxCharSize);
                        } else if (this.typeOfStatement == OracleStatement.SqlKind.CALL_BLOCK) {
                            if (_oacmxl < 4001) {
                                _oacmxl = 4001;
                            }
                        } else if (formOfUse != 2) {
                            _oacmxl = ((T4CConnection)this.oracleStatement.connection).retainV9BindBehavior && _oacmxl <= 4000 ? Math.min(_oacmxl * this.conversion.sMaxCharSize, 4000) : (_oacmxl *= this.conversion.sMaxCharSize);
                        }
                        if (_oacmxl == 0) {
                            _oacmxl = 32;
                        }
                    }
                    oac.init((short)_oactype, _oacmxl);
                    oac.setFormOfUse(formOfUse);
                    oac.setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
                }
            }
            if (oacdefArr[P] != null && oac.isOldSufficient(oacdefArr[P])) continue;
            oacdefArr[P] = oac;
            needToUpdateDefinition = true;
        }
        if (needToUpdateDefinition) {
            this.oracleStatement.nbPostPonedColumns[0] = 0;
        }
        return needToUpdateDefinition;
    }

    void initDefinesDefinition() throws SQLException, IOException {
        this.defCols = 0;
        for (int i2 = 0; i2 < this.definedColumnType.length && this.definedColumnType[i2] != 0; ++i2) {
            ++this.defCols;
        }
        this.oacdefDefines = new T4CTTIoac[this.defCols];
        int flg2 = 0;
        int maxLength = 0;
        int oacmxlc = 0;
        short internalType = 0;
        for (int i3 = 0; i3 < this.oacdefDefines.length; ++i3) {
            this.oacdefDefines[i3] = new T4CTTIoac(this.connection);
            internalType = (short)this.oracleStatement.getInternalType(this.definedColumnType[i3]);
            maxLength = Integer.MAX_VALUE;
            flg2 = 0;
            oacmxlc = 0;
            short formOfUse = 1;
            if (this.definedColumnFormOfUse != null && this.definedColumnFormOfUse.length > i3 && this.definedColumnFormOfUse[i3] == 2) {
                formOfUse = 2;
            }
            if (internalType == 8) {
                internalType = 1;
            } else if (internalType == 24) {
                internalType = (short)23;
            } else if (internalType == 1 || internalType == 96) {
                internalType = 1;
                maxLength = 4000 * this.conversion.sMaxCharSize;
                if (this.definedColumnSize != null && this.definedColumnSize.length > i3 && this.definedColumnSize[i3] > 0) {
                    maxLength = this.definedColumnSize[i3] * this.conversion.sMaxCharSize;
                }
            } else if (this.connection.useLobPrefetch && (internalType == 113 || internalType == 112 || internalType == 114)) {
                maxLength = 0;
                flg2 = 0x2000000;
                if (this.definedColumnSize != null && this.definedColumnSize.length > i3 && this.definedColumnSize[i3] > 0) {
                    oacmxlc = this.definedColumnSize[i3];
                }
            } else if (internalType == 23) {
                maxLength = 4000;
            }
            this.oacdefDefines[i3].init(internalType, maxLength);
            this.oacdefDefines[i3].addFlg2(flg2);
            this.oacdefDefines[i3].setMxlc(oacmxlc);
            this.oacdefDefines[i3].setFormOfUse(formOfUse);
            this.oacdefDefines[i3].setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
        }
    }

    void marshalBindsTypes(T4CTTIoac[] oac) throws IOException {
        if (oac == null) {
            return;
        }
        for (int i2 = 0; i2 < oac.length; ++i2) {
            oac[i2].marshal();
        }
    }

    Vector<IOException> marshalBinds(int[] oacmxlArr, boolean processingSLG) throws IOException {
        boolean sendFirstPostPonedColumnOnly;
        int rowId;
        Vector<IOException> ioExceptionsFromUserStream = null;
        int number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
        if (processingSLG) {
            rowId = this.rxh.iterNum;
            sendFirstPostPonedColumnOnly = true;
        } else {
            rowId = 0;
            sendFirstPostPonedColumnOnly = false;
        }
        while (rowId < number_of_bound_rows) {
            int parameterIndex = this.oracleStatement.firstRowInBatch + rowId;
            InputStream[] streamParameters = null;
            if (this.parameterStream != null) {
                streamParameters = this.parameterStream[parameterIndex];
            }
            byte[][] datumParameters = null;
            if (this.parameterDatum != null) {
                datumParameters = this.parameterDatum[parameterIndex];
            }
            OracleTypeADT[] otypeParameters = null;
            if (this.parameterOtype != null) {
                otypeParameters = this.parameterOtype[parameterIndex];
            }
            Vector<IOException> ioExceptionsFromUserStreamForThisRow = this.rxd.marshal(this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.tmpBindsByteArray, this.conversion, streamParameters, datumParameters, otypeParameters, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, null, rowId, oacmxlArr, this.plsql, this.oracleStatement.returnParamMeta, this.oracleStatement.nbPostPonedColumns, this.oracleStatement.indexOfPostPonedColumn, sendFirstPostPonedColumnOnly);
            sendFirstPostPonedColumnOnly = false;
            if (ioExceptionsFromUserStreamForThisRow != null) {
                if (ioExceptionsFromUserStream == null) {
                    ioExceptionsFromUserStream = new Vector<IOException>();
                }
                ioExceptionsFromUserStream.addAll(ioExceptionsFromUserStreamForThisRow);
            }
            ++rowId;
        }
        return ioExceptionsFromUserStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long setOptions(boolean doParse, boolean doExecute, boolean doFetch, boolean doDefine) throws SQLException {
        block24: {
            long options;
            block26: {
                block25: {
                    block23: {
                        options = 0L;
                        if (!doParse || doExecute || doFetch) break block23;
                        options |= 1L;
                        break block24;
                    }
                    if (!doParse || !doExecute || doFetch) break block25;
                    options = 32801L;
                    break block24;
                }
                if (!doExecute || !doFetch) break block26;
                if (doParse) {
                    options |= 1L;
                }
                switch (this.typeOfStatement) {
                    case SELECT_FOR_UPDATE: 
                    case SELECT: {
                        options |= 0x8060L;
                        break block24;
                    }
                    case PLSQL_BLOCK: 
                    case CALL_BLOCK: {
                        if (this.numberOfBindPositions > 0) {
                            options |= 0x420L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0);
                            if (this.sendBindsDefinition) {
                                options |= 8L;
                            }
                        } else {
                            options |= 0x20L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0);
                        }
                        break block24;
                    }
                    case DELETE: 
                    case INSERT: 
                    case MERGE: 
                    case UPDATE: 
                    case ALTER_SESSION: 
                    case OTHER: {
                        options = this.oracleStatement.returnParamAccessors != null ? (options |= 0x420L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0)) : (options |= 0x8020L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0));
                        break block24;
                    }
                    default: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4C8Oall.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 432);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 432);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
            }
            if (!doParse && !doExecute && doFetch) {
                options = 32832L;
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4C8Oall.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 432);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 432);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        if (!this.typeOfStatement.isPlsqlOrCall()) {
            if ((doParse || doExecute || !doFetch) && this.numberOfBindPositions > 0 && this.sendBindsDefinition) {
                options |= 8L;
            }
            if (this.connection.versionNumber >= 9000 && doDefine) {
                options |= 0x10L;
            }
        }
        return options &= 0xFFFFFFFFFFFFFFFFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4C8Oall.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4C8Oall.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CConnection t4CConnection = this.connection;
            return t4CConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4C8Oall.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4C8Oall"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

