/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;

class SQLStateMapping {
    public static final int SQLEXCEPTION = 0;
    public static final int SQLNONTRANSIENTEXCEPTION = 1;
    public static final int SQLTRANSIENTEXCEPTION = 2;
    public static final int SQLDATAEXCEPTION = 3;
    public static final int SQLFEATURENOTSUPPORTEDEXCEPTION = 4;
    public static final int SQLINTEGRITYCONSTRAINTVIOLATIONEXCEPTION = 5;
    public static final int SQLINVALIDAUTHORIZATIONSPECEXCEPTION = 6;
    public static final int SQLNONTRANSIENTCONNECTIONEXCEPTION = 7;
    public static final int SQLSYNTAXERROREXCEPTION = 8;
    public static final int SQLTIMEOUTEXCEPTION = 9;
    public static final int SQLTRANSACTIONROLLBACKEXCEPTION = 10;
    public static final int SQLTRANSIENTCONNECTIONEXCEPTION = 11;
    public static final int SQLCLIENTINFOEXCEPTION = 12;
    public static final int SQLRECOVERABLEEXCEPTION = 13;
    int low;
    int high;
    public String sqlState;
    public int exception;
    static final String mappingResource = "errorMap.xml";
    static SQLStateMapping[] all;
    private static final int NUMEBER_OF_MAPPINGS_IN_ERRORMAP_XML = 128;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLStateMapping(int l2, int h2, String s2, int ex) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLStateMapping.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(l2) + ", " + OracleLog.argument(h2) + ", " + OracleLog.argument(s2) + ", " + OracleLog.argument(ex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.low = l2;
            this.sqlState = s2;
            this.exception = ex;
            this.high = h2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLStateMapping.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIncluded(int value) {
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLStateMapping.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__ = this.low <= value && value <= this.high;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLStateMapping.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLStateMapping.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLException newSQLException(String reason, int vendorCode) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLStateMapping.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(reason) + ", " + OracleLog.argument(vendorCode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            switch (this.exception) {
                case 0: {
                    SQLException __result__ = new SQLException(reason, this.sqlState, vendorCode);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SQLStateMapping.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = __result__;
                    return sQLException;
                }
            }
            SQLException __result__ = new SQLException(reason, this.sqlState, vendorCode);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLStateMapping.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = __result__;
            return sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLStateMapping.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    boolean lessThan(SQLStateMapping rhs) {
        if (this.low < rhs.low) {
            return this.high < rhs.high;
        }
        return this.high <= rhs.high;
    }

    public String toString() {
        return super.toString() + "(" + this.low + ", " + this.high + ", " + this.sqlState + ", " + this.exception + ")";
    }

    public static void main(String[] args) throws IOException {
        SQLStateMapping[] a2 = SQLStateMapping.doGetMappings();
        System.out.println("a\t" + a2);
        for (int i2 = 0; i2 < a2.length; ++i2) {
            System.out.println("low:\t" + a2[i2].low + "\thigh:\t" + a2[i2].high + "\tsqlState:\t" + a2[i2].sqlState + "\tsqlException:\t" + a2[i2].exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SQLStateMapping[] getMappings() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLStateMapping.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (all == null) {
                try {
                    all = SQLStateMapping.doGetMappings();
                }
                catch (Throwable e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SQLStateMapping.logger().log(Level.WARNING, "         Warning: ORA Error number to SQLState code mapping resource not loaded correctly " + e2);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    all = new SQLStateMapping[0];
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLStateMapping.logger().log(OracleLog.TRACE_30, "         Return: " + all);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLStateMapping[] sQLStateMappingArray = all;
            return sQLStateMappingArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLStateMapping.logger().log(OracleLog.TRACE_30, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    static SQLStateMapping[] doGetMappings() throws IOException {
        InputStream s2 = SQLStateMapping.class.getResourceAsStream(mappingResource);
        ArrayList list = new ArrayList(128);
        SQLStateMapping.load(s2, list);
        return list.toArray(new SQLStateMapping[0]);
    }

    static void load(InputStream is, List list) throws IOException {
        String token;
        BufferedReader r2 = new BufferedReader(new InputStreamReader(is));
        Tokenizer st = new Tokenizer(r2);
        int oraErrorFrom = -1;
        int oraErrorTo = -1;
        String sqlState = null;
        int sqlException = -1;
        String comment = null;
        int s2 = 0;
        block39: while ((token = st.next()) != null) {
            switch (s2) {
                case 0: {
                    if (!token.equals("<")) continue block39;
                    s2 = 1;
                    continue block39;
                }
                case 1: {
                    if (token.equals("!")) {
                        s2 = 2;
                        continue block39;
                    }
                    if (token.equals("oraErrorSqlStateSqlExceptionMapping")) {
                        s2 = 6;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"oraErrorSqlStateSqlExceptionMapping\".");
                }
                case 2: {
                    if (token.equals("-")) {
                        s2 = 3;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"-\".");
                }
                case 3: {
                    if (!token.equals("-")) continue block39;
                    s2 = 4;
                    continue block39;
                }
                case 4: {
                    if (token.equals("-")) {
                        s2 = 5;
                        continue block39;
                    }
                    s2 = 3;
                    continue block39;
                }
                case 5: {
                    if (token.equals(">")) {
                        s2 = 1;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 6: {
                    if (token.equals(">")) {
                        s2 = 7;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 7: {
                    if (token.equals("<")) {
                        s2 = 8;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"<\".");
                }
                case 8: {
                    if (token.equals("!")) {
                        s2 = 9;
                        continue block39;
                    }
                    if (token.equals("error")) {
                        s2 = 14;
                        continue block39;
                    }
                    if (token.equals("/")) {
                        s2 = 16;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected one of \"!--\", \"error\", \"/\".");
                }
                case 9: {
                    if (token.equals("-")) {
                        s2 = 10;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"-\".");
                }
                case 10: {
                    if (token.equals("-")) {
                        s2 = 11;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"-\".");
                }
                case 11: {
                    if (!token.equals("-")) continue block39;
                    s2 = 12;
                    continue block39;
                }
                case 12: {
                    if (token.equals("-")) {
                        s2 = 13;
                        continue block39;
                    }
                    s2 = 11;
                    continue block39;
                }
                case 13: {
                    if (token.equals(">")) {
                        s2 = 7;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 14: {
                    if (token.equals("/")) {
                        s2 = 15;
                        continue block39;
                    }
                    if (token.equals("oraErrorFrom")) {
                        s2 = 19;
                        continue block39;
                    }
                    if (token.equals("oraErrorTo")) {
                        s2 = 21;
                        continue block39;
                    }
                    if (token.equals("sqlState")) {
                        s2 = 23;
                        continue block39;
                    }
                    if (token.equals("sqlException")) {
                        s2 = 25;
                        continue block39;
                    }
                    if (token.equals("comment")) {
                        s2 = 27;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected one of " + "\"oraErrorFrom\", \"oraErrorTo\", \"sqlState\", " + "\"sqlException\", \"comment\", \"/\".");
                }
                case 15: {
                    if (token.equals(">")) {
                        try {
                            SQLStateMapping.createOne(list, oraErrorFrom, oraErrorTo, sqlState, sqlException, comment);
                        }
                        catch (IOException e2) {
                            throw new IOException("Invalid error element at line " + st.lineno + " of errorMap.xml. " + e2.getMessage());
                        }
                        oraErrorFrom = -1;
                        oraErrorTo = -1;
                        sqlState = null;
                        sqlException = -1;
                        comment = null;
                        s2 = 7;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 16: {
                    if (token.equals("oraErrorSqlStateSqlExceptionMapping")) {
                        s2 = 17;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"oraErrorSqlStateSqlExceptionMapping\".");
                }
                case 17: {
                    if (token.equals(">")) {
                        s2 = 18;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 18: {
                    continue block39;
                }
                case 19: {
                    if (token.equals("=")) {
                        s2 = 20;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 20: {
                    try {
                        oraErrorFrom = Integer.parseInt(token);
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException("Unexpected value \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected an integer.");
                    }
                    s2 = 14;
                    continue block39;
                }
                case 21: {
                    if (token.equals("=")) {
                        s2 = 22;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 22: {
                    try {
                        oraErrorTo = Integer.parseInt(token);
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException("Unexpected value \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected an integer.");
                    }
                    s2 = 14;
                    continue block39;
                }
                case 23: {
                    if (token.equals("=")) {
                        s2 = 24;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 24: {
                    sqlState = token;
                    s2 = 14;
                    continue block39;
                }
                case 25: {
                    if (token.equals("=")) {
                        s2 = 26;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 26: {
                    try {
                        sqlException = SQLStateMapping.valueOf(token);
                    }
                    catch (Exception e3) {
                        throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected SQLException" + " subclass name.");
                    }
                    s2 = 14;
                    continue block39;
                }
                case 27: {
                    if (token.equals("=")) {
                        s2 = 28;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 28: {
                    comment = token;
                    s2 = 14;
                    continue block39;
                }
            }
            throw new IOException("Unknown parser state " + s2 + " at line " + st.lineno + " of errorMap.xml.");
        }
    }

    private static void createOne(List list, int oraErrorFrom, int oraErrorTo, String sqlState, int sqlException, String comment) throws IOException {
        if (oraErrorFrom == -1) {
            throw new IOException("oraErrorFrom is a required attribute");
        }
        if (oraErrorTo == -1) {
            oraErrorTo = oraErrorFrom;
        }
        if (sqlState == null || sqlState.length() == 0) {
            throw new IOException("sqlState is a required attribute");
        }
        if (sqlException == -1) {
            throw new IOException("sqlException is a required attribute");
        }
        if (comment == null || comment.length() < 8) {
            throw new IOException("a lengthy comment in required");
        }
        SQLStateMapping m2 = new SQLStateMapping(oraErrorFrom, oraErrorTo, sqlState, sqlException);
        SQLStateMapping.add(list, m2);
    }

    static void add(List l2, SQLStateMapping a2) {
        int i2;
        for (i2 = l2.size(); i2 > 0 && !((SQLStateMapping)l2.get(i2 - 1)).lessThan(a2); --i2) {
        }
        l2.add(i2, a2);
    }

    static int valueOf(String e2) throws Exception {
        if (e2.equalsIgnoreCase("SQLEXCEPTION")) {
            return 0;
        }
        if (e2.equalsIgnoreCase("SQLNONTRANSIENTEXCEPTION")) {
            return 1;
        }
        if (e2.equalsIgnoreCase("SQLTRANSIENTEXCEPTION")) {
            return 2;
        }
        if (e2.equalsIgnoreCase("SQLDATAEXCEPTION")) {
            return 3;
        }
        if (e2.equalsIgnoreCase("SQLFEATURENOTSUPPORTEDEXCEPTION")) {
            return 4;
        }
        if (e2.equalsIgnoreCase("SQLINTEGRITYCONSTRAINTVIOLATIONEXCEPTION")) {
            return 5;
        }
        if (e2.equalsIgnoreCase("SQLINVALIDAUTHORIZATIONSPECEXCEPTION")) {
            return 6;
        }
        if (e2.equalsIgnoreCase("SQLNONTRANSIENTCONNECTIONEXCEPTION")) {
            return 7;
        }
        if (e2.equalsIgnoreCase("SQLSYNTAXERROREXCEPTION")) {
            return 8;
        }
        if (e2.equalsIgnoreCase("SQLTIMEOUTEXCEPTION")) {
            return 9;
        }
        if (e2.equalsIgnoreCase("SQLTRANSACTIONROLLBACKEXCEPTION")) {
            return 10;
        }
        if (e2.equalsIgnoreCase("SQLTRANSIENTCONNECTIONEXCEPTION")) {
            return 11;
        }
        if (e2.equalsIgnoreCase("SQLCLIENTINFOEXCEPTION")) {
            return 12;
        }
        if (e2.equalsIgnoreCase("SQLRECOVERABLEEXCEPTION")) {
            return 13;
        }
        throw new Exception("unexpected exception name: " + e2);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.SQLStateMapping"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class Tokenizer {
        int lineno = 1;
        Reader r;
        int c;

        Tokenizer(Reader r2) throws IOException {
            this.r = r2;
            this.c = r2.read();
        }

        String next() throws IOException {
            StringBuffer b2 = new StringBuffer(16);
            boolean skipping = true;
            while (this.c != -1) {
                if (this.c == 10) {
                    ++this.lineno;
                }
                if (this.c <= 32 && skipping) {
                    this.c = this.r.read();
                    continue;
                }
                if (this.c <= 32 && !skipping) {
                    this.c = this.r.read();
                    break;
                }
                if (this.c == 34) {
                    while ((this.c = this.r.read()) != 34) {
                        b2.append((char)this.c);
                    }
                    this.c = this.r.read();
                    break;
                }
                if (48 <= this.c && this.c <= 57 || 65 <= this.c && this.c <= 90 || 97 <= this.c && this.c <= 122 || this.c == 95) {
                    do {
                        b2.append((char)this.c);
                    } while (48 <= (this.c = this.r.read()) && this.c <= 57 || 65 <= this.c && this.c <= 90 || 97 <= this.c && this.c <= 122 || this.c == 95);
                    break;
                }
                b2.append((char)this.c);
                this.c = this.r.read();
                break;
            }
            if (b2.length() > 0) {
                return b2.toString();
            }
            return null;
        }
    }
}

